/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.icu.impl.CacheValue;
import android.icu.text.DecimalFormatSymbols;
import android.icu.util.ULocale;
import android.opengl.EGL14;
import android.os.Build;
import android.os.Environment;
import android.os.IInstalld;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.ZygoteProcess;
import android.os.storage.StorageManager;
import android.security.keystore.AndroidKeyStoreProvider;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructCapUserData;
import android.system.StructCapUserHeader;
import android.text.Hyphenator;
import android.util.EventLog;
import android.util.Log;
import android.util.TimingsTraceLog;
import android.webkit.WebViewFactory;
import android.widget.TextView;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.ClassLoaderFactory;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.WrapperInit;
import com.android.internal.os.Zygote;
import com.android.internal.os.ZygoteConnection;
import com.android.internal.os.ZygoteServer;
import com.android.internal.util.Preconditions;
import dalvik.system.DexFile;
import dalvik.system.VMRuntime;
import dalvik.system.ZygoteHooks;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Provider;
import java.security.Security;
import libcore.io.IoUtils;

public class ZygoteInit {
    private static final String TAG = "Zygote";
    private static final String PROPERTY_DISABLE_OPENGL_PRELOADING = "ro.zygote.disable_gl_preload";
    private static final String PROPERTY_GFX_DRIVER = "ro.gfx.driver.0";
    private static final int LOG_BOOT_PROGRESS_PRELOAD_START = 3020;
    private static final int LOG_BOOT_PROGRESS_PRELOAD_END = 3030;
    private static final int PRELOAD_GC_THRESHOLD = 50000;
    private static final String ABI_LIST_ARG = "--abi-list=";
    private static final String SOCKET_NAME_ARG = "--socket-name=";
    private static final int DEXOPT_DISABLE_HIDDEN_API_CHECKS = 1024;
    private static Resources mResources;
    private static final String PRELOADED_CLASSES = "/system/etc/preloaded-classes";
    public static final boolean PRELOAD_RESOURCES = true;
    private static final int UNPRIVILEGED_UID = 9999;
    private static final int UNPRIVILEGED_GID = 9999;
    private static final int ROOT_UID = 0;
    private static final int ROOT_GID = 0;
    private static boolean sPreloadComplete;

    static void preload(TimingsTraceLog bootTimingsTraceLog) {
        Log.d(TAG, "begin preload");
        bootTimingsTraceLog.traceBegin("BeginIcuCachePinning");
        ZygoteInit.beginIcuCachePinning();
        bootTimingsTraceLog.traceEnd();
        bootTimingsTraceLog.traceBegin("PreloadClasses");
        ZygoteInit.preloadClasses();
        bootTimingsTraceLog.traceEnd();
        bootTimingsTraceLog.traceBegin("PreloadResources");
        ZygoteInit.preloadResources();
        bootTimingsTraceLog.traceEnd();
        Trace.traceBegin(16384L, "PreloadAppProcessHALs");
        ZygoteInit.nativePreloadAppProcessHALs();
        Trace.traceEnd(16384L);
        Trace.traceBegin(16384L, "PreloadOpenGL");
        ZygoteInit.preloadOpenGL();
        Trace.traceEnd(16384L);
        ZygoteInit.preloadSharedLibraries();
        ZygoteInit.preloadTextResources();
        WebViewFactory.prepareWebViewInZygote();
        ZygoteInit.endIcuCachePinning();
        ZygoteInit.warmUpJcaProviders();
        Log.d(TAG, "end preload");
        sPreloadComplete = true;
    }

    public static void lazyPreload() {
        Preconditions.checkState(!sPreloadComplete);
        Log.i(TAG, "Lazily preloading resources.");
        ZygoteInit.preload(new TimingsTraceLog("ZygoteInitTiming_lazy", 16384L));
    }

    private static void beginIcuCachePinning() {
        ULocale[] localesToPin;
        Log.i(TAG, "Installing ICU cache reference pinning...");
        CacheValue.setStrength(CacheValue.Strength.STRONG);
        Log.i(TAG, "Preloading ICU data...");
        for (ULocale uLocale : localesToPin = new ULocale[]{ULocale.ROOT, ULocale.US, ULocale.getDefault()}) {
            new DecimalFormatSymbols(uLocale);
        }
    }

    private static void endIcuCachePinning() {
        CacheValue.setStrength(CacheValue.Strength.SOFT);
        Log.i(TAG, "Uninstalled ICU cache reference pinning...");
    }

    private static void preloadSharedLibraries() {
        Log.i(TAG, "Preloading shared libraries...");
        System.loadLibrary("android");
        System.loadLibrary("compiler_rt");
        System.loadLibrary("jnigraphics");
    }

    private static native void nativePreloadAppProcessHALs();

    private static void preloadOpenGL() {
        String driverPackageName = SystemProperties.get(PROPERTY_GFX_DRIVER);
        if (!SystemProperties.getBoolean(PROPERTY_DISABLE_OPENGL_PRELOADING, false) && (driverPackageName == null || driverPackageName.isEmpty())) {
            EGL14.eglGetDisplay(0);
        }
    }

    private static void preloadTextResources() {
        Hyphenator.init();
        TextView.preloadFontCache();
    }

    private static void warmUpJcaProviders() {
        long startTime = SystemClock.uptimeMillis();
        Trace.traceBegin(16384L, "Starting installation of AndroidKeyStoreProvider");
        AndroidKeyStoreProvider.install();
        Log.i(TAG, "Installed AndroidKeyStoreProvider in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
        Trace.traceEnd(16384L);
        startTime = SystemClock.uptimeMillis();
        Trace.traceBegin(16384L, "Starting warm up of JCA providers");
        for (Provider p : Security.getProviders()) {
            p.warmUpServiceProvision();
        }
        Log.i(TAG, "Warmed up JCA providers in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
        Trace.traceEnd(16384L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void preloadClasses() {
        FileInputStream is;
        VMRuntime runtime = VMRuntime.getRuntime();
        try {
            is = new FileInputStream(PRELOADED_CLASSES);
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "Couldn't find /system/etc/preloaded-classes.");
            return;
        }
        Log.i(TAG, "Preloading classes...");
        long startTime = SystemClock.uptimeMillis();
        int reuid = Os.getuid();
        int regid = Os.getgid();
        boolean droppedPriviliges = false;
        if (reuid == 0 && regid == 0) {
            try {
                Os.setregid(0, 9999);
                Os.setreuid(0, 9999);
            }
            catch (ErrnoException ex) {
                throw new RuntimeException("Failed to drop root", ex);
            }
            droppedPriviliges = true;
        }
        float defaultUtilization = runtime.getTargetHeapUtilization();
        runtime.setTargetHeapUtilization(0.8f);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is), 256);
            int count = 0;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.equals("")) continue;
                Trace.traceBegin(16384L, line);
                try {
                    Class.forName(line, true, null);
                    ++count;
                }
                catch (ClassNotFoundException e) {
                    Log.w(TAG, "Class not found for preloading: " + line);
                }
                catch (UnsatisfiedLinkError e) {
                    Log.w(TAG, "Problem preloading " + line + ": " + e);
                }
                catch (Throwable t) {
                    Log.e(TAG, "Error preloading " + line + ".", t);
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException(t);
                }
                Trace.traceEnd(16384L);
            }
            Log.i(TAG, "...preloaded " + count + " classes in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
        }
        catch (IOException e) {
            Log.e(TAG, "Error reading /system/etc/preloaded-classes.", e);
        }
        finally {
            IoUtils.closeQuietly(is);
            runtime.setTargetHeapUtilization(defaultUtilization);
            Trace.traceBegin(16384L, "PreloadDexCaches");
            runtime.preloadDexCaches();
            Trace.traceEnd(16384L);
            if (droppedPriviliges) {
                try {
                    Os.setreuid(0, 0);
                    Os.setregid(0, 0);
                }
                catch (ErrnoException ex) {
                    throw new RuntimeException("Failed to restore root", ex);
                }
            }
        }
    }

    private static void preloadResources() {
        VMRuntime runtime = VMRuntime.getRuntime();
        try {
            mResources = Resources.getSystem();
            mResources.startPreloading();
            Log.i(TAG, "Preloading resources...");
            long startTime = SystemClock.uptimeMillis();
            TypedArray ar = mResources.obtainTypedArray(17236062);
            int N = ZygoteInit.preloadDrawables(ar);
            ar.recycle();
            Log.i(TAG, "...preloaded " + N + " resources in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
            startTime = SystemClock.uptimeMillis();
            ar = mResources.obtainTypedArray(17236061);
            N = ZygoteInit.preloadColorStateLists(ar);
            ar.recycle();
            Log.i(TAG, "...preloaded " + N + " resources in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
            if (mResources.getBoolean(17956973)) {
                startTime = SystemClock.uptimeMillis();
                ar = mResources.obtainTypedArray(17236063);
                N = ZygoteInit.preloadDrawables(ar);
                ar.recycle();
                Log.i(TAG, "...preloaded " + N + " resource in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
            }
            mResources.finishPreloading();
        }
        catch (RuntimeException e) {
            Log.w(TAG, "Failure preloading resources", e);
        }
    }

    private static int preloadColorStateLists(TypedArray ar) {
        int N = ar.length();
        for (int i = 0; i < N; ++i) {
            int id2 = ar.getResourceId(i, 0);
            if (id2 == 0 || mResources.getColorStateList(id2, null) != null) continue;
            throw new IllegalArgumentException("Unable to find preloaded color resource #0x" + Integer.toHexString(id2) + " (" + ar.getString(i) + ")");
        }
        return N;
    }

    private static int preloadDrawables(TypedArray ar) {
        int N = ar.length();
        for (int i = 0; i < N; ++i) {
            int id2 = ar.getResourceId(i, 0);
            if (id2 == 0 || mResources.getDrawable(id2, null) != null) continue;
            throw new IllegalArgumentException("Unable to find preloaded drawable resource #0x" + Integer.toHexString(id2) + " (" + ar.getString(i) + ")");
        }
        return N;
    }

    static void gcAndFinalize() {
        VMRuntime runtime = VMRuntime.getRuntime();
        System.gc();
        runtime.runFinalizationSync();
        System.gc();
    }

    private static Runnable handleSystemServerProcess(ZygoteConnection.Arguments parsedArgs) {
        String systemServerClasspath;
        Os.umask(OsConstants.S_IRWXG | OsConstants.S_IRWXO);
        if (parsedArgs.niceName != null) {
            Process.setArgV0(parsedArgs.niceName);
        }
        if ((systemServerClasspath = Os.getenv("SYSTEMSERVERCLASSPATH")) != null) {
            ZygoteInit.performSystemServerDexOpt(systemServerClasspath);
            boolean profileSystemServer = SystemProperties.getBoolean("dalvik.vm.profilesystemserver", false);
            if (profileSystemServer && (Build.IS_USERDEBUG || Build.IS_ENG)) {
                try {
                    File profileDir = Environment.getDataProfilesDePackageDirectory(1000, "system_server");
                    File profile = new File(profileDir, "primary.prof");
                    profile.getParentFile().mkdirs();
                    profile.createNewFile();
                    String[] codePaths = systemServerClasspath.split(":");
                    VMRuntime.registerAppInfo(profile.getPath(), codePaths);
                }
                catch (Exception e) {
                    Log.wtf(TAG, "Failed to set up system server profile", e);
                }
            }
        }
        if (parsedArgs.invokeWith != null) {
            String[] args = parsedArgs.remainingArgs;
            if (systemServerClasspath != null) {
                String[] amendedArgs = new String[args.length + 2];
                amendedArgs[0] = "-cp";
                amendedArgs[1] = systemServerClasspath;
                System.arraycopy(args, 0, amendedArgs, 2, args.length);
                args = amendedArgs;
            }
            WrapperInit.execApplication(parsedArgs.invokeWith, parsedArgs.niceName, parsedArgs.targetSdkVersion, VMRuntime.getCurrentInstructionSet(), null, args);
            throw new IllegalStateException("Unexpected return from WrapperInit.execApplication");
        }
        ClassLoader cl = null;
        if (systemServerClasspath != null) {
            cl = ZygoteInit.createPathClassLoader(systemServerClasspath, parsedArgs.targetSdkVersion);
            Thread.currentThread().setContextClassLoader(cl);
        }
        return ZygoteInit.zygoteInit(parsedArgs.targetSdkVersion, parsedArgs.remainingArgs, cl);
    }

    static ClassLoader createPathClassLoader(String classPath, int targetSdkVersion) {
        String libraryPath = System.getProperty("java.library.path");
        return ClassLoaderFactory.createClassLoader(classPath, libraryPath, libraryPath, ClassLoader.getSystemClassLoader(), targetSdkVersion, true, null);
    }

    private static void performSystemServerDexOpt(String classPath) {
        String[] classPathElements = classPath.split(":");
        IInstalld installd = IInstalld.Stub.asInterface(ServiceManager.getService("installd"));
        String instructionSet = VMRuntime.getRuntime().vmInstructionSet();
        String classPathForElement = "";
        for (String classPathElement : classPathElements) {
            int dexoptNeeded;
            String systemServerFilter = SystemProperties.get("dalvik.vm.systemservercompilerfilter", "speed");
            try {
                dexoptNeeded = DexFile.getDexOptNeeded(classPathElement, instructionSet, systemServerFilter, null, false, false);
            }
            catch (FileNotFoundException ignored) {
                Log.w(TAG, "Missing classpath element for system server: " + classPathElement);
                continue;
            }
            catch (IOException e) {
                Log.w(TAG, "Error checking classpath element for system server: " + classPathElement, e);
                dexoptNeeded = 0;
            }
            if (dexoptNeeded != 0) {
                String packageName = "*";
                String outputPath = null;
                int dexFlags = 1024;
                String compilerFilter = systemServerFilter;
                String uuid = StorageManager.UUID_PRIVATE_INTERNAL;
                String seInfo = null;
                String classLoaderContext = ZygoteInit.getSystemServerClassLoaderContext(classPathForElement);
                boolean targetSdkVersion = false;
                try {
                    installd.dexopt(classPathElement, 1000, "*", instructionSet, dexoptNeeded, outputPath, 1024, compilerFilter, uuid, classLoaderContext, seInfo, false, 0, null, null);
                }
                catch (RemoteException | ServiceSpecificException e) {
                    Log.w(TAG, "Failed compiling classpath element for system server: " + classPathElement, e);
                }
            }
            classPathForElement = ZygoteInit.encodeSystemServerClassPath(classPathForElement, classPathElement);
        }
    }

    private static String getSystemServerClassLoaderContext(String classPath) {
        return classPath == null ? "PCL[]" : "PCL[" + classPath + "]";
    }

    private static String encodeSystemServerClassPath(String classPath, String newElement) {
        return classPath == null || classPath.isEmpty() ? newElement : classPath + ":" + newElement;
    }

    private static Runnable forkSystemServer(String abiList, String socketName, ZygoteServer zygoteServer) {
        int pid;
        StructCapUserData[] data;
        long capabilities = ZygoteInit.posixCapabilitiesAsBits(OsConstants.CAP_IPC_LOCK, OsConstants.CAP_KILL, OsConstants.CAP_NET_ADMIN, OsConstants.CAP_NET_BIND_SERVICE, OsConstants.CAP_NET_BROADCAST, OsConstants.CAP_NET_RAW, OsConstants.CAP_SYS_MODULE, OsConstants.CAP_SYS_NICE, OsConstants.CAP_SYS_PTRACE, OsConstants.CAP_SYS_TIME, OsConstants.CAP_SYS_TTY_CONFIG, OsConstants.CAP_WAKE_ALARM, OsConstants.CAP_BLOCK_SUSPEND);
        StructCapUserHeader header = new StructCapUserHeader(OsConstants._LINUX_CAPABILITY_VERSION_3, 0);
        try {
            data = Os.capget(header);
        }
        catch (ErrnoException ex) {
            throw new RuntimeException("Failed to capget()", ex);
        }
        String[] args = new String[]{"--setuid=1000", "--setgid=1000", "--setgroups=1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1018,1021,1023,1032,1065,3001,3002,3003,3006,3007,3009,3010", "--capabilities=" + (capabilities &= (long)data[0].effective | (long)data[1].effective << 32) + "," + capabilities, "--nice-name=system_server", "--runtime-args", "com.android.server.SystemServer"};
        ZygoteConnection.Arguments parsedArgs = null;
        try {
            parsedArgs = new ZygoteConnection.Arguments(args);
            ZygoteConnection.applyDebuggerSystemProperty(parsedArgs);
            ZygoteConnection.applyInvokeWithSystemProperty(parsedArgs);
            pid = Zygote.forkSystemServer(parsedArgs.uid, parsedArgs.gid, parsedArgs.gids, parsedArgs.runtimeFlags, null, parsedArgs.permittedCapabilities, parsedArgs.effectiveCapabilities);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        if (pid == 0) {
            if (ZygoteInit.hasSecondZygote(abiList)) {
                ZygoteInit.waitForSecondaryZygote(socketName);
            }
            zygoteServer.closeServerSocket();
            return ZygoteInit.handleSystemServerProcess(parsedArgs);
        }
        return null;
    }

    private static long posixCapabilitiesAsBits(int ... capabilities) {
        long result = 0L;
        for (int capability : capabilities) {
            if (capability < 0 || capability > OsConstants.CAP_LAST_CAP) {
                throw new IllegalArgumentException(String.valueOf(capability));
            }
            result |= 1L << capability;
        }
        return result;
    }

    public static void main(String[] argv) {
        Runnable caller;
        ZygoteServer zygoteServer = new ZygoteServer();
        ZygoteHooks.startZygoteNoThreadCreation();
        try {
            Os.setpgid(0, 0);
        }
        catch (ErrnoException ex) {
            throw new RuntimeException("Failed to setpgid(0,0)", ex);
        }
        try {
            Runnable r;
            if (!"1".equals(SystemProperties.get("sys.boot_completed"))) {
                MetricsLogger.histogram(null, "boot_zygote_init", (int)SystemClock.elapsedRealtime());
            }
            String bootTimeTag = Process.is64Bit() ? "Zygote64Timing" : "Zygote32Timing";
            TimingsTraceLog bootTimingsTraceLog = new TimingsTraceLog(bootTimeTag, 16384L);
            bootTimingsTraceLog.traceBegin("ZygoteInit");
            RuntimeInit.enableDdms();
            boolean startSystemServer = false;
            String socketName = "zygote";
            String abiList = null;
            boolean enableLazyPreload = false;
            for (int i = 1; i < argv.length; ++i) {
                if ("start-system-server".equals(argv[i])) {
                    startSystemServer = true;
                    continue;
                }
                if ("--enable-lazy-preload".equals(argv[i])) {
                    enableLazyPreload = true;
                    continue;
                }
                if (argv[i].startsWith(ABI_LIST_ARG)) {
                    abiList = argv[i].substring(ABI_LIST_ARG.length());
                    continue;
                }
                if (argv[i].startsWith(SOCKET_NAME_ARG)) {
                    socketName = argv[i].substring(SOCKET_NAME_ARG.length());
                    continue;
                }
                throw new RuntimeException("Unknown command line argument: " + argv[i]);
            }
            if (abiList == null) {
                throw new RuntimeException("No ABI list supplied.");
            }
            zygoteServer.registerServerSocket(socketName);
            if (!enableLazyPreload) {
                bootTimingsTraceLog.traceBegin("ZygotePreload");
                EventLog.writeEvent(3020, SystemClock.uptimeMillis());
                ZygoteInit.preload(bootTimingsTraceLog);
                EventLog.writeEvent(3030, SystemClock.uptimeMillis());
                bootTimingsTraceLog.traceEnd();
            } else {
                Zygote.resetNicePriority();
            }
            bootTimingsTraceLog.traceBegin("PostZygoteInitGC");
            ZygoteInit.gcAndFinalize();
            bootTimingsTraceLog.traceEnd();
            bootTimingsTraceLog.traceEnd();
            Trace.setTracingEnabled(false, 0);
            Zygote.nativeSecurityInit();
            Zygote.nativeUnmountStorageOnInit();
            ZygoteHooks.stopZygoteNoThreadCreation();
            if (startSystemServer && (r = ZygoteInit.forkSystemServer(abiList, socketName, zygoteServer)) != null) {
                r.run();
                return;
            }
            Log.i(TAG, "Accepting command socket connections");
            caller = zygoteServer.runSelectLoop(abiList);
        }
        catch (Throwable ex) {
            Log.e(TAG, "System zygote died with exception", ex);
            throw ex;
        }
        finally {
            zygoteServer.closeServerSocket();
        }
        if (caller != null) {
            caller.run();
        }
    }

    private static boolean hasSecondZygote(String abiList) {
        return !SystemProperties.get("ro.product.cpu.abilist").equals(abiList);
    }

    private static void waitForSecondaryZygote(String socketName) {
        String otherZygoteName = "zygote".equals(socketName) ? "zygote_secondary" : "zygote";
        ZygoteProcess.waitForConnectionToZygote(otherZygoteName);
    }

    static boolean isPreloadComplete() {
        return sPreloadComplete;
    }

    private ZygoteInit() {
    }

    public static final Runnable zygoteInit(int targetSdkVersion, String[] argv, ClassLoader classLoader) {
        Trace.traceBegin(64L, "ZygoteInit");
        RuntimeInit.redirectLogStreams();
        RuntimeInit.commonInit();
        ZygoteInit.nativeZygoteInit();
        return RuntimeInit.applicationInit(targetSdkVersion, argv, classLoader);
    }

    private static final native void nativeZygoteInit();
}

