/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os.logging;

import android.content.Context;
import android.util.StatsLog;
import com.android.internal.logging.MetricsLogger;

public class MetricsLoggerWrapper {
    private static final int METRIC_VALUE_DISMISSED_BY_TAP = 0;
    private static final int METRIC_VALUE_DISMISSED_BY_DRAG = 1;

    public static void logPictureInPictureDismissByTap(Context context) {
        MetricsLogger.action(context, 822, 0);
        StatsLog.write(52, context.getUserId(), context.getApplicationInfo().packageName, context.getApplicationInfo().className, 4);
    }

    public static void logPictureInPictureDismissByDrag(Context context) {
        MetricsLogger.action(context, 822, 1);
        StatsLog.write(52, context.getUserId(), context.getApplicationInfo().packageName, context.getApplicationInfo().className, 4);
    }

    public static void logPictureInPictureMinimize(Context context, boolean isMinimized) {
        MetricsLogger.action(context, 821, isMinimized);
        if (isMinimized) {
            StatsLog.write(52, context.getUserId(), context.getApplicationInfo().packageName, context.getApplicationInfo().className, 3);
        } else {
            StatsLog.write(52, context.getUserId(), context.getApplicationInfo().packageName, context.getApplicationInfo().className, 2);
        }
    }

    public static void logPictureInPictureMenuVisible(Context context, boolean menuStateFull) {
        MetricsLogger.visibility(context, 823, menuStateFull);
    }

    public static void logPictureInPictureEnter(Context context, boolean supportsEnterPipOnTaskSwitch) {
        MetricsLogger.action(context, 819, supportsEnterPipOnTaskSwitch);
        if (supportsEnterPipOnTaskSwitch) {
            StatsLog.write(52, context.getUserId(), context.getApplicationInfo().packageName, context.getApplicationInfo().className, 1);
        }
    }

    public static void logPictureInPictureFullScreen(Context context) {
        MetricsLogger.action(context, 820);
        StatsLog.write(52, context.getUserId(), context.getApplicationInfo().packageName, context.getApplicationInfo().className, 2);
    }

    public static void logAppOverlayEnter(int uid, String packageName, boolean usingAlertWindow) {
        StatsLog.write(59, uid, packageName, usingAlertWindow, 1);
    }

    public static void logAppOverlayExit(int uid, String packageName, boolean usingAlertWindow) {
        StatsLog.write(59, uid, packageName, usingAlertWindow, 2);
    }
}

