/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.Size;
import android.view.Gravity;
import java.io.PrintWriter;
import java.util.ArrayList;

public class PipSnapAlgorithm {
    private static final int SNAP_MODE_CORNERS_ONLY = 0;
    private static final int SNAP_MODE_CORNERS_AND_SIDES = 1;
    private static final int SNAP_MODE_EDGE = 2;
    private static final int SNAP_MODE_EDGE_MAGNET_CORNERS = 3;
    private static final int SNAP_MODE_LONG_EDGE_MAGNET_CORNERS = 4;
    private static final float CORNER_MAGNET_THRESHOLD = 0.3f;
    private final Context mContext;
    private final ArrayList<Integer> mSnapGravities = new ArrayList();
    private final int mDefaultSnapMode = 3;
    private int mSnapMode = 3;
    private final float mDefaultSizePercent;
    private final float mMinAspectRatioForMinSize;
    private final float mMaxAspectRatioForMinSize;
    private final int mFlingDeceleration;
    private int mOrientation = 0;
    private final int mMinimizedVisibleSize;
    private boolean mIsMinimized;

    public PipSnapAlgorithm(Context context) {
        Resources res = context.getResources();
        this.mContext = context;
        this.mMinimizedVisibleSize = res.getDimensionPixelSize(17105236);
        this.mDefaultSizePercent = res.getFloat(17104961);
        this.mMaxAspectRatioForMinSize = res.getFloat(17104959);
        this.mMinAspectRatioForMinSize = 1.0f / this.mMaxAspectRatioForMinSize;
        this.mFlingDeceleration = this.mContext.getResources().getDimensionPixelSize(17105235);
        this.onConfigurationChanged();
    }

    public void onConfigurationChanged() {
        Resources res = this.mContext.getResources();
        this.mOrientation = res.getConfiguration().orientation;
        this.mSnapMode = res.getInteger(17694844);
        this.calculateSnapTargets();
    }

    public void setMinimized(boolean isMinimized) {
        this.mIsMinimized = isMinimized;
    }

    public Rect findClosestSnapBounds(Rect movementBounds, Rect stackBounds, float velocityX, float velocityY, Point dragStartPosition) {
        Rect intersectStackBounds = new Rect(stackBounds);
        Point intersect = this.getEdgeIntersect(stackBounds, movementBounds, velocityX, velocityY, dragStartPosition);
        intersectStackBounds.offsetTo(intersect.x, intersect.y);
        return this.findClosestSnapBounds(movementBounds, intersectStackBounds);
    }

    public Point getEdgeIntersect(Rect stackBounds, Rect movementBounds, float velX, float velY, Point dragStartPosition) {
        int maxDistance;
        boolean isLandscape = this.mOrientation == 2;
        int x = stackBounds.left;
        int y = stackBounds.top;
        float slope = velY / velX;
        float yIntercept = (float)y - slope * (float)x;
        Point vertPoint = new Point();
        Point horizPoint = new Point();
        vertPoint.x = velX > 0.0f ? movementBounds.right : movementBounds.left;
        vertPoint.y = this.findY(slope, yIntercept, vertPoint.x);
        horizPoint.y = velY > 0.0f ? movementBounds.bottom : movementBounds.top;
        horizPoint.x = this.findX(slope, yIntercept, horizPoint.y);
        if (isLandscape) {
            maxDistance = velX > 0.0f ? movementBounds.right - stackBounds.left : stackBounds.left - movementBounds.left;
        } else {
            int n = maxDistance = velY > 0.0f ? movementBounds.bottom - stackBounds.top : stackBounds.top - movementBounds.top;
        }
        if (maxDistance > 0) {
            int startPoint = isLandscape ? dragStartPosition.y : dragStartPosition.x;
            int endPoint = isLandscape ? horizPoint.y : horizPoint.x;
            int center = movementBounds.centerX();
            if (startPoint < center && endPoint < center || startPoint > center && endPoint > center) {
                int distance = (int)(0.0 - Math.pow(isLandscape ? (double)velX : (double)velY, 2.0)) / (2 * this.mFlingDeceleration);
                distance = Math.min(distance, maxDistance);
                if (isLandscape) {
                    horizPoint.x = stackBounds.left + (velX > 0.0f ? distance : -distance);
                } else {
                    horizPoint.y = stackBounds.top + (velY > 0.0f ? distance : -distance);
                }
                return horizPoint;
            }
        }
        double distanceVert = Math.hypot(vertPoint.x - x, vertPoint.y - y);
        double distanceHoriz = Math.hypot(horizPoint.x - x, horizPoint.y - y);
        if (distanceVert == 0.0) {
            return horizPoint;
        }
        if (distanceHoriz == 0.0) {
            return vertPoint;
        }
        return Math.abs(distanceVert) > Math.abs(distanceHoriz) ? horizPoint : vertPoint;
    }

    private int findY(float slope, float yIntercept, float x) {
        return (int)(slope * x + yIntercept);
    }

    private int findX(float slope, float yIntercept, float y) {
        return (int)((y - yIntercept) / slope);
    }

    public Rect findClosestSnapBounds(Rect movementBounds, Rect stackBounds) {
        Rect pipBounds = new Rect(movementBounds.left, movementBounds.top, movementBounds.right + stackBounds.width(), movementBounds.bottom + stackBounds.height());
        Rect newBounds = new Rect(stackBounds);
        if (this.mSnapMode == 4 || this.mSnapMode == 3) {
            float thresh;
            Rect tmpBounds = new Rect();
            Point[] snapTargets = new Point[this.mSnapGravities.size()];
            for (int i = 0; i < this.mSnapGravities.size(); ++i) {
                Gravity.apply(this.mSnapGravities.get(i), stackBounds.width(), stackBounds.height(), pipBounds, 0, 0, tmpBounds);
                snapTargets[i] = new Point(tmpBounds.left, tmpBounds.top);
            }
            Point snapTarget = this.findClosestPoint(stackBounds.left, stackBounds.top, snapTargets);
            float distance = this.distanceToPoint(snapTarget, stackBounds.left, stackBounds.top);
            if (distance < (thresh = (float)Math.max(stackBounds.width(), stackBounds.height()) * 0.3f)) {
                newBounds.offsetTo(snapTarget.x, snapTarget.y);
            } else {
                this.snapRectToClosestEdge(stackBounds, movementBounds, newBounds);
            }
        } else if (this.mSnapMode == 2) {
            this.snapRectToClosestEdge(stackBounds, movementBounds, newBounds);
        } else {
            Rect tmpBounds = new Rect();
            Point[] snapTargets = new Point[this.mSnapGravities.size()];
            for (int i = 0; i < this.mSnapGravities.size(); ++i) {
                Gravity.apply(this.mSnapGravities.get(i), stackBounds.width(), stackBounds.height(), pipBounds, 0, 0, tmpBounds);
                snapTargets[i] = new Point(tmpBounds.left, tmpBounds.top);
            }
            Point snapTarget = this.findClosestPoint(stackBounds.left, stackBounds.top, snapTargets);
            newBounds.offsetTo(snapTarget.x, snapTarget.y);
        }
        return newBounds;
    }

    public void applyMinimizedOffset(Rect stackBounds, Rect movementBounds, Point displaySize, Rect stableInsets) {
        if (stackBounds.left <= movementBounds.centerX()) {
            stackBounds.offsetTo(stableInsets.left + this.mMinimizedVisibleSize - stackBounds.width(), stackBounds.top);
        } else {
            stackBounds.offsetTo(displaySize.x - stableInsets.right - this.mMinimizedVisibleSize, stackBounds.top);
        }
    }

    public float getSnapFraction(Rect stackBounds, Rect movementBounds) {
        Rect tmpBounds = new Rect();
        this.snapRectToClosestEdge(stackBounds, movementBounds, tmpBounds);
        float widthFraction = (float)(tmpBounds.left - movementBounds.left) / (float)movementBounds.width();
        float heightFraction = (float)(tmpBounds.top - movementBounds.top) / (float)movementBounds.height();
        if (tmpBounds.top == movementBounds.top) {
            return widthFraction;
        }
        if (tmpBounds.left == movementBounds.right) {
            return 1.0f + heightFraction;
        }
        if (tmpBounds.top == movementBounds.bottom) {
            return 2.0f + (1.0f - widthFraction);
        }
        return 3.0f + (1.0f - heightFraction);
    }

    public void applySnapFraction(Rect stackBounds, Rect movementBounds, float snapFraction) {
        if (snapFraction < 1.0f) {
            int offset = movementBounds.left + (int)(snapFraction * (float)movementBounds.width());
            stackBounds.offsetTo(offset, movementBounds.top);
        } else if (snapFraction < 2.0f) {
            int offset = movementBounds.top + (int)((snapFraction -= 1.0f) * (float)movementBounds.height());
            stackBounds.offsetTo(movementBounds.right, offset);
        } else if (snapFraction < 3.0f) {
            int offset = movementBounds.left + (int)((1.0f - (snapFraction -= 2.0f)) * (float)movementBounds.width());
            stackBounds.offsetTo(offset, movementBounds.bottom);
        } else {
            int offset = movementBounds.top + (int)((1.0f - (snapFraction -= 3.0f)) * (float)movementBounds.height());
            stackBounds.offsetTo(movementBounds.left, offset);
        }
    }

    public void getMovementBounds(Rect stackBounds, Rect insetBounds, Rect movementBoundsOut, int imeHeight) {
        movementBoundsOut.set(insetBounds);
        movementBoundsOut.right = Math.max(insetBounds.left, insetBounds.right - stackBounds.width());
        movementBoundsOut.bottom = Math.max(insetBounds.top, insetBounds.bottom - stackBounds.height());
        movementBoundsOut.bottom -= imeHeight;
    }

    public Size getSizeForAspectRatio(float aspectRatio, float minEdgeSize, int displayWidth, int displayHeight) {
        int height;
        int width;
        int smallestDisplaySize = Math.min(displayWidth, displayHeight);
        int minSize = (int)Math.max(minEdgeSize, (float)smallestDisplaySize * this.mDefaultSizePercent);
        if (aspectRatio <= this.mMinAspectRatioForMinSize || aspectRatio > this.mMaxAspectRatioForMinSize) {
            if (aspectRatio <= 1.0f) {
                width = minSize;
                height = Math.round((float)width / aspectRatio);
            } else {
                height = minSize;
                width = Math.round((float)height * aspectRatio);
            }
        } else {
            float widthAtMaxAspectRatioForMinSize = this.mMaxAspectRatioForMinSize * (float)minSize;
            float radius = PointF.length(widthAtMaxAspectRatioForMinSize, minSize);
            height = (int)Math.round(Math.sqrt(radius * radius / (aspectRatio * aspectRatio + 1.0f)));
            width = Math.round((float)height * aspectRatio);
        }
        return new Size(width, height);
    }

    private Point findClosestPoint(int x, int y, Point[] points) {
        Point closestPoint = null;
        float minDistance = Float.MAX_VALUE;
        for (Point p : points) {
            float distance = this.distanceToPoint(p, x, y);
            if (!(distance < minDistance)) continue;
            closestPoint = p;
            minDistance = distance;
        }
        return closestPoint;
    }

    private void snapRectToClosestEdge(Rect stackBounds, Rect movementBounds, Rect boundsOut) {
        int boundedLeft = Math.max(movementBounds.left, Math.min(movementBounds.right, stackBounds.left));
        int boundedTop = Math.max(movementBounds.top, Math.min(movementBounds.bottom, stackBounds.top));
        boundsOut.set(stackBounds);
        if (this.mIsMinimized) {
            boundsOut.offsetTo(boundedLeft, boundedTop);
            return;
        }
        int fromLeft = Math.abs(stackBounds.left - movementBounds.left);
        int fromTop = Math.abs(stackBounds.top - movementBounds.top);
        int fromRight = Math.abs(movementBounds.right - stackBounds.left);
        int fromBottom = Math.abs(movementBounds.bottom - stackBounds.top);
        int shortest = this.mSnapMode == 4 ? (this.mOrientation == 2 ? Math.min(fromTop, fromBottom) : Math.min(fromLeft, fromRight)) : Math.min(Math.min(fromLeft, fromRight), Math.min(fromTop, fromBottom));
        if (shortest == fromLeft) {
            boundsOut.offsetTo(movementBounds.left, boundedTop);
        } else if (shortest == fromTop) {
            boundsOut.offsetTo(boundedLeft, movementBounds.top);
        } else if (shortest == fromRight) {
            boundsOut.offsetTo(movementBounds.right, boundedTop);
        } else {
            boundsOut.offsetTo(boundedLeft, movementBounds.bottom);
        }
    }

    private float distanceToPoint(Point p, int x, int y) {
        return PointF.length(p.x - x, p.y - y);
    }

    private void calculateSnapTargets() {
        this.mSnapGravities.clear();
        switch (this.mSnapMode) {
            case 1: {
                if (this.mOrientation == 2) {
                    this.mSnapGravities.add(49);
                    this.mSnapGravities.add(81);
                } else {
                    this.mSnapGravities.add(19);
                    this.mSnapGravities.add(21);
                }
            }
            case 0: 
            case 3: 
            case 4: {
                this.mSnapGravities.add(51);
                this.mSnapGravities.add(53);
                this.mSnapGravities.add(83);
                this.mSnapGravities.add(85);
                break;
            }
        }
    }

    public void dump(PrintWriter pw, String prefix) {
        String innerPrefix = prefix + "  ";
        pw.println(prefix + PipSnapAlgorithm.class.getSimpleName());
        pw.println(innerPrefix + "mSnapMode=" + this.mSnapMode);
        pw.println(innerPrefix + "mOrientation=" + this.mOrientation);
        pw.println(innerPrefix + "mMinimizedVisibleSize=" + this.mMinimizedVisibleSize);
        pw.println(innerPrefix + "mIsMinimized=" + this.mIsMinimized);
    }
}

