/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.provider.Telephony;
import android.telephony.SmsMessage;
import android.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.security.SecureRandom;
import java.util.Map;

public class AppSmsManager {
    private static final String LOG_TAG = "AppSmsManager";
    private final SecureRandom mRandom;
    private final Context mContext;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private final Map<String, AppRequestInfo> mTokenMap;
    @GuardedBy(value="mLock")
    private final Map<String, AppRequestInfo> mPackageMap;

    public AppSmsManager(Context context) {
        this.mRandom = new SecureRandom();
        this.mTokenMap = new ArrayMap<String, AppRequestInfo>();
        this.mPackageMap = new ArrayMap<String, AppRequestInfo>();
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createAppSpecificSmsToken(String callingPkg, PendingIntent intent) {
        AppOpsManager appOps = (AppOpsManager)this.mContext.getSystemService("appops");
        appOps.checkPackage(Binder.getCallingUid(), callingPkg);
        String token = this.generateNonce();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPackageMap.containsKey(callingPkg)) {
                this.removeRequestLocked(this.mPackageMap.get(callingPkg));
            }
            AppRequestInfo info = new AppRequestInfo(callingPkg, intent, token);
            this.addRequestLocked(info);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleSmsReceivedIntent(Intent intent) {
        if (intent.getAction() != "android.provider.Telephony.SMS_DELIVER") {
            Log.wtf(LOG_TAG, "Got intent with incorrect action: " + intent.getAction());
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            AppRequestInfo info = this.findAppRequestInfoSmsIntentLocked(intent);
            if (info == null) {
                return false;
            }
            try {
                Intent fillIn = new Intent();
                fillIn.putExtras(intent.getExtras());
                info.pendingIntent.send(this.mContext, 0, fillIn);
            }
            catch (PendingIntent.CanceledException e) {
                this.removeRequestLocked(info);
                return false;
            }
            this.removeRequestLocked(info);
            return true;
        }
    }

    private AppRequestInfo findAppRequestInfoSmsIntentLocked(Intent intent) {
        SmsMessage[] messages = Telephony.Sms.Intents.getMessagesFromIntent(intent);
        if (messages == null) {
            return null;
        }
        StringBuilder fullMessageBuilder = new StringBuilder();
        for (SmsMessage message : messages) {
            if (message == null || message.getMessageBody() == null) continue;
            fullMessageBuilder.append(message.getMessageBody());
        }
        String fullMessage = fullMessageBuilder.toString();
        for (String token : this.mTokenMap.keySet()) {
            if (!fullMessage.contains(token)) continue;
            return this.mTokenMap.get(token);
        }
        return null;
    }

    private String generateNonce() {
        byte[] bytes = new byte[8];
        this.mRandom.nextBytes(bytes);
        return Base64.encodeToString(bytes, 11);
    }

    private void removeRequestLocked(AppRequestInfo info) {
        this.mTokenMap.remove(info.token);
        this.mPackageMap.remove(info.packageName);
    }

    private void addRequestLocked(AppRequestInfo info) {
        this.mTokenMap.put(info.token, info);
        this.mPackageMap.put(info.packageName, info);
    }

    private final class AppRequestInfo {
        public final String packageName;
        public final PendingIntent pendingIntent;
        public final String token;

        AppRequestInfo(String packageName, PendingIntent pendingIntent, String token) {
            this.packageName = packageName;
            this.pendingIntent = pendingIntent;
            this.token = token;
        }
    }
}

