/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.res.Resources;
import android.os.RemoteException;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.SystemConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class CarrierAppUtils {
    private static final String TAG = "CarrierAppUtils";
    private static final boolean DEBUG = false;

    private CarrierAppUtils() {
    }

    public static synchronized void disableCarrierAppsUntilPrivileged(String callingPackage, IPackageManager packageManager, TelephonyManager telephonyManager, ContentResolver contentResolver, int userId) {
        SystemConfig config = SystemConfig.getInstance();
        String[] systemCarrierAppsDisabledUntilUsed = Resources.getSystem().getStringArray(17236001);
        ArrayMap<String, List<String>> systemCarrierAssociatedAppsDisabledUntilUsed = config.getDisabledUntilUsedPreinstalledCarrierAssociatedApps();
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(callingPackage, packageManager, telephonyManager, contentResolver, userId, systemCarrierAppsDisabledUntilUsed, systemCarrierAssociatedAppsDisabledUntilUsed);
    }

    public static synchronized void disableCarrierAppsUntilPrivileged(String callingPackage, IPackageManager packageManager, ContentResolver contentResolver, int userId) {
        SystemConfig config = SystemConfig.getInstance();
        String[] systemCarrierAppsDisabledUntilUsed = Resources.getSystem().getStringArray(17236001);
        ArrayMap<String, List<String>> systemCarrierAssociatedAppsDisabledUntilUsed = config.getDisabledUntilUsedPreinstalledCarrierAssociatedApps();
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(callingPackage, packageManager, null, contentResolver, userId, systemCarrierAppsDisabledUntilUsed, systemCarrierAssociatedAppsDisabledUntilUsed);
    }

    @VisibleForTesting
    public static void disableCarrierAppsUntilPrivileged(String callingPackage, IPackageManager packageManager, TelephonyManager telephonyManager, ContentResolver contentResolver, int userId, String[] systemCarrierAppsDisabledUntilUsed, ArrayMap<String, List<String>> systemCarrierAssociatedAppsDisabledUntilUsed) {
        List<ApplicationInfo> candidates = CarrierAppUtils.getDefaultCarrierAppCandidatesHelper(packageManager, userId, systemCarrierAppsDisabledUntilUsed);
        if (candidates == null || candidates.isEmpty()) {
            return;
        }
        Map<String, List<ApplicationInfo>> associatedApps = CarrierAppUtils.getDefaultCarrierAssociatedAppsHelper(packageManager, userId, systemCarrierAssociatedAppsDisabledUntilUsed);
        ArrayList<String> enabledCarrierPackages = new ArrayList<String>();
        boolean hasRunOnce = Settings.Secure.getIntForUser(contentResolver, "carrier_apps_handled", 0, userId) == 1;
        try {
            for (ApplicationInfo ai : candidates) {
                List<ApplicationInfo> associatedAppList;
                boolean hasPrivileges;
                String packageName = ai.packageName;
                boolean bl = hasPrivileges = telephonyManager != null && telephonyManager.checkCarrierPrivilegesForPackageAnyPhone(packageName) == 1;
                if (hasPrivileges) {
                    if (!(ai.isUpdatedSystemApp() || ai.enabledSetting != 0 && ai.enabledSetting != 4)) {
                        Slog.i(TAG, "Update state(" + packageName + "): ENABLED for user " + userId);
                        packageManager.setApplicationEnabledSetting(packageName, 1, 1, userId, callingPackage);
                    }
                    if ((associatedAppList = associatedApps.get(packageName)) != null) {
                        for (ApplicationInfo associatedApp : associatedAppList) {
                            if (associatedApp.enabledSetting != 0 && associatedApp.enabledSetting != 4) continue;
                            Slog.i(TAG, "Update associated state(" + associatedApp.packageName + "): ENABLED for user " + userId);
                            packageManager.setApplicationEnabledSetting(associatedApp.packageName, 1, 1, userId, callingPackage);
                        }
                    }
                    enabledCarrierPackages.add(ai.packageName);
                    continue;
                }
                if (!ai.isUpdatedSystemApp() && ai.enabledSetting == 0) {
                    Slog.i(TAG, "Update state(" + packageName + "): DISABLED_UNTIL_USED for user " + userId);
                    packageManager.setApplicationEnabledSetting(packageName, 4, 0, userId, callingPackage);
                }
                if (hasRunOnce || (associatedAppList = associatedApps.get(packageName)) == null) continue;
                for (ApplicationInfo associatedApp : associatedAppList) {
                    if (associatedApp.enabledSetting != 0) continue;
                    Slog.i(TAG, "Update associated state(" + associatedApp.packageName + "): DISABLED_UNTIL_USED for user " + userId);
                    packageManager.setApplicationEnabledSetting(associatedApp.packageName, 4, 0, userId, callingPackage);
                }
            }
            if (!hasRunOnce) {
                Settings.Secure.putIntForUser(contentResolver, "carrier_apps_handled", 1, userId);
            }
            if (!enabledCarrierPackages.isEmpty()) {
                String[] packageNames = new String[enabledCarrierPackages.size()];
                enabledCarrierPackages.toArray(packageNames);
                packageManager.grantDefaultPermissionsToEnabledCarrierApps(packageNames, userId);
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Could not reach PackageManager", e);
        }
    }

    public static List<ApplicationInfo> getDefaultCarrierApps(IPackageManager packageManager, TelephonyManager telephonyManager, int userId) {
        List<ApplicationInfo> candidates = CarrierAppUtils.getDefaultCarrierAppCandidates(packageManager, userId);
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        for (int i = candidates.size() - 1; i >= 0; --i) {
            boolean hasPrivileges;
            ApplicationInfo ai = candidates.get(i);
            String packageName = ai.packageName;
            boolean bl = hasPrivileges = telephonyManager.checkCarrierPrivilegesForPackageAnyPhone(packageName) == 1;
            if (hasPrivileges) continue;
            candidates.remove(i);
        }
        return candidates;
    }

    public static List<ApplicationInfo> getDefaultCarrierAppCandidates(IPackageManager packageManager, int userId) {
        String[] systemCarrierAppsDisabledUntilUsed = Resources.getSystem().getStringArray(17236001);
        return CarrierAppUtils.getDefaultCarrierAppCandidatesHelper(packageManager, userId, systemCarrierAppsDisabledUntilUsed);
    }

    private static List<ApplicationInfo> getDefaultCarrierAppCandidatesHelper(IPackageManager packageManager, int userId, String[] systemCarrierAppsDisabledUntilUsed) {
        if (systemCarrierAppsDisabledUntilUsed == null || systemCarrierAppsDisabledUntilUsed.length == 0) {
            return null;
        }
        ArrayList<ApplicationInfo> apps = new ArrayList<ApplicationInfo>(systemCarrierAppsDisabledUntilUsed.length);
        for (int i = 0; i < systemCarrierAppsDisabledUntilUsed.length; ++i) {
            String packageName = systemCarrierAppsDisabledUntilUsed[i];
            ApplicationInfo ai = CarrierAppUtils.getApplicationInfoIfSystemApp(packageManager, userId, packageName);
            if (ai == null) continue;
            apps.add(ai);
        }
        return apps;
    }

    private static Map<String, List<ApplicationInfo>> getDefaultCarrierAssociatedAppsHelper(IPackageManager packageManager, int userId, ArrayMap<String, List<String>> systemCarrierAssociatedAppsDisabledUntilUsed) {
        int size = systemCarrierAssociatedAppsDisabledUntilUsed.size();
        ArrayMap<String, List<ApplicationInfo>> associatedApps = new ArrayMap<String, List<ApplicationInfo>>(size);
        for (int i = 0; i < size; ++i) {
            String carrierAppPackage = systemCarrierAssociatedAppsDisabledUntilUsed.keyAt(i);
            List<String> associatedAppPackages = systemCarrierAssociatedAppsDisabledUntilUsed.valueAt(i);
            for (int j = 0; j < associatedAppPackages.size(); ++j) {
                ApplicationInfo ai = CarrierAppUtils.getApplicationInfoIfSystemApp(packageManager, userId, associatedAppPackages.get(j));
                if (ai == null || ai.isUpdatedSystemApp()) continue;
                ArrayList<ApplicationInfo> appList = (ArrayList<ApplicationInfo>)associatedApps.get(carrierAppPackage);
                if (appList == null) {
                    appList = new ArrayList<ApplicationInfo>();
                    associatedApps.put(carrierAppPackage, appList);
                }
                appList.add(ai);
            }
        }
        return associatedApps;
    }

    private static ApplicationInfo getApplicationInfoIfSystemApp(IPackageManager packageManager, int userId, String packageName) {
        try {
            ApplicationInfo ai = packageManager.getApplicationInfo(packageName, 32768, userId);
            if (ai != null && ai.isSystemApp()) {
                return ai;
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Could not reach PackageManager", e);
        }
        return null;
    }
}

