/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.LocalLog;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class CarrierIdentifier
extends Handler {
    private static final String LOG_TAG = CarrierIdentifier.class.getSimpleName();
    private static final boolean DBG = true;
    private static final boolean VDBG = Rlog.isLoggable(LOG_TAG, 2);
    private static final int SIM_LOAD_EVENT = 1;
    private static final int SIM_ABSENT_EVENT = 2;
    private static final int SPN_OVERRIDE_EVENT = 3;
    private static final int ICC_CHANGED_EVENT = 4;
    private static final int PREFER_APN_UPDATE_EVENT = 5;
    private static final int CARRIER_ID_DB_UPDATE_EVENT = 6;
    private static final Uri CONTENT_URL_PREFER_APN = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "preferapn");
    private static final String OPERATOR_BRAND_OVERRIDE_PREFIX = "operator_branding_";
    private List<CarrierMatchingRule> mCarrierMatchingRulesOnMccMnc = new ArrayList<CarrierMatchingRule>();
    private int mCarrierId = -1;
    private String mCarrierName;
    private String mPreferApn;
    private String mSpn = "";
    private Context mContext;
    private Phone mPhone;
    private IccRecords mIccRecords;
    private final LocalLog mCarrierIdLocalLog = new LocalLog(20);
    private final TelephonyManager mTelephonyMgr;
    private final SubscriptionsChangedListener mOnSubscriptionsChangedListener = new SubscriptionsChangedListener();
    private final SharedPreferenceChangedListener mSharedPrefListener = new SharedPreferenceChangedListener();
    private final ContentObserver mContentObserver = new ContentObserver(this){

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            CarrierIdentifier.logd("onChange URI: " + uri);
            if (CONTENT_URL_PREFER_APN.equals(uri.getLastPathSegment())) {
                CarrierIdentifier.this.sendEmptyMessage(5);
            } else {
                CarrierIdentifier.this.sendEmptyMessage(6);
            }
        }
    };

    public CarrierIdentifier(Phone phone) {
        CarrierIdentifier.logd("Creating CarrierIdentifier[" + phone.getPhoneId() + "]");
        this.mContext = phone.getContext();
        this.mPhone = phone;
        this.mTelephonyMgr = TelephonyManager.from(this.mContext);
        this.mContext.getContentResolver().registerContentObserver(CONTENT_URL_PREFER_APN, false, this.mContentObserver);
        this.mContext.getContentResolver().registerContentObserver(Telephony.CarrierIdentification.CONTENT_URI, false, this.mContentObserver);
        SubscriptionManager.from(this.mContext).addOnSubscriptionsChangedListener(this.mOnSubscriptionsChangedListener);
        PreferenceManager.getDefaultSharedPreferences(this.mContext).registerOnSharedPreferenceChangeListener(this.mSharedPrefListener);
        UiccController.getInstance().registerForIccChanged(this, 4, null);
    }

    @Override
    public void handleMessage(Message msg) {
        if (VDBG) {
            CarrierIdentifier.logd("handleMessage: " + msg.what);
        }
        switch (msg.what) {
            case 1: 
            case 6: {
                this.mSpn = this.mTelephonyMgr.getSimOperatorNameForPhone(this.mPhone.getPhoneId());
                this.mPreferApn = this.getPreferApn();
                this.loadCarrierMatchingRulesOnMccMnc();
                break;
            }
            case 2: {
                this.mCarrierMatchingRulesOnMccMnc.clear();
                this.mSpn = null;
                this.mPreferApn = null;
                this.updateCarrierIdAndName(-1, null);
                break;
            }
            case 5: {
                String preferApn = this.getPreferApn();
                if (CarrierIdentifier.equals(this.mPreferApn, preferApn, true)) break;
                CarrierIdentifier.logd("[updatePreferApn] from:" + this.mPreferApn + " to:" + preferApn);
                this.mPreferApn = preferApn;
                this.matchCarrier();
                break;
            }
            case 3: {
                String spn = this.mTelephonyMgr.getSimOperatorNameForPhone(this.mPhone.getPhoneId());
                if (CarrierIdentifier.equals(this.mSpn, spn, true)) break;
                CarrierIdentifier.logd("[updateSpn] from:" + this.mSpn + " to:" + spn);
                this.mSpn = spn;
                this.matchCarrier();
                break;
            }
            case 4: {
                IccRecords newIccRecords = UiccController.getInstance().getIccRecords(this.mPhone.getPhoneId(), 1);
                if (this.mIccRecords == newIccRecords) break;
                if (this.mIccRecords != null) {
                    CarrierIdentifier.logd("Removing stale icc objects.");
                    this.mIccRecords.unregisterForSpnUpdate(this);
                    this.mIccRecords = null;
                }
                if (newIccRecords == null) break;
                CarrierIdentifier.logd("new Icc object");
                newIccRecords.registerForSpnUpdate(this, 3, null);
                this.mIccRecords = newIccRecords;
                break;
            }
            default: {
                CarrierIdentifier.loge("invalid msg: " + msg.what);
            }
        }
    }

    private void loadCarrierMatchingRulesOnMccMnc() {
        try {
            String mccmnc = this.mTelephonyMgr.getSimOperatorNumericForPhone(this.mPhone.getPhoneId());
            try (Cursor cursor = this.mContext.getContentResolver().query(Telephony.CarrierIdentification.CONTENT_URI, null, "mccmnc=?", new String[]{mccmnc}, null);){
                if (cursor != null) {
                    if (VDBG) {
                        CarrierIdentifier.logd("[loadCarrierMatchingRules]- " + cursor.getCount() + " Records(s) in DB mccmnc: " + mccmnc);
                    }
                    this.mCarrierMatchingRulesOnMccMnc.clear();
                    while (cursor.moveToNext()) {
                        this.mCarrierMatchingRulesOnMccMnc.add(this.makeCarrierMatchingRule(cursor));
                    }
                    this.matchCarrier();
                }
            }
        }
        catch (Exception ex) {
            CarrierIdentifier.loge("[loadCarrierMatchingRules]- ex: " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPreferApn() {
        try (Cursor cursor = this.mContext.getContentResolver().query(Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "preferapn/subId/" + this.mPhone.getSubId()), new String[]{"apn"}, null, null, null);){
            if (cursor != null) {
                if (VDBG) {
                    CarrierIdentifier.logd("[getPreferApn]- " + cursor.getCount() + " Records(s) in DB");
                }
                if (cursor.moveToNext()) {
                    String apn = cursor.getString(cursor.getColumnIndexOrThrow("apn"));
                    CarrierIdentifier.logd("[getPreferApn]- " + apn);
                    String string2 = apn;
                    return string2;
                }
            }
        }
        return null;
    }

    private void updateCarrierIdAndName(int cid, String name) {
        boolean update = false;
        if (!CarrierIdentifier.equals(name, this.mCarrierName, true)) {
            CarrierIdentifier.logd("[updateCarrierName] from:" + this.mCarrierName + " to:" + name);
            this.mCarrierName = name;
            update = true;
        }
        if (cid != this.mCarrierId) {
            CarrierIdentifier.logd("[updateCarrierId] from:" + this.mCarrierId + " to:" + cid);
            this.mCarrierId = cid;
            update = true;
        }
        if (update) {
            this.mCarrierIdLocalLog.log("[updateCarrierIdAndName] cid:" + this.mCarrierId + " name:" + this.mCarrierName);
            Intent intent = new Intent("android.telephony.action.SUBSCRIPTION_CARRIER_IDENTITY_CHANGED");
            intent.putExtra("android.telephony.extra.CARRIER_ID", this.mCarrierId);
            intent.putExtra("android.telephony.extra.CARRIER_NAME", this.mCarrierName);
            intent.putExtra("android.telephony.extra.SUBSCRIPTION_ID", this.mPhone.getSubId());
            this.mContext.sendBroadcast(intent);
        }
    }

    private CarrierMatchingRule makeCarrierMatchingRule(Cursor cursor) {
        return new CarrierMatchingRule(cursor.getString(cursor.getColumnIndexOrThrow("mccmnc")), cursor.getString(cursor.getColumnIndexOrThrow("imsi_prefix_xpattern")), cursor.getString(cursor.getColumnIndexOrThrow("iccid_prefix")), cursor.getString(cursor.getColumnIndexOrThrow("gid1")), cursor.getString(cursor.getColumnIndexOrThrow("gid2")), cursor.getString(cursor.getColumnIndexOrThrow("plmn")), cursor.getString(cursor.getColumnIndexOrThrow("spn")), cursor.getString(cursor.getColumnIndexOrThrow("apn")), cursor.getInt(cursor.getColumnIndexOrThrow("carrier_id")), cursor.getString(cursor.getColumnIndexOrThrow("carrier_name")));
    }

    private void matchCarrier() {
        if (!SubscriptionManager.isValidSubscriptionId(this.mPhone.getSubId())) {
            CarrierIdentifier.logd("[matchCarrier]skip before sim records loaded");
            return;
        }
        String mccmnc = this.mTelephonyMgr.getSimOperatorNumericForPhone(this.mPhone.getPhoneId());
        String iccid = this.mPhone.getIccSerialNumber();
        String gid1 = this.mPhone.getGroupIdLevel1();
        String gid2 = this.mPhone.getGroupIdLevel2();
        String imsi = this.mPhone.getSubscriberId();
        String plmn = this.mPhone.getPlmn();
        String spn = this.mSpn;
        String apn = this.mPreferApn;
        if (VDBG) {
            CarrierIdentifier.logd("[matchCarrier] gid1: " + gid1 + " gid2: " + gid2 + " imsi: " + Rlog.pii(LOG_TAG, (Object)imsi) + " iccid: " + Rlog.pii(LOG_TAG, (Object)iccid) + " plmn: " + plmn + " spn: " + spn + " apn: " + apn);
        }
        CarrierMatchingRule subscriptionRule = new CarrierMatchingRule(mccmnc, imsi, iccid, gid1, gid2, plmn, spn, apn, -1, null);
        int maxScore = -1;
        CarrierMatchingRule maxRule = null;
        for (CarrierMatchingRule rule : this.mCarrierMatchingRulesOnMccMnc) {
            rule.match(subscriptionRule);
            if (rule.mScore <= maxScore) continue;
            maxScore = rule.mScore;
            maxRule = rule;
        }
        if (maxScore == -1) {
            CarrierIdentifier.logd("[matchCarrier - no match] cid: -1 name: " + null);
            this.updateCarrierIdAndName(-1, null);
        } else {
            CarrierIdentifier.logd("[matchCarrier] cid: " + maxRule.mCid + " name: " + maxRule.mName);
            this.updateCarrierIdAndName(maxRule.mCid, maxRule.mName);
        }
        String gid1ToLog = (maxScore & 0x10) == 0 && !TextUtils.isEmpty(subscriptionRule.mGid1) ? subscriptionRule.mGid1 : null;
        TelephonyMetrics.getInstance().writeCarrierIdMatchingEvent(this.mPhone.getPhoneId(), this.getCarrierListVersion(), this.mCarrierId, gid1ToLog);
    }

    private int getCarrierListVersion() {
        Cursor cursor = this.mContext.getContentResolver().query(Uri.withAppendedPath(Telephony.CarrierIdentification.CONTENT_URI, "get_version"), null, null, null);
        cursor.moveToFirst();
        return cursor.getInt(0);
    }

    public int getCarrierId() {
        return this.mCarrierId;
    }

    public String getCarrierName() {
        return this.mCarrierName;
    }

    private static boolean equals(String a, String b, boolean ignoreCase) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return ignoreCase ? a.equalsIgnoreCase(b) : a.equals(b);
        }
        return false;
    }

    private static void logd(String str) {
        Rlog.d(LOG_TAG, str);
    }

    private static void loge(String str) {
        Rlog.e(LOG_TAG, str);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        ipw.println("mCarrierIdLocalLogs:");
        ipw.increaseIndent();
        this.mCarrierIdLocalLog.dump(fd, pw, args);
        ipw.decreaseIndent();
        ipw.println("mCarrierId: " + this.mCarrierId);
        ipw.println("mCarrierName: " + this.mCarrierName);
        ipw.println("version: " + this.getCarrierListVersion());
        ipw.println("mCarrierMatchingRules on mccmnc: " + this.mTelephonyMgr.getSimOperatorNumericForPhone(this.mPhone.getPhoneId()));
        ipw.increaseIndent();
        for (CarrierMatchingRule rule : this.mCarrierMatchingRulesOnMccMnc) {
            ipw.println(rule.toString());
        }
        ipw.decreaseIndent();
        ipw.println("mSpn: " + this.mSpn);
        ipw.println("mPreferApn: " + this.mPreferApn);
        ipw.flush();
    }

    private static class CarrierMatchingRule {
        private static final int SCORE_MCCMNC = 128;
        private static final int SCORE_IMSI_PREFIX = 64;
        private static final int SCORE_ICCID_PREFIX = 32;
        private static final int SCORE_GID1 = 16;
        private static final int SCORE_GID2 = 8;
        private static final int SCORE_PLMN = 4;
        private static final int SCORE_SPN = 2;
        private static final int SCORE_APN = 1;
        private static final int SCORE_INVALID = -1;
        private String mMccMnc;
        private String mImsiPrefixPattern;
        private String mIccidPrefix;
        private String mGid1;
        private String mGid2;
        private String mPlmn;
        private String mSpn;
        private String mApn;
        private String mName;
        private int mCid;
        private int mScore = 0;

        CarrierMatchingRule(String mccmnc, String imsiPrefixPattern, String iccidPrefix, String gid1, String gid2, String plmn, String spn, String apn, int cid, String name) {
            this.mMccMnc = mccmnc;
            this.mImsiPrefixPattern = imsiPrefixPattern;
            this.mIccidPrefix = iccidPrefix;
            this.mGid1 = gid1;
            this.mGid2 = gid2;
            this.mPlmn = plmn;
            this.mSpn = spn;
            this.mApn = apn;
            this.mCid = cid;
            this.mName = name;
        }

        public void match(CarrierMatchingRule subscriptionRule) {
            this.mScore = 0;
            if (this.mMccMnc != null) {
                if (!CarrierIdentifier.equals(subscriptionRule.mMccMnc, this.mMccMnc, false)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 128;
            }
            if (this.mImsiPrefixPattern != null) {
                if (!this.imsiPrefixMatch(subscriptionRule.mImsiPrefixPattern, this.mImsiPrefixPattern)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 64;
            }
            if (this.mIccidPrefix != null) {
                if (!this.iccidPrefixMatch(subscriptionRule.mIccidPrefix, this.mIccidPrefix)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 32;
            }
            if (this.mGid1 != null) {
                if (!CarrierIdentifier.equals(subscriptionRule.mGid1, this.mGid1, true)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 16;
            }
            if (this.mGid2 != null) {
                if (!CarrierIdentifier.equals(subscriptionRule.mGid2, this.mGid2, true)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 8;
            }
            if (this.mPlmn != null) {
                if (!CarrierIdentifier.equals(subscriptionRule.mPlmn, this.mPlmn, true)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 4;
            }
            if (this.mSpn != null) {
                if (!CarrierIdentifier.equals(subscriptionRule.mSpn, this.mSpn, true)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 2;
            }
            if (this.mApn != null) {
                if (!CarrierIdentifier.equals(subscriptionRule.mApn, this.mApn, true)) {
                    this.mScore = -1;
                    return;
                }
                ++this.mScore;
            }
        }

        private boolean imsiPrefixMatch(String imsi, String prefixXPattern) {
            if (TextUtils.isEmpty(prefixXPattern)) {
                return true;
            }
            if (TextUtils.isEmpty(imsi)) {
                return false;
            }
            if (imsi.length() < prefixXPattern.length()) {
                return false;
            }
            for (int i = 0; i < prefixXPattern.length(); ++i) {
                if (prefixXPattern.charAt(i) == 'x' || prefixXPattern.charAt(i) == 'X' || prefixXPattern.charAt(i) == imsi.charAt(i)) continue;
                return false;
            }
            return true;
        }

        private boolean iccidPrefixMatch(String iccid, String prefix) {
            if (iccid == null || prefix == null) {
                return false;
            }
            return iccid.startsWith(prefix);
        }

        public String toString() {
            return "[CarrierMatchingRule] - mccmnc: " + this.mMccMnc + " gid1: " + this.mGid1 + " gid2: " + this.mGid2 + " plmn: " + this.mPlmn + " imsi_prefix: " + this.mImsiPrefixPattern + " iccid_prefix" + this.mIccidPrefix + " spn: " + this.mSpn + " apn: " + this.mApn + " name: " + this.mName + " cid: " + this.mCid + " score: " + this.mScore;
        }
    }

    private class SharedPreferenceChangedListener
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        private SharedPreferenceChangedListener() {
        }

        @Override
        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
            if (TextUtils.equals(key, CarrierIdentifier.OPERATOR_BRAND_OVERRIDE_PREFIX + CarrierIdentifier.this.mPhone.getIccSerialNumber())) {
                CarrierIdentifier.logd("[onSharedPreferenceChanged]: " + key);
                CarrierIdentifier.this.sendEmptyMessage(3);
            }
        }
    }

    private class SubscriptionsChangedListener
    extends SubscriptionManager.OnSubscriptionsChangedListener {
        final AtomicInteger mPreviousSubId = new AtomicInteger(-1);

        private SubscriptionsChangedListener() {
        }

        @Override
        public void onSubscriptionsChanged() {
            int subId = CarrierIdentifier.this.mPhone.getSubId();
            if (this.mPreviousSubId.getAndSet(subId) != subId) {
                CarrierIdentifier.logd("SubscriptionListener.onSubscriptionInfoChanged subId: " + this.mPreviousSubId);
                if (SubscriptionManager.isValidSubscriptionId(subId)) {
                    CarrierIdentifier.this.sendEmptyMessage(1);
                } else {
                    CarrierIdentifier.this.sendEmptyMessage(2);
                }
            }
        }
    }
}

