/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.RemoteException;
import android.service.carrier.ICarrierMessagingCallback;
import android.service.carrier.ICarrierMessagingService;
import android.service.carrier.MessagePdu;
import android.telephony.CarrierMessagingServiceManager;
import android.telephony.Rlog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.CarrierSmsUtils;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class CarrierServicesSmsFilter {
    protected static final boolean DBG = true;
    private final Context mContext;
    private final Phone mPhone;
    private final byte[][] mPdus;
    private final int mDestPort;
    private final String mPduFormat;
    private final CarrierServicesSmsFilterCallbackInterface mCarrierServicesSmsFilterCallback;
    private final String mLogTag;

    @VisibleForTesting
    public CarrierServicesSmsFilter(Context context, Phone phone, byte[][] pdus, int destPort, String pduFormat, CarrierServicesSmsFilterCallbackInterface carrierServicesSmsFilterCallback, String logTag) {
        this.mContext = context;
        this.mPhone = phone;
        this.mPdus = pdus;
        this.mDestPort = destPort;
        this.mPduFormat = pduFormat;
        this.mCarrierServicesSmsFilterCallback = carrierServicesSmsFilterCallback;
        this.mLogTag = logTag;
    }

    @VisibleForTesting
    public boolean filter() {
        String carrierImsPackage;
        Optional<String> carrierAppForFiltering = this.getCarrierAppPackageForFiltering();
        ArrayList<String> smsFilterPackages = new ArrayList<String>();
        if (carrierAppForFiltering.isPresent()) {
            smsFilterPackages.add(carrierAppForFiltering.get());
        }
        if ((carrierImsPackage = CarrierSmsUtils.getCarrierImsPackageForIntent(this.mContext, this.mPhone, new Intent("android.service.carrier.CarrierMessagingService"))) != null) {
            smsFilterPackages.add(carrierImsPackage);
        }
        FilterAggregator filterAggregator = new FilterAggregator(smsFilterPackages.size());
        for (String smsFilterPackage : smsFilterPackages) {
            this.filterWithPackage(smsFilterPackage, filterAggregator);
        }
        boolean handled = smsFilterPackages.size() > 0;
        return handled;
    }

    private Optional<String> getCarrierAppPackageForFiltering() {
        List<String> carrierPackages = null;
        UiccCard card = UiccController.getInstance().getUiccCard(this.mPhone.getPhoneId());
        if (card != null) {
            carrierPackages = card.getCarrierPackageNamesForIntent(this.mContext.getPackageManager(), new Intent("android.service.carrier.CarrierMessagingService"));
        } else {
            Rlog.e(this.mLogTag, "UiccCard not initialized.");
        }
        if (carrierPackages != null && carrierPackages.size() == 1) {
            this.log("Found carrier package.");
            return Optional.of(carrierPackages.get(0));
        }
        List<String> systemPackages = this.getSystemAppForIntent(new Intent("android.service.carrier.CarrierMessagingService"));
        if (systemPackages != null && systemPackages.size() == 1) {
            this.log("Found system package.");
            return Optional.of(systemPackages.get(0));
        }
        this.logv("Unable to find carrier package: " + carrierPackages + ", nor systemPackages: " + systemPackages);
        return Optional.empty();
    }

    private void filterWithPackage(String packageName, FilterAggregator filterAggregator) {
        CarrierSmsFilter smsFilter = new CarrierSmsFilter(this.mPdus, this.mDestPort, this.mPduFormat);
        CarrierSmsFilterCallback smsFilterCallback = new CarrierSmsFilterCallback(filterAggregator, smsFilter);
        smsFilter.filterSms(packageName, smsFilterCallback);
    }

    private List<String> getSystemAppForIntent(Intent intent) {
        ArrayList<String> packages = new ArrayList<String>();
        PackageManager packageManager = this.mContext.getPackageManager();
        List<ResolveInfo> receivers = packageManager.queryIntentServices(intent, 0);
        String carrierFilterSmsPerm = "android.permission.CARRIER_FILTER_SMS";
        for (ResolveInfo info : receivers) {
            if (info.serviceInfo == null) {
                this.loge("Can't get service information from " + info);
                continue;
            }
            String packageName = info.serviceInfo.packageName;
            if (packageManager.checkPermission(carrierFilterSmsPerm, packageName) != 0) continue;
            packages.add(packageName);
            this.log("getSystemAppForIntent: added package " + packageName);
        }
        return packages;
    }

    private void log(String message) {
        Rlog.d(this.mLogTag, message);
    }

    private void loge(String message) {
        Rlog.e(this.mLogTag, message);
    }

    private void logv(String message) {
        Rlog.e(this.mLogTag, message);
    }

    private final class FilterAggregator {
        private final Object mFilterLock = new Object();
        private int mNumPendingFilters;
        private int mFilterResult;

        FilterAggregator(int numFilters) {
            this.mNumPendingFilters = numFilters;
            this.mFilterResult = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onFilterComplete(int result) {
            Object object = this.mFilterLock;
            synchronized (object) {
                --this.mNumPendingFilters;
                this.combine(result);
                if (this.mNumPendingFilters == 0) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        CarrierServicesSmsFilter.this.mCarrierServicesSmsFilterCallback.onFilterComplete(this.mFilterResult);
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            }
        }

        private void combine(int result) {
            this.mFilterResult |= result;
        }
    }

    private final class CarrierSmsFilterCallback
    extends ICarrierMessagingCallback.Stub {
        private final FilterAggregator mFilterAggregator;
        private final CarrierMessagingServiceManager mCarrierMessagingServiceManager;

        CarrierSmsFilterCallback(FilterAggregator filterAggregator, CarrierMessagingServiceManager carrierMessagingServiceManager) {
            this.mFilterAggregator = filterAggregator;
            this.mCarrierMessagingServiceManager = carrierMessagingServiceManager;
        }

        @Override
        public void onFilterComplete(int result) {
            this.mCarrierMessagingServiceManager.disposeConnection(CarrierServicesSmsFilter.this.mContext);
            this.mFilterAggregator.onFilterComplete(result);
        }

        @Override
        public void onSendSmsComplete(int result, int messageRef) {
            CarrierServicesSmsFilter.this.loge("Unexpected onSendSmsComplete call with result: " + result);
        }

        @Override
        public void onSendMultipartSmsComplete(int result, int[] messageRefs) {
            CarrierServicesSmsFilter.this.loge("Unexpected onSendMultipartSmsComplete call with result: " + result);
        }

        @Override
        public void onSendMmsComplete(int result, byte[] sendConfPdu) {
            CarrierServicesSmsFilter.this.loge("Unexpected onSendMmsComplete call with result: " + result);
        }

        @Override
        public void onDownloadMmsComplete(int result) {
            CarrierServicesSmsFilter.this.loge("Unexpected onDownloadMmsComplete call with result: " + result);
        }
    }

    private final class CarrierSmsFilter
    extends CarrierMessagingServiceManager {
        private final byte[][] mPdus;
        private final int mDestPort;
        private final String mSmsFormat;
        private volatile CarrierSmsFilterCallback mSmsFilterCallback;

        CarrierSmsFilter(byte[][] pdus, int destPort, String smsFormat) {
            this.mPdus = pdus;
            this.mDestPort = destPort;
            this.mSmsFormat = smsFormat;
        }

        void filterSms(String carrierPackageName, CarrierSmsFilterCallback smsFilterCallback) {
            this.mSmsFilterCallback = smsFilterCallback;
            if (!this.bindToCarrierMessagingService(CarrierServicesSmsFilter.this.mContext, carrierPackageName)) {
                CarrierServicesSmsFilter.this.loge("bindService() for carrier messaging service failed");
                smsFilterCallback.onFilterComplete(0);
            } else {
                CarrierServicesSmsFilter.this.logv("bindService() for carrier messaging service succeeded");
            }
        }

        @Override
        protected void onServiceReady(ICarrierMessagingService carrierMessagingService) {
            try {
                carrierMessagingService.filterSms(new MessagePdu(Arrays.asList(this.mPdus)), this.mSmsFormat, this.mDestPort, CarrierServicesSmsFilter.this.mPhone.getSubId(), this.mSmsFilterCallback);
            }
            catch (RemoteException e) {
                CarrierServicesSmsFilter.this.loge("Exception filtering the SMS: " + e);
                this.mSmsFilterCallback.onFilterComplete(0);
            }
        }
    }

    @VisibleForTesting
    public static interface CarrierServicesSmsFilterCallbackInterface {
        public void onFilterComplete(int var1);
    }
}

