/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.hardware.radio.V1_0.CellIdentity;
import android.hardware.radio.V1_0.CellIdentityGsm;
import android.hardware.radio.V1_0.CellIdentityLte;
import android.hardware.radio.V1_0.DataRegStateResult;
import android.hardware.radio.V1_0.VoiceRegStateResult;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.telephony.CellIdentityCdma;
import android.telephony.CellIdentityTdscdma;
import android.telephony.CellIdentityWcdma;
import android.telephony.NetworkRegistrationState;
import android.telephony.NetworkService;
import android.telephony.NetworkServiceCallback;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import java.util.concurrent.ConcurrentHashMap;

public class CellularNetworkService
extends NetworkService {
    private static final boolean DBG = false;
    private static final String TAG = CellularNetworkService.class.getSimpleName();
    private static final int GET_CS_REGISTRATION_STATE_DONE = 1;
    private static final int GET_PS_REGISTRATION_STATE_DONE = 2;
    private static final int NETWORK_REGISTRATION_STATE_CHANGED = 3;

    @Override
    protected NetworkService.NetworkServiceProvider createNetworkServiceProvider(int slotId) {
        if (!SubscriptionManager.isValidSlotIndex(slotId)) {
            this.loge("Tried to Cellular network service with invalid slotId " + slotId);
            return null;
        }
        return new CellularNetworkServiceProvider(slotId);
    }

    private void log(String s) {
        Rlog.d(TAG, s);
    }

    private void loge(String s) {
        Rlog.e(TAG, s);
    }

    private class CellularNetworkServiceProvider
    extends NetworkService.NetworkServiceProvider {
        private final ConcurrentHashMap<Message, NetworkServiceCallback> mCallbackMap;
        private final Looper mLooper;
        private final HandlerThread mHandlerThread;
        private final Handler mHandler;
        private final Phone mPhone;

        CellularNetworkServiceProvider(int slotId) {
            super(CellularNetworkService.this, slotId);
            this.mCallbackMap = new ConcurrentHashMap();
            this.mPhone = PhoneFactory.getPhone(this.getSlotId());
            this.mHandlerThread = new HandlerThread(CellularNetworkService.class.getSimpleName());
            this.mHandlerThread.start();
            this.mLooper = this.mHandlerThread.getLooper();
            this.mHandler = new Handler(this.mLooper){

                @Override
                public void handleMessage(Message message) {
                    NetworkServiceCallback callback = (NetworkServiceCallback)CellularNetworkServiceProvider.this.mCallbackMap.remove(message);
                    switch (message.what) {
                        case 1: 
                        case 2: {
                            if (callback == null) {
                                return;
                            }
                            AsyncResult ar = (AsyncResult)message.obj;
                            int domain = message.what == 1 ? 1 : 2;
                            NetworkRegistrationState netState = CellularNetworkServiceProvider.this.getRegistrationStateFromResult(ar.result, domain);
                            int resultCode = ar.exception != null || netState == null ? 5 : 0;
                            try {
                                callback.onGetNetworkRegistrationStateComplete(resultCode, netState);
                            }
                            catch (Exception e) {
                                CellularNetworkService.this.loge("Exception: " + e);
                            }
                            break;
                        }
                        case 3: {
                            CellularNetworkServiceProvider.this.notifyNetworkRegistrationStateChanged();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
            };
            this.mPhone.mCi.registerForNetworkStateChanged(this.mHandler, 3, null);
        }

        private int getRegStateFromHalRegState(int halRegState) {
            switch (halRegState) {
                case 0: 
                case 10: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: 
                case 12: {
                    return 2;
                }
                case 3: 
                case 13: {
                    return 3;
                }
                case 4: 
                case 14: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
            }
            return 0;
        }

        private boolean isEmergencyOnly(int halRegState) {
            switch (halRegState) {
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    return true;
                }
            }
            return false;
        }

        private int[] getAvailableServices(int regState, int domain, boolean emergencyOnly) {
            int[] availableServices = null;
            if (emergencyOnly) {
                availableServices = new int[]{5};
            } else if (regState == 5 || regState == 1) {
                if (domain == 2) {
                    availableServices = new int[]{2};
                } else if (domain == 1) {
                    availableServices = new int[]{1, 3, 4};
                }
            }
            return availableServices;
        }

        private int getAccessNetworkTechnologyFromRat(int rilRat) {
            return ServiceState.rilRadioTechnologyToNetworkType(rilRat);
        }

        private NetworkRegistrationState getRegistrationStateFromResult(Object result, int domain) {
            if (result == null) {
                return null;
            }
            if (domain == 1) {
                VoiceRegStateResult voiceRegState = (VoiceRegStateResult)result;
                int transportType = 1;
                int regState = this.getRegStateFromHalRegState(voiceRegState.regState);
                int accessNetworkTechnology = this.getAccessNetworkTechnologyFromRat(voiceRegState.rat);
                int reasonForDenial = voiceRegState.reasonForDenial;
                boolean emergencyOnly = this.isEmergencyOnly(voiceRegState.regState);
                boolean cssSupported = voiceRegState.cssSupported;
                int roamingIndicator = voiceRegState.roamingIndicator;
                int systemIsInPrl = voiceRegState.systemIsInPrl;
                int defaultRoamingIndicator = voiceRegState.defaultRoamingIndicator;
                int[] availableServices = this.getAvailableServices(regState, domain, emergencyOnly);
                android.telephony.CellIdentity cellIdentity = this.convertHalCellIdentityToCellIdentity(voiceRegState.cellIdentity);
                return new NetworkRegistrationState(transportType, domain, regState, accessNetworkTechnology, reasonForDenial, emergencyOnly, availableServices, cellIdentity, cssSupported, roamingIndicator, systemIsInPrl, defaultRoamingIndicator);
            }
            if (domain == 2) {
                DataRegStateResult dataRegState = (DataRegStateResult)result;
                int transportType = 1;
                int regState = this.getRegStateFromHalRegState(dataRegState.regState);
                int accessNetworkTechnology = this.getAccessNetworkTechnologyFromRat(dataRegState.rat);
                int reasonForDenial = dataRegState.reasonDataDenied;
                boolean emergencyOnly = this.isEmergencyOnly(dataRegState.regState);
                int maxDataCalls = dataRegState.maxDataCalls;
                int[] availableServices = this.getAvailableServices(regState, domain, emergencyOnly);
                android.telephony.CellIdentity cellIdentity = this.convertHalCellIdentityToCellIdentity(dataRegState.cellIdentity);
                return new NetworkRegistrationState(transportType, domain, regState, accessNetworkTechnology, reasonForDenial, emergencyOnly, availableServices, cellIdentity, maxDataCalls);
            }
            return null;
        }

        private android.telephony.CellIdentity convertHalCellIdentityToCellIdentity(CellIdentity cellIdentity) {
            if (cellIdentity == null) {
                return null;
            }
            android.telephony.CellIdentity result = null;
            switch (cellIdentity.cellInfoType) {
                case 1: {
                    if (cellIdentity.cellIdentityGsm.size() != 1) break;
                    CellIdentityGsm cellIdentityGsm = cellIdentity.cellIdentityGsm.get(0);
                    result = new android.telephony.CellIdentityGsm(cellIdentityGsm.lac, cellIdentityGsm.cid, cellIdentityGsm.arfcn, cellIdentityGsm.bsic, cellIdentityGsm.mcc, cellIdentityGsm.mnc, null, null);
                    break;
                }
                case 4: {
                    if (cellIdentity.cellIdentityWcdma.size() != 1) break;
                    android.hardware.radio.V1_0.CellIdentityWcdma cellIdentityWcdma = cellIdentity.cellIdentityWcdma.get(0);
                    result = new CellIdentityWcdma(cellIdentityWcdma.lac, cellIdentityWcdma.cid, cellIdentityWcdma.psc, cellIdentityWcdma.uarfcn, cellIdentityWcdma.mcc, cellIdentityWcdma.mnc, null, null);
                    break;
                }
                case 5: {
                    if (cellIdentity.cellIdentityTdscdma.size() != 1) break;
                    android.hardware.radio.V1_0.CellIdentityTdscdma cellIdentityTdscdma = cellIdentity.cellIdentityTdscdma.get(0);
                    result = new CellIdentityTdscdma(cellIdentityTdscdma.mcc, cellIdentityTdscdma.mnc, cellIdentityTdscdma.lac, cellIdentityTdscdma.cid, cellIdentityTdscdma.cpid);
                    break;
                }
                case 3: {
                    if (cellIdentity.cellIdentityLte.size() != 1) break;
                    CellIdentityLte cellIdentityLte = cellIdentity.cellIdentityLte.get(0);
                    result = new android.telephony.CellIdentityLte(cellIdentityLte.ci, cellIdentityLte.pci, cellIdentityLte.tac, cellIdentityLte.earfcn, Integer.MAX_VALUE, cellIdentityLte.mcc, cellIdentityLte.mnc, null, null);
                    break;
                }
                case 2: {
                    if (cellIdentity.cellIdentityCdma.size() != 1) break;
                    android.hardware.radio.V1_0.CellIdentityCdma cellIdentityCdma = cellIdentity.cellIdentityCdma.get(0);
                    result = new CellIdentityCdma(cellIdentityCdma.networkId, cellIdentityCdma.systemId, cellIdentityCdma.baseStationId, cellIdentityCdma.longitude, cellIdentityCdma.latitude);
                    break;
                }
            }
            return result;
        }

        @Override
        public void getNetworkRegistrationState(int domain, NetworkServiceCallback callback) {
            Message message = null;
            if (domain == 1) {
                message = Message.obtain(this.mHandler, 1);
                this.mCallbackMap.put(message, callback);
                this.mPhone.mCi.getVoiceRegistrationState(message);
            } else if (domain == 2) {
                message = Message.obtain(this.mHandler, 2);
                this.mCallbackMap.put(message, callback);
                this.mPhone.mCi.getDataRegistrationState(message);
            } else {
                CellularNetworkService.this.loge("getNetworkRegistrationState invalid domain " + domain);
                callback.onGetNetworkRegistrationStateComplete(2, null);
            }
        }

        @Override
        protected void onDestroy() {
            super.onDestroy();
            this.mCallbackMap.clear();
            this.mHandlerThread.quit();
            this.mPhone.mCi.unregisterForNetworkStateChanged(this.mHandler);
        }
    }
}

