/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import com.android.internal.telephony.ATParseEx;
import com.android.internal.telephony.ATResponseParser;
import com.android.internal.telephony.UUSInfo;

public class DriverCall
implements Comparable<DriverCall> {
    static final String LOG_TAG = "DriverCall";
    public static final int AUDIO_QUALITY_UNSPECIFIED = 0;
    public static final int AUDIO_QUALITY_AMR = 1;
    public static final int AUDIO_QUALITY_AMR_WB = 2;
    public static final int AUDIO_QUALITY_GSM_EFR = 3;
    public static final int AUDIO_QUALITY_GSM_FR = 4;
    public static final int AUDIO_QUALITY_GSM_HR = 5;
    public static final int AUDIO_QUALITY_EVRC = 6;
    public static final int AUDIO_QUALITY_EVRC_B = 7;
    public static final int AUDIO_QUALITY_EVRC_WB = 8;
    public static final int AUDIO_QUALITY_EVRC_NW = 9;
    public int index;
    public boolean isMT;
    public State state;
    public boolean isMpty;
    public String number;
    public int TOA;
    public boolean isVoice;
    public boolean isVoicePrivacy;
    public int als;
    public int numberPresentation;
    public String name;
    public int namePresentation;
    public UUSInfo uusInfo;
    public int audioQuality = 0;

    static DriverCall fromCLCCLine(String line) {
        DriverCall ret = new DriverCall();
        ATResponseParser p = new ATResponseParser(line);
        try {
            ret.index = p.nextInt();
            ret.isMT = p.nextBoolean();
            ret.state = DriverCall.stateFromCLCC(p.nextInt());
            ret.isVoice = 0 == p.nextInt();
            ret.isMpty = p.nextBoolean();
            ret.numberPresentation = 1;
            if (p.hasMore()) {
                ret.number = PhoneNumberUtils.extractNetworkPortionAlt(p.nextString());
                if (ret.number.length() == 0) {
                    ret.number = null;
                }
                ret.TOA = p.nextInt();
                ret.number = PhoneNumberUtils.stringFromStringAndTOA(ret.number, ret.TOA);
            }
        }
        catch (ATParseEx ex) {
            Rlog.e(LOG_TAG, "Invalid CLCC line: '" + line + "'");
            return null;
        }
        return ret;
    }

    public String toString() {
        return "id=" + this.index + "," + (Object)((Object)this.state) + ",toa=" + this.TOA + "," + (this.isMpty ? "conf" : "norm") + "," + (this.isMT ? "mt" : "mo") + "," + this.als + "," + (this.isVoice ? "voc" : "nonvoc") + "," + (this.isVoicePrivacy ? "evp" : "noevp") + ",,cli=" + this.numberPresentation + ",," + this.namePresentation + ",audioQuality=" + this.audioQuality;
    }

    public static State stateFromCLCC(int state) throws ATParseEx {
        switch (state) {
            case 0: {
                return State.ACTIVE;
            }
            case 1: {
                return State.HOLDING;
            }
            case 2: {
                return State.DIALING;
            }
            case 3: {
                return State.ALERTING;
            }
            case 4: {
                return State.INCOMING;
            }
            case 5: {
                return State.WAITING;
            }
        }
        throw new ATParseEx("illegal call state " + state);
    }

    public static int presentationFromCLIP(int cli) throws ATParseEx {
        switch (cli) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        throw new ATParseEx("illegal presentation " + cli);
    }

    @Override
    public int compareTo(DriverCall dc) {
        if (this.index < dc.index) {
            return -1;
        }
        if (this.index == dc.index) {
            return 0;
        }
        return 1;
    }

    public static enum State {
        ACTIVE,
        HOLDING,
        DIALING,
        ALERTING,
        INCOMING,
        WAITING;

    }
}

