/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Message;
import android.os.RemoteException;
import android.telephony.Rlog;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.aidl.IImsSmsListener;
import android.telephony.ims.feature.ImsFeature;
import android.telephony.ims.stub.ImsRegistrationImplBase;
import android.util.Pair;
import com.android.ims.ImsException;
import com.android.ims.ImsManager;
import com.android.ims.MmTelFeatureConnection;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsDispatchersController;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.util.SMSDispatcherUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ImsSmsDispatcher
extends SMSDispatcher {
    private static final int IMS_RETRY_STARTING_TIMEOUT_MS = 500;
    private static final int CEILING_SERVICE_RETRY_COUNT = 6;
    @VisibleForTesting
    public Map<Integer, SMSDispatcher.SmsTracker> mTrackers = new ConcurrentHashMap<Integer, SMSDispatcher.SmsTracker>();
    @VisibleForTesting
    public AtomicInteger mNextToken = new AtomicInteger();
    private final Object mLock = new Object();
    private volatile boolean mIsSmsCapable;
    private volatile boolean mIsImsServiceUp;
    private volatile boolean mIsRegistered;
    private volatile int mImsServiceRetryCount = 0;
    private IRetryTimeout mRetryTimeout = () -> {
        int timeout = (1 << this.mImsServiceRetryCount) * 500;
        if (this.mImsServiceRetryCount <= 6) {
            ++this.mImsServiceRetryCount;
        }
        return timeout;
    };
    private ImsRegistrationImplBase.Callback mRegistrationCallback = new ImsRegistrationImplBase.Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRegistered(int imsRadioTech) {
            Rlog.d("SMSDispatcher", "onImsConnected imsRadioTech=" + imsRadioTech);
            Object object = ImsSmsDispatcher.this.mLock;
            synchronized (object) {
                ImsSmsDispatcher.this.mIsRegistered = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRegistering(int imsRadioTech) {
            Rlog.d("SMSDispatcher", "onImsProgressing imsRadioTech=" + imsRadioTech);
            Object object = ImsSmsDispatcher.this.mLock;
            synchronized (object) {
                ImsSmsDispatcher.this.mIsRegistered = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDeregistered(ImsReasonInfo info) {
            Rlog.d("SMSDispatcher", "onImsDisconnected imsReasonInfo=" + info);
            Object object = ImsSmsDispatcher.this.mLock;
            synchronized (object) {
                ImsSmsDispatcher.this.mIsRegistered = false;
            }
        }
    };
    private ImsFeature.CapabilityCallback mCapabilityCallback = new ImsFeature.CapabilityCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCapabilitiesStatusChanged(ImsFeature.Capabilities config) {
            Object object = ImsSmsDispatcher.this.mLock;
            synchronized (object) {
                ImsSmsDispatcher.this.mIsSmsCapable = config.isCapable(8);
            }
        }
    };
    private MmTelFeatureConnection.IFeatureUpdate mNotifyStatusChangedCallback = new MmTelFeatureConnection.IFeatureUpdate(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyStateChanged() {
            try {
                int status = ImsSmsDispatcher.this.getImsManager().getImsServiceState();
                Rlog.d("SMSDispatcher", "Status Changed: " + status);
                switch (status) {
                    case 2: {
                        Object object = ImsSmsDispatcher.this.mLock;
                        synchronized (object) {
                            ImsSmsDispatcher.this.setListeners();
                            ImsSmsDispatcher.this.mIsImsServiceUp = true;
                            break;
                        }
                    }
                    case 0: 
                    case 1: {
                        Object object = ImsSmsDispatcher.this.mLock;
                        synchronized (object) {
                            ImsSmsDispatcher.this.mIsImsServiceUp = false;
                            break;
                        }
                    }
                    default: {
                        Rlog.w("SMSDispatcher", "Unexpected State!");
                    }
                }
            }
            catch (ImsException e) {
                ImsSmsDispatcher.this.retryGetImsService();
            }
        }

        @Override
        public void notifyUnavailable() {
            ImsSmsDispatcher.this.retryGetImsService();
        }
    };
    private final IImsSmsListener mImsSmsListener = new IImsSmsListener.Stub(){

        @Override
        public void onSendSmsResult(int token, int messageRef, int status, int reason) throws RemoteException {
            SMSDispatcher.SmsTracker tracker = ImsSmsDispatcher.this.mTrackers.get(token);
            if (tracker == null) {
                throw new IllegalArgumentException("Invalid token.");
            }
            switch (reason) {
                case 1: {
                    tracker.onSent(ImsSmsDispatcher.this.mContext);
                    break;
                }
                case 2: {
                    tracker.onFailed(ImsSmsDispatcher.this.mContext, reason, 0);
                    ImsSmsDispatcher.this.mTrackers.remove(token);
                    break;
                }
                case 3: {
                    ++tracker.mRetryCount;
                    ImsSmsDispatcher.this.sendSms(tracker);
                    break;
                }
                case 4: {
                    ImsSmsDispatcher.this.fallbackToPstn(token, tracker);
                    break;
                }
            }
        }

        @Override
        public void onSmsStatusReportReceived(int token, int messageRef, String format, byte[] pdu) throws RemoteException {
            Rlog.d("SMSDispatcher", "Status report received.");
            SMSDispatcher.SmsTracker tracker = ImsSmsDispatcher.this.mTrackers.get(token);
            if (tracker == null) {
                throw new RemoteException("Invalid token.");
            }
            Pair<Boolean, Boolean> result = ImsSmsDispatcher.this.mSmsDispatchersController.handleSmsStatusReport(tracker, format, pdu);
            Rlog.d("SMSDispatcher", "Status report handle result, success: " + result.first + "complete: " + result.second);
            try {
                ImsSmsDispatcher.this.getImsManager().acknowledgeSmsReport(token, messageRef, (Boolean)result.first != false ? 1 : 2);
            }
            catch (ImsException e) {
                Rlog.e("SMSDispatcher", "Failed to acknowledgeSmsReport(). Error: " + e.getMessage());
            }
            if (((Boolean)result.second).booleanValue()) {
                ImsSmsDispatcher.this.mTrackers.remove(token);
            }
        }

        @Override
        public void onSmsReceived(int token, String format, byte[] pdu) throws RemoteException {
            Rlog.d("SMSDispatcher", "SMS received.");
            ImsSmsDispatcher.this.mSmsDispatchersController.injectSmsPdu(pdu, format, result -> {
                Rlog.d("SMSDispatcher", "SMS handled result: " + result);
                try {
                    ImsSmsDispatcher.this.getImsManager().acknowledgeSms(token, 0, result == 1 ? 1 : 2);
                }
                catch (ImsException e) {
                    Rlog.e("SMSDispatcher", "Failed to acknowledgeSms(). Error: " + e.getMessage());
                }
            });
        }
    };

    public ImsSmsDispatcher(Phone phone, SmsDispatchersController smsDispatchersController) {
        super(phone, smsDispatchersController);
        this.sendEmptyMessage(16);
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 16: {
                try {
                    this.getImsService();
                }
                catch (ImsException e) {
                    Rlog.e("SMSDispatcher", "setListeners: " + e);
                    this.retryGetImsService();
                }
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    private void getImsService() throws ImsException {
        Rlog.d("SMSDispatcher", "getImsService");
        this.getImsManager().addNotifyStatusChangedCallbackIfAvailable(this.mNotifyStatusChangedCallback);
        this.mNotifyStatusChangedCallback.notifyStateChanged();
    }

    private void setListeners() throws ImsException {
        this.getImsManager().addRegistrationCallback(this.mRegistrationCallback);
        this.getImsManager().addCapabilitiesCallback(this.mCapabilityCallback);
        this.getImsManager().setSmsListener(this.mImsSmsListener);
        this.getImsManager().onSmsReady();
        this.mImsServiceRetryCount = 0;
    }

    private void retryGetImsService() {
        if (this.getImsManager().isServiceAvailable()) {
            return;
        }
        this.getImsManager().removeNotifyStatusChangedCallback(this.mNotifyStatusChangedCallback);
        Rlog.e("SMSDispatcher", "getImsService: Retrying getting ImsService...");
        this.removeMessages(16);
        this.sendEmptyMessageDelayed(16, this.mRetryTimeout.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIsImsServiceUp && this.mIsRegistered && this.mIsSmsCapable;
        }
    }

    @Override
    protected String getFormat() {
        try {
            return this.getImsManager().getSmsFormat();
        }
        catch (ImsException e) {
            Rlog.e("SMSDispatcher", "Failed to get sms format. Error: " + e.getMessage());
            return "unknown";
        }
    }

    @Override
    protected boolean shouldBlockSms() {
        return SMSDispatcherUtil.shouldBlockSms(this.isCdmaMo(), this.mPhone);
    }

    @Override
    protected SmsMessageBase.SubmitPduBase getSubmitPdu(String scAddr, String destAddr, String message, boolean statusReportRequested, SmsHeader smsHeader) {
        return SMSDispatcherUtil.getSubmitPdu(this.isCdmaMo(), scAddr, destAddr, message, statusReportRequested, smsHeader);
    }

    @Override
    protected SmsMessageBase.SubmitPduBase getSubmitPdu(String scAddr, String destAddr, int destPort, byte[] message, boolean statusReportRequested) {
        return SMSDispatcherUtil.getSubmitPdu(this.isCdmaMo(), scAddr, destAddr, destPort, message, statusReportRequested);
    }

    @Override
    protected GsmAlphabet.TextEncodingDetails calculateLength(CharSequence messageBody, boolean use7bitOnly) {
        return SMSDispatcherUtil.calculateLength(this.isCdmaMo(), messageBody, use7bitOnly);
    }

    @Override
    public void sendSms(SMSDispatcher.SmsTracker tracker) {
        boolean isRetry;
        Rlog.d("SMSDispatcher", "sendSms:  mRetryCount=" + tracker.mRetryCount + " mMessageRef=" + tracker.mMessageRef + " SS=" + this.mPhone.getServiceState().getState());
        HashMap<String, Object> map = tracker.getData();
        byte[] pdu = (byte[])map.get("pdu");
        byte[] smsc = (byte[])map.get("smsc");
        boolean bl = isRetry = tracker.mRetryCount > 0;
        if ("3gpp".equals(this.getFormat()) && tracker.mRetryCount > 0 && (1 & pdu[0]) == 1) {
            pdu[0] = (byte)(pdu[0] | 4);
            pdu[1] = (byte)tracker.mMessageRef;
        }
        int token = this.mNextToken.incrementAndGet();
        this.mTrackers.put(token, tracker);
        try {
            this.getImsManager().sendSms(token, tracker.mMessageRef, this.getFormat(), smsc != null ? new String(smsc) : null, isRetry, pdu);
        }
        catch (ImsException e) {
            Rlog.e("SMSDispatcher", "sendSms failed. Falling back to PSTN. Error: " + e.getMessage());
            this.fallbackToPstn(token, tracker);
        }
    }

    private ImsManager getImsManager() {
        return ImsManager.getInstance(this.mContext, this.mPhone.getPhoneId());
    }

    @VisibleForTesting
    public void fallbackToPstn(int token, SMSDispatcher.SmsTracker tracker) {
        this.mSmsDispatchersController.sendRetrySms(tracker);
        this.mTrackers.remove(token);
    }

    @Override
    protected boolean isCdmaMo() {
        return this.mSmsDispatchersController.isCdmaFormat(this.getFormat());
    }

    @VisibleForTesting
    public static interface IRetryTimeout {
        public int get();
    }
}

