/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.telephony.CarrierConfigManager;
import android.telephony.INetworkService;
import android.telephony.INetworkServiceCallback;
import android.telephony.NetworkRegistrationState;
import android.telephony.Rlog;
import com.android.internal.telephony.Phone;

public class NetworkRegistrationManager {
    private static final String TAG = NetworkRegistrationManager.class.getSimpleName();
    private final int mTransportType;
    private final Phone mPhone;
    private final CarrierConfigManager mCarrierConfigManager;
    private final RegistrantList mRegStateChangeRegistrants = new RegistrantList();
    private INetworkService.Stub mServiceBinder;
    private RegManagerDeathRecipient mDeathRecipient;

    public NetworkRegistrationManager(int transportType, Phone phone) {
        this.mTransportType = transportType;
        this.mPhone = phone;
        this.mCarrierConfigManager = (CarrierConfigManager)phone.getContext().getSystemService("carrier_config");
        this.bindService();
    }

    public boolean isServiceConnected() {
        return this.mServiceBinder != null && this.mServiceBinder.isBinderAlive();
    }

    public void unregisterForNetworkRegistrationStateChanged(Handler h) {
        this.mRegStateChangeRegistrants.remove(h);
    }

    public void registerForNetworkRegistrationStateChanged(Handler h, int what, Object obj) {
        NetworkRegistrationManager.logd("registerForNetworkRegistrationStateChanged");
        Registrant r = new Registrant(h, what, obj);
        this.mRegStateChangeRegistrants.addUnique(h, what, obj);
    }

    public void getNetworkRegistrationState(int domain, Message onCompleteMessage) {
        if (onCompleteMessage == null) {
            return;
        }
        NetworkRegistrationManager.logd("getNetworkRegistrationState domain " + domain);
        if (!this.isServiceConnected()) {
            onCompleteMessage.obj = new AsyncResult(onCompleteMessage.obj, null, new IllegalStateException("Service not connected."));
            onCompleteMessage.sendToTarget();
            return;
        }
        try {
            this.mServiceBinder.getNetworkRegistrationState(this.mPhone.getPhoneId(), domain, new NetworkRegStateCallback(onCompleteMessage));
        }
        catch (RemoteException e) {
            Rlog.e(TAG, "getNetworkRegistrationState RemoteException " + e);
            onCompleteMessage.obj = new AsyncResult(onCompleteMessage.obj, null, e);
            onCompleteMessage.sendToTarget();
        }
    }

    private boolean bindService() {
        Intent intent = new Intent("android.telephony.NetworkService");
        intent.setPackage(this.getPackageName());
        try {
            return this.mPhone.getContext().bindService(intent, new NetworkServiceConnection(), 1);
        }
        catch (SecurityException e) {
            NetworkRegistrationManager.loge("bindService failed " + e);
            return false;
        }
    }

    private String getPackageName() {
        String carrierConfig;
        int resourceId;
        switch (this.mTransportType) {
            case 1: {
                resourceId = 17039721;
                carrierConfig = "carrier_network_service_wwan_package_override_string";
                break;
            }
            case 2: {
                resourceId = 17039719;
                carrierConfig = "carrier_network_service_wlan_package_override_string";
                break;
            }
            default: {
                throw new IllegalStateException("Transport type not WWAN or WLAN. type=" + this.mTransportType);
            }
        }
        String packageName = this.mPhone.getContext().getResources().getString(resourceId);
        PersistableBundle b = this.mCarrierConfigManager.getConfigForSubId(this.mPhone.getSubId());
        if (b != null) {
            packageName = b.getString(carrierConfig, packageName);
        }
        NetworkRegistrationManager.logd("Binding to packageName " + packageName + " for transport type" + this.mTransportType);
        return packageName;
    }

    private static int logd(String msg) {
        return Rlog.d(TAG, msg);
    }

    private static int loge(String msg) {
        return Rlog.e(TAG, msg);
    }

    private class NetworkRegStateCallback
    extends INetworkServiceCallback.Stub {
        private final Message mOnCompleteMessage;

        NetworkRegStateCallback(Message onCompleteMessage) {
            this.mOnCompleteMessage = onCompleteMessage;
        }

        @Override
        public void onGetNetworkRegistrationStateComplete(int result, NetworkRegistrationState state) {
            NetworkRegistrationManager.logd("onGetNetworkRegistrationStateComplete result " + result + " state " + state);
            this.mOnCompleteMessage.arg1 = result;
            this.mOnCompleteMessage.obj = new AsyncResult(this.mOnCompleteMessage.obj, state, null);
            this.mOnCompleteMessage.sendToTarget();
        }

        @Override
        public void onNetworkStateChanged() {
            NetworkRegistrationManager.logd("onNetworkStateChanged");
            NetworkRegistrationManager.this.mRegStateChangeRegistrants.notifyRegistrants();
        }
    }

    private class NetworkServiceConnection
    implements ServiceConnection {
        private NetworkServiceConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            NetworkRegistrationManager.this.mServiceBinder = (INetworkService.Stub)service;
            NetworkRegistrationManager.this.mDeathRecipient = new RegManagerDeathRecipient(name);
            try {
                NetworkRegistrationManager.this.mServiceBinder.linkToDeath(NetworkRegistrationManager.this.mDeathRecipient, 0);
                NetworkRegistrationManager.this.mServiceBinder.createNetworkServiceProvider(NetworkRegistrationManager.this.mPhone.getPhoneId());
                NetworkRegistrationManager.this.mServiceBinder.registerForNetworkRegistrationStateChanged(NetworkRegistrationManager.this.mPhone.getPhoneId(), new NetworkRegStateCallback(null));
            }
            catch (RemoteException exception) {
                NetworkRegistrationManager.this.mDeathRecipient.binderDied();
                NetworkRegistrationManager.logd("RemoteException " + exception);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            NetworkRegistrationManager.logd("onServiceDisconnected " + name);
            if (NetworkRegistrationManager.this.mServiceBinder != null) {
                NetworkRegistrationManager.this.mServiceBinder.unlinkToDeath(NetworkRegistrationManager.this.mDeathRecipient, 0);
            }
        }
    }

    private class RegManagerDeathRecipient
    implements IBinder.DeathRecipient {
        private final ComponentName mComponentName;

        RegManagerDeathRecipient(ComponentName name) {
            this.mComponentName = name;
        }

        @Override
        public void binderDied() {
            NetworkRegistrationManager.logd("NetworkService(" + this.mComponentName + " transport type " + NetworkRegistrationManager.this.mTransportType + ") died.");
        }
    }
}

