/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.telephony.Rlog;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Calendar;
import java.util.TimeZone;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public final class NitzData {
    private static final String LOG_TAG = "SST";
    private static final int MS_PER_QUARTER_HOUR = 900000;
    private static final int MAX_NITZ_YEAR = 2037;
    private final String mOriginalString;
    private final int mZoneOffset;
    private final Integer mDstOffset;
    private final long mCurrentTimeMillis;
    private final TimeZone mEmulatorHostTimeZone;

    private NitzData(String originalString, int zoneOffsetMillis, Integer dstOffsetMillis, long utcTimeMillis, TimeZone emulatorHostTimeZone) {
        if (originalString == null) {
            throw new NullPointerException("originalString==null");
        }
        this.mOriginalString = originalString;
        this.mZoneOffset = zoneOffsetMillis;
        this.mDstOffset = dstOffsetMillis;
        this.mCurrentTimeMillis = utcTimeMillis;
        this.mEmulatorHostTimeZone = emulatorHostTimeZone;
    }

    public static NitzData parse(String nitz) {
        try {
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            c.clear();
            c.set(16, 0);
            String[] nitzSubs = nitz.split("[/:,+-]");
            int year = 2000 + Integer.parseInt(nitzSubs[0]);
            if (year > 2037) {
                Rlog.e(LOG_TAG, "NITZ year: " + year + " exceeds limit, skip NITZ time update");
                return null;
            }
            c.set(1, year);
            int month = Integer.parseInt(nitzSubs[1]) - 1;
            c.set(2, month);
            int date = Integer.parseInt(nitzSubs[2]);
            c.set(5, date);
            int hour = Integer.parseInt(nitzSubs[3]);
            c.set(10, hour);
            int minute = Integer.parseInt(nitzSubs[4]);
            c.set(12, minute);
            int second = Integer.parseInt(nitzSubs[5]);
            c.set(13, second);
            boolean sign = nitz.indexOf(45) == -1;
            int totalUtcOffsetQuarterHours = Integer.parseInt(nitzSubs[6]);
            int totalUtcOffsetMillis = (sign ? 1 : -1) * totalUtcOffsetQuarterHours * 900000;
            Integer dstAdjustmentQuarterHours = nitzSubs.length >= 8 ? Integer.valueOf(Integer.parseInt(nitzSubs[7])) : null;
            Integer dstAdjustmentMillis = null;
            if (dstAdjustmentQuarterHours != null) {
                dstAdjustmentMillis = dstAdjustmentQuarterHours * 900000;
            }
            TimeZone zone = null;
            if (nitzSubs.length >= 9) {
                String tzname = nitzSubs[8].replace('!', '/');
                zone = TimeZone.getTimeZone(tzname);
            }
            return new NitzData(nitz, totalUtcOffsetMillis, dstAdjustmentMillis, c.getTimeInMillis(), zone);
        }
        catch (RuntimeException ex) {
            Rlog.e(LOG_TAG, "NITZ: Parsing NITZ time " + nitz + " ex=" + ex);
            return null;
        }
    }

    public static NitzData createForTests(int zoneOffsetMillis, Integer dstOffsetMillis, long utcTimeMillis, TimeZone emulatorHostTimeZone) {
        return new NitzData("Test data", zoneOffsetMillis, dstOffsetMillis, utcTimeMillis, emulatorHostTimeZone);
    }

    public long getCurrentTimeInMillis() {
        return this.mCurrentTimeMillis;
    }

    public int getLocalOffsetMillis() {
        return this.mZoneOffset;
    }

    public Integer getDstAdjustmentMillis() {
        return this.mDstOffset;
    }

    public boolean isDst() {
        return this.mDstOffset != null && this.mDstOffset != 0;
    }

    public TimeZone getEmulatorHostTimeZone() {
        return this.mEmulatorHostTimeZone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NitzData nitzData = (NitzData)o;
        if (this.mZoneOffset != nitzData.mZoneOffset) {
            return false;
        }
        if (this.mCurrentTimeMillis != nitzData.mCurrentTimeMillis) {
            return false;
        }
        if (!this.mOriginalString.equals(nitzData.mOriginalString)) {
            return false;
        }
        if (this.mDstOffset != null ? !this.mDstOffset.equals(nitzData.mDstOffset) : nitzData.mDstOffset != null) {
            return false;
        }
        return this.mEmulatorHostTimeZone != null ? this.mEmulatorHostTimeZone.equals(nitzData.mEmulatorHostTimeZone) : nitzData.mEmulatorHostTimeZone == null;
    }

    public int hashCode() {
        int result = this.mOriginalString.hashCode();
        result = 31 * result + this.mZoneOffset;
        result = 31 * result + (this.mDstOffset != null ? this.mDstOffset.hashCode() : 0);
        result = 31 * result + (int)(this.mCurrentTimeMillis ^ this.mCurrentTimeMillis >>> 32);
        result = 31 * result + (this.mEmulatorHostTimeZone != null ? this.mEmulatorHostTimeZone.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "NitzData{mOriginalString=" + this.mOriginalString + ", mZoneOffset=" + this.mZoneOffset + ", mDstOffset=" + this.mDstOffset + ", mCurrentTimeMillis=" + this.mCurrentTimeMillis + ", mEmulatorHostTimeZone=" + this.mEmulatorHostTimeZone + '}';
    }
}

