/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.content.Context;
import android.os.PowerManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.TimeUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.NitzData;
import com.android.internal.telephony.TimeServiceHelper;
import com.android.internal.telephony.TimeZoneLookupHelper;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.util.TimeStampedValue;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.TimeZone;

public class NitzStateMachine {
    private static final String LOG_TAG = "SST";
    private static final boolean DBG = true;
    private TimeStampedValue<Long> mSavedNitzTime;
    private boolean mNeedCountryCodeForNitz = false;
    private TimeStampedValue<NitzData> mLatestNitzSignal;
    private boolean mGotCountryCode = false;
    private String mSavedTimeZoneId;
    private boolean mNitzTimeZoneDetectionSuccessful = false;
    private final LocalLog mTimeLog = new LocalLog(15);
    private final LocalLog mTimeZoneLog = new LocalLog(15);
    private final GsmCdmaPhone mPhone;
    private final DeviceState mDeviceState;
    private final TimeServiceHelper mTimeServiceHelper;
    private final TimeZoneLookupHelper mTimeZoneLookupHelper;
    private final PowerManager.WakeLock mWakeLock;
    private static final String WAKELOCK_TAG = "NitzStateMachine";

    public NitzStateMachine(GsmCdmaPhone phone) {
        this(phone, new TimeServiceHelper(phone.getContext()), new DeviceState(phone), new TimeZoneLookupHelper());
    }

    @VisibleForTesting
    public NitzStateMachine(GsmCdmaPhone phone, TimeServiceHelper timeServiceHelper, DeviceState deviceState, TimeZoneLookupHelper timeZoneLookupHelper) {
        this.mPhone = phone;
        Context context = phone.getContext();
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, WAKELOCK_TAG);
        this.mDeviceState = deviceState;
        this.mTimeZoneLookupHelper = timeZoneLookupHelper;
        this.mTimeServiceHelper = timeServiceHelper;
        this.mTimeServiceHelper.setListener(new TimeServiceHelper.Listener(){

            @Override
            public void onTimeDetectionChange(boolean enabled) {
                if (enabled) {
                    NitzStateMachine.this.handleAutoTimeEnabled();
                }
            }

            @Override
            public void onTimeZoneDetectionChange(boolean enabled) {
                if (enabled) {
                    NitzStateMachine.this.handleAutoTimeZoneEnabled();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNetworkCountryCodeSet(boolean countryChanged) {
        this.mGotCountryCode = true;
        String isoCountryCode = this.mDeviceState.getNetworkCountryIsoForPhone();
        if (!TextUtils.isEmpty(isoCountryCode) && !this.mNitzTimeZoneDetectionSuccessful && this.mTimeServiceHelper.isTimeZoneDetectionEnabled()) {
            this.updateTimeZoneByNetworkCountryCode(isoCountryCode);
        }
        if (countryChanged || this.mNeedCountryCodeForNitz) {
            String zoneId;
            boolean isTimeZoneSettingInitialized = this.mTimeServiceHelper.isTimeZoneSettingInitialized();
            Rlog.d(LOG_TAG, "handleNetworkCountryCodeSet: isTimeZoneSettingInitialized=" + isTimeZoneSettingInitialized + " mLatestNitzSignal=" + this.mLatestNitzSignal + " isoCountryCode=" + isoCountryCode);
            if (TextUtils.isEmpty(isoCountryCode) && this.mNeedCountryCodeForNitz) {
                TimeZoneLookupHelper.OffsetResult lookupResult = this.mTimeZoneLookupHelper.lookupByNitz((NitzData)this.mLatestNitzSignal.mValue);
                Rlog.d(LOG_TAG, "handleNetworkCountryCodeSet: guessZoneIdByNitz() returned lookupResult=" + lookupResult);
                zoneId = lookupResult != null ? lookupResult.zoneId : null;
            } else if (this.mLatestNitzSignal == null) {
                zoneId = null;
                Rlog.d(LOG_TAG, "handleNetworkCountryCodeSet: No cached NITZ data available, not setting zone");
            } else if (NitzStateMachine.nitzOffsetMightBeBogus((NitzData)this.mLatestNitzSignal.mValue) && isTimeZoneSettingInitialized && !this.countryUsesUtc(isoCountryCode, this.mLatestNitzSignal)) {
                TimeZone zone = TimeZone.getDefault();
                Rlog.d(LOG_TAG, "handleNetworkCountryCodeSet: NITZ looks bogus, maybe using current default zone to adjust the system clock, mNeedCountryCodeForNitz=" + this.mNeedCountryCodeForNitz + " mLatestNitzSignal=" + this.mLatestNitzSignal + " zone=" + zone);
                zoneId = zone.getID();
                if (this.mNeedCountryCodeForNitz) {
                    NitzData nitzData = (NitzData)this.mLatestNitzSignal.mValue;
                    try {
                        this.mWakeLock.acquire();
                        long ctm = nitzData.getCurrentTimeInMillis();
                        long delayAdjustedCtm = ctm + (this.mTimeServiceHelper.elapsedRealtime() - this.mLatestNitzSignal.mElapsedRealtime);
                        long tzOffset = zone.getOffset(delayAdjustedCtm);
                        Rlog.d(LOG_TAG, "handleNetworkCountryCodeSet: tzOffset=" + tzOffset + " delayAdjustedCtm=" + TimeUtils.logTimeOfDay(delayAdjustedCtm));
                        if (this.mTimeServiceHelper.isTimeDetectionEnabled()) {
                            long timeZoneAdjustedCtm = delayAdjustedCtm - tzOffset;
                            String msg = "handleNetworkCountryCodeSet: setting time timeZoneAdjustedCtm=" + TimeUtils.logTimeOfDay(timeZoneAdjustedCtm);
                            this.setAndBroadcastNetworkSetTime(msg, timeZoneAdjustedCtm);
                        }
                        this.mSavedNitzTime = new TimeStampedValue<Long>((Long)this.mSavedNitzTime.mValue - tzOffset, this.mSavedNitzTime.mElapsedRealtime);
                        Rlog.d(LOG_TAG, "handleNetworkCountryCodeSet:adjusting time mSavedNitzTime=" + this.mSavedNitzTime);
                    }
                    finally {
                        this.mWakeLock.release();
                    }
                }
            } else {
                NitzData nitzData = (NitzData)this.mLatestNitzSignal.mValue;
                TimeZoneLookupHelper.OffsetResult lookupResult = this.mTimeZoneLookupHelper.lookupByNitzCountry(nitzData, isoCountryCode);
                Rlog.d(LOG_TAG, "handleNetworkCountryCodeSet: using guessZoneIdByNitzCountry(nitzData, isoCountryCode), nitzData=" + nitzData + " isoCountryCode=" + isoCountryCode + " lookupResult=" + lookupResult);
                zoneId = lookupResult != null ? lookupResult.zoneId : null;
            }
            String tmpLog = "handleNetworkCountryCodeSet: isTimeZoneSettingInitialized=" + isTimeZoneSettingInitialized + " mLatestNitzSignal=" + this.mLatestNitzSignal + " isoCountryCode=" + isoCountryCode + " mNeedCountryCodeForNitz=" + this.mNeedCountryCodeForNitz + " zoneId=" + zoneId;
            this.mTimeZoneLog.log(tmpLog);
            if (zoneId != null) {
                Rlog.d(LOG_TAG, "handleNetworkCountryCodeSet: zoneId != null, zoneId=" + zoneId);
                if (this.mTimeServiceHelper.isTimeZoneDetectionEnabled()) {
                    this.setAndBroadcastNetworkSetTimeZone(zoneId);
                } else {
                    Rlog.d(LOG_TAG, "handleNetworkCountryCodeSet: skip changing zone as isTimeZoneDetectionEnabled() is false");
                }
                if (this.mNeedCountryCodeForNitz) {
                    this.mSavedTimeZoneId = zoneId;
                }
            } else {
                Rlog.d(LOG_TAG, "handleNetworkCountryCodeSet: lookupResult == null, do nothing");
            }
            this.mNeedCountryCodeForNitz = false;
        }
    }

    private boolean countryUsesUtc(String isoCountryCode, TimeStampedValue<NitzData> nitzSignal) {
        return this.mTimeZoneLookupHelper.countryUsesUtc(isoCountryCode, ((NitzData)nitzSignal.mValue).getCurrentTimeInMillis());
    }

    public void handleNetworkAvailable() {
        Rlog.d(LOG_TAG, "handleNetworkAvailable: mNitzTimeZoneDetectionSuccessful=" + this.mNitzTimeZoneDetectionSuccessful + ", Setting mNitzTimeZoneDetectionSuccessful=false");
        this.mNitzTimeZoneDetectionSuccessful = false;
    }

    public void handleNetworkUnavailable() {
        Rlog.d(LOG_TAG, "handleNetworkUnavailable");
        this.mGotCountryCode = false;
        this.mNitzTimeZoneDetectionSuccessful = false;
    }

    private static boolean nitzOffsetMightBeBogus(NitzData nitzData) {
        return nitzData.getLocalOffsetMillis() == 0 && !nitzData.isDst();
    }

    public void handleNitzReceived(TimeStampedValue<NitzData> nitzSignal) {
        this.handleTimeZoneFromNitz(nitzSignal);
        this.handleTimeFromNitz(nitzSignal);
    }

    private void handleTimeZoneFromNitz(TimeStampedValue<NitzData> nitzSignal) {
        try {
            TimeZoneLookupHelper.OffsetResult lookupResult;
            String zoneId;
            NitzData newNitzData = (NitzData)nitzSignal.mValue;
            String iso = this.mDeviceState.getNetworkCountryIsoForPhone();
            if (newNitzData.getEmulatorHostTimeZone() != null) {
                zoneId = newNitzData.getEmulatorHostTimeZone().getID();
            } else if (!this.mGotCountryCode) {
                zoneId = null;
            } else if (!TextUtils.isEmpty(iso)) {
                lookupResult = this.mTimeZoneLookupHelper.lookupByNitzCountry(newNitzData, iso);
                zoneId = lookupResult != null ? lookupResult.zoneId : null;
            } else {
                lookupResult = this.mTimeZoneLookupHelper.lookupByNitz(newNitzData);
                Rlog.d(LOG_TAG, "handleTimeZoneFromNitz: guessZoneIdByNitz returned lookupResult=" + lookupResult);
                String string2 = zoneId = lookupResult != null ? lookupResult.zoneId : null;
            }
            if (zoneId == null || this.mLatestNitzSignal == null || NitzStateMachine.offsetInfoDiffers(newNitzData, (NitzData)this.mLatestNitzSignal.mValue)) {
                this.mNeedCountryCodeForNitz = true;
                this.mLatestNitzSignal = nitzSignal;
            }
            String tmpLog = "handleTimeZoneFromNitz: nitzSignal=" + nitzSignal + " zoneId=" + zoneId + " iso=" + iso + " mGotCountryCode=" + this.mGotCountryCode + " mNeedCountryCodeForNitz=" + this.mNeedCountryCodeForNitz + " isTimeZoneDetectionEnabled()=" + this.mTimeServiceHelper.isTimeZoneDetectionEnabled();
            Rlog.d(LOG_TAG, tmpLog);
            this.mTimeZoneLog.log(tmpLog);
            if (zoneId != null) {
                if (this.mTimeServiceHelper.isTimeZoneDetectionEnabled()) {
                    this.setAndBroadcastNetworkSetTimeZone(zoneId);
                }
                this.mNitzTimeZoneDetectionSuccessful = true;
                this.mSavedTimeZoneId = zoneId;
            }
        }
        catch (RuntimeException ex) {
            Rlog.e(LOG_TAG, "handleTimeZoneFromNitz: Processing NITZ data nitzSignal=" + nitzSignal + " ex=" + ex);
        }
    }

    private static boolean offsetInfoDiffers(NitzData one, NitzData two) {
        return one.getLocalOffsetMillis() != two.getLocalOffsetMillis() || one.isDst() != two.isDst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeFromNitz(TimeStampedValue<NitzData> nitzSignal) {
        try {
            boolean ignoreNitz = this.mDeviceState.getIgnoreNitz();
            if (ignoreNitz) {
                Rlog.d(LOG_TAG, "handleTimeFromNitz: Not setting clock because gsm.ignore-nitz is set");
                return;
            }
            try {
                this.mWakeLock.acquire();
                long elapsedRealtime = this.mTimeServiceHelper.elapsedRealtime();
                long millisSinceNitzReceived = elapsedRealtime - nitzSignal.mElapsedRealtime;
                if (millisSinceNitzReceived < 0L || millisSinceNitzReceived > Integer.MAX_VALUE) {
                    Rlog.d(LOG_TAG, "handleTimeFromNitz: not setting time, unexpected elapsedRealtime=" + elapsedRealtime + " nitzSignal=" + nitzSignal);
                    return;
                }
                long adjustedCurrentTimeMillis = ((NitzData)nitzSignal.mValue).getCurrentTimeInMillis() + millisSinceNitzReceived;
                long gained = adjustedCurrentTimeMillis - this.mTimeServiceHelper.currentTimeMillis();
                if (this.mTimeServiceHelper.isTimeDetectionEnabled()) {
                    String logMsg = "handleTimeFromNitz: nitzSignal=" + nitzSignal + " adjustedCurrentTimeMillis=" + adjustedCurrentTimeMillis + " millisSinceNitzReceived= " + millisSinceNitzReceived + " gained=" + gained;
                    if (this.mSavedNitzTime == null) {
                        logMsg = logMsg + ": First update received.";
                        this.setAndBroadcastNetworkSetTime(logMsg, adjustedCurrentTimeMillis);
                    } else {
                        long elapsedRealtimeSinceLastSaved = this.mTimeServiceHelper.elapsedRealtime() - this.mSavedNitzTime.mElapsedRealtime;
                        int nitzUpdateSpacing = this.mDeviceState.getNitzUpdateSpacingMillis();
                        int nitzUpdateDiff = this.mDeviceState.getNitzUpdateDiffMillis();
                        if (elapsedRealtimeSinceLastSaved > (long)nitzUpdateSpacing || Math.abs(gained) > (long)nitzUpdateDiff) {
                            logMsg = logMsg + ": New update received.";
                            this.setAndBroadcastNetworkSetTime(logMsg, adjustedCurrentTimeMillis);
                        } else {
                            Rlog.d(LOG_TAG, logMsg + ": Update throttled.");
                            return;
                        }
                    }
                }
                this.mSavedNitzTime = new TimeStampedValue<Long>(adjustedCurrentTimeMillis, nitzSignal.mElapsedRealtime);
            }
            finally {
                this.mWakeLock.release();
            }
        }
        catch (RuntimeException ex) {
            Rlog.e(LOG_TAG, "handleTimeFromNitz: Processing NITZ data nitzSignal=" + nitzSignal + " ex=" + ex);
        }
    }

    private void setAndBroadcastNetworkSetTimeZone(String zoneId) {
        Rlog.d(LOG_TAG, "setAndBroadcastNetworkSetTimeZone: zoneId=" + zoneId);
        this.mTimeServiceHelper.setDeviceTimeZone(zoneId);
        Rlog.d(LOG_TAG, "setAndBroadcastNetworkSetTimeZone: called setDeviceTimeZone() zoneId=" + zoneId);
    }

    private void setAndBroadcastNetworkSetTime(String msg, long time) {
        if (!this.mWakeLock.isHeld()) {
            Rlog.w(LOG_TAG, "setAndBroadcastNetworkSetTime: Wake lock not held while setting device time (msg=" + msg + ")");
        }
        msg = "setAndBroadcastNetworkSetTime: [Setting time to time=" + time + "]:" + msg;
        Rlog.d(LOG_TAG, msg);
        this.mTimeLog.log(msg);
        this.mTimeServiceHelper.setDeviceTime(time);
        TelephonyMetrics.getInstance().writeNITZEvent(this.mPhone.getPhoneId(), time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAutoTimeEnabled() {
        Rlog.d(LOG_TAG, "handleAutoTimeEnabled: Reverting to NITZ Time: mSavedNitzTime=" + this.mSavedNitzTime);
        if (this.mSavedNitzTime != null) {
            try {
                this.mWakeLock.acquire();
                long elapsedRealtime = this.mTimeServiceHelper.elapsedRealtime();
                String msg = "mSavedNitzTime: Reverting to NITZ time elapsedRealtime=" + elapsedRealtime + " mSavedNitzTime=" + this.mSavedNitzTime;
                long adjustedCurrentTimeMillis = (Long)this.mSavedNitzTime.mValue + (elapsedRealtime - this.mSavedNitzTime.mElapsedRealtime);
                this.setAndBroadcastNetworkSetTime(msg, adjustedCurrentTimeMillis);
            }
            finally {
                this.mWakeLock.release();
            }
        }
    }

    private void handleAutoTimeZoneEnabled() {
        String tmpLog = "handleAutoTimeZoneEnabled: Reverting to NITZ TimeZone: mSavedTimeZoneId=" + this.mSavedTimeZoneId;
        Rlog.d(LOG_TAG, tmpLog);
        this.mTimeZoneLog.log(tmpLog);
        if (this.mSavedTimeZoneId != null) {
            this.setAndBroadcastNetworkSetTimeZone(this.mSavedTimeZoneId);
        } else {
            String iso = this.mDeviceState.getNetworkCountryIsoForPhone();
            if (!TextUtils.isEmpty(iso)) {
                this.updateTimeZoneByNetworkCountryCode(iso);
            }
        }
    }

    public void dumpState(PrintWriter pw) {
        pw.println(" mSavedTime=" + this.mSavedNitzTime);
        pw.println(" mNeedCountryCodeForNitz=" + this.mNeedCountryCodeForNitz);
        pw.println(" mLatestNitzSignal=" + this.mLatestNitzSignal);
        pw.println(" mGotCountryCode=" + this.mGotCountryCode);
        pw.println(" mSavedTimeZoneId=" + this.mSavedTimeZoneId);
        pw.println(" mNitzTimeZoneDetectionSuccessful=" + this.mNitzTimeZoneDetectionSuccessful);
        pw.println(" mWakeLock=" + this.mWakeLock);
        pw.flush();
    }

    public void dumpLogs(FileDescriptor fd, IndentingPrintWriter ipw, String[] args) {
        ipw.println(" Time Logs:");
        ipw.increaseIndent();
        this.mTimeLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.println(" Time zone Logs:");
        ipw.increaseIndent();
        this.mTimeZoneLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
    }

    private void updateTimeZoneByNetworkCountryCode(String iso) {
        TimeZoneLookupHelper.CountryResult lookupResult = this.mTimeZoneLookupHelper.lookupByCountry(iso, this.mTimeServiceHelper.currentTimeMillis());
        if (lookupResult != null && lookupResult.allZonesHaveSameOffset) {
            String logMsg = "updateTimeZoneByNetworkCountryCode: set time lookupResult=" + lookupResult + " iso=" + iso;
            Rlog.d(LOG_TAG, logMsg);
            this.mTimeZoneLog.log(logMsg);
            this.setAndBroadcastNetworkSetTimeZone(lookupResult.zoneId);
        } else {
            Rlog.d(LOG_TAG, "updateTimeZoneByNetworkCountryCode: no good zone for iso=" + iso + " lookupResult=" + lookupResult);
        }
    }

    public boolean getNitzTimeZoneDetectionSuccessful() {
        return this.mNitzTimeZoneDetectionSuccessful;
    }

    public NitzData getCachedNitzData() {
        return this.mLatestNitzSignal != null ? (NitzData)this.mLatestNitzSignal.mValue : null;
    }

    public String getSavedTimeZoneId() {
        return this.mSavedTimeZoneId;
    }

    public static class DeviceState {
        private static final int NITZ_UPDATE_SPACING_DEFAULT = 600000;
        private final int mNitzUpdateSpacing;
        private static final int NITZ_UPDATE_DIFF_DEFAULT = 2000;
        private final int mNitzUpdateDiff;
        private final GsmCdmaPhone mPhone;
        private final TelephonyManager mTelephonyManager;
        private final ContentResolver mCr;

        public DeviceState(GsmCdmaPhone phone) {
            this.mPhone = phone;
            Context context = phone.getContext();
            this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
            this.mCr = context.getContentResolver();
            this.mNitzUpdateSpacing = SystemProperties.getInt("ro.nitz_update_spacing", 600000);
            this.mNitzUpdateDiff = SystemProperties.getInt("ro.nitz_update_diff", 2000);
        }

        public int getNitzUpdateSpacingMillis() {
            return Settings.Global.getInt(this.mCr, "nitz_update_spacing", this.mNitzUpdateSpacing);
        }

        public int getNitzUpdateDiffMillis() {
            return Settings.Global.getInt(this.mCr, "nitz_update_diff", this.mNitzUpdateDiff);
        }

        public boolean getIgnoreNitz() {
            String ignoreNitz = SystemProperties.get("gsm.ignore-nitz");
            return ignoreNitz != null && ignoreNitz.equals("yes");
        }

        public String getNetworkCountryIsoForPhone() {
            return this.mTelephonyManager.getNetworkCountryIsoForPhone(this.mPhone.getPhoneId());
        }
    }
}

