/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.hardware.radio.V1_0.RadioResponseInfo;
import android.hardware.radio.config.V1_0.IRadioConfigResponse;
import android.hardware.radio.config.V1_0.SimSlotStatus;
import com.android.internal.telephony.RILRequest;
import com.android.internal.telephony.RadioConfig;
import com.android.internal.telephony.RadioResponse;
import com.android.internal.telephony.uicc.IccSlotStatus;
import java.util.ArrayList;

public class RadioConfigResponse
extends IRadioConfigResponse.Stub {
    private final RadioConfig mRadioConfig;

    public RadioConfigResponse(RadioConfig radioConfig) {
        this.mRadioConfig = radioConfig;
    }

    @Override
    public void getSimSlotsStatusResponse(RadioResponseInfo responseInfo, ArrayList<SimSlotStatus> slotStatus) {
        RILRequest rr = this.mRadioConfig.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<IccSlotStatus> ret = RadioConfig.convertHalSlotStatus(slotStatus);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            } else {
                rr.onError(responseInfo.error, ret);
            }
        }
    }

    @Override
    public void setSimSlotsMappingResponse(RadioResponseInfo responseInfo) {
        RILRequest rr = this.mRadioConfig.processResponse(responseInfo);
        if (rr != null) {
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, null);
            } else {
                rr.onError(responseInfo.error, null);
            }
        }
    }
}

