/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.TargetApi;
import android.os.Build;
import android.telephony.Rlog;
import com.android.internal.annotations.VisibleForTesting;

@TargetApi(value=8)
public class RilWakelockInfo {
    private final String LOG_TAG = RilWakelockInfo.class.getSimpleName();
    private int mRilRequestSent;
    private int mTokenNumber;
    private long mRequestTime;
    private long mResponseTime;
    private long mWakelockTimeAttributedSoFar;
    private long mLastAggregatedTime;
    private int mConcurrentRequests;

    @VisibleForTesting
    public int getConcurrentRequests() {
        return this.mConcurrentRequests;
    }

    RilWakelockInfo(int rilRequest, int tokenNumber, int concurrentRequests, long requestTime) {
        concurrentRequests = this.validateConcurrentRequests(concurrentRequests);
        this.mRilRequestSent = rilRequest;
        this.mTokenNumber = tokenNumber;
        this.mConcurrentRequests = concurrentRequests;
        this.mRequestTime = requestTime;
        this.mWakelockTimeAttributedSoFar = 0L;
        this.mLastAggregatedTime = requestTime;
    }

    private int validateConcurrentRequests(int concurrentRequests) {
        if (concurrentRequests <= 0) {
            if (Build.IS_DEBUGGABLE) {
                IllegalArgumentException e = new IllegalArgumentException("concurrentRequests should always be greater than 0.");
                Rlog.e(this.LOG_TAG, e.toString());
                throw e;
            }
            concurrentRequests = 1;
        }
        return concurrentRequests;
    }

    int getTokenNumber() {
        return this.mTokenNumber;
    }

    int getRilRequestSent() {
        return this.mRilRequestSent;
    }

    void setResponseTime(long responseTime) {
        this.updateTime(responseTime);
        this.mResponseTime = responseTime;
    }

    void updateConcurrentRequests(int concurrentRequests, long time) {
        concurrentRequests = this.validateConcurrentRequests(concurrentRequests);
        this.updateTime(time);
        this.mConcurrentRequests = concurrentRequests;
    }

    synchronized void updateTime(long time) {
        this.mWakelockTimeAttributedSoFar += (time - this.mLastAggregatedTime) / (long)this.mConcurrentRequests;
        this.mLastAggregatedTime = time;
    }

    long getWakelockTimeAttributedToClient() {
        return this.mWakelockTimeAttributedSoFar;
    }

    public String toString() {
        return "WakelockInfo{rilRequestSent=" + this.mRilRequestSent + ", tokenNumber=" + this.mTokenNumber + ", requestTime=" + this.mRequestTime + ", responseTime=" + this.mResponseTime + ", mWakelockTimeAttributed=" + this.mWakelockTimeAttributedSoFar + '}';
    }
}

