/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.icu.util.TimeZone;
import android.text.TextUtils;
import com.android.internal.telephony.NitzData;
import java.util.Date;
import libcore.util.CountryTimeZones;
import libcore.util.TimeZoneFinder;

public class TimeZoneLookupHelper {
    private static final int MS_PER_HOUR = 3600000;
    private CountryTimeZones mLastCountryTimeZones;

    public OffsetResult lookupByNitzCountry(NitzData nitzData, String isoCountryCode) {
        CountryTimeZones countryTimeZones = this.getCountryTimeZones(isoCountryCode);
        if (countryTimeZones == null) {
            return null;
        }
        TimeZone bias = TimeZone.getDefault();
        CountryTimeZones.OffsetResult offsetResult = countryTimeZones.lookupByOffsetWithBias(nitzData.getLocalOffsetMillis(), nitzData.isDst(), nitzData.getCurrentTimeInMillis(), bias);
        if (offsetResult == null) {
            return null;
        }
        return new OffsetResult(offsetResult.mTimeZone.getID(), offsetResult.mOneMatch);
    }

    public OffsetResult lookupByNitz(NitzData nitzData) {
        return TimeZoneLookupHelper.lookupByNitzStatic(nitzData);
    }

    public CountryResult lookupByCountry(String isoCountryCode, long whenMillis) {
        CountryTimeZones countryTimeZones = this.getCountryTimeZones(isoCountryCode);
        if (countryTimeZones == null) {
            return null;
        }
        if (countryTimeZones.getDefaultTimeZoneId() == null) {
            return null;
        }
        return new CountryResult(countryTimeZones.getDefaultTimeZoneId(), countryTimeZones.isDefaultOkForCountryTimeZoneDetection(whenMillis), whenMillis);
    }

    static java.util.TimeZone guessZoneByNitzStatic(NitzData nitzData) {
        OffsetResult result = TimeZoneLookupHelper.lookupByNitzStatic(nitzData);
        return result != null ? java.util.TimeZone.getTimeZone(result.zoneId) : null;
    }

    private static OffsetResult lookupByNitzStatic(NitzData nitzData) {
        int utcOffsetMillis = nitzData.getLocalOffsetMillis();
        boolean isDst = nitzData.isDst();
        long timeMillis = nitzData.getCurrentTimeInMillis();
        OffsetResult match = TimeZoneLookupHelper.lookupByInstantOffsetDst(timeMillis, utcOffsetMillis, isDst);
        if (match == null) {
            match = TimeZoneLookupHelper.lookupByInstantOffsetDst(timeMillis, utcOffsetMillis, !isDst);
        }
        return match;
    }

    private static OffsetResult lookupByInstantOffsetDst(long timeMillis, int utcOffsetMillis, boolean isDst) {
        int rawOffset = utcOffsetMillis;
        if (isDst) {
            rawOffset -= 3600000;
        }
        String[] zones = java.util.TimeZone.getAvailableIDs(rawOffset);
        java.util.TimeZone match = null;
        Date d = new Date(timeMillis);
        boolean isOnlyMatch = true;
        for (String zone : zones) {
            java.util.TimeZone tz = java.util.TimeZone.getTimeZone(zone);
            if (tz.getOffset(timeMillis) != utcOffsetMillis || tz.inDaylightTime(d) != isDst) continue;
            if (match == null) {
                match = tz;
                continue;
            }
            isOnlyMatch = false;
            break;
        }
        if (match == null) {
            return null;
        }
        return new OffsetResult(match.getID(), isOnlyMatch);
    }

    public boolean countryUsesUtc(String isoCountryCode, long whenMillis) {
        if (TextUtils.isEmpty(isoCountryCode)) {
            return false;
        }
        CountryTimeZones countryTimeZones = this.getCountryTimeZones(isoCountryCode);
        return countryTimeZones != null && countryTimeZones.hasUtcZone(whenMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountryTimeZones getCountryTimeZones(String isoCountryCode) {
        TimeZoneLookupHelper timeZoneLookupHelper = this;
        synchronized (timeZoneLookupHelper) {
            if (this.mLastCountryTimeZones != null && this.mLastCountryTimeZones.isForCountryCode(isoCountryCode)) {
                return this.mLastCountryTimeZones;
            }
            CountryTimeZones countryTimeZones = TimeZoneFinder.getInstance().lookupCountryTimeZones(isoCountryCode);
            if (countryTimeZones != null) {
                this.mLastCountryTimeZones = countryTimeZones;
            }
            return countryTimeZones;
        }
    }

    public static final class CountryResult {
        public final String zoneId;
        public final boolean allZonesHaveSameOffset;
        public final long whenMillis;

        public CountryResult(String zoneId, boolean allZonesHaveSameOffset, long whenMillis) {
            this.zoneId = zoneId;
            this.allZonesHaveSameOffset = allZonesHaveSameOffset;
            this.whenMillis = whenMillis;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CountryResult that = (CountryResult)o;
            if (this.allZonesHaveSameOffset != that.allZonesHaveSameOffset) {
                return false;
            }
            if (this.whenMillis != that.whenMillis) {
                return false;
            }
            return this.zoneId.equals(that.zoneId);
        }

        public int hashCode() {
            int result = this.zoneId.hashCode();
            result = 31 * result + (this.allZonesHaveSameOffset ? 1 : 0);
            result = 31 * result + (int)(this.whenMillis ^ this.whenMillis >>> 32);
            return result;
        }

        public String toString() {
            return "CountryResult{zoneId='" + this.zoneId + '\'' + ", allZonesHaveSameOffset=" + this.allZonesHaveSameOffset + ", whenMillis=" + this.whenMillis + '}';
        }
    }

    public static final class OffsetResult {
        public final String zoneId;
        public final boolean isOnlyMatch;

        public OffsetResult(String zoneId, boolean isOnlyMatch) {
            this.zoneId = zoneId;
            this.isOnlyMatch = isOnlyMatch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OffsetResult result = (OffsetResult)o;
            if (this.isOnlyMatch != result.isOnlyMatch) {
                return false;
            }
            return this.zoneId.equals(result.zoneId);
        }

        public int hashCode() {
            int result = this.zoneId.hashCode();
            result = 31 * result + (this.isOnlyMatch ? 1 : 0);
            return result;
        }

        public String toString() {
            return "Result{zoneId='" + this.zoneId + '\'' + ", isOnlyMatch=" + this.isOnlyMatch + '}';
        }
    }
}

