/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import java.util.HashMap;

public class WspTypeDecoder {
    private static final int WAP_PDU_SHORT_LENGTH_MAX = 30;
    private static final int WAP_PDU_LENGTH_QUOTE = 31;
    public static final int PDU_TYPE_PUSH = 6;
    public static final int PDU_TYPE_CONFIRMED_PUSH = 7;
    private static final HashMap<Integer, String> WELL_KNOWN_MIME_TYPES = new HashMap();
    private static final HashMap<Integer, String> WELL_KNOWN_PARAMETERS = new HashMap();
    public static final int PARAMETER_ID_X_WAP_APPLICATION_ID = 47;
    private static final int Q_VALUE = 0;
    public static final String CONTENT_TYPE_B_PUSH_CO = "application/vnd.wap.coc";
    public static final String CONTENT_TYPE_B_MMS = "application/vnd.wap.mms-message";
    public static final String CONTENT_TYPE_B_PUSH_SYNCML_NOTI = "application/vnd.syncml.notification";
    byte[] mWspData;
    int mDataLength;
    long mUnsigned32bit;
    String mStringValue;
    HashMap<String, String> mContentParameters;

    public WspTypeDecoder(byte[] pdu) {
        this.mWspData = pdu;
    }

    public boolean decodeTextString(int startIndex) {
        int index = startIndex;
        while (this.mWspData[index] != 0) {
            ++index;
        }
        this.mDataLength = index - startIndex + 1;
        this.mStringValue = this.mWspData[startIndex] == 127 ? new String(this.mWspData, startIndex + 1, this.mDataLength - 2) : new String(this.mWspData, startIndex, this.mDataLength - 1);
        return true;
    }

    public boolean decodeTokenText(int startIndex) {
        int index = startIndex;
        while (this.mWspData[index] != 0) {
            ++index;
        }
        this.mDataLength = index - startIndex + 1;
        this.mStringValue = new String(this.mWspData, startIndex, this.mDataLength - 1);
        return true;
    }

    public boolean decodeShortInteger(int startIndex) {
        if ((this.mWspData[startIndex] & 0x80) == 0) {
            return false;
        }
        this.mUnsigned32bit = this.mWspData[startIndex] & 0x7F;
        this.mDataLength = 1;
        return true;
    }

    public boolean decodeLongInteger(int startIndex) {
        int lengthMultiOctet = this.mWspData[startIndex] & 0xFF;
        if (lengthMultiOctet > 30) {
            return false;
        }
        this.mUnsigned32bit = 0L;
        for (int i = 1; i <= lengthMultiOctet; ++i) {
            this.mUnsigned32bit = this.mUnsigned32bit << 8 | (long)(this.mWspData[startIndex + i] & 0xFF);
        }
        this.mDataLength = 1 + lengthMultiOctet;
        return true;
    }

    public boolean decodeIntegerValue(int startIndex) {
        if (this.decodeShortInteger(startIndex)) {
            return true;
        }
        return this.decodeLongInteger(startIndex);
    }

    public boolean decodeUintvarInteger(int startIndex) {
        int index = startIndex;
        this.mUnsigned32bit = 0L;
        while ((this.mWspData[index] & 0x80) != 0) {
            if (index - startIndex >= 4) {
                return false;
            }
            this.mUnsigned32bit = this.mUnsigned32bit << 7 | (long)(this.mWspData[index] & 0x7F);
            ++index;
        }
        this.mUnsigned32bit = this.mUnsigned32bit << 7 | (long)(this.mWspData[index] & 0x7F);
        this.mDataLength = index - startIndex + 1;
        return true;
    }

    public boolean decodeValueLength(int startIndex) {
        if ((this.mWspData[startIndex] & 0xFF) > 31) {
            return false;
        }
        if (this.mWspData[startIndex] < 31) {
            this.mUnsigned32bit = this.mWspData[startIndex];
            this.mDataLength = 1;
        } else {
            this.decodeUintvarInteger(startIndex + 1);
            ++this.mDataLength;
        }
        return true;
    }

    public boolean decodeExtensionMedia(int startIndex) {
        int index;
        boolean rtrn;
        this.mDataLength = 0;
        this.mStringValue = null;
        int length = this.mWspData.length;
        boolean bl = rtrn = index < length;
        for (index = startIndex; index < length && this.mWspData[index] != 0; ++index) {
        }
        this.mDataLength = index - startIndex + 1;
        this.mStringValue = new String(this.mWspData, startIndex, this.mDataLength - 1);
        return rtrn;
    }

    public boolean decodeConstrainedEncoding(int startIndex) {
        if (this.decodeShortInteger(startIndex)) {
            this.mStringValue = null;
            return true;
        }
        return this.decodeExtensionMedia(startIndex);
    }

    public boolean decodeContentType(int startIndex) {
        this.mContentParameters = new HashMap();
        try {
            if (!this.decodeValueLength(startIndex)) {
                boolean found = this.decodeConstrainedEncoding(startIndex);
                if (found) {
                    this.expandWellKnownMimeType();
                }
                return found;
            }
            int headersLength = (int)this.mUnsigned32bit;
            int mediaPrefixLength = this.getDecodedDataLength();
            if (this.decodeIntegerValue(startIndex + mediaPrefixLength)) {
                this.mDataLength += mediaPrefixLength;
                int readLength = this.mDataLength;
                this.mStringValue = null;
                this.expandWellKnownMimeType();
                long wellKnownValue = this.mUnsigned32bit;
                String mimeType = this.mStringValue;
                if (this.readContentParameters(startIndex + this.mDataLength, headersLength - (this.mDataLength - mediaPrefixLength), 0)) {
                    this.mDataLength += readLength;
                    this.mUnsigned32bit = wellKnownValue;
                    this.mStringValue = mimeType;
                    return true;
                }
                return false;
            }
            if (this.decodeExtensionMedia(startIndex + mediaPrefixLength)) {
                this.mDataLength += mediaPrefixLength;
                int readLength = this.mDataLength;
                this.expandWellKnownMimeType();
                long wellKnownValue = this.mUnsigned32bit;
                String mimeType = this.mStringValue;
                if (this.readContentParameters(startIndex + this.mDataLength, headersLength - (this.mDataLength - mediaPrefixLength), 0)) {
                    this.mDataLength += readLength;
                    this.mUnsigned32bit = wellKnownValue;
                    this.mStringValue = mimeType;
                    return true;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        return false;
    }

    private boolean readContentParameters(int startIndex, int leftToRead, int accumulator) {
        int totalRead = 0;
        if (leftToRead > 0) {
            byte nextByte = this.mWspData[startIndex];
            String value = null;
            String param = null;
            if ((nextByte & 0x80) == 0 && nextByte > 31) {
                this.decodeTokenText(startIndex);
                param = this.mStringValue;
                totalRead += this.mDataLength;
            } else if (this.decodeIntegerValue(startIndex)) {
                totalRead += this.mDataLength;
                int wellKnownParameterValue = (int)this.mUnsigned32bit;
                param = WELL_KNOWN_PARAMETERS.get(wellKnownParameterValue);
                if (param == null) {
                    param = "unassigned/0x" + Long.toHexString(wellKnownParameterValue);
                }
                if (wellKnownParameterValue == 0) {
                    if (this.decodeUintvarInteger(startIndex + totalRead)) {
                        value = String.valueOf(this.mUnsigned32bit);
                        this.mContentParameters.put(param, value);
                        return this.readContentParameters(startIndex + (totalRead += this.mDataLength), leftToRead - totalRead, accumulator + totalRead);
                    }
                    return false;
                }
            } else {
                return false;
            }
            if (this.decodeNoValue(startIndex + totalRead)) {
                totalRead += this.mDataLength;
                value = null;
            } else if (this.decodeIntegerValue(startIndex + totalRead)) {
                totalRead += this.mDataLength;
                int intValue = (int)this.mUnsigned32bit;
                value = String.valueOf(intValue);
            } else {
                this.decodeTokenText(startIndex + totalRead);
                totalRead += this.mDataLength;
                value = this.mStringValue;
                if (value.startsWith("\"")) {
                    value = value.substring(1);
                }
            }
            this.mContentParameters.put(param, value);
            return this.readContentParameters(startIndex + totalRead, leftToRead - totalRead, accumulator + totalRead);
        }
        this.mDataLength = accumulator;
        return true;
    }

    private boolean decodeNoValue(int startIndex) {
        if (this.mWspData[startIndex] == 0) {
            this.mDataLength = 1;
            return true;
        }
        return false;
    }

    private void expandWellKnownMimeType() {
        if (this.mStringValue == null) {
            int binaryContentType = (int)this.mUnsigned32bit;
            this.mStringValue = WELL_KNOWN_MIME_TYPES.get(binaryContentType);
        } else {
            this.mUnsigned32bit = -1L;
        }
    }

    public boolean decodeContentLength(int startIndex) {
        return this.decodeIntegerValue(startIndex);
    }

    public boolean decodeContentLocation(int startIndex) {
        return this.decodeTextString(startIndex);
    }

    public boolean decodeXWapApplicationId(int startIndex) {
        if (this.decodeIntegerValue(startIndex)) {
            this.mStringValue = null;
            return true;
        }
        return this.decodeTextString(startIndex);
    }

    public boolean seekXWapApplicationId(int startIndex, int endIndex) {
        int index = startIndex;
        try {
            index = startIndex;
            while (index <= endIndex) {
                if (this.decodeIntegerValue(index)) {
                    int fieldValue = (int)this.getValue32();
                    if (fieldValue == 47) {
                        this.mUnsigned32bit = index + 1;
                        return true;
                    }
                } else if (!this.decodeTextString(index)) {
                    return false;
                }
                if ((index += this.getDecodedDataLength()) > endIndex) {
                    return false;
                }
                byte val = this.mWspData[index];
                if (0 <= val && val <= 30) {
                    index += this.mWspData[index] + 1;
                    continue;
                }
                if (val == 31) {
                    if (index + 1 >= endIndex) {
                        return false;
                    }
                    if (!this.decodeUintvarInteger(++index)) {
                        return false;
                    }
                    index += this.getDecodedDataLength();
                    continue;
                }
                if (31 < val && val <= 127) {
                    if (!this.decodeTextString(index)) {
                        return false;
                    }
                    index += this.getDecodedDataLength();
                    continue;
                }
                ++index;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        return false;
    }

    public boolean decodeXWapContentURI(int startIndex) {
        return this.decodeTextString(startIndex);
    }

    public boolean decodeXWapInitiatorURI(int startIndex) {
        return this.decodeTextString(startIndex);
    }

    public int getDecodedDataLength() {
        return this.mDataLength;
    }

    public long getValue32() {
        return this.mUnsigned32bit;
    }

    public String getValueString() {
        return this.mStringValue;
    }

    public HashMap<String, String> getContentParameters() {
        return this.mContentParameters;
    }

    static {
        WELL_KNOWN_MIME_TYPES.put(0, "*/*");
        WELL_KNOWN_MIME_TYPES.put(1, "text/*");
        WELL_KNOWN_MIME_TYPES.put(2, "text/html");
        WELL_KNOWN_MIME_TYPES.put(3, "text/plain");
        WELL_KNOWN_MIME_TYPES.put(4, "text/x-hdml");
        WELL_KNOWN_MIME_TYPES.put(5, "text/x-ttml");
        WELL_KNOWN_MIME_TYPES.put(6, "text/x-vCalendar");
        WELL_KNOWN_MIME_TYPES.put(7, "text/x-vCard");
        WELL_KNOWN_MIME_TYPES.put(8, "text/vnd.wap.wml");
        WELL_KNOWN_MIME_TYPES.put(9, "text/vnd.wap.wmlscript");
        WELL_KNOWN_MIME_TYPES.put(10, "text/vnd.wap.wta-event");
        WELL_KNOWN_MIME_TYPES.put(11, "multipart/*");
        WELL_KNOWN_MIME_TYPES.put(12, "multipart/mixed");
        WELL_KNOWN_MIME_TYPES.put(13, "multipart/form-data");
        WELL_KNOWN_MIME_TYPES.put(14, "multipart/byterantes");
        WELL_KNOWN_MIME_TYPES.put(15, "multipart/alternative");
        WELL_KNOWN_MIME_TYPES.put(16, "application/*");
        WELL_KNOWN_MIME_TYPES.put(17, "application/java-vm");
        WELL_KNOWN_MIME_TYPES.put(18, "application/x-www-form-urlencoded");
        WELL_KNOWN_MIME_TYPES.put(19, "application/x-hdmlc");
        WELL_KNOWN_MIME_TYPES.put(20, "application/vnd.wap.wmlc");
        WELL_KNOWN_MIME_TYPES.put(21, "application/vnd.wap.wmlscriptc");
        WELL_KNOWN_MIME_TYPES.put(22, "application/vnd.wap.wta-eventc");
        WELL_KNOWN_MIME_TYPES.put(23, "application/vnd.wap.uaprof");
        WELL_KNOWN_MIME_TYPES.put(24, "application/vnd.wap.wtls-ca-certificate");
        WELL_KNOWN_MIME_TYPES.put(25, "application/vnd.wap.wtls-user-certificate");
        WELL_KNOWN_MIME_TYPES.put(26, "application/x-x509-ca-cert");
        WELL_KNOWN_MIME_TYPES.put(27, "application/x-x509-user-cert");
        WELL_KNOWN_MIME_TYPES.put(28, "image/*");
        WELL_KNOWN_MIME_TYPES.put(29, "image/gif");
        WELL_KNOWN_MIME_TYPES.put(30, "image/jpeg");
        WELL_KNOWN_MIME_TYPES.put(31, "image/tiff");
        WELL_KNOWN_MIME_TYPES.put(32, "image/png");
        WELL_KNOWN_MIME_TYPES.put(33, "image/vnd.wap.wbmp");
        WELL_KNOWN_MIME_TYPES.put(34, "application/vnd.wap.multipart.*");
        WELL_KNOWN_MIME_TYPES.put(35, "application/vnd.wap.multipart.mixed");
        WELL_KNOWN_MIME_TYPES.put(36, "application/vnd.wap.multipart.form-data");
        WELL_KNOWN_MIME_TYPES.put(37, "application/vnd.wap.multipart.byteranges");
        WELL_KNOWN_MIME_TYPES.put(38, "application/vnd.wap.multipart.alternative");
        WELL_KNOWN_MIME_TYPES.put(39, "application/xml");
        WELL_KNOWN_MIME_TYPES.put(40, "text/xml");
        WELL_KNOWN_MIME_TYPES.put(41, "application/vnd.wap.wbxml");
        WELL_KNOWN_MIME_TYPES.put(42, "application/x-x968-cross-cert");
        WELL_KNOWN_MIME_TYPES.put(43, "application/x-x968-ca-cert");
        WELL_KNOWN_MIME_TYPES.put(44, "application/x-x968-user-cert");
        WELL_KNOWN_MIME_TYPES.put(45, "text/vnd.wap.si");
        WELL_KNOWN_MIME_TYPES.put(46, "application/vnd.wap.sic");
        WELL_KNOWN_MIME_TYPES.put(47, "text/vnd.wap.sl");
        WELL_KNOWN_MIME_TYPES.put(48, "application/vnd.wap.slc");
        WELL_KNOWN_MIME_TYPES.put(49, "text/vnd.wap.co");
        WELL_KNOWN_MIME_TYPES.put(50, CONTENT_TYPE_B_PUSH_CO);
        WELL_KNOWN_MIME_TYPES.put(51, "application/vnd.wap.multipart.related");
        WELL_KNOWN_MIME_TYPES.put(52, "application/vnd.wap.sia");
        WELL_KNOWN_MIME_TYPES.put(53, "text/vnd.wap.connectivity-xml");
        WELL_KNOWN_MIME_TYPES.put(54, "application/vnd.wap.connectivity-wbxml");
        WELL_KNOWN_MIME_TYPES.put(55, "application/pkcs7-mime");
        WELL_KNOWN_MIME_TYPES.put(56, "application/vnd.wap.hashed-certificate");
        WELL_KNOWN_MIME_TYPES.put(57, "application/vnd.wap.signed-certificate");
        WELL_KNOWN_MIME_TYPES.put(58, "application/vnd.wap.cert-response");
        WELL_KNOWN_MIME_TYPES.put(59, "application/xhtml+xml");
        WELL_KNOWN_MIME_TYPES.put(60, "application/wml+xml");
        WELL_KNOWN_MIME_TYPES.put(61, "text/css");
        WELL_KNOWN_MIME_TYPES.put(62, CONTENT_TYPE_B_MMS);
        WELL_KNOWN_MIME_TYPES.put(63, "application/vnd.wap.rollover-certificate");
        WELL_KNOWN_MIME_TYPES.put(64, "application/vnd.wap.locc+wbxml");
        WELL_KNOWN_MIME_TYPES.put(65, "application/vnd.wap.loc+xml");
        WELL_KNOWN_MIME_TYPES.put(66, "application/vnd.syncml.dm+wbxml");
        WELL_KNOWN_MIME_TYPES.put(67, "application/vnd.syncml.dm+xml");
        WELL_KNOWN_MIME_TYPES.put(68, CONTENT_TYPE_B_PUSH_SYNCML_NOTI);
        WELL_KNOWN_MIME_TYPES.put(69, "application/vnd.wap.xhtml+xml");
        WELL_KNOWN_MIME_TYPES.put(70, "application/vnd.wv.csp.cir");
        WELL_KNOWN_MIME_TYPES.put(71, "application/vnd.oma.dd+xml");
        WELL_KNOWN_MIME_TYPES.put(72, "application/vnd.oma.drm.message");
        WELL_KNOWN_MIME_TYPES.put(73, "application/vnd.oma.drm.content");
        WELL_KNOWN_MIME_TYPES.put(74, "application/vnd.oma.drm.rights+xml");
        WELL_KNOWN_MIME_TYPES.put(75, "application/vnd.oma.drm.rights+wbxml");
        WELL_KNOWN_MIME_TYPES.put(76, "application/vnd.wv.csp+xml");
        WELL_KNOWN_MIME_TYPES.put(77, "application/vnd.wv.csp+wbxml");
        WELL_KNOWN_MIME_TYPES.put(78, "application/vnd.syncml.ds.notification");
        WELL_KNOWN_MIME_TYPES.put(79, "audio/*");
        WELL_KNOWN_MIME_TYPES.put(80, "video/*");
        WELL_KNOWN_MIME_TYPES.put(81, "application/vnd.oma.dd2+xml");
        WELL_KNOWN_MIME_TYPES.put(82, "application/mikey");
        WELL_KNOWN_MIME_TYPES.put(83, "application/vnd.oma.dcd");
        WELL_KNOWN_MIME_TYPES.put(84, "application/vnd.oma.dcdc");
        WELL_KNOWN_MIME_TYPES.put(513, "application/vnd.uplanet.cacheop-wbxml");
        WELL_KNOWN_MIME_TYPES.put(514, "application/vnd.uplanet.signal");
        WELL_KNOWN_MIME_TYPES.put(515, "application/vnd.uplanet.alert-wbxml");
        WELL_KNOWN_MIME_TYPES.put(516, "application/vnd.uplanet.list-wbxml");
        WELL_KNOWN_MIME_TYPES.put(517, "application/vnd.uplanet.listcmd-wbxml");
        WELL_KNOWN_MIME_TYPES.put(518, "application/vnd.uplanet.channel-wbxml");
        WELL_KNOWN_MIME_TYPES.put(519, "application/vnd.uplanet.provisioning-status-uri");
        WELL_KNOWN_MIME_TYPES.put(520, "x-wap.multipart/vnd.uplanet.header-set");
        WELL_KNOWN_MIME_TYPES.put(521, "application/vnd.uplanet.bearer-choice-wbxml");
        WELL_KNOWN_MIME_TYPES.put(522, "application/vnd.phonecom.mmc-wbxml");
        WELL_KNOWN_MIME_TYPES.put(523, "application/vnd.nokia.syncset+wbxml");
        WELL_KNOWN_MIME_TYPES.put(524, "image/x-up-wpng");
        WELL_KNOWN_MIME_TYPES.put(768, "application/iota.mmc-wbxml");
        WELL_KNOWN_MIME_TYPES.put(769, "application/iota.mmc-xml");
        WELL_KNOWN_MIME_TYPES.put(770, "application/vnd.syncml+xml");
        WELL_KNOWN_MIME_TYPES.put(771, "application/vnd.syncml+wbxml");
        WELL_KNOWN_MIME_TYPES.put(772, "text/vnd.wap.emn+xml");
        WELL_KNOWN_MIME_TYPES.put(773, "text/calendar");
        WELL_KNOWN_MIME_TYPES.put(774, "application/vnd.omads-email+xml");
        WELL_KNOWN_MIME_TYPES.put(775, "application/vnd.omads-file+xml");
        WELL_KNOWN_MIME_TYPES.put(776, "application/vnd.omads-folder+xml");
        WELL_KNOWN_MIME_TYPES.put(777, "text/directory;profile=vCard");
        WELL_KNOWN_MIME_TYPES.put(778, "application/vnd.wap.emn+wbxml");
        WELL_KNOWN_MIME_TYPES.put(779, "application/vnd.nokia.ipdc-purchase-response");
        WELL_KNOWN_MIME_TYPES.put(780, "application/vnd.motorola.screen3+xml");
        WELL_KNOWN_MIME_TYPES.put(781, "application/vnd.motorola.screen3+gzip");
        WELL_KNOWN_MIME_TYPES.put(782, "application/vnd.cmcc.setting+wbxml");
        WELL_KNOWN_MIME_TYPES.put(783, "application/vnd.cmcc.bombing+wbxml");
        WELL_KNOWN_MIME_TYPES.put(784, "application/vnd.docomo.pf");
        WELL_KNOWN_MIME_TYPES.put(785, "application/vnd.docomo.ub");
        WELL_KNOWN_MIME_TYPES.put(786, "application/vnd.omaloc-supl-init");
        WELL_KNOWN_MIME_TYPES.put(787, "application/vnd.oma.group-usage-list+xml");
        WELL_KNOWN_MIME_TYPES.put(788, "application/oma-directory+xml");
        WELL_KNOWN_MIME_TYPES.put(789, "application/vnd.docomo.pf2");
        WELL_KNOWN_MIME_TYPES.put(790, "application/vnd.oma.drm.roap-trigger+wbxml");
        WELL_KNOWN_MIME_TYPES.put(791, "application/vnd.sbm.mid2");
        WELL_KNOWN_MIME_TYPES.put(792, "application/vnd.wmf.bootstrap");
        WELL_KNOWN_MIME_TYPES.put(793, "application/vnc.cmcc.dcd+xml");
        WELL_KNOWN_MIME_TYPES.put(794, "application/vnd.sbm.cid");
        WELL_KNOWN_MIME_TYPES.put(795, "application/vnd.oma.bcast.provisioningtrigger");
        WELL_KNOWN_PARAMETERS.put(0, "Q");
        WELL_KNOWN_PARAMETERS.put(1, "Charset");
        WELL_KNOWN_PARAMETERS.put(2, "Level");
        WELL_KNOWN_PARAMETERS.put(3, "Type");
        WELL_KNOWN_PARAMETERS.put(7, "Differences");
        WELL_KNOWN_PARAMETERS.put(8, "Padding");
        WELL_KNOWN_PARAMETERS.put(9, "Type");
        WELL_KNOWN_PARAMETERS.put(14, "Max-Age");
        WELL_KNOWN_PARAMETERS.put(16, "Secure");
        WELL_KNOWN_PARAMETERS.put(17, "SEC");
        WELL_KNOWN_PARAMETERS.put(18, "MAC");
        WELL_KNOWN_PARAMETERS.put(19, "Creation-date");
        WELL_KNOWN_PARAMETERS.put(20, "Modification-date");
        WELL_KNOWN_PARAMETERS.put(21, "Read-date");
        WELL_KNOWN_PARAMETERS.put(22, "Size");
        WELL_KNOWN_PARAMETERS.put(23, "Name");
        WELL_KNOWN_PARAMETERS.put(24, "Filename");
        WELL_KNOWN_PARAMETERS.put(25, "Start");
        WELL_KNOWN_PARAMETERS.put(26, "Start-info");
        WELL_KNOWN_PARAMETERS.put(27, "Comment");
        WELL_KNOWN_PARAMETERS.put(28, "Domain");
        WELL_KNOWN_PARAMETERS.put(29, "Path");
    }
}

