/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.Message;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.util.Pair;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsDispatchersController;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.telephony.util.SMSDispatcherUtil;

public class CdmaSMSDispatcher
extends SMSDispatcher {
    private static final String TAG = "CdmaSMSDispatcher";
    private static final boolean VDBG = false;

    public CdmaSMSDispatcher(Phone phone, SmsDispatchersController smsDispatchersController) {
        super(phone, smsDispatchersController);
        Rlog.d(TAG, "CdmaSMSDispatcher created");
    }

    @Override
    public String getFormat() {
        return "3gpp2";
    }

    public void sendStatusReportMessage(SmsMessage sms) {
        this.sendMessage(this.obtainMessage(10, sms));
    }

    @Override
    protected void handleStatusReport(Object o) {
        if (o instanceof SmsMessage) {
            this.handleCdmaStatusReport((SmsMessage)o);
        } else {
            Rlog.e(TAG, "handleStatusReport() called for object type " + o.getClass().getName());
        }
    }

    @Override
    protected boolean shouldBlockSms() {
        return SMSDispatcherUtil.shouldBlockSms(this.isCdmaMo(), this.mPhone);
    }

    @Override
    protected SmsMessageBase.SubmitPduBase getSubmitPdu(String scAddr, String destAddr, String message, boolean statusReportRequested, SmsHeader smsHeader) {
        return SMSDispatcherUtil.getSubmitPduCdma(scAddr, destAddr, message, statusReportRequested, smsHeader);
    }

    @Override
    protected SmsMessageBase.SubmitPduBase getSubmitPdu(String scAddr, String destAddr, int destPort, byte[] message, boolean statusReportRequested) {
        return SMSDispatcherUtil.getSubmitPduCdma(scAddr, destAddr, destPort, message, statusReportRequested);
    }

    @Override
    protected GsmAlphabet.TextEncodingDetails calculateLength(CharSequence messageBody, boolean use7bitOnly) {
        return SMSDispatcherUtil.calculateLengthCdma(messageBody, use7bitOnly);
    }

    private void handleCdmaStatusReport(SmsMessage sms) {
        int count = this.deliveryPendingList.size();
        for (int i = 0; i < count; ++i) {
            SMSDispatcher.SmsTracker tracker = (SMSDispatcher.SmsTracker)this.deliveryPendingList.get(i);
            if (tracker.mMessageRef != sms.mMessageRef) continue;
            Pair<Boolean, Boolean> result = this.mSmsDispatchersController.handleSmsStatusReport(tracker, this.getFormat(), sms.getPdu());
            if (!((Boolean)result.second).booleanValue()) break;
            this.deliveryPendingList.remove(i);
            break;
        }
    }

    @Override
    public void sendSms(SMSDispatcher.SmsTracker tracker) {
        boolean imsSmsDisabled;
        Rlog.d(TAG, "sendSms:  isIms()=" + this.isIms() + " mRetryCount=" + tracker.mRetryCount + " mImsRetry=" + tracker.mImsRetry + " mMessageRef=" + tracker.mMessageRef + " SS=" + this.mPhone.getServiceState().getState());
        int ss = this.mPhone.getServiceState().getState();
        if (!this.isIms() && ss != 0) {
            tracker.onFailed(this.mContext, CdmaSMSDispatcher.getNotInServiceError(ss), 0);
            return;
        }
        Message reply = this.obtainMessage(2, tracker);
        byte[] pdu = (byte[])tracker.getData().get("pdu");
        int currentDataNetwork = this.mPhone.getServiceState().getDataNetworkType();
        boolean bl = imsSmsDisabled = (currentDataNetwork == 14 || ServiceState.isLte(currentDataNetwork) && !this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed()) && this.mPhone.getServiceState().getVoiceNetworkType() == 7 && ((GsmCdmaPhone)this.mPhone).mCT.mState != PhoneConstants.State.IDLE;
        if (0 == tracker.mImsRetry && !this.isIms() || imsSmsDisabled) {
            this.mCi.sendCdmaSms(pdu, reply);
        } else {
            this.mCi.sendImsCdmaSms(pdu, tracker.mImsRetry, tracker.mMessageRef, reply);
            ++tracker.mImsRetry;
        }
    }
}

