/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.hardware.radio.V1_0.SetupDataCallResult;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.data.DataCallResponse;
import android.telephony.data.DataProfile;
import android.telephony.data.DataService;
import android.telephony.data.DataServiceCallback;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CellularDataService
extends DataService {
    private static final String TAG = CellularDataService.class.getSimpleName();
    private static final boolean DBG = false;
    private static final int SETUP_DATA_CALL_COMPLETE = 1;
    private static final int DEACTIVATE_DATA_ALL_COMPLETE = 2;
    private static final int SET_INITIAL_ATTACH_APN_COMPLETE = 3;
    private static final int SET_DATA_PROFILE_COMPLETE = 4;
    private static final int GET_DATA_CALL_LIST_COMPLETE = 5;
    private static final int DATA_CALL_LIST_CHANGED = 6;

    @Override
    public DataService.DataServiceProvider createDataServiceProvider(int slotId) {
        this.log("Cellular data service created for slot " + slotId);
        if (!SubscriptionManager.isValidSlotIndex(slotId)) {
            this.loge("Tried to cellular data service with invalid slotId " + slotId);
            return null;
        }
        return new CellularDataServiceProvider(slotId);
    }

    @VisibleForTesting
    public DataCallResponse convertDataCallResult(SetupDataCallResult dcResult) {
        if (dcResult == null) {
            return null;
        }
        String[] addresses = null;
        if (!TextUtils.isEmpty(dcResult.addresses)) {
            addresses = dcResult.addresses.split("\\s+");
        }
        ArrayList<LinkAddress> laList = new ArrayList<LinkAddress>();
        if (addresses != null) {
            for (String address : addresses) {
                if ((address = address.trim()).isEmpty()) continue;
                try {
                    InetAddress ia;
                    LinkAddress la = address.split("/").length == 2 ? new LinkAddress(address) : new LinkAddress(ia, (ia = NetworkUtils.numericToInetAddress(address)) instanceof Inet4Address ? 32 : 128);
                    laList.add(la);
                }
                catch (IllegalArgumentException e) {
                    this.loge("Unknown address: " + address + ", exception = " + e);
                }
            }
        }
        String[] dnses = null;
        if (!TextUtils.isEmpty(dcResult.dnses)) {
            dnses = dcResult.dnses.split("\\s+");
        }
        ArrayList<InetAddress> dnsList = new ArrayList<InetAddress>();
        if (dnses != null) {
            for (String dns : dnses) {
                dns = dns.trim();
                try {
                    InetAddress ia = NetworkUtils.numericToInetAddress(dns);
                    dnsList.add(ia);
                }
                catch (IllegalArgumentException e) {
                    this.loge("Unknown dns: " + dns + ", exception = " + e);
                }
            }
        }
        String[] gateways = null;
        if (!TextUtils.isEmpty(dcResult.gateways)) {
            gateways = dcResult.gateways.split("\\s+");
        }
        ArrayList<InetAddress> gatewayList = new ArrayList<InetAddress>();
        if (gateways != null) {
            for (String gateway : gateways) {
                gateway = gateway.trim();
                try {
                    InetAddress ia = NetworkUtils.numericToInetAddress(gateway);
                    gatewayList.add(ia);
                }
                catch (IllegalArgumentException e) {
                    this.loge("Unknown gateway: " + gateway + ", exception = " + e);
                }
            }
        }
        return new DataCallResponse(dcResult.status, dcResult.suggestedRetryTime, dcResult.cid, dcResult.active, dcResult.type, dcResult.ifname, laList, dnsList, gatewayList, new ArrayList<String>(Arrays.asList(dcResult.pcscf.trim().split("\\s+"))), dcResult.mtu);
    }

    private void log(String s) {
        Rlog.d(TAG, s);
    }

    private void loge(String s) {
        Rlog.e(TAG, s);
    }

    private class CellularDataServiceProvider
    extends DataService.DataServiceProvider {
        private final Map<Message, DataServiceCallback> mCallbackMap;
        private final Looper mLooper;
        private final Handler mHandler;
        private final Phone mPhone;

        private CellularDataServiceProvider(int slotId) {
            super(CellularDataService.this, slotId);
            this.mCallbackMap = new HashMap<Message, DataServiceCallback>();
            this.mPhone = PhoneFactory.getPhone(this.getSlotId());
            HandlerThread thread = new HandlerThread(CellularDataService.class.getSimpleName());
            thread.start();
            this.mLooper = thread.getLooper();
            this.mHandler = new Handler(this.mLooper){

                @Override
                public void handleMessage(Message message) {
                    DataServiceCallback callback = (DataServiceCallback)CellularDataServiceProvider.this.mCallbackMap.remove(message);
                    AsyncResult ar = (AsyncResult)message.obj;
                    switch (message.what) {
                        case 1: {
                            SetupDataCallResult result = (SetupDataCallResult)ar.result;
                            callback.onSetupDataCallComplete(ar.exception != null ? 4 : 0, CellularDataService.this.convertDataCallResult(result));
                            break;
                        }
                        case 2: {
                            callback.onDeactivateDataCallComplete(ar.exception != null ? 4 : 0);
                            break;
                        }
                        case 3: {
                            callback.onSetInitialAttachApnComplete(ar.exception != null ? 4 : 0);
                            break;
                        }
                        case 4: {
                            callback.onSetDataProfileComplete(ar.exception != null ? 4 : 0);
                            break;
                        }
                        case 5: {
                            callback.onGetDataCallListComplete(ar.exception != null ? 4 : 0, ar.exception != null ? null : CellularDataServiceProvider.this.getDataCallList((List)ar.result));
                            break;
                        }
                        case 6: {
                            CellularDataServiceProvider.this.notifyDataCallListChanged(CellularDataServiceProvider.this.getDataCallList((List)ar.result));
                            break;
                        }
                        default: {
                            CellularDataService.this.loge("Unexpected event: " + message.what);
                            return;
                        }
                    }
                }
            };
            this.mPhone.mCi.registerForDataCallListChanged(this.mHandler, 6, null);
        }

        private List<DataCallResponse> getDataCallList(List<SetupDataCallResult> dcList) {
            ArrayList<DataCallResponse> dcResponseList = new ArrayList<DataCallResponse>();
            for (SetupDataCallResult dcResult : dcList) {
                dcResponseList.add(CellularDataService.this.convertDataCallResult(dcResult));
            }
            return dcResponseList;
        }

        @Override
        public void setupDataCall(int radioTechnology, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, int reason, LinkProperties linkProperties, DataServiceCallback callback) {
            Message message = null;
            if (callback != null) {
                message = Message.obtain(this.mHandler, 1);
                this.mCallbackMap.put(message, callback);
            }
            this.mPhone.mCi.setupDataCall(radioTechnology, dataProfile, isRoaming, allowRoaming, reason, linkProperties, message);
        }

        @Override
        public void deactivateDataCall(int cid, int reason, DataServiceCallback callback) {
            Message message = null;
            if (callback != null) {
                message = Message.obtain(this.mHandler, 2);
                this.mCallbackMap.put(message, callback);
            }
            this.mPhone.mCi.deactivateDataCall(cid, reason, message);
        }

        @Override
        public void setInitialAttachApn(DataProfile dataProfile, boolean isRoaming, DataServiceCallback callback) {
            Message message = null;
            if (callback != null) {
                message = Message.obtain(this.mHandler, 3);
                this.mCallbackMap.put(message, callback);
            }
            this.mPhone.mCi.setInitialAttachApn(dataProfile, isRoaming, message);
        }

        @Override
        public void setDataProfile(List<DataProfile> dps, boolean isRoaming, DataServiceCallback callback) {
            Message message = null;
            if (callback != null) {
                message = Message.obtain(this.mHandler, 4);
                this.mCallbackMap.put(message, callback);
            }
            this.mPhone.mCi.setDataProfile(dps.toArray(new DataProfile[dps.size()]), isRoaming, message);
        }

        @Override
        public void getDataCallList(DataServiceCallback callback) {
            Message message = null;
            if (callback != null) {
                message = Message.obtain(this.mHandler, 5);
                this.mCallbackMap.put(message, callback);
            }
            this.mPhone.mCi.getDataCallList(message);
        }
    }
}

