/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.content.ContentResolver;
import android.os.Handler;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.util.LocalLog;
import android.util.Pair;
import com.android.internal.telephony.Phone;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class DataEnabledSettings {
    private static final String LOG_TAG = "DataEnabledSettings";
    public static final int REASON_REGISTERED = 0;
    public static final int REASON_INTERNAL_DATA_ENABLED = 1;
    public static final int REASON_USER_DATA_ENABLED = 2;
    public static final int REASON_POLICY_DATA_ENABLED = 3;
    public static final int REASON_DATA_ENABLED_BY_CARRIER = 4;
    private boolean mInternalDataEnabled = true;
    private boolean mPolicyDataEnabled = true;
    private boolean mCarrierDataEnabled = true;
    private Phone mPhone = null;
    private ContentResolver mResolver = null;
    private final RegistrantList mDataEnabledChangedRegistrants = new RegistrantList();
    private final LocalLog mSettingChangeLocalLog = new LocalLog(50);

    public String toString() {
        return "[mInternalDataEnabled=" + this.mInternalDataEnabled + ", isUserDataEnabled=" + this.isUserDataEnabled() + ", isProvisioningDataEnabled=" + this.isProvisioningDataEnabled() + ", mPolicyDataEnabled=" + this.mPolicyDataEnabled + ", mCarrierDataEnabled=" + this.mCarrierDataEnabled + "]";
    }

    public DataEnabledSettings(Phone phone) {
        this.mPhone = phone;
        this.mResolver = this.mPhone.getContext().getContentResolver();
    }

    public synchronized void setInternalDataEnabled(boolean enabled) {
        this.localLog("InternalDataEnabled", enabled);
        boolean prevDataEnabled = this.isDataEnabled();
        this.mInternalDataEnabled = enabled;
        if (prevDataEnabled != this.isDataEnabled()) {
            this.notifyDataEnabledChanged(!prevDataEnabled, 1);
        }
    }

    public synchronized boolean isInternalDataEnabled() {
        return this.mInternalDataEnabled;
    }

    public synchronized void setUserDataEnabled(boolean enabled) {
        this.localLog("UserDataEnabled", enabled);
        boolean prevDataEnabled = this.isDataEnabled();
        Settings.Global.putInt(this.mResolver, this.getMobileDataSettingName(), enabled ? 1 : 0);
        if (prevDataEnabled != this.isDataEnabled()) {
            this.notifyDataEnabledChanged(!prevDataEnabled, 2);
        }
    }

    public synchronized boolean isUserDataEnabled() {
        boolean defaultVal = "true".equalsIgnoreCase(SystemProperties.get("ro.com.android.mobiledata", "true"));
        return Settings.Global.getInt(this.mResolver, this.getMobileDataSettingName(), defaultVal ? 1 : 0) != 0;
    }

    private String getMobileDataSettingName() {
        int subId = this.mPhone.getSubId();
        if (TelephonyManager.getDefault().getSimCount() == 1 || !SubscriptionManager.isValidSubscriptionId(subId)) {
            return "mobile_data";
        }
        return "mobile_data" + this.mPhone.getSubId();
    }

    public synchronized void setPolicyDataEnabled(boolean enabled) {
        this.localLog("PolicyDataEnabled", enabled);
        boolean prevDataEnabled = this.isDataEnabled();
        this.mPolicyDataEnabled = enabled;
        if (prevDataEnabled != this.isDataEnabled()) {
            this.notifyDataEnabledChanged(!prevDataEnabled, 3);
        }
    }

    public synchronized boolean isPolicyDataEnabled() {
        return this.mPolicyDataEnabled;
    }

    public synchronized void setCarrierDataEnabled(boolean enabled) {
        this.localLog("CarrierDataEnabled", enabled);
        boolean prevDataEnabled = this.isDataEnabled();
        this.mCarrierDataEnabled = enabled;
        if (prevDataEnabled != this.isDataEnabled()) {
            this.notifyDataEnabledChanged(!prevDataEnabled, 4);
        }
    }

    public synchronized boolean isCarrierDataEnabled() {
        return this.mCarrierDataEnabled;
    }

    public synchronized boolean isDataEnabled() {
        if (this.isProvisioning()) {
            return this.isProvisioningDataEnabled();
        }
        return this.mInternalDataEnabled && this.isUserDataEnabled() && this.mPolicyDataEnabled && this.mCarrierDataEnabled;
    }

    public boolean isProvisioning() {
        return Settings.Global.getInt(this.mResolver, "device_provisioned", 0) == 0;
    }

    public boolean isProvisioningDataEnabled() {
        String prov_property = SystemProperties.get("ro.com.android.prov_mobiledata", "false");
        boolean retVal = "true".equalsIgnoreCase(prov_property);
        int prov_mobile_data = Settings.Global.getInt(this.mResolver, "device_provisioning_mobile_data", retVal ? 1 : 0);
        retVal = prov_mobile_data != 0;
        this.log("getDataEnabled during provisioning retVal=" + retVal + " - (" + prov_property + ", " + prov_mobile_data + ")");
        return retVal;
    }

    private void notifyDataEnabledChanged(boolean enabled, int reason) {
        this.mDataEnabledChangedRegistrants.notifyResult(new Pair<Boolean, Integer>(enabled, reason));
    }

    public void registerForDataEnabledChanged(Handler h, int what, Object obj) {
        this.mDataEnabledChangedRegistrants.addUnique(h, what, obj);
        this.notifyDataEnabledChanged(this.isDataEnabled(), 0);
    }

    public void unregisterForDataEnabledChanged(Handler h) {
        this.mDataEnabledChangedRegistrants.remove(h);
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private void localLog(String name, boolean value) {
        this.mSettingChangeLocalLog.log(name + " change to " + value);
    }

    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println(" DataEnabledSettings=");
        this.mSettingChangeLocalLog.dump(fd, pw, args);
    }
}

