/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.LinkProperties;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.data.DataCallResponse;
import android.telephony.data.DataProfile;
import android.telephony.data.IDataService;
import android.telephony.data.IDataServiceCallback;
import android.text.TextUtils;
import com.android.internal.telephony.Phone;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DataServiceManager {
    private static final String TAG = DataServiceManager.class.getSimpleName();
    private static final boolean DBG = false;
    static final String DATA_CALL_RESPONSE = "data_call_response";
    private final Phone mPhone;
    private final CarrierConfigManager mCarrierConfigManager;
    private final int mTransportType;
    private boolean mBound;
    private IDataService mIDataService;
    private DataServiceManagerDeathRecipient mDeathRecipient;
    private final RegistrantList mServiceBindingChangedRegistrants = new RegistrantList();
    private final Map<IBinder, Message> mMessageMap = new ConcurrentHashMap<IBinder, Message>();
    private final RegistrantList mDataCallListChangedRegistrants = new RegistrantList();

    public DataServiceManager(Phone phone, int transportType) {
        this.mPhone = phone;
        this.mTransportType = transportType;
        this.mBound = false;
        this.mCarrierConfigManager = (CarrierConfigManager)phone.getContext().getSystemService("carrier_config");
        this.bindDataService();
    }

    private void bindDataService() {
        String packageName = this.getDataServicePackageName();
        if (TextUtils.isEmpty(packageName)) {
            this.loge("Can't find the binding package");
            return;
        }
        try {
            if (!this.mPhone.getContext().bindService(new Intent("android.telephony.data.DataService").setPackage(packageName), new CellularDataServiceConnection(), 1)) {
                this.loge("Cannot bind to the data service.");
            }
        }
        catch (Exception e) {
            this.loge("Cannot bind to the data service. Exception: " + e);
        }
    }

    private String getDataServicePackageName() {
        String carrierConfig;
        int resourceId;
        switch (this.mTransportType) {
            case 1: {
                resourceId = 17039720;
                carrierConfig = "carrier_data_service_wwan_package_override_string";
                break;
            }
            case 2: {
                resourceId = 17039718;
                carrierConfig = "carrier_data_service_wlan_package_override_string";
                break;
            }
            default: {
                throw new IllegalStateException("Transport type not WWAN or WLAN. type=" + this.mTransportType);
            }
        }
        String packageName = this.mPhone.getContext().getResources().getString(resourceId);
        PersistableBundle b = this.mCarrierConfigManager.getConfigForSubId(this.mPhone.getSubId());
        if (b != null) {
            packageName = b.getString(carrierConfig, packageName);
        }
        return packageName;
    }

    private void sendCompleteMessage(Message msg, int code) {
        if (msg != null) {
            msg.arg1 = code;
            msg.sendToTarget();
        }
    }

    public void setupDataCall(int accessNetworkType, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, int reason, LinkProperties linkProperties, Message onCompleteMessage) {
        if (!this.mBound) {
            this.loge("Data service not bound.");
            this.sendCompleteMessage(onCompleteMessage, 4);
            return;
        }
        CellularDataServiceCallback callback = null;
        if (onCompleteMessage != null) {
            callback = new CellularDataServiceCallback();
            this.mMessageMap.put(callback.asBinder(), onCompleteMessage);
        }
        try {
            this.mIDataService.setupDataCall(this.mPhone.getPhoneId(), accessNetworkType, dataProfile, isRoaming, allowRoaming, reason, linkProperties, callback);
        }
        catch (RemoteException e) {
            this.loge("Cannot invoke setupDataCall on data service.");
            if (callback != null) {
                this.mMessageMap.remove(callback.asBinder());
            }
            this.sendCompleteMessage(onCompleteMessage, 4);
        }
    }

    public void deactivateDataCall(int cid, int reason, Message onCompleteMessage) {
        if (!this.mBound) {
            this.loge("Data service not bound.");
            this.sendCompleteMessage(onCompleteMessage, 4);
            return;
        }
        CellularDataServiceCallback callback = null;
        if (onCompleteMessage != null) {
            callback = new CellularDataServiceCallback();
            this.mMessageMap.put(callback.asBinder(), onCompleteMessage);
        }
        try {
            this.mIDataService.deactivateDataCall(this.mPhone.getPhoneId(), cid, reason, callback);
        }
        catch (RemoteException e) {
            this.loge("Cannot invoke deactivateDataCall on data service.");
            if (callback != null) {
                this.mMessageMap.remove(callback.asBinder());
            }
            this.sendCompleteMessage(onCompleteMessage, 4);
        }
    }

    public void setInitialAttachApn(DataProfile dataProfile, boolean isRoaming, Message onCompleteMessage) {
        if (!this.mBound) {
            this.loge("Data service not bound.");
            this.sendCompleteMessage(onCompleteMessage, 4);
            return;
        }
        CellularDataServiceCallback callback = null;
        if (onCompleteMessage != null) {
            callback = new CellularDataServiceCallback();
            this.mMessageMap.put(callback.asBinder(), onCompleteMessage);
        }
        try {
            this.mIDataService.setInitialAttachApn(this.mPhone.getPhoneId(), dataProfile, isRoaming, callback);
        }
        catch (RemoteException e) {
            this.loge("Cannot invoke setInitialAttachApn on data service.");
            if (callback != null) {
                this.mMessageMap.remove(callback.asBinder());
            }
            this.sendCompleteMessage(onCompleteMessage, 4);
        }
    }

    public void setDataProfile(List<DataProfile> dps, boolean isRoaming, Message onCompleteMessage) {
        if (!this.mBound) {
            this.loge("Data service not bound.");
            this.sendCompleteMessage(onCompleteMessage, 4);
            return;
        }
        CellularDataServiceCallback callback = null;
        if (onCompleteMessage != null) {
            callback = new CellularDataServiceCallback();
            this.mMessageMap.put(callback.asBinder(), onCompleteMessage);
        }
        try {
            this.mIDataService.setDataProfile(this.mPhone.getPhoneId(), dps, isRoaming, callback);
        }
        catch (RemoteException e) {
            this.loge("Cannot invoke setDataProfile on data service.");
            if (callback != null) {
                this.mMessageMap.remove(callback.asBinder());
            }
            this.sendCompleteMessage(onCompleteMessage, 4);
        }
    }

    public void getDataCallList(Message onCompleteMessage) {
        if (!this.mBound) {
            this.loge("Data service not bound.");
            this.sendCompleteMessage(onCompleteMessage, 4);
            return;
        }
        CellularDataServiceCallback callback = null;
        if (onCompleteMessage != null) {
            callback = new CellularDataServiceCallback();
            this.mMessageMap.put(callback.asBinder(), onCompleteMessage);
        }
        try {
            this.mIDataService.getDataCallList(this.mPhone.getPhoneId(), callback);
        }
        catch (RemoteException e) {
            this.loge("Cannot invoke getDataCallList on data service.");
            if (callback != null) {
                this.mMessageMap.remove(callback.asBinder());
            }
            this.sendCompleteMessage(onCompleteMessage, 4);
        }
    }

    public void registerForDataCallListChanged(Handler h, int what) {
        if (h != null) {
            this.mDataCallListChangedRegistrants.addUnique(h, what, null);
        }
    }

    public void unregisterForDataCallListChanged(Handler h) {
        if (h != null) {
            this.mDataCallListChangedRegistrants.remove(h);
        }
    }

    public void registerForServiceBindingChanged(Handler h, int what, Object obj) {
        if (h != null) {
            this.mServiceBindingChangedRegistrants.addUnique(h, what, obj);
        }
    }

    public void unregisterForServiceBindingChanged(Handler h) {
        if (h != null) {
            this.mServiceBindingChangedRegistrants.remove(h);
        }
    }

    public int getTransportType() {
        return this.mTransportType;
    }

    private void log(String s) {
        Rlog.d(TAG, s);
    }

    private void loge(String s) {
        Rlog.e(TAG, s);
    }

    private final class CellularDataServiceCallback
    extends IDataServiceCallback.Stub {
        private CellularDataServiceCallback() {
        }

        @Override
        public void onSetupDataCallComplete(int resultCode, DataCallResponse response) {
            Message msg = (Message)DataServiceManager.this.mMessageMap.remove(this.asBinder());
            if (msg != null) {
                msg.getData().putParcelable(DataServiceManager.DATA_CALL_RESPONSE, response);
                DataServiceManager.this.sendCompleteMessage(msg, resultCode);
            } else {
                DataServiceManager.this.loge("Unable to find the message for setup call response.");
            }
        }

        @Override
        public void onDeactivateDataCallComplete(int resultCode) {
            Message msg = (Message)DataServiceManager.this.mMessageMap.remove(this.asBinder());
            DataServiceManager.this.sendCompleteMessage(msg, resultCode);
        }

        @Override
        public void onSetInitialAttachApnComplete(int resultCode) {
            Message msg = (Message)DataServiceManager.this.mMessageMap.remove(this.asBinder());
            DataServiceManager.this.sendCompleteMessage(msg, resultCode);
        }

        @Override
        public void onSetDataProfileComplete(int resultCode) {
            Message msg = (Message)DataServiceManager.this.mMessageMap.remove(this.asBinder());
            DataServiceManager.this.sendCompleteMessage(msg, resultCode);
        }

        @Override
        public void onGetDataCallListComplete(int resultCode, List<DataCallResponse> dataCallList) {
            Message msg = (Message)DataServiceManager.this.mMessageMap.remove(this.asBinder());
            DataServiceManager.this.sendCompleteMessage(msg, resultCode);
        }

        @Override
        public void onDataCallListChanged(List<DataCallResponse> dataCallList) {
            DataServiceManager.this.mDataCallListChangedRegistrants.notifyRegistrants(new AsyncResult(null, dataCallList, null));
        }
    }

    private final class CellularDataServiceConnection
    implements ServiceConnection {
        private CellularDataServiceConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            DataServiceManager.this.mIDataService = IDataService.Stub.asInterface(service);
            DataServiceManager.this.mDeathRecipient = new DataServiceManagerDeathRecipient(name);
            DataServiceManager.this.mBound = true;
            try {
                service.linkToDeath(DataServiceManager.this.mDeathRecipient, 0);
                DataServiceManager.this.mIDataService.createDataServiceProvider(DataServiceManager.this.mPhone.getPhoneId());
                DataServiceManager.this.mIDataService.registerForDataCallListChanged(DataServiceManager.this.mPhone.getPhoneId(), new CellularDataServiceCallback());
            }
            catch (RemoteException e) {
                DataServiceManager.this.mDeathRecipient.binderDied();
                DataServiceManager.this.loge("Remote exception. " + e);
                return;
            }
            DataServiceManager.this.mServiceBindingChangedRegistrants.notifyResult(true);
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            DataServiceManager.this.mIDataService.asBinder().unlinkToDeath(DataServiceManager.this.mDeathRecipient, 0);
            DataServiceManager.this.mIDataService = null;
            DataServiceManager.this.mBound = false;
            DataServiceManager.this.mServiceBindingChangedRegistrants.notifyResult(false);
        }
    }

    private class DataServiceManagerDeathRecipient
    implements IBinder.DeathRecipient {
        private final ComponentName mComponentName;

        DataServiceManagerDeathRecipient(ComponentName name) {
            this.mComponentName = name;
        }

        @Override
        public void binderDied() {
            DataServiceManager.this.loge("DataService(" + this.mComponentName + " transport type " + DataServiceManager.this.mTransportType + ") died.");
        }
    }
}

