/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.euicc;

import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.ComponentInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.euicc.EuiccProfileInfo;
import android.telephony.euicc.EuiccNotification;
import android.telephony.euicc.EuiccRulesAuthTable;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.euicc.EuiccConnector;
import com.android.internal.telephony.euicc.IAuthenticateServerCallback;
import com.android.internal.telephony.euicc.ICancelSessionCallback;
import com.android.internal.telephony.euicc.IDeleteProfileCallback;
import com.android.internal.telephony.euicc.IDisableProfileCallback;
import com.android.internal.telephony.euicc.IEuiccCardController;
import com.android.internal.telephony.euicc.IGetAllProfilesCallback;
import com.android.internal.telephony.euicc.IGetDefaultSmdpAddressCallback;
import com.android.internal.telephony.euicc.IGetEuiccChallengeCallback;
import com.android.internal.telephony.euicc.IGetEuiccInfo1Callback;
import com.android.internal.telephony.euicc.IGetEuiccInfo2Callback;
import com.android.internal.telephony.euicc.IGetProfileCallback;
import com.android.internal.telephony.euicc.IGetRulesAuthTableCallback;
import com.android.internal.telephony.euicc.IGetSmdsAddressCallback;
import com.android.internal.telephony.euicc.IListNotificationsCallback;
import com.android.internal.telephony.euicc.ILoadBoundProfilePackageCallback;
import com.android.internal.telephony.euicc.IPrepareDownloadCallback;
import com.android.internal.telephony.euicc.IRemoveNotificationFromListCallback;
import com.android.internal.telephony.euicc.IResetMemoryCallback;
import com.android.internal.telephony.euicc.IRetrieveNotificationCallback;
import com.android.internal.telephony.euicc.IRetrieveNotificationListCallback;
import com.android.internal.telephony.euicc.ISetDefaultSmdpAddressCallback;
import com.android.internal.telephony.euicc.ISetNicknameCallback;
import com.android.internal.telephony.euicc.ISwitchToProfileCallback;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.uicc.UiccSlot;
import com.android.internal.telephony.uicc.euicc.EuiccCard;
import com.android.internal.telephony.uicc.euicc.EuiccCardErrorException;
import com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class EuiccCardController
extends IEuiccCardController.Stub {
    private static final String TAG = "EuiccCardController";
    private final Context mContext;
    private AppOpsManager mAppOps;
    private String mCallingPackage;
    private ComponentInfo mBestComponent;
    private Handler mEuiccMainThreadHandler;
    private static EuiccCardController sInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EuiccCardController init(Context context) {
        Class<EuiccCardController> clazz = EuiccCardController.class;
        synchronized (EuiccCardController.class) {
            if (sInstance == null) {
                sInstance = new EuiccCardController(context);
            } else {
                Log.wtf(TAG, "init() called multiple times! sInstance = " + sInstance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EuiccCardController get() {
        if (sInstance != null) return sInstance;
        Class<EuiccCardController> clazz = EuiccCardController.class;
        synchronized (EuiccCardController.class) {
            if (sInstance != null) return sInstance;
            throw new IllegalStateException("get() called before init()");
        }
    }

    private EuiccCardController(Context context) {
        this.mContext = context;
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        this.mEuiccMainThreadHandler = new Handler();
        ServiceManager.addService("euicc_card_controller", this);
    }

    private void checkCallingPackage(String callingPackage) {
        this.mAppOps.checkPackage(Binder.getCallingUid(), callingPackage);
        this.mCallingPackage = callingPackage;
        this.mBestComponent = EuiccConnector.findBestComponent(this.mContext.getPackageManager());
        if (this.mBestComponent == null || !TextUtils.equals(this.mCallingPackage, this.mBestComponent.packageName)) {
            throw new SecurityException("The calling package can only be LPA.");
        }
    }

    private EuiccCard getEuiccCard(String cardId) {
        UiccSlot slot;
        UiccController controller = UiccController.getInstance();
        int slotId = controller.getUiccSlotForCardId(cardId);
        if (slotId != -1 && (slot = controller.getUiccSlot(slotId)).isEuicc()) {
            return (EuiccCard)controller.getUiccCardForSlot(slotId);
        }
        return null;
    }

    private int getResultCode(Throwable e) {
        if (e instanceof EuiccCardErrorException) {
            return ((EuiccCardErrorException)e).getErrorCode();
        }
        return -1;
    }

    @Override
    public void getAllProfiles(String callingPackage, String cardId, final IGetAllProfilesCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<EuiccProfileInfo[]> cardCb = new AsyncResultCallback<EuiccProfileInfo[]>(){

            @Override
            public void onResult(EuiccProfileInfo[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).getAllProfiles(cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void getProfile(String callingPackage, String cardId, String iccid, final IGetProfileCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<EuiccProfileInfo> cardCb = new AsyncResultCallback<EuiccProfileInfo>(){

            @Override
            public void onResult(EuiccProfileInfo result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).getProfile(iccid, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void disableProfile(String callingPackage, String cardId, String iccid, boolean refresh, final IDisableProfileCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(){

            @Override
            public void onResult(Void result) {
                try {
                    callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e));
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).disableProfile(iccid, refresh, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void switchToProfile(String callingPackage, final String cardId, final String iccid, final boolean refresh, final ISwitchToProfileCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<EuiccProfileInfo> profileCb = new AsyncResultCallback<EuiccProfileInfo>(){

            @Override
            public void onResult(final EuiccProfileInfo profile) {
                AsyncResultCallback<Void> switchCb = new AsyncResultCallback<Void>(){

                    @Override
                    public void onResult(Void result) {
                        try {
                            callback.onComplete(0, profile);
                        }
                        catch (RemoteException exception) {
                            throw exception.rethrowFromSystemServer();
                        }
                    }

                    @Override
                    public void onException(Throwable e) {
                        try {
                            callback.onComplete(EuiccCardController.this.getResultCode(e), profile);
                        }
                        catch (RemoteException exception) {
                            throw exception.rethrowFromSystemServer();
                        }
                    }
                };
                EuiccCardController.this.getEuiccCard(cardId).switchToProfile(iccid, refresh, switchCb, EuiccCardController.this.mEuiccMainThreadHandler);
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).getProfile(iccid, profileCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void setNickname(String callingPackage, String cardId, String iccid, String nickname, final ISetNicknameCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(){

            @Override
            public void onResult(Void result) {
                try {
                    callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e));
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).setNickname(iccid, nickname, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void deleteProfile(String callingPackage, String cardId, String iccid, final IDeleteProfileCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(){

            @Override
            public void onResult(Void result) {
                try {
                    callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e));
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).deleteProfile(iccid, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void resetMemory(String callingPackage, String cardId, int options, final IResetMemoryCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(){

            @Override
            public void onResult(Void result) {
                try {
                    callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e));
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).resetMemory(options, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void getDefaultSmdpAddress(String callingPackage, String cardId, final IGetDefaultSmdpAddressCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<String> cardCb = new AsyncResultCallback<String>(){

            @Override
            public void onResult(String result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).getDefaultSmdpAddress(cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void getSmdsAddress(String callingPackage, String cardId, final IGetSmdsAddressCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<String> cardCb = new AsyncResultCallback<String>(){

            @Override
            public void onResult(String result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).getSmdsAddress(cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void setDefaultSmdpAddress(String callingPackage, String cardId, String address, final ISetDefaultSmdpAddressCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(){

            @Override
            public void onResult(Void result) {
                try {
                    callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e));
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).setDefaultSmdpAddress(address, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void getRulesAuthTable(String callingPackage, String cardId, final IGetRulesAuthTableCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<EuiccRulesAuthTable> cardCb = new AsyncResultCallback<EuiccRulesAuthTable>(){

            @Override
            public void onResult(EuiccRulesAuthTable result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).getRulesAuthTable(cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void getEuiccChallenge(String callingPackage, String cardId, final IGetEuiccChallengeCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(){

            @Override
            public void onResult(byte[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).getEuiccChallenge(cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void getEuiccInfo1(String callingPackage, String cardId, final IGetEuiccInfo1Callback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(){

            @Override
            public void onResult(byte[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).getEuiccInfo1(cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void getEuiccInfo2(String callingPackage, String cardId, final IGetEuiccInfo2Callback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(){

            @Override
            public void onResult(byte[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).getEuiccInfo2(cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void authenticateServer(String callingPackage, String cardId, String matchingId, byte[] serverSigned1, byte[] serverSignature1, byte[] euiccCiPkIdToBeUsed, byte[] serverCertificate, final IAuthenticateServerCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(){

            @Override
            public void onResult(byte[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).authenticateServer(matchingId, serverSigned1, serverSignature1, euiccCiPkIdToBeUsed, serverCertificate, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void prepareDownload(String callingPackage, String cardId, byte[] hashCc, byte[] smdpSigned2, byte[] smdpSignature2, byte[] smdpCertificate, final IPrepareDownloadCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(){

            @Override
            public void onResult(byte[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).prepareDownload(hashCc, smdpSigned2, smdpSignature2, smdpCertificate, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void loadBoundProfilePackage(String callingPackage, String cardId, byte[] boundProfilePackage, final ILoadBoundProfilePackageCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(){

            @Override
            public void onResult(byte[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).loadBoundProfilePackage(boundProfilePackage, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void cancelSession(String callingPackage, String cardId, byte[] transactionId, int reason, final ICancelSessionCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(){

            @Override
            public void onResult(byte[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).cancelSession(transactionId, reason, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void listNotifications(String callingPackage, String cardId, int events, final IListNotificationsCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<EuiccNotification[]> cardCb = new AsyncResultCallback<EuiccNotification[]>(){

            @Override
            public void onResult(EuiccNotification[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).listNotifications(events, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void retrieveNotificationList(String callingPackage, String cardId, int events, final IRetrieveNotificationListCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<EuiccNotification[]> cardCb = new AsyncResultCallback<EuiccNotification[]>(){

            @Override
            public void onResult(EuiccNotification[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).retrieveNotificationList(events, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void retrieveNotification(String callingPackage, String cardId, int seqNumber, final IRetrieveNotificationCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<EuiccNotification> cardCb = new AsyncResultCallback<EuiccNotification>(){

            @Override
            public void onResult(EuiccNotification result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).retrieveNotification(seqNumber, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void removeNotificationFromList(String callingPackage, String cardId, int seqNumber, final IRemoveNotificationFromListCallback callback) {
        this.checkCallingPackage(callingPackage);
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(){

            @Override
            public void onResult(Void result) {
                try {
                    callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    callback.onComplete(EuiccCardController.this.getResultCode(e));
                }
                catch (RemoteException exception) {
                    throw exception.rethrowFromSystemServer();
                }
            }
        };
        this.getEuiccCard(cardId).removeNotificationFromList(seqNumber, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "Requires DUMP");
        long token = Binder.clearCallingIdentity();
        super.dump(fd, pw, args);
        pw.println("mCallingPackage=" + this.mCallingPackage);
        pw.println("mBestComponent=" + this.mBestComponent);
        Binder.restoreCallingIdentity(token);
    }
}

