/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.euicc;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.service.euicc.GetDefaultDownloadableSubscriptionListResult;
import android.service.euicc.GetDownloadableSubscriptionMetadataResult;
import android.service.euicc.GetEuiccProfileInfoListResult;
import android.service.euicc.IDeleteSubscriptionCallback;
import android.service.euicc.IDownloadSubscriptionCallback;
import android.service.euicc.IEraseSubscriptionsCallback;
import android.service.euicc.IEuiccService;
import android.service.euicc.IGetDefaultDownloadableSubscriptionListCallback;
import android.service.euicc.IGetDownloadableSubscriptionMetadataCallback;
import android.service.euicc.IGetEidCallback;
import android.service.euicc.IGetEuiccInfoCallback;
import android.service.euicc.IGetEuiccProfileInfoListCallback;
import android.service.euicc.IGetOtaStatusCallback;
import android.service.euicc.IOtaStatusChangedCallback;
import android.service.euicc.IRetainSubscriptionsForFactoryResetCallback;
import android.service.euicc.ISwitchToSubscriptionCallback;
import android.service.euicc.IUpdateSubscriptionNicknameCallback;
import android.telephony.euicc.DownloadableSubscription;
import android.telephony.euicc.EuiccInfo;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.content.PackageMonitor;
import com.android.internal.util.IState;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class EuiccConnector
extends StateMachine
implements ServiceConnection {
    private static final String TAG = "EuiccConnector";
    private static final int BIND_TIMEOUT_MILLIS = 30000;
    @VisibleForTesting
    static final int LINGER_TIMEOUT_MILLIS = 60000;
    private static final int CMD_PACKAGE_CHANGE = 1;
    private static final int CMD_CONNECT_TIMEOUT = 2;
    private static final int CMD_LINGER_TIMEOUT = 3;
    private static final int CMD_SERVICE_CONNECTED = 4;
    private static final int CMD_SERVICE_DISCONNECTED = 5;
    private static final int CMD_COMMAND_COMPLETE = 6;
    private static final int CMD_GET_EID = 100;
    private static final int CMD_GET_DOWNLOADABLE_SUBSCRIPTION_METADATA = 101;
    private static final int CMD_DOWNLOAD_SUBSCRIPTION = 102;
    private static final int CMD_GET_EUICC_PROFILE_INFO_LIST = 103;
    private static final int CMD_GET_DEFAULT_DOWNLOADABLE_SUBSCRIPTION_LIST = 104;
    private static final int CMD_GET_EUICC_INFO = 105;
    private static final int CMD_DELETE_SUBSCRIPTION = 106;
    private static final int CMD_SWITCH_TO_SUBSCRIPTION = 107;
    private static final int CMD_UPDATE_SUBSCRIPTION_NICKNAME = 108;
    private static final int CMD_ERASE_SUBSCRIPTIONS = 109;
    private static final int CMD_RETAIN_SUBSCRIPTIONS = 110;
    private static final int CMD_GET_OTA_STATUS = 111;
    private static final int CMD_START_OTA_IF_NECESSARY = 112;
    private static final int EUICC_QUERY_FLAGS = 0x10100040;
    private Context mContext;
    private PackageManager mPm;
    private final PackageMonitor mPackageMonitor = new EuiccPackageMonitor();
    private final BroadcastReceiver mUserUnlockedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_UNLOCKED".equals(intent.getAction())) {
                EuiccConnector.this.sendMessage(1);
            }
        }
    };
    private ServiceInfo mSelectedComponent;
    private IEuiccService mEuiccService;
    private Set<BaseEuiccCommandCallback> mActiveCommandCallbacks = new ArraySet<BaseEuiccCommandCallback>();
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public UnavailableState mUnavailableState;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public AvailableState mAvailableState;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public BindingState mBindingState;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public DisconnectedState mDisconnectedState;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public ConnectedState mConnectedState;

    private static boolean isEuiccCommand(int what) {
        return what >= 100;
    }

    public static ActivityInfo findBestActivity(PackageManager packageManager, Intent intent) {
        List<ResolveInfo> resolveInfoList = packageManager.queryIntentActivities(intent, 0x10100040);
        ActivityInfo bestComponent = (ActivityInfo)EuiccConnector.findBestComponent(packageManager, resolveInfoList);
        if (bestComponent == null) {
            Log.w(TAG, "No valid component found for intent: " + intent);
        }
        return bestComponent;
    }

    public static ComponentInfo findBestComponent(PackageManager packageManager) {
        Intent intent = new Intent("android.service.euicc.EuiccService");
        List<ResolveInfo> resolveInfoList = packageManager.queryIntentServices(intent, 0x10100040);
        ComponentInfo bestComponent = EuiccConnector.findBestComponent(packageManager, resolveInfoList);
        if (bestComponent == null) {
            Log.w(TAG, "No valid EuiccService implementation found");
        }
        return bestComponent;
    }

    EuiccConnector(Context context) {
        super(TAG);
        this.init(context);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public EuiccConnector(Context context, Looper looper) {
        super(TAG, looper);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.mPm = context.getPackageManager();
        this.mUnavailableState = new UnavailableState();
        this.addState(this.mUnavailableState);
        this.mAvailableState = new AvailableState();
        this.addState(this.mAvailableState, this.mUnavailableState);
        this.mBindingState = new BindingState();
        this.addState(this.mBindingState);
        this.mDisconnectedState = new DisconnectedState();
        this.addState(this.mDisconnectedState);
        this.mConnectedState = new ConnectedState();
        this.addState(this.mConnectedState, this.mDisconnectedState);
        this.mSelectedComponent = this.findBestComponent();
        this.setInitialState(this.mSelectedComponent != null ? this.mAvailableState : this.mUnavailableState);
        this.mPackageMonitor.register(this.mContext, null, false);
        this.mContext.registerReceiver(this.mUserUnlockedReceiver, new IntentFilter("android.intent.action.USER_UNLOCKED"));
        this.start();
    }

    @Override
    public void onHalting() {
        this.mPackageMonitor.unregister();
        this.mContext.unregisterReceiver(this.mUserUnlockedReceiver);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void getEid(GetEidCommandCallback callback) {
        this.sendMessage(100, callback);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void getOtaStatus(GetOtaStatusCommandCallback callback) {
        this.sendMessage(111, callback);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void startOtaIfNecessary(OtaStatusChangedCallback callback) {
        this.sendMessage(112, callback);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void getDownloadableSubscriptionMetadata(DownloadableSubscription subscription, boolean forceDeactivateSim, GetMetadataCommandCallback callback) {
        GetMetadataRequest request = new GetMetadataRequest();
        request.mSubscription = subscription;
        request.mForceDeactivateSim = forceDeactivateSim;
        request.mCallback = callback;
        this.sendMessage(101, request);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void downloadSubscription(DownloadableSubscription subscription, boolean switchAfterDownload, boolean forceDeactivateSim, DownloadCommandCallback callback) {
        DownloadRequest request = new DownloadRequest();
        request.mSubscription = subscription;
        request.mSwitchAfterDownload = switchAfterDownload;
        request.mForceDeactivateSim = forceDeactivateSim;
        request.mCallback = callback;
        this.sendMessage(102, request);
    }

    void getEuiccProfileInfoList(GetEuiccProfileInfoListCommandCallback callback) {
        this.sendMessage(103, callback);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void getDefaultDownloadableSubscriptionList(boolean forceDeactivateSim, GetDefaultListCommandCallback callback) {
        GetDefaultListRequest request = new GetDefaultListRequest();
        request.mForceDeactivateSim = forceDeactivateSim;
        request.mCallback = callback;
        this.sendMessage(104, request);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void getEuiccInfo(GetEuiccInfoCommandCallback callback) {
        this.sendMessage(105, callback);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void deleteSubscription(String iccid, DeleteCommandCallback callback) {
        DeleteRequest request = new DeleteRequest();
        request.mIccid = iccid;
        request.mCallback = callback;
        this.sendMessage(106, request);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void switchToSubscription(String iccid, boolean forceDeactivateSim, SwitchCommandCallback callback) {
        SwitchRequest request = new SwitchRequest();
        request.mIccid = iccid;
        request.mForceDeactivateSim = forceDeactivateSim;
        request.mCallback = callback;
        this.sendMessage(107, request);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void updateSubscriptionNickname(String iccid, String nickname, UpdateNicknameCommandCallback callback) {
        UpdateNicknameRequest request = new UpdateNicknameRequest();
        request.mIccid = iccid;
        request.mNickname = nickname;
        request.mCallback = callback;
        this.sendMessage(108, request);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void eraseSubscriptions(EraseCommandCallback callback) {
        this.sendMessage(109, callback);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void retainSubscriptions(RetainSubscriptionsCommandCallback callback) {
        this.sendMessage(110, callback);
    }

    private static BaseEuiccCommandCallback getCallback(Message message) {
        switch (message.what) {
            case 100: 
            case 103: 
            case 105: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                return (BaseEuiccCommandCallback)message.obj;
            }
            case 101: {
                return ((GetMetadataRequest)message.obj).mCallback;
            }
            case 102: {
                return ((DownloadRequest)message.obj).mCallback;
            }
            case 104: {
                return ((GetDefaultListRequest)message.obj).mCallback;
            }
            case 106: {
                return ((DeleteRequest)message.obj).mCallback;
            }
            case 107: {
                return ((SwitchRequest)message.obj).mCallback;
            }
            case 108: {
                return ((UpdateNicknameRequest)message.obj).mCallback;
            }
        }
        throw new IllegalArgumentException("Unsupported message: " + message.what);
    }

    private void onCommandStart(BaseEuiccCommandCallback callback) {
        this.mActiveCommandCallbacks.add(callback);
        this.removeMessages(3);
    }

    private void onCommandEnd(BaseEuiccCommandCallback callback) {
        if (!this.mActiveCommandCallbacks.remove(callback)) {
            Log.wtf(TAG, "Callback already removed from mActiveCommandCallbacks");
        }
        if (this.mActiveCommandCallbacks.isEmpty()) {
            this.sendMessageDelayed(3, 60000L);
        }
    }

    private ServiceInfo findBestComponent() {
        return (ServiceInfo)EuiccConnector.findBestComponent(this.mPm);
    }

    private boolean createBinding() {
        if (this.mSelectedComponent == null) {
            Log.wtf(TAG, "Attempting to create binding but no component is selected");
            return false;
        }
        Intent intent = new Intent("android.service.euicc.EuiccService");
        intent.setComponent(this.mSelectedComponent.getComponentName());
        return this.mContext.bindService(intent, this, 0x4000001);
    }

    private void unbind() {
        this.mEuiccService = null;
        this.mContext.unbindService(this);
    }

    private static ComponentInfo findBestComponent(PackageManager packageManager, List<ResolveInfo> resolveInfoList) {
        int bestPriority = Integer.MIN_VALUE;
        ComponentInfo bestComponent = null;
        if (resolveInfoList != null) {
            for (ResolveInfo resolveInfo : resolveInfoList) {
                if (!EuiccConnector.isValidEuiccComponent(packageManager, resolveInfo) || resolveInfo.filter.getPriority() <= bestPriority) continue;
                bestPriority = resolveInfo.filter.getPriority();
                bestComponent = resolveInfo.getComponentInfo();
            }
        }
        return bestComponent;
    }

    private static boolean isValidEuiccComponent(PackageManager packageManager, ResolveInfo resolveInfo) {
        String permission2;
        ComponentInfo componentInfo = resolveInfo.getComponentInfo();
        String packageName = componentInfo.getComponentName().getPackageName();
        if (packageManager.checkPermission("com.android.permission.WRITE_EMBEDDED_SUBSCRIPTIONS", packageName) != 0) {
            Log.wtf(TAG, "Package " + packageName + " does not declare WRITE_EMBEDDED_SUBSCRIPTIONS");
            return false;
        }
        if (componentInfo instanceof ServiceInfo) {
            permission2 = ((ServiceInfo)componentInfo).permission;
        } else if (componentInfo instanceof ActivityInfo) {
            permission2 = ((ActivityInfo)componentInfo).permission;
        } else {
            throw new IllegalArgumentException("Can only verify services/activities");
        }
        if (!TextUtils.equals(permission2, "com.android.permission.BIND_EUICC_SERVICE")) {
            Log.wtf(TAG, "Package " + packageName + " does not require the BIND_EUICC_SERVICE permission");
            return false;
        }
        if (resolveInfo.filter == null || resolveInfo.filter.getPriority() == 0) {
            Log.wtf(TAG, "Package " + packageName + " does not specify a priority");
            return false;
        }
        return true;
    }

    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        IEuiccService euiccService = IEuiccService.Stub.asInterface(service);
        this.sendMessage(4, euiccService);
    }

    @Override
    public void onServiceDisconnected(ComponentName name) {
        this.sendMessage(5);
    }

    @Override
    protected void unhandledMessage(Message msg) {
        IState state = this.getCurrentState();
        Log.wtf(TAG, "Unhandled message " + msg.what + " in state " + (state == null ? "null" : state.getName()));
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        super.dump(fd, pw, args);
        pw.println("mSelectedComponent=" + this.mSelectedComponent);
        pw.println("mEuiccService=" + this.mEuiccService);
        pw.println("mActiveCommandCount=" + this.mActiveCommandCallbacks.size());
    }

    private class EuiccPackageMonitor
    extends PackageMonitor {
        private EuiccPackageMonitor() {
        }

        @Override
        public void onPackageAdded(String packageName, int reason) {
            this.sendPackageChange(packageName, true);
        }

        @Override
        public void onPackageRemoved(String packageName, int reason) {
            this.sendPackageChange(packageName, true);
        }

        @Override
        public void onPackageUpdateFinished(String packageName, int uid) {
            this.sendPackageChange(packageName, true);
        }

        @Override
        public void onPackageModified(String packageName) {
            this.sendPackageChange(packageName, false);
        }

        @Override
        public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
            if (doit) {
                for (String packageName : packages) {
                    this.sendPackageChange(packageName, true);
                }
            }
            return super.onHandleForceStop(intent, packages, uid, doit);
        }

        private void sendPackageChange(String packageName, boolean forceUnbindForThisPackage) {
            EuiccConnector.this.sendMessage(1, forceUnbindForThisPackage ? packageName : null);
        }
    }

    private class ConnectedState
    extends State {
        private ConnectedState() {
        }

        @Override
        public void enter() {
            EuiccConnector.this.removeMessages(2);
            EuiccConnector.this.sendMessageDelayed(3, 60000L);
        }

        @Override
        public boolean processMessage(Message message) {
            if (message.what == 5) {
                EuiccConnector.this.mEuiccService = null;
                EuiccConnector.this.transitionTo(EuiccConnector.this.mDisconnectedState);
                return true;
            }
            if (message.what == 3) {
                EuiccConnector.this.unbind();
                EuiccConnector.this.transitionTo(EuiccConnector.this.mAvailableState);
                return true;
            }
            if (message.what == 6) {
                Runnable runnable = (Runnable)message.obj;
                runnable.run();
                return true;
            }
            if (EuiccConnector.isEuiccCommand(message.what)) {
                final BaseEuiccCommandCallback callback = EuiccConnector.getCallback(message);
                EuiccConnector.this.onCommandStart(callback);
                int slotId = -1;
                try {
                    switch (message.what) {
                        case 100: {
                            EuiccConnector.this.mEuiccService.getEid(slotId, new IGetEidCallback.Stub(){

                                @Override
                                public void onSuccess(String eid) {
                                    EuiccConnector.this.sendMessage(6, () -> {
                                        ((GetEidCommandCallback)callback).onGetEidComplete(eid);
                                        EuiccConnector.this.onCommandEnd(callback);
                                    });
                                }
                            });
                            break;
                        }
                        case 101: {
                            GetMetadataRequest request = (GetMetadataRequest)message.obj;
                            EuiccConnector.this.mEuiccService.getDownloadableSubscriptionMetadata(slotId, request.mSubscription, request.mForceDeactivateSim, new IGetDownloadableSubscriptionMetadataCallback.Stub(){

                                @Override
                                public void onComplete(GetDownloadableSubscriptionMetadataResult result) {
                                    EuiccConnector.this.sendMessage(6, () -> {
                                        ((GetMetadataCommandCallback)callback).onGetMetadataComplete(result);
                                        EuiccConnector.this.onCommandEnd(callback);
                                    });
                                }
                            });
                            break;
                        }
                        case 102: {
                            DownloadRequest request = (DownloadRequest)message.obj;
                            EuiccConnector.this.mEuiccService.downloadSubscription(slotId, request.mSubscription, request.mSwitchAfterDownload, request.mForceDeactivateSim, new IDownloadSubscriptionCallback.Stub(){

                                @Override
                                public void onComplete(int result) {
                                    EuiccConnector.this.sendMessage(6, () -> {
                                        ((DownloadCommandCallback)callback).onDownloadComplete(result);
                                        EuiccConnector.this.onCommandEnd(callback);
                                    });
                                }
                            });
                            break;
                        }
                        case 103: {
                            EuiccConnector.this.mEuiccService.getEuiccProfileInfoList(slotId, new IGetEuiccProfileInfoListCallback.Stub(){

                                @Override
                                public void onComplete(GetEuiccProfileInfoListResult result) {
                                    EuiccConnector.this.sendMessage(6, () -> {
                                        ((GetEuiccProfileInfoListCommandCallback)callback).onListComplete(result);
                                        EuiccConnector.this.onCommandEnd(callback);
                                    });
                                }
                            });
                            break;
                        }
                        case 104: {
                            GetDefaultListRequest request = (GetDefaultListRequest)message.obj;
                            EuiccConnector.this.mEuiccService.getDefaultDownloadableSubscriptionList(slotId, request.mForceDeactivateSim, new IGetDefaultDownloadableSubscriptionListCallback.Stub(){

                                @Override
                                public void onComplete(GetDefaultDownloadableSubscriptionListResult result) {
                                    EuiccConnector.this.sendMessage(6, () -> {
                                        ((GetDefaultListCommandCallback)callback).onGetDefaultListComplete(result);
                                        EuiccConnector.this.onCommandEnd(callback);
                                    });
                                }
                            });
                            break;
                        }
                        case 105: {
                            EuiccConnector.this.mEuiccService.getEuiccInfo(slotId, new IGetEuiccInfoCallback.Stub(){

                                @Override
                                public void onSuccess(EuiccInfo euiccInfo) {
                                    EuiccConnector.this.sendMessage(6, () -> {
                                        ((GetEuiccInfoCommandCallback)callback).onGetEuiccInfoComplete(euiccInfo);
                                        EuiccConnector.this.onCommandEnd(callback);
                                    });
                                }
                            });
                            break;
                        }
                        case 106: {
                            DeleteRequest request = (DeleteRequest)message.obj;
                            EuiccConnector.this.mEuiccService.deleteSubscription(slotId, request.mIccid, new IDeleteSubscriptionCallback.Stub(){

                                @Override
                                public void onComplete(int result) {
                                    EuiccConnector.this.sendMessage(6, () -> {
                                        ((DeleteCommandCallback)callback).onDeleteComplete(result);
                                        EuiccConnector.this.onCommandEnd(callback);
                                    });
                                }
                            });
                            break;
                        }
                        case 107: {
                            SwitchRequest request = (SwitchRequest)message.obj;
                            EuiccConnector.this.mEuiccService.switchToSubscription(slotId, request.mIccid, request.mForceDeactivateSim, new ISwitchToSubscriptionCallback.Stub(){

                                @Override
                                public void onComplete(int result) {
                                    EuiccConnector.this.sendMessage(6, () -> {
                                        ((SwitchCommandCallback)callback).onSwitchComplete(result);
                                        EuiccConnector.this.onCommandEnd(callback);
                                    });
                                }
                            });
                            break;
                        }
                        case 108: {
                            UpdateNicknameRequest request = (UpdateNicknameRequest)message.obj;
                            EuiccConnector.this.mEuiccService.updateSubscriptionNickname(slotId, request.mIccid, request.mNickname, new IUpdateSubscriptionNicknameCallback.Stub(){

                                @Override
                                public void onComplete(int result) {
                                    EuiccConnector.this.sendMessage(6, () -> {
                                        ((UpdateNicknameCommandCallback)callback).onUpdateNicknameComplete(result);
                                        EuiccConnector.this.onCommandEnd(callback);
                                    });
                                }
                            });
                            break;
                        }
                        case 109: {
                            EuiccConnector.this.mEuiccService.eraseSubscriptions(slotId, new IEraseSubscriptionsCallback.Stub(){

                                @Override
                                public void onComplete(int result) {
                                    EuiccConnector.this.sendMessage(6, () -> {
                                        ((EraseCommandCallback)callback).onEraseComplete(result);
                                        EuiccConnector.this.onCommandEnd(callback);
                                    });
                                }
                            });
                            break;
                        }
                        case 110: {
                            EuiccConnector.this.mEuiccService.retainSubscriptionsForFactoryReset(slotId, new IRetainSubscriptionsForFactoryResetCallback.Stub(){

                                @Override
                                public void onComplete(int result) {
                                    EuiccConnector.this.sendMessage(6, () -> {
                                        ((RetainSubscriptionsCommandCallback)callback).onRetainSubscriptionsComplete(result);
                                        EuiccConnector.this.onCommandEnd(callback);
                                    });
                                }
                            });
                            break;
                        }
                        case 111: {
                            EuiccConnector.this.mEuiccService.getOtaStatus(slotId, new IGetOtaStatusCallback.Stub(){

                                @Override
                                public void onSuccess(int status) {
                                    EuiccConnector.this.sendMessage(6, () -> {
                                        ((GetOtaStatusCommandCallback)callback).onGetOtaStatusComplete(status);
                                        EuiccConnector.this.onCommandEnd(callback);
                                    });
                                }
                            });
                            break;
                        }
                        case 112: {
                            EuiccConnector.this.mEuiccService.startOtaIfNecessary(slotId, new IOtaStatusChangedCallback.Stub(){

                                @Override
                                public void onOtaStatusChanged(int status) throws RemoteException {
                                    if (status == 1) {
                                        EuiccConnector.this.sendMessage(6, () -> ((OtaStatusChangedCallback)callback).onOtaStatusChanged(status));
                                    } else {
                                        EuiccConnector.this.sendMessage(6, () -> {
                                            ((OtaStatusChangedCallback)callback).onOtaStatusChanged(status);
                                            EuiccConnector.this.onCommandEnd(callback);
                                        });
                                    }
                                }
                            });
                            break;
                        }
                        default: {
                            Log.wtf(EuiccConnector.TAG, "Unimplemented eUICC command: " + message.what);
                            callback.onEuiccServiceUnavailable();
                            EuiccConnector.this.onCommandEnd(callback);
                            return true;
                        }
                    }
                }
                catch (Exception e) {
                    Log.w(EuiccConnector.TAG, "Exception making binder call to EuiccService", e);
                    callback.onEuiccServiceUnavailable();
                    EuiccConnector.this.onCommandEnd(callback);
                }
                return true;
            }
            return false;
        }

        @Override
        public void exit() {
            EuiccConnector.this.removeMessages(3);
            for (BaseEuiccCommandCallback callback : EuiccConnector.this.mActiveCommandCallbacks) {
                callback.onEuiccServiceUnavailable();
            }
            EuiccConnector.this.mActiveCommandCallbacks.clear();
        }
    }

    private class DisconnectedState
    extends State {
        private DisconnectedState() {
        }

        @Override
        public void enter() {
            EuiccConnector.this.sendMessageDelayed(2, 30000L);
        }

        @Override
        public boolean processMessage(Message message) {
            if (message.what == 4) {
                EuiccConnector.this.mEuiccService = (IEuiccService)message.obj;
                EuiccConnector.this.transitionTo(EuiccConnector.this.mConnectedState);
                return true;
            }
            if (message.what == 1) {
                boolean forceRebind;
                ServiceInfo bestComponent = EuiccConnector.this.findBestComponent();
                String affectedPackage = (String)message.obj;
                boolean isSameComponent = bestComponent == null ? EuiccConnector.this.mSelectedComponent != null : EuiccConnector.this.mSelectedComponent == null || Objects.equals(bestComponent.getComponentName(), EuiccConnector.this.mSelectedComponent.getComponentName());
                boolean bl = forceRebind = bestComponent != null && Objects.equals(bestComponent.packageName, affectedPackage);
                if (!isSameComponent || forceRebind) {
                    EuiccConnector.this.unbind();
                    EuiccConnector.this.mSelectedComponent = bestComponent;
                    if (EuiccConnector.this.mSelectedComponent == null) {
                        EuiccConnector.this.transitionTo(EuiccConnector.this.mUnavailableState);
                    } else {
                        EuiccConnector.this.transitionTo(EuiccConnector.this.mBindingState);
                    }
                }
                return true;
            }
            if (message.what == 2) {
                EuiccConnector.this.transitionTo(EuiccConnector.this.mAvailableState);
                return true;
            }
            if (EuiccConnector.isEuiccCommand(message.what)) {
                EuiccConnector.this.deferMessage(message);
                return true;
            }
            return false;
        }
    }

    private class BindingState
    extends State {
        private BindingState() {
        }

        @Override
        public void enter() {
            if (EuiccConnector.this.createBinding()) {
                EuiccConnector.this.transitionTo(EuiccConnector.this.mDisconnectedState);
            } else {
                EuiccConnector.this.transitionTo(EuiccConnector.this.mAvailableState);
            }
        }

        @Override
        public boolean processMessage(Message message) {
            EuiccConnector.this.deferMessage(message);
            return true;
        }
    }

    private class AvailableState
    extends State {
        private AvailableState() {
        }

        @Override
        public boolean processMessage(Message message) {
            if (EuiccConnector.isEuiccCommand(message.what)) {
                EuiccConnector.this.deferMessage(message);
                EuiccConnector.this.transitionTo(EuiccConnector.this.mBindingState);
                return true;
            }
            return false;
        }
    }

    private class UnavailableState
    extends State {
        private UnavailableState() {
        }

        @Override
        public boolean processMessage(Message message) {
            if (message.what == 1) {
                EuiccConnector.this.mSelectedComponent = EuiccConnector.this.findBestComponent();
                if (EuiccConnector.this.mSelectedComponent != null) {
                    EuiccConnector.this.transitionTo(EuiccConnector.this.mAvailableState);
                } else if (EuiccConnector.this.getCurrentState() != EuiccConnector.this.mUnavailableState) {
                    EuiccConnector.this.transitionTo(EuiccConnector.this.mUnavailableState);
                }
                return true;
            }
            if (EuiccConnector.isEuiccCommand(message.what)) {
                BaseEuiccCommandCallback callback = EuiccConnector.getCallback(message);
                callback.onEuiccServiceUnavailable();
                return true;
            }
            return false;
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface RetainSubscriptionsCommandCallback
    extends BaseEuiccCommandCallback {
        public void onRetainSubscriptionsComplete(int var1);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface EraseCommandCallback
    extends BaseEuiccCommandCallback {
        public void onEraseComplete(int var1);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface UpdateNicknameCommandCallback
    extends BaseEuiccCommandCallback {
        public void onUpdateNicknameComplete(int var1);
    }

    static class UpdateNicknameRequest {
        String mIccid;
        String mNickname;
        UpdateNicknameCommandCallback mCallback;

        UpdateNicknameRequest() {
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface SwitchCommandCallback
    extends BaseEuiccCommandCallback {
        public void onSwitchComplete(int var1);
    }

    static class SwitchRequest {
        String mIccid;
        boolean mForceDeactivateSim;
        SwitchCommandCallback mCallback;

        SwitchRequest() {
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface DeleteCommandCallback
    extends BaseEuiccCommandCallback {
        public void onDeleteComplete(int var1);
    }

    static class DeleteRequest {
        String mIccid;
        DeleteCommandCallback mCallback;

        DeleteRequest() {
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface GetEuiccInfoCommandCallback
    extends BaseEuiccCommandCallback {
        public void onGetEuiccInfoComplete(EuiccInfo var1);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface GetDefaultListCommandCallback
    extends BaseEuiccCommandCallback {
        public void onGetDefaultListComplete(GetDefaultDownloadableSubscriptionListResult var1);
    }

    static class GetDefaultListRequest {
        boolean mForceDeactivateSim;
        GetDefaultListCommandCallback mCallback;

        GetDefaultListRequest() {
        }
    }

    static interface GetEuiccProfileInfoListCommandCallback
    extends BaseEuiccCommandCallback {
        public void onListComplete(GetEuiccProfileInfoListResult var1);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface DownloadCommandCallback
    extends BaseEuiccCommandCallback {
        public void onDownloadComplete(int var1);
    }

    static class DownloadRequest {
        DownloadableSubscription mSubscription;
        boolean mSwitchAfterDownload;
        boolean mForceDeactivateSim;
        DownloadCommandCallback mCallback;

        DownloadRequest() {
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface GetMetadataCommandCallback
    extends BaseEuiccCommandCallback {
        public void onGetMetadataComplete(GetDownloadableSubscriptionMetadataResult var1);
    }

    static class GetMetadataRequest {
        DownloadableSubscription mSubscription;
        boolean mForceDeactivateSim;
        GetMetadataCommandCallback mCallback;

        GetMetadataRequest() {
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface OtaStatusChangedCallback
    extends BaseEuiccCommandCallback {
        public void onOtaStatusChanged(int var1);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface GetOtaStatusCommandCallback
    extends BaseEuiccCommandCallback {
        public void onGetOtaStatusComplete(int var1);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface GetEidCommandCallback
    extends BaseEuiccCommandCallback {
        public void onGetEidComplete(String var1);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface BaseEuiccCommandCallback {
        public void onEuiccServiceUnavailable();
    }
}

