/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.euicc;

import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.ServiceManager;
import android.provider.Settings;
import android.service.euicc.GetDefaultDownloadableSubscriptionListResult;
import android.service.euicc.GetDownloadableSubscriptionMetadataResult;
import android.service.euicc.GetEuiccProfileInfoListResult;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.UiccAccessRule;
import android.telephony.euicc.DownloadableSubscription;
import android.telephony.euicc.EuiccInfo;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.euicc.EuiccConnector;
import com.android.internal.telephony.euicc.EuiccOperation;
import com.android.internal.telephony.euicc.IEuiccController;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public class EuiccController
extends IEuiccController.Stub {
    private static final String TAG = "EuiccController";
    @VisibleForTesting
    static final String EXTRA_OPERATION = "operation";
    private static final int OK = 0;
    private static final int RESOLVABLE_ERROR = 1;
    private static final int ERROR = 2;
    private static EuiccController sInstance;
    private final Context mContext;
    private final EuiccConnector mConnector;
    private final SubscriptionManager mSubscriptionManager;
    private final AppOpsManager mAppOpsManager;
    private final PackageManager mPackageManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EuiccController init(Context context) {
        Class<EuiccController> clazz = EuiccController.class;
        synchronized (EuiccController.class) {
            if (sInstance == null) {
                sInstance = new EuiccController(context);
            } else {
                Log.wtf(TAG, "init() called multiple times! sInstance = " + sInstance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EuiccController get() {
        if (sInstance != null) return sInstance;
        Class<EuiccController> clazz = EuiccController.class;
        synchronized (EuiccController.class) {
            if (sInstance != null) return sInstance;
            throw new IllegalStateException("get() called before init()");
        }
    }

    private EuiccController(Context context) {
        this(context, new EuiccConnector(context));
        ServiceManager.addService("econtroller", this);
    }

    @VisibleForTesting
    public EuiccController(Context context, EuiccConnector connector) {
        this.mContext = context;
        this.mConnector = connector;
        this.mSubscriptionManager = (SubscriptionManager)context.getSystemService("telephony_subscription_service");
        this.mAppOpsManager = (AppOpsManager)context.getSystemService("appops");
        this.mPackageManager = context.getPackageManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void continueOperation(Intent resolutionIntent, Bundle resolutionExtras) {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to continue operation");
        }
        long token = Binder.clearCallingIdentity();
        try {
            EuiccOperation op = (EuiccOperation)resolutionIntent.getParcelableExtra(EXTRA_OPERATION);
            if (op == null) {
                throw new IllegalArgumentException("Invalid resolution intent");
            }
            PendingIntent callbackIntent = (PendingIntent)resolutionIntent.getParcelableExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_RESOLUTION_CALLBACK_INTENT");
            op.continueOperation(resolutionExtras, callbackIntent);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEid() {
        if (!this.callerCanReadPhoneStatePrivileged() && !this.callerHasCarrierPrivilegesForActiveSubscription()) {
            throw new SecurityException("Must have carrier privileges on active subscription to read EID");
        }
        long token = Binder.clearCallingIdentity();
        try {
            String string2 = this.blockingGetEidFromEuiccService();
            return string2;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOtaStatus() {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to get OTA status");
        }
        long token = Binder.clearCallingIdentity();
        try {
            int n = this.blockingGetOtaStatusFromEuiccService();
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    public void startOtaUpdatingIfNecessary() {
        this.mConnector.startOtaIfNecessary(new EuiccConnector.OtaStatusChangedCallback(){

            @Override
            public void onOtaStatusChanged(int status) {
                EuiccController.this.sendOtaStatusChangedBroadcast();
            }

            @Override
            public void onEuiccServiceUnavailable() {
            }
        });
    }

    @Override
    public void getDownloadableSubscriptionMetadata(DownloadableSubscription subscription, String callingPackage, PendingIntent callbackIntent) {
        this.getDownloadableSubscriptionMetadata(subscription, false, callingPackage, callbackIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getDownloadableSubscriptionMetadata(DownloadableSubscription subscription, boolean forceDeactivateSim, String callingPackage, PendingIntent callbackIntent) {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to get metadata");
        }
        this.mAppOpsManager.checkPackage(Binder.getCallingUid(), callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            this.mConnector.getDownloadableSubscriptionMetadata(subscription, forceDeactivateSim, new GetMetadataCommandCallback(token, subscription, callingPackage, callbackIntent));
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    public void downloadSubscription(DownloadableSubscription subscription, boolean switchAfterDownload, String callingPackage, PendingIntent callbackIntent) {
        this.downloadSubscription(subscription, switchAfterDownload, callingPackage, false, callbackIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void downloadSubscription(DownloadableSubscription subscription, boolean switchAfterDownload, String callingPackage, boolean forceDeactivateSim, PendingIntent callbackIntent) {
        boolean callerCanWriteEmbeddedSubscriptions = this.callerCanWriteEmbeddedSubscriptions();
        this.mAppOpsManager.checkPackage(Binder.getCallingUid(), callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            if (callerCanWriteEmbeddedSubscriptions) {
                this.downloadSubscriptionPrivileged(token, subscription, switchAfterDownload, forceDeactivateSim, callingPackage, callbackIntent);
                return;
            }
            this.mConnector.getDownloadableSubscriptionMetadata(subscription, forceDeactivateSim, new DownloadSubscriptionGetMetadataCommandCallback(token, subscription, switchAfterDownload, callingPackage, forceDeactivateSim, callbackIntent));
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    void downloadSubscriptionPrivileged(final long callingToken, final DownloadableSubscription subscription, final boolean switchAfterDownload, boolean forceDeactivateSim, final String callingPackage, final PendingIntent callbackIntent) {
        this.mConnector.downloadSubscription(subscription, switchAfterDownload, forceDeactivateSim, new EuiccConnector.DownloadCommandCallback(){

            @Override
            public void onDownloadComplete(int result) {
                int resultCode;
                Intent extrasIntent = new Intent();
                switch (result) {
                    case 0: {
                        resultCode = 0;
                        Settings.Global.putInt(EuiccController.this.mContext.getContentResolver(), "euicc_provisioned", 1);
                        if (switchAfterDownload) break;
                        EuiccController.this.refreshSubscriptionsAndSendResult(callbackIntent, resultCode, extrasIntent);
                        return;
                    }
                    case -1: {
                        resultCode = 1;
                        EuiccController.this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_DEACTIVATE_SIM", callingPackage, false, EuiccOperation.forDownloadDeactivateSim(callingToken, subscription, switchAfterDownload, callingPackage));
                        break;
                    }
                    case -2: {
                        resultCode = 1;
                        boolean retried = false;
                        if (!TextUtils.isEmpty(subscription.getConfirmationCode())) {
                            retried = true;
                        }
                        EuiccController.this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_CONFIRMATION_CODE", callingPackage, retried, EuiccOperation.forDownloadConfirmationCode(callingToken, subscription, switchAfterDownload, callingPackage));
                        break;
                    }
                    default: {
                        resultCode = 2;
                        extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                    }
                }
                EuiccController.this.sendResult(callbackIntent, resultCode, extrasIntent);
            }

            @Override
            public void onEuiccServiceUnavailable() {
                EuiccController.this.sendResult(callbackIntent, 2, null);
            }
        });
    }

    public GetEuiccProfileInfoListResult blockingGetEuiccProfileInfoList() {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference resultRef = new AtomicReference();
        this.mConnector.getEuiccProfileInfoList(new EuiccConnector.GetEuiccProfileInfoListCommandCallback(){

            @Override
            public void onListComplete(GetEuiccProfileInfoListResult result) {
                resultRef.set(result);
                latch.countDown();
            }

            @Override
            public void onEuiccServiceUnavailable() {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return (GetEuiccProfileInfoListResult)resultRef.get();
    }

    @Override
    public void getDefaultDownloadableSubscriptionList(String callingPackage, PendingIntent callbackIntent) {
        this.getDefaultDownloadableSubscriptionList(false, callingPackage, callbackIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getDefaultDownloadableSubscriptionList(boolean forceDeactivateSim, String callingPackage, PendingIntent callbackIntent) {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to get default list");
        }
        this.mAppOpsManager.checkPackage(Binder.getCallingUid(), callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            this.mConnector.getDefaultDownloadableSubscriptionList(forceDeactivateSim, new GetDefaultListCommandCallback(token, callingPackage, callbackIntent));
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EuiccInfo getEuiccInfo() {
        long token = Binder.clearCallingIdentity();
        try {
            EuiccInfo euiccInfo = this.blockingGetEuiccInfoFromEuiccService();
            return euiccInfo;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSubscription(int subscriptionId, String callingPackage, PendingIntent callbackIntent) {
        boolean callerCanWriteEmbeddedSubscriptions = this.callerCanWriteEmbeddedSubscriptions();
        this.mAppOpsManager.checkPackage(Binder.getCallingUid(), callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            SubscriptionInfo sub = this.getSubscriptionForSubscriptionId(subscriptionId);
            if (sub == null) {
                Log.e(TAG, "Cannot delete nonexistent subscription: " + subscriptionId);
                this.sendResult(callbackIntent, 2, null);
                return;
            }
            if (!callerCanWriteEmbeddedSubscriptions && !sub.canManageSubscription(this.mContext, callingPackage)) {
                Log.e(TAG, "No permissions: " + subscriptionId);
                this.sendResult(callbackIntent, 2, null);
                return;
            }
            this.deleteSubscriptionPrivileged(sub.getIccId(), callbackIntent);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    void deleteSubscriptionPrivileged(String iccid, final PendingIntent callbackIntent) {
        this.mConnector.deleteSubscription(iccid, new EuiccConnector.DeleteCommandCallback(){

            @Override
            public void onDeleteComplete(int result) {
                Intent extrasIntent = new Intent();
                switch (result) {
                    case 0: {
                        int resultCode = 0;
                        EuiccController.this.refreshSubscriptionsAndSendResult(callbackIntent, resultCode, extrasIntent);
                        return;
                    }
                }
                int resultCode = 2;
                extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                EuiccController.this.sendResult(callbackIntent, resultCode, extrasIntent);
            }

            @Override
            public void onEuiccServiceUnavailable() {
                EuiccController.this.sendResult(callbackIntent, 2, null);
            }
        });
    }

    @Override
    public void switchToSubscription(int subscriptionId, String callingPackage, PendingIntent callbackIntent) {
        this.switchToSubscription(subscriptionId, false, callingPackage, callbackIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchToSubscription(int subscriptionId, boolean forceDeactivateSim, String callingPackage, PendingIntent callbackIntent) {
        boolean callerCanWriteEmbeddedSubscriptions = this.callerCanWriteEmbeddedSubscriptions();
        this.mAppOpsManager.checkPackage(Binder.getCallingUid(), callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            String iccid;
            if (callerCanWriteEmbeddedSubscriptions) {
                forceDeactivateSim = true;
            }
            if (subscriptionId == -1) {
                if (!callerCanWriteEmbeddedSubscriptions) {
                    Log.e(TAG, "Not permitted to switch to empty subscription");
                    this.sendResult(callbackIntent, 2, null);
                    return;
                }
                iccid = null;
            } else {
                SubscriptionInfo sub = this.getSubscriptionForSubscriptionId(subscriptionId);
                if (sub == null) {
                    Log.e(TAG, "Cannot switch to nonexistent subscription: " + subscriptionId);
                    this.sendResult(callbackIntent, 2, null);
                    return;
                }
                if (!callerCanWriteEmbeddedSubscriptions && !sub.canManageSubscription(this.mContext, callingPackage)) {
                    Log.e(TAG, "Not permitted to switch to subscription: " + subscriptionId);
                    this.sendResult(callbackIntent, 2, null);
                    return;
                }
                iccid = sub.getIccId();
            }
            if (!callerCanWriteEmbeddedSubscriptions && !this.canManageActiveSubscription(callingPackage)) {
                Intent extrasIntent = new Intent();
                this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_NO_PRIVILEGES", callingPackage, false, EuiccOperation.forSwitchNoPrivileges(token, subscriptionId, callingPackage));
                this.sendResult(callbackIntent, 1, extrasIntent);
                return;
            }
            this.switchToSubscriptionPrivileged(token, subscriptionId, iccid, forceDeactivateSim, callingPackage, callbackIntent);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    void switchToSubscriptionPrivileged(long callingToken, int subscriptionId, boolean forceDeactivateSim, String callingPackage, PendingIntent callbackIntent) {
        String iccid = null;
        SubscriptionInfo sub = this.getSubscriptionForSubscriptionId(subscriptionId);
        if (sub != null) {
            iccid = sub.getIccId();
        }
        this.switchToSubscriptionPrivileged(callingToken, subscriptionId, iccid, forceDeactivateSim, callingPackage, callbackIntent);
    }

    void switchToSubscriptionPrivileged(final long callingToken, final int subscriptionId, String iccid, boolean forceDeactivateSim, final String callingPackage, final PendingIntent callbackIntent) {
        this.mConnector.switchToSubscription(iccid, forceDeactivateSim, new EuiccConnector.SwitchCommandCallback(){

            @Override
            public void onSwitchComplete(int result) {
                int resultCode;
                Intent extrasIntent = new Intent();
                switch (result) {
                    case 0: {
                        resultCode = 0;
                        break;
                    }
                    case -1: {
                        resultCode = 1;
                        EuiccController.this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_DEACTIVATE_SIM", callingPackage, false, EuiccOperation.forSwitchDeactivateSim(callingToken, subscriptionId, callingPackage));
                        break;
                    }
                    default: {
                        resultCode = 2;
                        extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                    }
                }
                EuiccController.this.sendResult(callbackIntent, resultCode, extrasIntent);
            }

            @Override
            public void onEuiccServiceUnavailable() {
                EuiccController.this.sendResult(callbackIntent, 2, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSubscriptionNickname(int subscriptionId, String nickname, final PendingIntent callbackIntent) {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to update nickname");
        }
        long token = Binder.clearCallingIdentity();
        try {
            SubscriptionInfo sub = this.getSubscriptionForSubscriptionId(subscriptionId);
            if (sub == null) {
                Log.e(TAG, "Cannot update nickname to nonexistent subscription: " + subscriptionId);
                this.sendResult(callbackIntent, 2, null);
                return;
            }
            this.mConnector.updateSubscriptionNickname(sub.getIccId(), nickname, new EuiccConnector.UpdateNicknameCommandCallback(){

                @Override
                public void onUpdateNicknameComplete(int result) {
                    int resultCode;
                    Intent extrasIntent = new Intent();
                    switch (result) {
                        case 0: {
                            resultCode = 0;
                            break;
                        }
                        default: {
                            resultCode = 2;
                            extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                        }
                    }
                    EuiccController.this.sendResult(callbackIntent, resultCode, extrasIntent);
                }

                @Override
                public void onEuiccServiceUnavailable() {
                    EuiccController.this.sendResult(callbackIntent, 2, null);
                }
            });
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eraseSubscriptions(final PendingIntent callbackIntent) {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to erase subscriptions");
        }
        long token = Binder.clearCallingIdentity();
        try {
            this.mConnector.eraseSubscriptions(new EuiccConnector.EraseCommandCallback(){

                @Override
                public void onEraseComplete(int result) {
                    Intent extrasIntent = new Intent();
                    switch (result) {
                        case 0: {
                            int resultCode = 0;
                            EuiccController.this.refreshSubscriptionsAndSendResult(callbackIntent, resultCode, extrasIntent);
                            return;
                        }
                    }
                    int resultCode = 2;
                    extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                    EuiccController.this.sendResult(callbackIntent, resultCode, extrasIntent);
                }

                @Override
                public void onEuiccServiceUnavailable() {
                    EuiccController.this.sendResult(callbackIntent, 2, null);
                }
            });
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retainSubscriptionsForFactoryReset(final PendingIntent callbackIntent) {
        this.mContext.enforceCallingPermission("android.permission.MASTER_CLEAR", "Must have MASTER_CLEAR to retain subscriptions for factory reset");
        long token = Binder.clearCallingIdentity();
        try {
            this.mConnector.retainSubscriptions(new EuiccConnector.RetainSubscriptionsCommandCallback(){

                @Override
                public void onRetainSubscriptionsComplete(int result) {
                    int resultCode;
                    Intent extrasIntent = new Intent();
                    switch (result) {
                        case 0: {
                            resultCode = 0;
                            break;
                        }
                        default: {
                            resultCode = 2;
                            extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                        }
                    }
                    EuiccController.this.sendResult(callbackIntent, resultCode, extrasIntent);
                }

                @Override
                public void onEuiccServiceUnavailable() {
                    EuiccController.this.sendResult(callbackIntent, 2, null);
                }
            });
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void refreshSubscriptionsAndSendResult(PendingIntent callbackIntent, int resultCode, Intent extrasIntent) {
        SubscriptionController.getInstance().requestEmbeddedSubscriptionInfoListRefresh(() -> this.sendResult(callbackIntent, resultCode, extrasIntent));
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void sendResult(PendingIntent callbackIntent, int resultCode, Intent extrasIntent) {
        try {
            callbackIntent.send(this.mContext, resultCode, extrasIntent);
        }
        catch (PendingIntent.CanceledException canceledException) {
            // empty catch block
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void addResolutionIntent(Intent extrasIntent, String resolutionAction, String callingPackage, boolean confirmationCodeRetried, EuiccOperation op) {
        Intent intent = new Intent("android.telephony.euicc.action.RESOLVE_ERROR");
        intent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_RESOLUTION_ACTION", resolutionAction);
        intent.putExtra("android.service.euicc.extra.RESOLUTION_CALLING_PACKAGE", callingPackage);
        intent.putExtra("android.service.euicc.extra.RESOLUTION_CONFIRMATION_CODE_RETRIED", confirmationCodeRetried);
        intent.putExtra(EXTRA_OPERATION, op);
        PendingIntent resolutionIntent = PendingIntent.getActivity(this.mContext, 0, intent, 0x40000000);
        extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_RESOLUTION_INTENT", resolutionIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "Requires DUMP");
        long token = Binder.clearCallingIdentity();
        try {
            this.mConnector.dump(fd, pw, args);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void sendOtaStatusChangedBroadcast() {
        Intent intent = new Intent("android.telephony.euicc.action.OTA_STATUS_CHANGED");
        this.mContext.sendBroadcast(intent, "com.android.permission.WRITE_EMBEDDED_SUBSCRIPTIONS");
    }

    private SubscriptionInfo getSubscriptionForSubscriptionId(int subscriptionId) {
        List<SubscriptionInfo> subs = this.mSubscriptionManager.getAvailableSubscriptionInfoList();
        int subCount = subs.size();
        for (int i = 0; i < subCount; ++i) {
            SubscriptionInfo sub = subs.get(i);
            if (subscriptionId != sub.getSubscriptionId()) continue;
            return sub;
        }
        return null;
    }

    private String blockingGetEidFromEuiccService() {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference eidRef = new AtomicReference();
        this.mConnector.getEid(new EuiccConnector.GetEidCommandCallback(){

            @Override
            public void onGetEidComplete(String eid) {
                eidRef.set(eid);
                latch.countDown();
            }

            @Override
            public void onEuiccServiceUnavailable() {
                latch.countDown();
            }
        });
        return (String)EuiccController.awaitResult(latch, eidRef);
    }

    private int blockingGetOtaStatusFromEuiccService() {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference<Integer> statusRef = new AtomicReference<Integer>(5);
        this.mConnector.getOtaStatus(new EuiccConnector.GetOtaStatusCommandCallback(){

            @Override
            public void onGetOtaStatusComplete(int status) {
                statusRef.set(status);
                latch.countDown();
            }

            @Override
            public void onEuiccServiceUnavailable() {
                latch.countDown();
            }
        });
        return EuiccController.awaitResult(latch, statusRef);
    }

    private EuiccInfo blockingGetEuiccInfoFromEuiccService() {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference euiccInfoRef = new AtomicReference();
        this.mConnector.getEuiccInfo(new EuiccConnector.GetEuiccInfoCommandCallback(){

            @Override
            public void onGetEuiccInfoComplete(EuiccInfo euiccInfo) {
                euiccInfoRef.set(euiccInfo);
                latch.countDown();
            }

            @Override
            public void onEuiccServiceUnavailable() {
                latch.countDown();
            }
        });
        return (EuiccInfo)EuiccController.awaitResult(latch, euiccInfoRef);
    }

    private static <T> T awaitResult(CountDownLatch latch, AtomicReference<T> resultRef) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return resultRef.get();
    }

    private boolean canManageActiveSubscription(String callingPackage) {
        List<SubscriptionInfo> subInfoList = this.mSubscriptionManager.getActiveSubscriptionInfoList();
        if (subInfoList == null) {
            return false;
        }
        int size = subInfoList.size();
        for (int subIndex = 0; subIndex < size; ++subIndex) {
            SubscriptionInfo subInfo = subInfoList.get(subIndex);
            if (!subInfo.isEmbedded() || !subInfo.canManageSubscription(this.mContext, callingPackage)) continue;
            return true;
        }
        return false;
    }

    private boolean callerCanReadPhoneStatePrivileged() {
        return this.mContext.checkCallingPermission("android.permission.READ_PRIVILEGED_PHONE_STATE") == 0;
    }

    private boolean callerCanWriteEmbeddedSubscriptions() {
        return this.mContext.checkCallingPermission("com.android.permission.WRITE_EMBEDDED_SUBSCRIPTIONS") == 0;
    }

    private boolean callerHasCarrierPrivilegesForActiveSubscription() {
        TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
        return tm.hasCarrierPrivileges();
    }

    class GetDefaultListCommandCallback
    implements EuiccConnector.GetDefaultListCommandCallback {
        final long mCallingToken;
        final String mCallingPackage;
        final PendingIntent mCallbackIntent;

        GetDefaultListCommandCallback(long callingToken, String callingPackage, PendingIntent callbackIntent) {
            this.mCallingToken = callingToken;
            this.mCallingPackage = callingPackage;
            this.mCallbackIntent = callbackIntent;
        }

        @Override
        public void onGetDefaultListComplete(GetDefaultDownloadableSubscriptionListResult result) {
            int resultCode;
            Intent extrasIntent = new Intent();
            switch (result.result) {
                case 0: {
                    resultCode = 0;
                    extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DOWNLOADABLE_SUBSCRIPTIONS", result.subscriptions);
                    break;
                }
                case -1: {
                    resultCode = 1;
                    EuiccController.this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_DEACTIVATE_SIM", this.mCallingPackage, false, EuiccOperation.forGetDefaultListDeactivateSim(this.mCallingToken, this.mCallingPackage));
                    break;
                }
                default: {
                    resultCode = 2;
                    extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result.result);
                }
            }
            EuiccController.this.sendResult(this.mCallbackIntent, resultCode, extrasIntent);
        }

        @Override
        public void onEuiccServiceUnavailable() {
            EuiccController.this.sendResult(this.mCallbackIntent, 2, null);
        }
    }

    class DownloadSubscriptionGetMetadataCommandCallback
    extends GetMetadataCommandCallback {
        private final boolean mSwitchAfterDownload;
        private final boolean mForceDeactivateSim;

        DownloadSubscriptionGetMetadataCommandCallback(long callingToken, DownloadableSubscription subscription, boolean switchAfterDownload, String callingPackage, boolean forceDeactivateSim, PendingIntent callbackIntent) {
            super(callingToken, subscription, callingPackage, callbackIntent);
            this.mSwitchAfterDownload = switchAfterDownload;
            this.mForceDeactivateSim = forceDeactivateSim;
        }

        @Override
        public void onGetMetadataComplete(GetDownloadableSubscriptionMetadataResult result) {
            PackageInfo info;
            if (result.result == -1) {
                Intent extrasIntent = new Intent();
                EuiccController.this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_NO_PRIVILEGES", this.mCallingPackage, false, EuiccOperation.forDownloadNoPrivileges(this.mCallingToken, this.mSubscription, this.mSwitchAfterDownload, this.mCallingPackage));
                EuiccController.this.sendResult(this.mCallbackIntent, 1, extrasIntent);
                return;
            }
            if (result.result != 0) {
                super.onGetMetadataComplete(result);
                return;
            }
            DownloadableSubscription subscription = result.subscription;
            UiccAccessRule[] rules = subscription.getAccessRules();
            if (rules == null) {
                Log.e(EuiccController.TAG, "No access rules but caller is unprivileged");
                EuiccController.this.sendResult(this.mCallbackIntent, 2, null);
                return;
            }
            try {
                info = EuiccController.this.mPackageManager.getPackageInfo(this.mCallingPackage, 64);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(EuiccController.TAG, "Calling package valid but gone");
                EuiccController.this.sendResult(this.mCallbackIntent, 2, null);
                return;
            }
            for (int i = 0; i < rules.length; ++i) {
                if (rules[i].getCarrierPrivilegeStatus(info) != 1) continue;
                if (EuiccController.this.canManageActiveSubscription(this.mCallingPackage)) {
                    EuiccController.this.downloadSubscriptionPrivileged(this.mCallingToken, subscription, this.mSwitchAfterDownload, this.mForceDeactivateSim, this.mCallingPackage, this.mCallbackIntent);
                    return;
                }
                Intent extrasIntent = new Intent();
                EuiccController.this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_NO_PRIVILEGES", this.mCallingPackage, false, EuiccOperation.forDownloadNoPrivileges(this.mCallingToken, subscription, this.mSwitchAfterDownload, this.mCallingPackage));
                EuiccController.this.sendResult(this.mCallbackIntent, 1, extrasIntent);
                return;
            }
            Log.e(EuiccController.TAG, "Caller is not permitted to download this profile");
            EuiccController.this.sendResult(this.mCallbackIntent, 2, null);
        }

        @Override
        protected EuiccOperation getOperationForDeactivateSim() {
            return EuiccOperation.forDownloadDeactivateSim(this.mCallingToken, this.mSubscription, this.mSwitchAfterDownload, this.mCallingPackage);
        }
    }

    class GetMetadataCommandCallback
    implements EuiccConnector.GetMetadataCommandCallback {
        protected final long mCallingToken;
        protected final DownloadableSubscription mSubscription;
        protected final String mCallingPackage;
        protected final PendingIntent mCallbackIntent;

        GetMetadataCommandCallback(long callingToken, DownloadableSubscription subscription, String callingPackage, PendingIntent callbackIntent) {
            this.mCallingToken = callingToken;
            this.mSubscription = subscription;
            this.mCallingPackage = callingPackage;
            this.mCallbackIntent = callbackIntent;
        }

        @Override
        public void onGetMetadataComplete(GetDownloadableSubscriptionMetadataResult result) {
            int resultCode;
            Intent extrasIntent = new Intent();
            switch (result.result) {
                case 0: {
                    resultCode = 0;
                    extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DOWNLOADABLE_SUBSCRIPTION", result.subscription);
                    break;
                }
                case -1: {
                    resultCode = 1;
                    EuiccController.this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_DEACTIVATE_SIM", this.mCallingPackage, false, this.getOperationForDeactivateSim());
                    break;
                }
                default: {
                    resultCode = 2;
                    extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result.result);
                }
            }
            EuiccController.this.sendResult(this.mCallbackIntent, resultCode, extrasIntent);
        }

        @Override
        public void onEuiccServiceUnavailable() {
            EuiccController.this.sendResult(this.mCallbackIntent, 2, null);
        }

        protected EuiccOperation getOperationForDeactivateSim() {
            return EuiccOperation.forGetMetadataDeactivateSim(this.mCallingToken, this.mSubscription, this.mCallingPackage);
        }
    }
}

