/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.telephony.SmsCbCmasInfo;
import android.telephony.SmsCbEtwsInfo;
import java.util.Arrays;

public class SmsCbHeader {
    static final int PDU_HEADER_LENGTH = 6;
    static final int FORMAT_GSM = 1;
    static final int FORMAT_UMTS = 2;
    static final int FORMAT_ETWS_PRIMARY = 3;
    private static final int MESSAGE_TYPE_CBS_MESSAGE = 1;
    private static final int PDU_LENGTH_GSM = 88;
    private static final int PDU_LENGTH_ETWS = 56;
    private final int mGeographicalScope;
    private final int mSerialNumber;
    private final int mMessageIdentifier;
    private final int mDataCodingScheme;
    private final int mPageIndex;
    private final int mNrOfPages;
    private final int mFormat;
    private final SmsCbEtwsInfo mEtwsInfo;
    private final SmsCbCmasInfo mCmasInfo;

    public SmsCbHeader(byte[] pdu) throws IllegalArgumentException {
        if (pdu == null || pdu.length < 6) {
            throw new IllegalArgumentException("Illegal PDU");
        }
        if (pdu.length <= 88) {
            this.mGeographicalScope = (pdu[0] & 0xC0) >>> 6;
            this.mSerialNumber = (pdu[0] & 0xFF) << 8 | pdu[1] & 0xFF;
            this.mMessageIdentifier = (pdu[2] & 0xFF) << 8 | pdu[3] & 0xFF;
            if (this.isEtwsMessage() && pdu.length <= 56) {
                this.mFormat = 3;
                this.mDataCodingScheme = -1;
                this.mPageIndex = -1;
                this.mNrOfPages = -1;
                boolean emergencyUserAlert = (pdu[4] & 1) != 0;
                boolean activatePopup = (pdu[5] & 0x80) != 0;
                int warningType = (pdu[4] & 0xFE) >>> 1;
                byte[] warningSecurityInfo = pdu.length > 6 ? Arrays.copyOfRange(pdu, 6, pdu.length) : null;
                this.mEtwsInfo = new SmsCbEtwsInfo(warningType, emergencyUserAlert, activatePopup, true, warningSecurityInfo);
                this.mCmasInfo = null;
                return;
            }
            this.mFormat = 1;
            this.mDataCodingScheme = pdu[4] & 0xFF;
            int pageIndex = (pdu[5] & 0xF0) >>> 4;
            int nrOfPages = pdu[5] & 0xF;
            if (pageIndex == 0 || nrOfPages == 0 || pageIndex > nrOfPages) {
                pageIndex = 1;
                nrOfPages = 1;
            }
            this.mPageIndex = pageIndex;
            this.mNrOfPages = nrOfPages;
        } else {
            this.mFormat = 2;
            byte messageType = pdu[0];
            if (messageType != 1) {
                throw new IllegalArgumentException("Unsupported message type " + messageType);
            }
            this.mMessageIdentifier = (pdu[1] & 0xFF) << 8 | pdu[2] & 0xFF;
            this.mGeographicalScope = (pdu[3] & 0xC0) >>> 6;
            this.mSerialNumber = (pdu[3] & 0xFF) << 8 | pdu[4] & 0xFF;
            this.mDataCodingScheme = pdu[5] & 0xFF;
            this.mPageIndex = 1;
            this.mNrOfPages = 1;
        }
        if (this.isEtwsMessage()) {
            boolean emergencyUserAlert = this.isEtwsEmergencyUserAlert();
            boolean activatePopup = this.isEtwsPopupAlert();
            int warningType = this.getEtwsWarningType();
            this.mEtwsInfo = new SmsCbEtwsInfo(warningType, emergencyUserAlert, activatePopup, false, null);
            this.mCmasInfo = null;
        } else if (this.isCmasMessage()) {
            int messageClass = this.getCmasMessageClass();
            int severity = this.getCmasSeverity();
            int urgency = this.getCmasUrgency();
            int certainty = this.getCmasCertainty();
            this.mEtwsInfo = null;
            this.mCmasInfo = new SmsCbCmasInfo(messageClass, -1, -1, severity, urgency, certainty);
        } else {
            this.mEtwsInfo = null;
            this.mCmasInfo = null;
        }
    }

    int getGeographicalScope() {
        return this.mGeographicalScope;
    }

    int getSerialNumber() {
        return this.mSerialNumber;
    }

    int getServiceCategory() {
        return this.mMessageIdentifier;
    }

    int getDataCodingScheme() {
        return this.mDataCodingScheme;
    }

    int getPageIndex() {
        return this.mPageIndex;
    }

    int getNumberOfPages() {
        return this.mNrOfPages;
    }

    SmsCbEtwsInfo getEtwsInfo() {
        return this.mEtwsInfo;
    }

    SmsCbCmasInfo getCmasInfo() {
        return this.mCmasInfo;
    }

    boolean isEmergencyMessage() {
        return this.mMessageIdentifier >= 4352 && this.mMessageIdentifier <= 6399;
    }

    private boolean isEtwsMessage() {
        return (this.mMessageIdentifier & 0xFFF8) == 4352;
    }

    boolean isEtwsPrimaryNotification() {
        return this.mFormat == 3;
    }

    boolean isUmtsFormat() {
        return this.mFormat == 2;
    }

    private boolean isCmasMessage() {
        return this.mMessageIdentifier >= 4370 && this.mMessageIdentifier <= 4399;
    }

    private boolean isEtwsPopupAlert() {
        return (this.mSerialNumber & 0x1000) != 0;
    }

    private boolean isEtwsEmergencyUserAlert() {
        return (this.mSerialNumber & 0x2000) != 0;
    }

    private int getEtwsWarningType() {
        return this.mMessageIdentifier - 4352;
    }

    private int getCmasMessageClass() {
        switch (this.mMessageIdentifier) {
            case 4370: 
            case 4383: {
                return 0;
            }
            case 4371: 
            case 4372: 
            case 4384: 
            case 4385: {
                return 1;
            }
            case 4373: 
            case 4374: 
            case 4375: 
            case 4376: 
            case 4377: 
            case 4378: 
            case 4386: 
            case 4387: 
            case 4388: 
            case 4389: 
            case 4390: 
            case 4391: {
                return 2;
            }
            case 4379: 
            case 4392: {
                return 3;
            }
            case 4380: 
            case 4393: {
                return 4;
            }
            case 4381: 
            case 4394: {
                return 5;
            }
            case 4382: 
            case 4395: {
                return 6;
            }
        }
        return -1;
    }

    private int getCmasSeverity() {
        switch (this.mMessageIdentifier) {
            case 4371: 
            case 4372: 
            case 4373: 
            case 4374: 
            case 4384: 
            case 4385: 
            case 4386: 
            case 4387: {
                return 0;
            }
            case 4375: 
            case 4376: 
            case 4377: 
            case 4378: 
            case 4388: 
            case 4389: 
            case 4390: 
            case 4391: {
                return 1;
            }
        }
        return -1;
    }

    private int getCmasUrgency() {
        switch (this.mMessageIdentifier) {
            case 4371: 
            case 4372: 
            case 4375: 
            case 4376: 
            case 4384: 
            case 4385: 
            case 4388: 
            case 4389: {
                return 0;
            }
            case 4373: 
            case 4374: 
            case 4377: 
            case 4378: 
            case 4386: 
            case 4387: 
            case 4390: 
            case 4391: {
                return 1;
            }
        }
        return -1;
    }

    private int getCmasCertainty() {
        switch (this.mMessageIdentifier) {
            case 4371: 
            case 4373: 
            case 4375: 
            case 4377: 
            case 4384: 
            case 4386: 
            case 4388: 
            case 4390: {
                return 0;
            }
            case 4372: 
            case 4374: 
            case 4376: 
            case 4378: 
            case 4385: 
            case 4387: 
            case 4389: 
            case 4391: {
                return 1;
            }
        }
        return -1;
    }

    public String toString() {
        return "SmsCbHeader{GS=" + this.mGeographicalScope + ", serialNumber=0x" + Integer.toHexString(this.mSerialNumber) + ", messageIdentifier=0x" + Integer.toHexString(this.mMessageIdentifier) + ", format=" + this.mFormat + ", DCS=0x" + Integer.toHexString(this.mDataCodingScheme) + ", page " + this.mPageIndex + " of " + this.mNrOfPages + '}';
    }
}

