/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.net.Uri;
import android.os.RemoteException;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.stub.ImsRegistrationImplBase;
import android.util.ArrayMap;
import com.android.ims.internal.IImsRegistrationListener;
import java.util.Map;

public class ImsRegistrationCompatAdapter
extends ImsRegistrationImplBase {
    private static final Map<Integer, Integer> RADIO_TECH_MAPPER = new ArrayMap<Integer, Integer>(2);
    private final IImsRegistrationListener mListener = new IImsRegistrationListener.Stub(){

        @Override
        public void registrationConnected() throws RemoteException {
            ImsRegistrationCompatAdapter.this.onRegistered(-1);
        }

        @Override
        public void registrationProgressing() throws RemoteException {
            ImsRegistrationCompatAdapter.this.onRegistering(-1);
        }

        @Override
        public void registrationConnectedWithRadioTech(int imsRadioTech) throws RemoteException {
            ImsRegistrationCompatAdapter.this.onRegistered(RADIO_TECH_MAPPER.getOrDefault(imsRadioTech, -1));
        }

        @Override
        public void registrationProgressingWithRadioTech(int imsRadioTech) throws RemoteException {
            ImsRegistrationCompatAdapter.this.onRegistering(RADIO_TECH_MAPPER.getOrDefault(imsRadioTech, -1));
        }

        @Override
        public void registrationDisconnected(ImsReasonInfo imsReasonInfo) throws RemoteException {
            ImsRegistrationCompatAdapter.this.onDeregistered(imsReasonInfo);
        }

        @Override
        public void registrationResumed() throws RemoteException {
        }

        @Override
        public void registrationSuspended() throws RemoteException {
        }

        @Override
        public void registrationServiceCapabilityChanged(int serviceClass, int event) throws RemoteException {
        }

        @Override
        public void registrationFeatureCapabilityChanged(int serviceClass, int[] enabledFeatures, int[] disabledFeatures) throws RemoteException {
        }

        @Override
        public void voiceMessageCountUpdate(int count) throws RemoteException {
        }

        @Override
        public void registrationAssociatedUriChanged(Uri[] uris) throws RemoteException {
            ImsRegistrationCompatAdapter.this.onSubscriberAssociatedUriChanged(uris);
        }

        @Override
        public void registrationChangeFailed(int targetAccessTech, ImsReasonInfo imsReasonInfo) throws RemoteException {
            ImsRegistrationCompatAdapter.this.onTechnologyChangeFailed(RADIO_TECH_MAPPER.getOrDefault(targetAccessTech, -1), imsReasonInfo);
        }
    };

    public IImsRegistrationListener getRegistrationListener() {
        return this.mListener;
    }

    static {
        RADIO_TECH_MAPPER.put(14, 0);
        RADIO_TECH_MAPPER.put(18, 1);
    }
}

