/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.os.UserHandle;
import android.telephony.CarrierConfigManager;
import android.telephony.SubscriptionManager;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsMmTelFeature;
import android.telephony.ims.aidl.IImsRcsFeature;
import android.telephony.ims.aidl.IImsRegistration;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import com.android.ims.internal.IImsServiceFeatureCallback;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.ims.ImsServiceController;
import com.android.internal.telephony.ims.ImsServiceControllerCompat;
import com.android.internal.telephony.ims.ImsServiceControllerStaticCompat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ImsResolver
implements ImsServiceController.ImsServiceControllerCallbacks {
    private static final String TAG = "ImsResolver";
    public static final String METADATA_EMERGENCY_MMTEL_FEATURE = "android.telephony.ims.EMERGENCY_MMTEL_FEATURE";
    public static final String METADATA_MMTEL_FEATURE = "android.telephony.ims.MMTEL_FEATURE";
    public static final String METADATA_RCS_FEATURE = "android.telephony.ims.RCS_FEATURE";
    private static final int HANDLER_ADD_PACKAGE = 0;
    private static final int HANDLER_REMOVE_PACKAGE = 1;
    private static final int HANDLER_CONFIG_CHANGED = 2;
    private BroadcastReceiver mAppChangedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            String packageName = intent.getData().getSchemeSpecificPart();
            switch (action) {
                case "android.intent.action.PACKAGE_ADDED": 
                case "android.intent.action.PACKAGE_CHANGED": {
                    ImsResolver.this.mHandler.obtainMessage(0, packageName).sendToTarget();
                    break;
                }
                case "android.intent.action.PACKAGE_REMOVED": {
                    ImsResolver.this.mHandler.obtainMessage(1, packageName).sendToTarget();
                    break;
                }
                default: {
                    return;
                }
            }
        }
    };
    private BroadcastReceiver mConfigChangedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            int subId = intent.getIntExtra("subscription", -1);
            if (subId == -1) {
                Log.i(ImsResolver.TAG, "Received SIM change for invalid sub id.");
                return;
            }
            Log.i(ImsResolver.TAG, "Received Carrier Config Changed for SubId: " + subId);
            ImsResolver.this.mHandler.obtainMessage(2, subId).sendToTarget();
        }
    };
    private SubscriptionManagerProxy mSubscriptionManagerProxy = new SubscriptionManagerProxy(){

        @Override
        public int getSubId(int slotId) {
            int[] subIds = SubscriptionManager.getSubId(slotId);
            if (subIds != null) {
                return subIds[0];
            }
            return -1;
        }

        @Override
        public int getSlotIndex(int subId) {
            return SubscriptionManager.getSlotIndex(subId);
        }
    };
    private ImsServiceControllerFactory mImsServiceControllerFactory = new ImsServiceControllerFactory(){

        @Override
        public String getServiceInterface() {
            return "android.telephony.ims.ImsService";
        }

        @Override
        public ImsServiceController create(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks callbacks) {
            return new ImsServiceController(context, componentName, callbacks);
        }
    };
    private ImsServiceControllerFactory mImsServiceControllerFactoryCompat = new ImsServiceControllerFactory(){

        @Override
        public String getServiceInterface() {
            return "android.telephony.ims.compat.ImsService";
        }

        @Override
        public ImsServiceController create(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks callbacks) {
            return new ImsServiceControllerCompat(context, componentName, callbacks);
        }
    };
    private ImsServiceControllerFactory mImsServiceControllerFactoryStaticBindingCompat = new ImsServiceControllerFactory(){

        @Override
        public String getServiceInterface() {
            return null;
        }

        @Override
        public ImsServiceController create(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks callbacks) {
            return new ImsServiceControllerStaticCompat(context, componentName, callbacks);
        }
    };
    private final CarrierConfigManager mCarrierConfigManager;
    private final Context mContext;
    private final Object mBoundServicesLock = new Object();
    private final int mNumSlots;
    private final boolean mIsDynamicBinding;
    private Handler mHandler = new Handler(Looper.getMainLooper(), msg -> {
        switch (msg.what) {
            case 0: {
                String packageName = (String)msg.obj;
                this.maybeAddedImsService(packageName);
                break;
            }
            case 1: {
                String packageName = (String)msg.obj;
                this.maybeRemovedImsService(packageName);
                break;
            }
            case 2: {
                int subId = (Integer)msg.obj;
                this.maybeRebindService(subId);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    });
    private String mDeviceService;
    private String[] mCarrierServices;
    private List<SparseArray<ImsServiceController>> mBoundImsServicesByFeature;
    private Set<ImsServiceInfo> mInstalledServicesCache = new ArraySet<ImsServiceInfo>();
    private Set<ImsServiceController> mActiveControllers = new ArraySet<ImsServiceController>();
    private final ComponentName mStaticComponent;

    public ImsResolver(Context context, String defaultImsPackageName, int numSlots, boolean isDynamicBinding) {
        this.mContext = context;
        this.mDeviceService = defaultImsPackageName;
        this.mNumSlots = numSlots;
        this.mIsDynamicBinding = isDynamicBinding;
        this.mStaticComponent = new ComponentName(this.mContext, ImsResolver.class);
        if (!this.mIsDynamicBinding) {
            Log.i(TAG, "ImsResolver initialized with static binding.");
            this.mDeviceService = this.mStaticComponent.getPackageName();
        }
        this.mCarrierConfigManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        this.mCarrierServices = new String[numSlots];
        this.mBoundImsServicesByFeature = Stream.generate(SparseArray::new).limit(this.mNumSlots).collect(Collectors.toList());
        if (this.mIsDynamicBinding) {
            IntentFilter appChangedFilter = new IntentFilter();
            appChangedFilter.addAction("android.intent.action.PACKAGE_CHANGED");
            appChangedFilter.addAction("android.intent.action.PACKAGE_REMOVED");
            appChangedFilter.addAction("android.intent.action.PACKAGE_ADDED");
            appChangedFilter.addDataScheme("package");
            context.registerReceiverAsUser(this.mAppChangedReceiver, UserHandle.ALL, appChangedFilter, null, null);
            context.registerReceiver(this.mConfigChangedReceiver, new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED"));
        }
    }

    @VisibleForTesting
    public void setSubscriptionManagerProxy(SubscriptionManagerProxy proxy) {
        this.mSubscriptionManagerProxy = proxy;
    }

    @VisibleForTesting
    public void setImsServiceControllerFactory(ImsServiceControllerFactory factory) {
        this.mImsServiceControllerFactory = factory;
    }

    @VisibleForTesting
    public Handler getHandler() {
        return this.mHandler;
    }

    public void populateCacheAndStartBind() {
        Log.i(TAG, "Initializing cache and binding.");
        this.mHandler.obtainMessage(2, -1).sendToTarget();
        this.mHandler.obtainMessage(0, null).sendToTarget();
    }

    public void enableIms(int slotId) {
        SparseArray<ImsServiceController> controllers = this.getImsServiceControllers(slotId);
        if (controllers != null) {
            for (int i = 0; i < controllers.size(); ++i) {
                int key = controllers.keyAt(i);
                controllers.get(key).enableIms(slotId);
            }
        }
    }

    public void disableIms(int slotId) {
        SparseArray<ImsServiceController> controllers = this.getImsServiceControllers(slotId);
        if (controllers != null) {
            for (int i = 0; i < controllers.size(); ++i) {
                int key = controllers.keyAt(i);
                controllers.get(key).disableIms(slotId);
            }
        }
    }

    public IImsMmTelFeature getMmTelFeatureAndListen(int slotId, IImsServiceFeatureCallback callback) {
        ImsServiceController controller = this.getImsServiceControllerAndListen(slotId, 1, callback);
        return controller != null ? controller.getMmTelFeature(slotId) : null;
    }

    public IImsRcsFeature getRcsFeatureAndListen(int slotId, IImsServiceFeatureCallback callback) {
        ImsServiceController controller = this.getImsServiceControllerAndListen(slotId, 2, callback);
        return controller != null ? controller.getRcsFeature(slotId) : null;
    }

    public IImsRegistration getImsRegistration(int slotId, int feature) throws RemoteException {
        ImsServiceController controller = this.getImsServiceController(slotId, feature);
        if (controller != null) {
            return controller.getRegistration(slotId);
        }
        return null;
    }

    public IImsConfig getImsConfig(int slotId, int feature) throws RemoteException {
        ImsServiceController controller = this.getImsServiceController(slotId, feature);
        if (controller != null) {
            return controller.getConfig(slotId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public ImsServiceController getImsServiceController(int slotId, int feature) {
        ImsServiceController controller;
        if (slotId < 0 || slotId >= this.mNumSlots) {
            return null;
        }
        Object object = this.mBoundServicesLock;
        synchronized (object) {
            SparseArray<ImsServiceController> services = this.mBoundImsServicesByFeature.get(slotId);
            if (services == null) {
                return null;
            }
            controller = services.get(feature);
        }
        return controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SparseArray<ImsServiceController> getImsServiceControllers(int slotId) {
        if (slotId < 0 || slotId >= this.mNumSlots) {
            return null;
        }
        Object object = this.mBoundServicesLock;
        synchronized (object) {
            SparseArray<ImsServiceController> services = this.mBoundImsServicesByFeature.get(slotId);
            if (services == null) {
                return null;
            }
            return services;
        }
    }

    @VisibleForTesting
    public ImsServiceController getImsServiceControllerAndListen(int slotId, int feature, IImsServiceFeatureCallback callback) {
        ImsServiceController controller = this.getImsServiceController(slotId, feature);
        if (controller != null) {
            controller.addImsServiceFeatureListener(callback);
            return controller;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putImsController(int slotId, int feature, ImsServiceController controller) {
        if (slotId < 0 || slotId >= this.mNumSlots || feature <= -1 || feature >= 3) {
            Log.w(TAG, "putImsController received invalid parameters - slot: " + slotId + ", feature: " + feature);
            return;
        }
        Object object = this.mBoundServicesLock;
        synchronized (object) {
            SparseArray<ImsServiceController> services = this.mBoundImsServicesByFeature.get(slotId);
            if (services == null) {
                services = new SparseArray();
                this.mBoundImsServicesByFeature.add(slotId, services);
            }
            Log.i(TAG, "ImsServiceController added on slot: " + slotId + " with feature: " + feature + " using package: " + controller.getComponentName());
            services.put(feature, controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImsServiceController removeImsController(int slotId, int feature) {
        if (slotId < 0 || slotId >= this.mNumSlots || feature <= -1 || feature >= 3) {
            Log.w(TAG, "removeImsController received invalid parameters - slot: " + slotId + ", feature: " + feature);
            return null;
        }
        Object object = this.mBoundServicesLock;
        synchronized (object) {
            SparseArray<ImsServiceController> services = this.mBoundImsServicesByFeature.get(slotId);
            if (services == null) {
                return null;
            }
            ImsServiceController c = services.get(feature, null);
            if (c != null) {
                Log.i(TAG, "ImsServiceController removed on slot: " + slotId + " with feature: " + feature + " using package: " + c.getComponentName());
                services.remove(feature);
            }
            return c;
        }
    }

    private void maybeAddedImsService(String packageName) {
        Log.d(TAG, "maybeAddedImsService, packageName: " + packageName);
        List<ImsServiceInfo> infos = this.getImsServiceInfo(packageName);
        ArrayList<ImsServiceInfo> newlyAddedInfos = new ArrayList<ImsServiceInfo>();
        for (ImsServiceInfo info : infos) {
            Optional<ImsServiceInfo> match = this.getInfoByComponentName(this.mInstalledServicesCache, info.name);
            if (match.isPresent()) {
                Log.i(TAG, "Updating features in cached ImsService: " + info.name);
                Log.d(TAG, "Updating features - Old features: " + match.get().supportedFeatures + " new features: " + info.supportedFeatures);
                match.get().supportedFeatures = info.supportedFeatures;
                this.updateImsServiceFeatures(info);
                continue;
            }
            Log.i(TAG, "Adding newly added ImsService to cache: " + info.name);
            this.mInstalledServicesCache.add(info);
            newlyAddedInfos.add(info);
        }
        for (ImsServiceInfo info : newlyAddedInfos) {
            if (this.isActiveCarrierService(info)) {
                this.bindNewImsService(info);
                this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
                continue;
            }
            if (!this.isDeviceService(info)) continue;
            this.bindNewImsService(info);
        }
    }

    private boolean maybeRemovedImsService(String packageName) {
        Optional<ImsServiceInfo> match = this.getInfoByPackageName(this.mInstalledServicesCache, packageName);
        if (match.isPresent()) {
            this.mInstalledServicesCache.remove(match.get());
            Log.i(TAG, "Removing ImsService: " + match.get().name);
            this.unbindImsService(match.get());
            this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
            return true;
        }
        return false;
    }

    private boolean isActiveCarrierService(ImsServiceInfo info) {
        for (int i = 0; i < this.mNumSlots; ++i) {
            if (!TextUtils.equals(this.mCarrierServices[i], info.name.getPackageName())) continue;
            return true;
        }
        return false;
    }

    private boolean isDeviceService(ImsServiceInfo info) {
        return TextUtils.equals(this.mDeviceService, info.name.getPackageName());
    }

    private int getSlotForActiveCarrierService(ImsServiceInfo info) {
        for (int i = 0; i < this.mNumSlots; ++i) {
            if (!TextUtils.equals(this.mCarrierServices[i], info.name.getPackageName())) continue;
            return i;
        }
        return -1;
    }

    private Optional<ImsServiceController> getControllerByServiceInfo(Set<ImsServiceController> searchSet, ImsServiceInfo matchValue) {
        return searchSet.stream().filter(c -> Objects.equals(c.getComponentName(), matchValue.name)).findFirst();
    }

    private Optional<ImsServiceInfo> getInfoByPackageName(Set<ImsServiceInfo> searchSet, String matchValue) {
        return searchSet.stream().filter(i -> Objects.equals(i.name.getPackageName(), matchValue)).findFirst();
    }

    private Optional<ImsServiceInfo> getInfoByComponentName(Set<ImsServiceInfo> searchSet, ComponentName matchValue) {
        return searchSet.stream().filter(i -> Objects.equals(i.name, matchValue)).findFirst();
    }

    private void updateImsServiceFeatures(ImsServiceInfo newInfo) {
        if (newInfo == null) {
            return;
        }
        Optional<ImsServiceController> o = this.getControllerByServiceInfo(this.mActiveControllers, newInfo);
        if (o.isPresent()) {
            Log.i(TAG, "Updating features for ImsService: " + o.get().getComponentName());
            HashSet<Pair<Integer, Integer>> features = this.calculateFeaturesToCreate(newInfo);
            try {
                if (features.size() > 0) {
                    Log.d(TAG, "Updating Features - New Features: " + features);
                    o.get().changeImsServiceFeatures(features);
                    if (this.isActiveCarrierService(newInfo) && !TextUtils.equals(newInfo.name.getPackageName(), this.mDeviceService)) {
                        Log.i(TAG, "Updating device default");
                        this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
                    }
                } else {
                    Log.i(TAG, "Unbinding: features = 0 for ImsService: " + o.get().getComponentName());
                    o.get().unbind();
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "updateImsServiceFeatures: Remote Exception: " + e.getMessage());
            }
        }
    }

    private void bindNewImsService(ImsServiceInfo info) {
        if (info == null) {
            return;
        }
        ImsServiceController controller = info.controllerFactory.create(this.mContext, info.name, this);
        HashSet<Pair<Integer, Integer>> features = this.calculateFeaturesToCreate(info);
        if (features.size() > 0) {
            Log.i(TAG, "Binding ImsService: " + controller.getComponentName() + " with features: " + features);
            controller.bind(features);
            this.mActiveControllers.add(controller);
        }
    }

    private void unbindImsService(ImsServiceInfo info) {
        if (info == null) {
            return;
        }
        Optional<ImsServiceController> o = this.getControllerByServiceInfo(this.mActiveControllers, info);
        if (o.isPresent()) {
            try {
                Log.i(TAG, "Unbinding ImsService: " + o.get().getComponentName());
                o.get().unbind();
            }
            catch (RemoteException e) {
                Log.e(TAG, "unbindImsService: Remote Exception: " + e.getMessage());
            }
            this.mActiveControllers.remove(o.get());
        }
    }

    private HashSet<Pair<Integer, Integer>> calculateFeaturesToCreate(ImsServiceInfo info) {
        HashSet<Pair<Integer, Integer>> imsFeaturesBySlot = new HashSet<Pair<Integer, Integer>>();
        int slotId = this.getSlotForActiveCarrierService(info);
        if (slotId != -1) {
            imsFeaturesBySlot.addAll(info.supportedFeatures.stream().map(feature -> new Pair<Integer, Integer>(slotId, (Integer)feature)).collect(Collectors.toList()));
        } else if (this.isDeviceService(info)) {
            for (int i = 0; i < this.mNumSlots; ++i) {
                int currSlotId = i;
                ImsServiceInfo carrierImsInfo = this.getImsServiceInfoFromCache(this.mCarrierServices[i]);
                if (carrierImsInfo == null) {
                    imsFeaturesBySlot.addAll(info.supportedFeatures.stream().map(feature -> new Pair<Integer, Integer>(currSlotId, (Integer)feature)).collect(Collectors.toList()));
                    continue;
                }
                HashSet<Integer> deviceFeatures = new HashSet<Integer>(info.supportedFeatures);
                deviceFeatures.removeAll(carrierImsInfo.supportedFeatures);
                imsFeaturesBySlot.addAll(deviceFeatures.stream().map(feature -> new Pair<Integer, Integer>(currSlotId, (Integer)feature)).collect(Collectors.toList()));
            }
        }
        return imsFeaturesBySlot;
    }

    @Override
    public void imsServiceFeatureCreated(int slotId, int feature, ImsServiceController controller) {
        this.putImsController(slotId, feature, controller);
    }

    @Override
    public void imsServiceFeatureRemoved(int slotId, int feature, ImsServiceController controller) {
        this.removeImsController(slotId, feature);
    }

    private void maybeRebindService(int subId) {
        if (subId <= -1) {
            for (int i = 0; i < this.mNumSlots; ++i) {
                subId = this.mSubscriptionManagerProxy.getSubId(i);
                this.updateBoundCarrierServices(subId);
            }
        } else {
            this.updateBoundCarrierServices(subId);
        }
    }

    private void updateBoundCarrierServices(int subId) {
        int slotId = this.mSubscriptionManagerProxy.getSlotIndex(subId);
        String newPackageName = this.mCarrierConfigManager.getConfigForSubId(subId).getString("config_ims_package_override_string", null);
        if (slotId != -1 && slotId < this.mNumSlots) {
            String oldPackageName = this.mCarrierServices[slotId];
            this.mCarrierServices[slotId] = newPackageName;
            if (!TextUtils.equals(newPackageName, oldPackageName)) {
                Log.i(TAG, "Carrier Config updated, binding new ImsService");
                this.unbindImsService(this.getImsServiceInfoFromCache(oldPackageName));
                this.bindNewImsService(this.getImsServiceInfoFromCache(newPackageName));
                this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
            }
        }
    }

    @VisibleForTesting
    public ImsServiceInfo getImsServiceInfoFromCache(String packageName) {
        if (TextUtils.isEmpty(packageName)) {
            return null;
        }
        Optional<ImsServiceInfo> infoFilter = this.getInfoByPackageName(this.mInstalledServicesCache, packageName);
        if (infoFilter.isPresent()) {
            return infoFilter.get();
        }
        return null;
    }

    private List<ImsServiceInfo> getImsServiceInfo(String packageName) {
        ArrayList<ImsServiceInfo> infos = new ArrayList<ImsServiceInfo>();
        if (!this.mIsDynamicBinding) {
            infos.addAll(this.getStaticImsService());
        } else {
            infos.addAll(this.searchForImsServices(packageName, this.mImsServiceControllerFactory));
            infos.addAll(this.searchForImsServices(packageName, this.mImsServiceControllerFactoryCompat));
        }
        return infos;
    }

    private List<ImsServiceInfo> getStaticImsService() {
        ArrayList<ImsServiceInfo> infos = new ArrayList<ImsServiceInfo>();
        ImsServiceInfo info = new ImsServiceInfo();
        info.name = this.mStaticComponent;
        info.supportedFeatures = new HashSet<Integer>(3);
        info.controllerFactory = this.mImsServiceControllerFactoryStaticBindingCompat;
        info.supportsEmergencyMmTel = true;
        info.supportedFeatures.add(1);
        infos.add(info);
        return infos;
    }

    private List<ImsServiceInfo> searchForImsServices(String packageName, ImsServiceControllerFactory controllerFactory) {
        ArrayList<ImsServiceInfo> infos = new ArrayList<ImsServiceInfo>();
        Intent serviceIntent = new Intent(controllerFactory.getServiceInterface());
        serviceIntent.setPackage(packageName);
        PackageManager packageManager = this.mContext.getPackageManager();
        for (ResolveInfo entry : packageManager.queryIntentServicesAsUser(serviceIntent, 128, this.mContext.getUserId())) {
            ServiceInfo serviceInfo = entry.serviceInfo;
            if (serviceInfo == null) continue;
            ImsServiceInfo info = new ImsServiceInfo();
            info.name = new ComponentName(serviceInfo.packageName, serviceInfo.name);
            info.supportedFeatures = new HashSet<Integer>(3);
            info.controllerFactory = controllerFactory;
            if (serviceInfo.metaData != null) {
                if (serviceInfo.metaData.getBoolean(METADATA_EMERGENCY_MMTEL_FEATURE, false)) {
                    info.supportsEmergencyMmTel = true;
                }
                if (serviceInfo.metaData.getBoolean(METADATA_MMTEL_FEATURE, false)) {
                    info.supportedFeatures.add(1);
                }
                if (serviceInfo.metaData.getBoolean(METADATA_RCS_FEATURE, false)) {
                    info.supportedFeatures.add(2);
                }
            }
            if (TextUtils.equals(serviceInfo.permission, "android.permission.BIND_IMS_SERVICE")) {
                Log.d(TAG, "ImsService (" + serviceIntent + ") added to cache: " + info.name + " with features: " + info.supportedFeatures);
                infos.add(info);
                continue;
            }
            Log.w(TAG, "ImsService does not have BIND_IMS_SERVICE permission: " + info.name);
        }
        return infos;
    }

    @VisibleForTesting
    public static interface ImsServiceControllerFactory {
        public String getServiceInterface();

        public ImsServiceController create(Context var1, ComponentName var2, ImsServiceController.ImsServiceControllerCallbacks var3);
    }

    @VisibleForTesting
    public static interface SubscriptionManagerProxy {
        public int getSubId(int var1);

        public int getSlotIndex(int var1);
    }

    @VisibleForTesting
    public static class ImsServiceInfo {
        public ComponentName name;
        public Set<Integer> supportedFeatures;
        public boolean supportsEmergencyMmTel = false;
        public ImsServiceControllerFactory controllerFactory;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImsServiceInfo that = (ImsServiceInfo)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.supportedFeatures != null ? !this.supportedFeatures.equals(that.supportedFeatures) : that.supportedFeatures != null) {
                return false;
            }
            return this.controllerFactory != null ? this.controllerFactory.equals(that.controllerFactory) : that.controllerFactory == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.supportedFeatures != null ? this.supportedFeatures.hashCode() : 0);
            result = 31 * result + (this.controllerFactory != null ? this.controllerFactory.hashCode() : 0);
            return result;
        }
    }
}

