/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.IPackageManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsMmTelFeature;
import android.telephony.ims.aidl.IImsRcsFeature;
import android.telephony.ims.aidl.IImsRegistration;
import android.telephony.ims.aidl.IImsServiceController;
import android.util.Log;
import android.util.Pair;
import com.android.ims.internal.IImsFeatureStatusCallback;
import com.android.ims.internal.IImsServiceFeatureCallback;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.ExponentialBackoff;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ImsServiceController {
    private static final String LOG_TAG = "ImsServiceController";
    private static final int REBIND_START_DELAY_MS = 2000;
    private static final int REBIND_MAXIMUM_DELAY_MS = 60000;
    private final ComponentName mComponentName;
    private final HandlerThread mHandlerThread = new HandlerThread("ImsServiceControllerHandler");
    private final IPackageManager mPackageManager;
    private ImsServiceControllerCallbacks mCallbacks;
    private ExponentialBackoff mBackoff;
    private boolean mIsBound = false;
    private boolean mIsBinding = false;
    private HashSet<Pair<Integer, Integer>> mImsFeatures;
    private HashSet<ImsFeatureContainer> mImsFeatureBinders = new HashSet();
    private IImsServiceController mIImsServiceController;
    private IBinder mImsServiceControllerBinder;
    private ImsServiceConnection mImsServiceConnection;
    private ImsDeathRecipient mImsDeathRecipient;
    private Set<IImsServiceFeatureCallback> mImsStatusCallbacks = new HashSet<IImsServiceFeatureCallback>();
    private Set<ImsFeatureStatusCallback> mFeatureStatusCallbacks = new HashSet<ImsFeatureStatusCallback>();
    protected final Object mLock = new Object();
    protected final Context mContext;
    private Runnable mRestartImsServiceRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = ImsServiceController.this.mLock;
            synchronized (object) {
                if (ImsServiceController.this.mIsBound) {
                    return;
                }
                ImsServiceController.this.bind(ImsServiceController.this.mImsFeatures);
            }
        }
    };
    private RebindRetry mRebindRetry = new RebindRetry(){

        @Override
        public long getStartDelay() {
            return 2000L;
        }

        @Override
        public long getMaximumDelay() {
            return 60000L;
        }
    };

    public ImsServiceController(Context context, ComponentName componentName, ImsServiceControllerCallbacks callbacks) {
        this.mContext = context;
        this.mComponentName = componentName;
        this.mCallbacks = callbacks;
        this.mHandlerThread.start();
        this.mBackoff = new ExponentialBackoff(this.mRebindRetry.getStartDelay(), this.mRebindRetry.getMaximumDelay(), 2, this.mHandlerThread.getLooper(), this.mRestartImsServiceRunnable);
        this.mPackageManager = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
    }

    @VisibleForTesting
    public ImsServiceController(Context context, ComponentName componentName, ImsServiceControllerCallbacks callbacks, Handler handler, RebindRetry rebindRetry) {
        this.mContext = context;
        this.mComponentName = componentName;
        this.mCallbacks = callbacks;
        this.mBackoff = new ExponentialBackoff(rebindRetry.getStartDelay(), rebindRetry.getMaximumDelay(), 2, handler, this.mRestartImsServiceRunnable);
        this.mPackageManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind(HashSet<Pair<Integer, Integer>> imsFeatureSet) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mIsBound && !this.mIsBinding) {
                this.mIsBinding = true;
                this.mImsFeatures = imsFeatureSet;
                Intent imsServiceIntent = new Intent(this.getServiceInterface()).setComponent(this.mComponentName);
                this.mImsServiceConnection = new ImsServiceConnection();
                int serviceFlags = 0x4000041;
                Log.i(LOG_TAG, "Binding ImsService:" + this.mComponentName);
                try {
                    boolean bindSucceeded = this.startBindToService(imsServiceIntent, this.mImsServiceConnection, serviceFlags);
                    if (!bindSucceeded) {
                        this.mBackoff.notifyFailed();
                    }
                    return bindSucceeded;
                }
                catch (Exception e) {
                    this.mBackoff.notifyFailed();
                    Log.e(LOG_TAG, "Error binding (" + this.mComponentName + ") with exception: " + e.getMessage() + ", rebinding in " + this.mBackoff.getCurrentDelay() + " ms");
                    return false;
                }
            }
            return false;
        }
    }

    protected boolean startBindToService(Intent intent, ImsServiceConnection connection, int flags) {
        return this.mContext.bindService(intent, connection, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.mBackoff.stop();
            if (this.mImsServiceConnection == null || this.mImsDeathRecipient == null) {
                return;
            }
            this.changeImsServiceFeatures(new HashSet<Pair<Integer, Integer>>());
            this.removeImsServiceFeatureListener();
            this.mImsServiceControllerBinder.unlinkToDeath(this.mImsDeathRecipient, 0);
            Log.i(LOG_TAG, "Unbinding ImsService: " + this.mComponentName);
            this.mContext.unbindService(this.mImsServiceConnection);
            this.cleanUpService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeImsServiceFeatures(HashSet<Pair<Integer, Integer>> newImsFeatures) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsBound) {
                HashSet<Pair<Integer, Integer>> newFeatures = new HashSet<Pair<Integer, Integer>>(newImsFeatures);
                newFeatures.removeAll(this.mImsFeatures);
                for (Pair<Integer, Integer> i : newFeatures) {
                    this.addImsServiceFeature(i);
                }
                HashSet<Pair<Integer, Integer>> oldFeatures = new HashSet<Pair<Integer, Integer>>(this.mImsFeatures);
                oldFeatures.removeAll(newImsFeatures);
                for (Pair<Integer, Integer> i : oldFeatures) {
                    this.removeImsServiceFeature(i);
                }
            }
            Log.i(LOG_TAG, "Features changed (" + this.mImsFeatures + "->" + newImsFeatures + ") for ImsService: " + this.mComponentName);
            this.mImsFeatures = newImsFeatures;
        }
    }

    @VisibleForTesting
    public IImsServiceController getImsServiceController() {
        return this.mIImsServiceController;
    }

    @VisibleForTesting
    public IBinder getImsServiceControllerBinder() {
        return this.mImsServiceControllerBinder;
    }

    @VisibleForTesting
    public long getRebindDelay() {
        return this.mBackoff.getCurrentDelay();
    }

    public ComponentName getComponentName() {
        return this.mComponentName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImsServiceFeatureListener(IImsServiceFeatureCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            this.mImsStatusCallbacks.add(callback);
        }
    }

    public void enableIms(int slotId) {
        try {
            this.mIImsServiceController.enableIms(slotId);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Couldn't enable IMS: " + e.getMessage());
        }
    }

    public void disableIms(int slotId) {
        try {
            this.mIImsServiceController.disableIms(slotId);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Couldn't disable IMS: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsMmTelFeature getMmTelFeature(int slotId) {
        Object object = this.mLock;
        synchronized (object) {
            ImsFeatureContainer f = this.getImsFeatureContainer(slotId, 1);
            if (f == null) {
                Log.w(LOG_TAG, "Requested null MMTelFeature on slot " + slotId);
                return null;
            }
            return f.resolve(IImsMmTelFeature.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsRcsFeature getRcsFeature(int slotId) {
        Object object = this.mLock;
        synchronized (object) {
            ImsFeatureContainer f = this.getImsFeatureContainer(slotId, 2);
            if (f == null) {
                Log.w(LOG_TAG, "Requested null RcsFeature on slot " + slotId);
                return null;
            }
            return f.resolve(IImsRcsFeature.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsRegistration getRegistration(int slotId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIImsServiceController.getRegistration(slotId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsConfig getConfig(int slotId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIImsServiceController.getConfig(slotId);
        }
    }

    protected String getServiceInterface() {
        return "android.telephony.ims.ImsService";
    }

    protected void setServiceController(IBinder serviceController) {
        this.mIImsServiceController = IImsServiceController.Stub.asInterface(serviceController);
    }

    protected boolean isServiceControllerAvailable() {
        return this.mIImsServiceController != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeImsServiceFeatureListener() {
        Object object = this.mLock;
        synchronized (object) {
            this.mImsStatusCallbacks.clear();
        }
    }

    private void startDelayedRebindToService() {
        this.mBackoff.start();
    }

    private void grantPermissionsToService() {
        Log.i(LOG_TAG, "Granting Runtime permissions to:" + this.getComponentName());
        String[] pkgToGrant = new String[]{this.mComponentName.getPackageName()};
        try {
            if (this.mPackageManager != null) {
                this.mPackageManager.grantDefaultPermissionsToEnabledImsServices(pkgToGrant, this.mContext.getUserId());
            }
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Unable to grant permissions, binder died.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendImsFeatureCreatedCallback(int slot, int feature) {
        Object object = this.mLock;
        synchronized (object) {
            Iterator<IImsServiceFeatureCallback> i = this.mImsStatusCallbacks.iterator();
            while (i.hasNext()) {
                IImsServiceFeatureCallback callbacks = i.next();
                try {
                    callbacks.imsFeatureCreated(slot, feature);
                }
                catch (RemoteException e) {
                    Log.w(LOG_TAG, "sendImsFeatureCreatedCallback: Binder died, removing callback. Exception:" + e.getMessage());
                    i.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendImsFeatureRemovedCallback(int slot, int feature) {
        Object object = this.mLock;
        synchronized (object) {
            Iterator<IImsServiceFeatureCallback> i = this.mImsStatusCallbacks.iterator();
            while (i.hasNext()) {
                IImsServiceFeatureCallback callbacks = i.next();
                try {
                    callbacks.imsFeatureRemoved(slot, feature);
                }
                catch (RemoteException e) {
                    Log.w(LOG_TAG, "sendImsFeatureRemovedCallback: Binder died, removing callback. Exception:" + e.getMessage());
                    i.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendImsFeatureStatusChanged(int slot, int feature, int status) {
        Object object = this.mLock;
        synchronized (object) {
            Iterator<IImsServiceFeatureCallback> i = this.mImsStatusCallbacks.iterator();
            while (i.hasNext()) {
                IImsServiceFeatureCallback callbacks = i.next();
                try {
                    callbacks.imsStatusChanged(slot, feature, status);
                }
                catch (RemoteException e) {
                    Log.w(LOG_TAG, "sendImsFeatureStatusChanged: Binder died, removing callback. Exception:" + e.getMessage());
                    i.remove();
                }
            }
        }
    }

    private void addImsServiceFeature(Pair<Integer, Integer> featurePair) throws RemoteException {
        if (!this.isServiceControllerAvailable() || this.mCallbacks == null) {
            Log.w(LOG_TAG, "addImsServiceFeature called with null values.");
            return;
        }
        ImsFeatureStatusCallback c = new ImsFeatureStatusCallback((Integer)featurePair.first, (Integer)featurePair.second);
        this.mFeatureStatusCallbacks.add(c);
        IInterface f = this.createImsFeature((Integer)featurePair.first, (Integer)featurePair.second, c.getCallback());
        this.addImsFeatureBinder((Integer)featurePair.first, (Integer)featurePair.second, f);
        this.mCallbacks.imsServiceFeatureCreated((Integer)featurePair.first, (Integer)featurePair.second, this);
        this.sendImsFeatureCreatedCallback((Integer)featurePair.first, (Integer)featurePair.second);
    }

    private void removeImsServiceFeature(Pair<Integer, Integer> featurePair) throws RemoteException {
        if (!this.isServiceControllerAvailable() || this.mCallbacks == null) {
            Log.w(LOG_TAG, "removeImsServiceFeature called with null values.");
            return;
        }
        ImsFeatureStatusCallback callbackToRemove = this.mFeatureStatusCallbacks.stream().filter(c -> ((ImsFeatureStatusCallback)c).mSlotId == (Integer)featurePair.first && ((ImsFeatureStatusCallback)c).mFeatureType == (Integer)featurePair.second).findFirst().orElse(null);
        if (callbackToRemove != null) {
            this.mFeatureStatusCallbacks.remove(callbackToRemove);
        }
        this.removeImsFeature((Integer)featurePair.first, (Integer)featurePair.second, callbackToRemove != null ? callbackToRemove.getCallback() : null);
        this.removeImsFeatureBinder((Integer)featurePair.first, (Integer)featurePair.second);
        this.mCallbacks.imsServiceFeatureRemoved((Integer)featurePair.first, (Integer)featurePair.second, this);
        this.sendImsFeatureRemovedCallback((Integer)featurePair.first, (Integer)featurePair.second);
    }

    protected IInterface createImsFeature(int slotId, int featureType, IImsFeatureStatusCallback c) throws RemoteException {
        switch (featureType) {
            case 1: {
                return this.mIImsServiceController.createMmTelFeature(slotId, c);
            }
            case 2: {
                return this.mIImsServiceController.createRcsFeature(slotId, c);
            }
        }
        return null;
    }

    protected void removeImsFeature(int slotId, int featureType, IImsFeatureStatusCallback c) throws RemoteException {
        this.mIImsServiceController.removeImsFeature(slotId, featureType, c);
    }

    private void addImsFeatureBinder(int slotId, int featureType, IInterface b) {
        this.mImsFeatureBinders.add(new ImsFeatureContainer(slotId, featureType, b));
    }

    private void removeImsFeatureBinder(int slotId, int featureType) {
        ImsFeatureContainer container = this.mImsFeatureBinders.stream().filter(f -> f.slotId == slotId && f.featureType == featureType).findFirst().orElse(null);
        if (container != null) {
            this.mImsFeatureBinders.remove(container);
        }
    }

    private ImsFeatureContainer getImsFeatureContainer(int slotId, int featureType) {
        return this.mImsFeatureBinders.stream().filter(f -> f.slotId == slotId && f.featureType == featureType).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllFeaturesRemoved() {
        if (this.mCallbacks == null) {
            Log.w(LOG_TAG, "notifyAllFeaturesRemoved called with invalid callbacks.");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            for (Pair<Integer, Integer> feature : this.mImsFeatures) {
                this.mCallbacks.imsServiceFeatureRemoved((Integer)feature.first, (Integer)feature.second, this);
                this.sendImsFeatureRemovedCallback((Integer)feature.first, (Integer)feature.second);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpService() {
        Object object = this.mLock;
        synchronized (object) {
            this.mImsDeathRecipient = null;
            this.mImsServiceConnection = null;
            this.mImsServiceControllerBinder = null;
            this.setServiceController(null);
            this.mIsBound = false;
        }
    }

    private class ImsFeatureStatusCallback {
        private int mSlotId;
        private int mFeatureType;
        private final IImsFeatureStatusCallback mCallback = new IImsFeatureStatusCallback.Stub(){

            @Override
            public void notifyImsFeatureStatus(int featureStatus) throws RemoteException {
                Log.i(ImsServiceController.LOG_TAG, "notifyImsFeatureStatus: slot=" + ImsFeatureStatusCallback.this.mSlotId + ", feature=" + ImsFeatureStatusCallback.this.mFeatureType + ", status=" + featureStatus);
                ImsServiceController.this.sendImsFeatureStatusChanged(ImsFeatureStatusCallback.this.mSlotId, ImsFeatureStatusCallback.this.mFeatureType, featureStatus);
            }
        };

        ImsFeatureStatusCallback(int slotId, int featureType) {
            this.mSlotId = slotId;
            this.mFeatureType = featureType;
        }

        public IImsFeatureStatusCallback getCallback() {
            return this.mCallback;
        }
    }

    private class ImsFeatureContainer {
        public int slotId;
        public int featureType;
        private IInterface mBinder;

        ImsFeatureContainer(int slotId, int featureType, IInterface binder) {
            this.slotId = slotId;
            this.featureType = featureType;
            this.mBinder = binder;
        }

        public <T extends IInterface> T resolve(Class<T> className) {
            return (T)((IInterface)className.cast(this.mBinder));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImsFeatureContainer that = (ImsFeatureContainer)o;
            if (this.slotId != that.slotId) {
                return false;
            }
            if (this.featureType != that.featureType) {
                return false;
            }
            return this.mBinder != null ? this.mBinder.equals(that.mBinder) : that.mBinder == null;
        }

        public int hashCode() {
            int result = this.slotId;
            result = 31 * result + this.featureType;
            result = 31 * result + (this.mBinder != null ? this.mBinder.hashCode() : 0);
            return result;
        }
    }

    @VisibleForTesting
    public static interface RebindRetry {
        public long getStartDelay();

        public long getMaximumDelay();
    }

    public static interface ImsServiceControllerCallbacks {
        public void imsServiceFeatureCreated(int var1, int var2, ImsServiceController var3);

        public void imsServiceFeatureRemoved(int var1, int var2, ImsServiceController var3);
    }

    class ImsServiceConnection
    implements ServiceConnection {
        ImsServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            ImsServiceController.this.mBackoff.stop();
            Object object = ImsServiceController.this.mLock;
            synchronized (object) {
                ImsServiceController.this.mIsBound = true;
                ImsServiceController.this.mIsBinding = false;
                ImsServiceController.this.grantPermissionsToService();
                Log.d(ImsServiceController.LOG_TAG, "ImsService(" + name + "): onServiceConnected with binder: " + service);
                if (service != null) {
                    ImsServiceController.this.mImsDeathRecipient = new ImsDeathRecipient(name);
                    try {
                        service.linkToDeath(ImsServiceController.this.mImsDeathRecipient, 0);
                        ImsServiceController.this.mImsServiceControllerBinder = service;
                        ImsServiceController.this.setServiceController(service);
                        for (Pair i : ImsServiceController.this.mImsFeatures) {
                            ImsServiceController.this.addImsServiceFeature(i);
                        }
                    }
                    catch (RemoteException e) {
                        ImsServiceController.this.mIsBound = false;
                        ImsServiceController.this.mIsBinding = false;
                        if (ImsServiceController.this.mImsDeathRecipient != null) {
                            ImsServiceController.this.mImsDeathRecipient.binderDied();
                        }
                        Log.e(ImsServiceController.LOG_TAG, "ImsService(" + name + ") RemoteException:" + e.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Object object = ImsServiceController.this.mLock;
            synchronized (object) {
                ImsServiceController.this.mIsBinding = false;
            }
            if (ImsServiceController.this.isServiceControllerAvailable()) {
                ImsServiceController.this.mImsServiceControllerBinder.unlinkToDeath(ImsServiceController.this.mImsDeathRecipient, 0);
            }
            ImsServiceController.this.notifyAllFeaturesRemoved();
            ImsServiceController.this.cleanUpService();
            Log.w(ImsServiceController.LOG_TAG, "ImsService(" + name + "): onServiceDisconnected. Rebinding...");
            ImsServiceController.this.startDelayedRebindToService();
        }
    }

    class ImsDeathRecipient
    implements IBinder.DeathRecipient {
        private ComponentName mComponentName;

        ImsDeathRecipient(ComponentName name) {
            this.mComponentName = name;
        }

        @Override
        public void binderDied() {
            Log.e(ImsServiceController.LOG_TAG, "ImsService(" + this.mComponentName + ") died. Restarting...");
            ImsServiceController.this.notifyAllFeaturesRemoved();
            ImsServiceController.this.cleanUpService();
            ImsServiceController.this.startDelayedRebindToService();
        }
    }
}

