/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.app.PendingIntent;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.ims.ImsCallProfile;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsConfig;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsRegistrationListener;
import com.android.ims.internal.IImsService;
import com.android.ims.internal.IImsUt;
import com.android.internal.telephony.ims.MmTelInterfaceAdapter;

public class ImsServiceInterfaceAdapter
extends MmTelInterfaceAdapter {
    private static final int SERVICE_ID = 1;

    public ImsServiceInterfaceAdapter(int slotId, IBinder binder) {
        super(slotId, binder);
    }

    @Override
    public int startSession(PendingIntent incomingCallIntent, IImsRegistrationListener listener) throws RemoteException {
        return this.getInterface().open(this.mSlotId, 1, incomingCallIntent, listener);
    }

    @Override
    public void endSession(int sessionId) throws RemoteException {
        this.getInterface().close(sessionId);
    }

    @Override
    public boolean isConnected(int callSessionType, int callType) throws RemoteException {
        return this.getInterface().isConnected(1, callSessionType, callType);
    }

    @Override
    public boolean isOpened() throws RemoteException {
        return this.getInterface().isOpened(1);
    }

    @Override
    public int getFeatureState() throws RemoteException {
        return 2;
    }

    @Override
    public void addRegistrationListener(IImsRegistrationListener listener) throws RemoteException {
        this.getInterface().addRegistrationListener(this.mSlotId, 1, listener);
    }

    @Override
    public void removeRegistrationListener(IImsRegistrationListener listener) throws RemoteException {
    }

    @Override
    public ImsCallProfile createCallProfile(int sessionId, int callSessionType, int callType) throws RemoteException {
        return this.getInterface().createCallProfile(sessionId, callSessionType, callType);
    }

    @Override
    public IImsCallSession createCallSession(int sessionId, ImsCallProfile profile) throws RemoteException {
        return this.getInterface().createCallSession(sessionId, profile, null);
    }

    @Override
    public IImsCallSession getPendingCallSession(int sessionId, String callId) throws RemoteException {
        return this.getInterface().getPendingCallSession(sessionId, callId);
    }

    @Override
    public IImsUt getUtInterface() throws RemoteException {
        return this.getInterface().getUtInterface(1);
    }

    @Override
    public IImsConfig getConfigInterface() throws RemoteException {
        return this.getInterface().getConfigInterface(this.mSlotId);
    }

    @Override
    public void turnOnIms() throws RemoteException {
        this.getInterface().turnOnIms(this.mSlotId);
    }

    @Override
    public void turnOffIms() throws RemoteException {
        this.getInterface().turnOffIms(this.mSlotId);
    }

    @Override
    public IImsEcbm getEcbmInterface() throws RemoteException {
        return this.getInterface().getEcbmInterface(1);
    }

    @Override
    public void setUiTTYMode(int uiTtyMode, Message onComplete) throws RemoteException {
        this.getInterface().setUiTTYMode(1, uiTtyMode, onComplete);
    }

    @Override
    public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
        return this.getInterface().getMultiEndpointInterface(1);
    }

    private IImsService getInterface() throws RemoteException {
        IImsService feature = IImsService.Stub.asInterface(this.mBinder);
        if (feature == null) {
            throw new RemoteException("Binder not Available");
        }
        return feature;
    }
}

