/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.app.PendingIntent;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.ims.ImsCallProfile;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsConfig;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsMMTelFeature;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsRegistrationListener;
import com.android.ims.internal.IImsUt;

public class MmTelInterfaceAdapter {
    protected IBinder mBinder;
    protected int mSlotId;

    public MmTelInterfaceAdapter(int slotId, IBinder binder) {
        this.mBinder = binder;
        this.mSlotId = slotId;
    }

    public int startSession(PendingIntent incomingCallIntent, IImsRegistrationListener listener) throws RemoteException {
        return this.getInterface().startSession(incomingCallIntent, listener);
    }

    public void endSession(int sessionId) throws RemoteException {
        this.getInterface().endSession(sessionId);
    }

    public boolean isConnected(int callSessionType, int callType) throws RemoteException {
        return this.getInterface().isConnected(callSessionType, callType);
    }

    public boolean isOpened() throws RemoteException {
        return this.getInterface().isOpened();
    }

    public int getFeatureState() throws RemoteException {
        return this.getInterface().getFeatureStatus();
    }

    public void addRegistrationListener(IImsRegistrationListener listener) throws RemoteException {
        this.getInterface().addRegistrationListener(listener);
    }

    public void removeRegistrationListener(IImsRegistrationListener listener) throws RemoteException {
        this.getInterface().removeRegistrationListener(listener);
    }

    public ImsCallProfile createCallProfile(int sessionId, int callSessionType, int callType) throws RemoteException {
        return this.getInterface().createCallProfile(sessionId, callSessionType, callType);
    }

    public IImsCallSession createCallSession(int sessionId, ImsCallProfile profile) throws RemoteException {
        return this.getInterface().createCallSession(sessionId, profile);
    }

    public IImsCallSession getPendingCallSession(int sessionId, String callId) throws RemoteException {
        return this.getInterface().getPendingCallSession(sessionId, callId);
    }

    public IImsUt getUtInterface() throws RemoteException {
        return this.getInterface().getUtInterface();
    }

    public IImsConfig getConfigInterface() throws RemoteException {
        return this.getInterface().getConfigInterface();
    }

    public void turnOnIms() throws RemoteException {
        this.getInterface().turnOnIms();
    }

    public void turnOffIms() throws RemoteException {
        this.getInterface().turnOffIms();
    }

    public IImsEcbm getEcbmInterface() throws RemoteException {
        return this.getInterface().getEcbmInterface();
    }

    public void setUiTTYMode(int uiTtyMode, Message onComplete) throws RemoteException {
        this.getInterface().setUiTTYMode(uiTtyMode, onComplete);
    }

    public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
        return this.getInterface().getMultiEndpointInterface();
    }

    private IImsMMTelFeature getInterface() throws RemoteException {
        IImsMMTelFeature feature = IImsMMTelFeature.Stub.asInterface(this.mBinder);
        if (feature == null) {
            throw new RemoteException("Binder not Available");
        }
        return feature;
    }
}

