/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telecom.VideoProfile;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.ImsExternalCallState;
import android.util.ArrayMap;
import android.util.Log;
import com.android.ims.ImsExternalCallStateListener;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.imsphone.ImsExternalConnection;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPhoneCallTracker;
import com.android.internal.telephony.imsphone.ImsPullCall;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ImsExternalCallTracker
implements ImsPhoneCallTracker.PhoneStateListener {
    public static final String TAG = "ImsExternalCallTracker";
    private static final int EVENT_VIDEO_CAPABILITIES_CHANGED = 1;
    public static final String EXTRA_IMS_EXTERNAL_CALL_ID = "android.telephony.ImsExternalCallTracker.extra.EXTERNAL_CALL_ID";
    private Map<Integer, ImsExternalConnection> mExternalConnections = new ArrayMap<Integer, ImsExternalConnection>();
    private Map<Integer, Boolean> mExternalCallPullableState = new ArrayMap<Integer, Boolean>();
    private final ImsPhone mPhone;
    private final ImsCallNotify mCallStateNotifier;
    private final ExternalCallStateListener mExternalCallStateListener;
    private final ExternalConnectionListener mExternalConnectionListener = new ExternalConnectionListener();
    private ImsPullCall mCallPuller;
    private boolean mIsVideoCapable;
    private boolean mHasActiveCalls;
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ImsExternalCallTracker.this.handleVideoCapabilitiesChanged((AsyncResult)msg.obj);
                    break;
                }
            }
        }
    };

    @VisibleForTesting
    public ImsExternalCallTracker(ImsPhone phone, ImsPullCall callPuller, ImsCallNotify callNotifier) {
        this.mPhone = phone;
        this.mCallStateNotifier = callNotifier;
        this.mExternalCallStateListener = new ExternalCallStateListener();
        this.mCallPuller = callPuller;
    }

    public ImsExternalCallTracker(ImsPhone phone) {
        this.mPhone = phone;
        this.mCallStateNotifier = new ImsCallNotify(){

            @Override
            public void notifyUnknownConnection(Connection c) {
                ImsExternalCallTracker.this.mPhone.notifyUnknownConnection(c);
            }

            @Override
            public void notifyPreciseCallStateChanged() {
                ImsExternalCallTracker.this.mPhone.notifyPreciseCallStateChanged();
            }
        };
        this.mExternalCallStateListener = new ExternalCallStateListener();
        this.registerForNotifications();
    }

    public void tearDown() {
        this.unregisterForNotifications();
    }

    public void setCallPuller(ImsPullCall callPuller) {
        this.mCallPuller = callPuller;
    }

    public ExternalCallStateListener getExternalCallStateListener() {
        return this.mExternalCallStateListener;
    }

    @Override
    public void onPhoneStateChanged(PhoneConstants.State oldState, PhoneConstants.State newState) {
        this.mHasActiveCalls = newState != PhoneConstants.State.IDLE;
        Log.i(TAG, "onPhoneStateChanged : hasActiveCalls = " + this.mHasActiveCalls);
        this.refreshCallPullState();
    }

    private void registerForNotifications() {
        if (this.mPhone != null) {
            Log.d(TAG, "Registering: " + this.mPhone);
            this.mPhone.getDefaultPhone().registerForVideoCapabilityChanged(this.mHandler, 1, null);
        }
    }

    private void unregisterForNotifications() {
        if (this.mPhone != null) {
            Log.d(TAG, "Unregistering: " + this.mPhone);
            this.mPhone.unregisterForVideoCapabilityChanged(this.mHandler);
        }
    }

    public void refreshExternalCallState(List<ImsExternalCallState> externalCallStates) {
        Log.d(TAG, "refreshExternalCallState");
        Iterator<Map.Entry<Integer, ImsExternalConnection>> connectionIterator = this.mExternalConnections.entrySet().iterator();
        boolean wasCallRemoved = false;
        while (connectionIterator.hasNext()) {
            Map.Entry<Integer, ImsExternalConnection> entry = connectionIterator.next();
            int callId = entry.getKey();
            if (this.containsCallId(externalCallStates, callId)) continue;
            ImsExternalConnection externalConnection = entry.getValue();
            externalConnection.setTerminated();
            externalConnection.removeListener(this.mExternalConnectionListener);
            connectionIterator.remove();
            wasCallRemoved = true;
        }
        if (wasCallRemoved) {
            this.mCallStateNotifier.notifyPreciseCallStateChanged();
        }
        if (externalCallStates != null && !externalCallStates.isEmpty()) {
            for (ImsExternalCallState callState : externalCallStates) {
                if (!this.mExternalConnections.containsKey(callState.getCallId())) {
                    Log.d(TAG, "refreshExternalCallState: got = " + callState);
                    if (callState.getCallState() != 1) continue;
                    this.createExternalConnection(callState);
                    continue;
                }
                this.updateExistingConnection(this.mExternalConnections.get(callState.getCallId()), callState);
            }
        }
    }

    public Connection getConnectionById(int callId) {
        return this.mExternalConnections.get(callId);
    }

    private void createExternalConnection(ImsExternalCallState state) {
        Log.i(TAG, "createExternalConnection : state = " + state);
        int videoState = ImsCallProfile.getVideoStateFromCallType(state.getCallType());
        boolean isCallPullPermitted = this.isCallPullPermitted(state.isCallPullable(), videoState);
        ImsExternalConnection connection = new ImsExternalConnection(this.mPhone, state.getCallId(), state.getAddress(), isCallPullPermitted);
        connection.setVideoState(videoState);
        connection.addListener(this.mExternalConnectionListener);
        Log.d(TAG, "createExternalConnection - pullable state : externalCallId = " + connection.getCallId() + " ; isPullable = " + isCallPullPermitted + " ; networkPullable = " + state.isCallPullable() + " ; isVideo = " + VideoProfile.isVideo(videoState) + " ; videoEnabled = " + this.mIsVideoCapable + " ; hasActiveCalls = " + this.mHasActiveCalls);
        this.mExternalConnections.put(connection.getCallId(), connection);
        this.mExternalCallPullableState.put(connection.getCallId(), state.isCallPullable());
        this.mCallStateNotifier.notifyUnknownConnection(connection);
    }

    private void updateExistingConnection(ImsExternalConnection connection, ImsExternalCallState state) {
        int newVideoState;
        Call.State newState;
        Log.i(TAG, "updateExistingConnection : state = " + state);
        Call.State existingState = connection.getState();
        Call.State state2 = newState = state.getCallState() == 1 ? Call.State.ACTIVE : Call.State.DISCONNECTED;
        if (existingState != newState) {
            if (newState == Call.State.ACTIVE) {
                connection.setActive();
            } else {
                connection.setTerminated();
                connection.removeListener(this.mExternalConnectionListener);
                this.mExternalConnections.remove(connection.getCallId());
                this.mExternalCallPullableState.remove(connection.getCallId());
                this.mCallStateNotifier.notifyPreciseCallStateChanged();
            }
        }
        if ((newVideoState = ImsCallProfile.getVideoStateFromCallType(state.getCallType())) != connection.getVideoState()) {
            connection.setVideoState(newVideoState);
        }
        this.mExternalCallPullableState.put(state.getCallId(), state.isCallPullable());
        boolean isCallPullPermitted = this.isCallPullPermitted(state.isCallPullable(), newVideoState);
        Log.d(TAG, "updateExistingConnection - pullable state : externalCallId = " + connection.getCallId() + " ; isPullable = " + isCallPullPermitted + " ; networkPullable = " + state.isCallPullable() + " ; isVideo = " + VideoProfile.isVideo(connection.getVideoState()) + " ; videoEnabled = " + this.mIsVideoCapable + " ; hasActiveCalls = " + this.mHasActiveCalls);
        connection.setIsPullable(isCallPullPermitted);
    }

    private void refreshCallPullState() {
        Log.d(TAG, "refreshCallPullState");
        for (ImsExternalConnection imsExternalConnection : this.mExternalConnections.values()) {
            boolean isNetworkPullable = this.mExternalCallPullableState.get(imsExternalConnection.getCallId());
            boolean isCallPullPermitted = this.isCallPullPermitted(isNetworkPullable, imsExternalConnection.getVideoState());
            Log.d(TAG, "refreshCallPullState : externalCallId = " + imsExternalConnection.getCallId() + " ; isPullable = " + isCallPullPermitted + " ; networkPullable = " + isNetworkPullable + " ; isVideo = " + VideoProfile.isVideo(imsExternalConnection.getVideoState()) + " ; videoEnabled = " + this.mIsVideoCapable + " ; hasActiveCalls = " + this.mHasActiveCalls);
            imsExternalConnection.setIsPullable(isCallPullPermitted);
        }
    }

    private boolean containsCallId(List<ImsExternalCallState> externalCallStates, int callId) {
        if (externalCallStates == null) {
            return false;
        }
        for (ImsExternalCallState state : externalCallStates) {
            if (state.getCallId() != callId) continue;
            return true;
        }
        return false;
    }

    private void handleVideoCapabilitiesChanged(AsyncResult ar) {
        this.mIsVideoCapable = (Boolean)ar.result;
        Log.i(TAG, "handleVideoCapabilitiesChanged : isVideoCapable = " + this.mIsVideoCapable);
        this.refreshCallPullState();
    }

    private boolean isCallPullPermitted(boolean isNetworkPullable, int videoState) {
        if (VideoProfile.isVideo(videoState) && !this.mIsVideoCapable) {
            return false;
        }
        if (this.mHasActiveCalls) {
            return false;
        }
        return isNetworkPullable;
    }

    public class ExternalConnectionListener
    implements ImsExternalConnection.Listener {
        @Override
        public void onPullExternalCall(ImsExternalConnection connection) {
            Log.d(ImsExternalCallTracker.TAG, "onPullExternalCall: connection = " + connection);
            if (ImsExternalCallTracker.this.mCallPuller == null) {
                Log.e(ImsExternalCallTracker.TAG, "onPullExternalCall : No call puller defined");
                return;
            }
            ImsExternalCallTracker.this.mCallPuller.pullExternalCall(connection.getAddress(), connection.getVideoState(), connection.getCallId());
        }
    }

    public class ExternalCallStateListener
    extends ImsExternalCallStateListener {
        @Override
        public void onImsExternalCallStateUpdate(List<ImsExternalCallState> externalCallState) {
            ImsExternalCallTracker.this.refreshExternalCallState(externalCallState);
        }
    }

    public static interface ImsCallNotify {
        public void notifyUnknownConnection(Connection var1);

        public void notifyPreciseCallStateChanged();
    }
}

