/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.metrics;

import android.hardware.radio.V1_0.SetupDataCallResult;
import android.os.Build;
import android.os.SystemClock;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.TelephonyHistogram;
import android.telephony.data.DataCallResponse;
import android.telephony.ims.ImsCallSession;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.feature.MmTelFeature;
import android.text.TextUtils;
import android.util.Base64;
import android.util.SparseArray;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.GsmCdmaConnection;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.metrics.CallSessionEventBuilder;
import com.android.internal.telephony.metrics.InProgressCallSession;
import com.android.internal.telephony.metrics.InProgressSmsSession;
import com.android.internal.telephony.metrics.ModemPowerMetrics;
import com.android.internal.telephony.metrics.SmsSessionEventBuilder;
import com.android.internal.telephony.metrics.TelephonyEventBuilder;
import com.android.internal.telephony.nano.TelephonyProto;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;

public class TelephonyMetrics {
    private static final String TAG = TelephonyMetrics.class.getSimpleName();
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final int MAX_TELEPHONY_EVENTS = 1000;
    private static final int MAX_COMPLETED_CALL_SESSIONS = 50;
    private static final int MAX_COMPLETED_SMS_SESSIONS = 500;
    private static final int SESSION_START_PRECISION_MINUTES = 5;
    private static TelephonyMetrics sInstance;
    private final Deque<TelephonyProto.TelephonyEvent> mTelephonyEvents = new ArrayDeque<TelephonyProto.TelephonyEvent>();
    private final SparseArray<InProgressCallSession> mInProgressCallSessions = new SparseArray();
    private final Deque<TelephonyProto.TelephonyCallSession> mCompletedCallSessions = new ArrayDeque<TelephonyProto.TelephonyCallSession>();
    private final SparseArray<InProgressSmsSession> mInProgressSmsSessions = new SparseArray();
    private final Deque<TelephonyProto.SmsSession> mCompletedSmsSessions = new ArrayDeque<TelephonyProto.SmsSession>();
    private final SparseArray<TelephonyProto.TelephonyServiceState> mLastServiceState = new SparseArray();
    private final SparseArray<TelephonyProto.ImsCapabilities> mLastImsCapabilities = new SparseArray();
    private final SparseArray<TelephonyProto.ImsConnectionState> mLastImsConnectionState = new SparseArray();
    private final SparseArray<TelephonyProto.TelephonySettings> mLastSettings = new SparseArray();
    private long mStartSystemTimeMs;
    private long mStartElapsedTimeMs;
    private boolean mTelephonyEventsDropped = false;

    public TelephonyMetrics() {
        this.reset();
    }

    public static synchronized TelephonyMetrics getInstance() {
        if (sInstance == null) {
            sInstance = new TelephonyMetrics();
        }
        return sInstance;
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (args != null && args.length > 0) {
            switch (args[0]) {
                case "--metrics": {
                    this.printAllMetrics(pw);
                    break;
                }
                case "--metricsproto": {
                    pw.println(TelephonyMetrics.convertProtoToBase64String(this.buildProto()));
                    this.reset();
                }
            }
        }
    }

    private static String telephonyEventToString(int event) {
        switch (event) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "SETTINGS_CHANGED";
            }
            case 2: {
                return "RIL_SERVICE_STATE_CHANGED";
            }
            case 3: {
                return "IMS_CONNECTION_STATE_CHANGED";
            }
            case 4: {
                return "IMS_CAPABILITIES_CHANGED";
            }
            case 5: {
                return "DATA_CALL_SETUP";
            }
            case 6: {
                return "DATA_CALL_SETUP_RESPONSE";
            }
            case 7: {
                return "DATA_CALL_LIST_CHANGED";
            }
            case 8: {
                return "DATA_CALL_DEACTIVATE";
            }
            case 9: {
                return "DATA_CALL_DEACTIVATE_RESPONSE";
            }
            case 10: {
                return "DATA_STALL_ACTION";
            }
            case 11: {
                return "MODEM_RESTART";
            }
            case 13: {
                return "CARRIER_ID_MATCHING";
            }
        }
        return Integer.toString(event);
    }

    private static String callSessionEventToString(int event) {
        switch (event) {
            case 0: {
                return "EVENT_UNKNOWN";
            }
            case 1: {
                return "SETTINGS_CHANGED";
            }
            case 2: {
                return "RIL_SERVICE_STATE_CHANGED";
            }
            case 3: {
                return "IMS_CONNECTION_STATE_CHANGED";
            }
            case 4: {
                return "IMS_CAPABILITIES_CHANGED";
            }
            case 5: {
                return "DATA_CALL_LIST_CHANGED";
            }
            case 6: {
                return "RIL_REQUEST";
            }
            case 7: {
                return "RIL_RESPONSE";
            }
            case 8: {
                return "RIL_CALL_RING";
            }
            case 9: {
                return "RIL_CALL_SRVCC";
            }
            case 10: {
                return "RIL_CALL_LIST_CHANGED";
            }
            case 11: {
                return "IMS_COMMAND";
            }
            case 12: {
                return "IMS_COMMAND_RECEIVED";
            }
            case 13: {
                return "IMS_COMMAND_FAILED";
            }
            case 14: {
                return "IMS_COMMAND_COMPLETE";
            }
            case 15: {
                return "IMS_CALL_RECEIVE";
            }
            case 16: {
                return "IMS_CALL_STATE_CHANGED";
            }
            case 17: {
                return "IMS_CALL_TERMINATED";
            }
            case 18: {
                return "IMS_CALL_HANDOVER";
            }
            case 19: {
                return "IMS_CALL_HANDOVER_FAILED";
            }
            case 20: {
                return "PHONE_STATE_CHANGED";
            }
            case 21: {
                return "NITZ_TIME";
            }
        }
        return Integer.toString(event);
    }

    private static String smsSessionEventToString(int event) {
        switch (event) {
            case 0: {
                return "EVENT_UNKNOWN";
            }
            case 1: {
                return "SETTINGS_CHANGED";
            }
            case 2: {
                return "RIL_SERVICE_STATE_CHANGED";
            }
            case 3: {
                return "IMS_CONNECTION_STATE_CHANGED";
            }
            case 4: {
                return "IMS_CAPABILITIES_CHANGED";
            }
            case 5: {
                return "DATA_CALL_LIST_CHANGED";
            }
            case 6: {
                return "SMS_SEND";
            }
            case 7: {
                return "SMS_SEND_RESULT";
            }
            case 8: {
                return "SMS_RECEIVED";
            }
        }
        return Integer.toString(event);
    }

    private synchronized void printAllMetrics(PrintWriter rawWriter) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)rawWriter, "  ");
        pw.println("Telephony metrics proto:");
        pw.println("------------------------------------------");
        pw.println("Telephony events:");
        pw.increaseIndent();
        for (TelephonyProto.TelephonyEvent telephonyEvent : this.mTelephonyEvents) {
            pw.print(telephonyEvent.timestampMillis);
            pw.print(" [");
            pw.print(telephonyEvent.phoneId);
            pw.print("] ");
            pw.print("T=");
            if (telephonyEvent.type == 2) {
                pw.print(TelephonyMetrics.telephonyEventToString(telephonyEvent.type) + "(" + telephonyEvent.serviceState.dataRat + ")");
            } else {
                pw.print(TelephonyMetrics.telephonyEventToString(telephonyEvent.type));
            }
            pw.println("");
        }
        pw.decreaseIndent();
        pw.println("Call sessions:");
        pw.increaseIndent();
        for (TelephonyProto.TelephonyCallSession telephonyCallSession : this.mCompletedCallSessions) {
            pw.println("Start time in minutes: " + telephonyCallSession.startTimeMinutes);
            pw.println("Events dropped: " + telephonyCallSession.eventsDropped);
            pw.println("Events: ");
            pw.increaseIndent();
            for (TelephonyProto.TelephonyCallSession.Event event : telephonyCallSession.events) {
                pw.print(event.delay);
                pw.print(" T=");
                if (event.type == 2) {
                    pw.println(TelephonyMetrics.callSessionEventToString(event.type) + "(" + event.serviceState.dataRat + ")");
                    continue;
                }
                if (event.type == 10) {
                    pw.println(TelephonyMetrics.callSessionEventToString(event.type));
                    pw.increaseIndent();
                    for (TelephonyProto.TelephonyCallSession.Event.RilCall call : event.calls) {
                        pw.println(call.index + ". Type = " + call.type + " State = " + call.state + " End Reason " + call.callEndReason + " isMultiparty = " + call.isMultiparty);
                    }
                    pw.decreaseIndent();
                    continue;
                }
                pw.println(TelephonyMetrics.callSessionEventToString(event.type));
            }
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
        pw.println("Sms sessions:");
        pw.increaseIndent();
        int count = 0;
        for (TelephonyProto.SmsSession smsSession : this.mCompletedSmsSessions) {
            pw.print("[" + ++count + "] Start time in minutes: " + smsSession.startTimeMinutes);
            if (smsSession.eventsDropped) {
                pw.println(", events dropped: " + smsSession.eventsDropped);
            }
            pw.println("Events: ");
            pw.increaseIndent();
            for (TelephonyProto.SmsSession.Event event : smsSession.events) {
                pw.print(event.delay);
                pw.print(" T=");
                pw.println(TelephonyMetrics.smsSessionEventToString(event.type));
            }
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
        pw.println("Modem power stats:");
        pw.increaseIndent();
        TelephonyProto.ModemPowerStats modemPowerStats = new ModemPowerMetrics().buildProto();
        pw.println("Power log duration (battery time) (ms): " + modemPowerStats.loggingDurationMs);
        pw.println("Energy consumed by modem (mAh): " + modemPowerStats.energyConsumedMah);
        pw.println("Number of packets sent (tx): " + modemPowerStats.numPacketsTx);
        pw.println("Amount of time kernel is active because of cellular data (ms): " + modemPowerStats.cellularKernelActiveTimeMs);
        pw.println("Amount of time spent in very poor rx signal level (ms): " + modemPowerStats.timeInVeryPoorRxSignalLevelMs);
        pw.println("Amount of time modem is in sleep (ms): " + modemPowerStats.sleepTimeMs);
        pw.println("Amount of time modem is in idle (ms): " + modemPowerStats.idleTimeMs);
        pw.println("Amount of time modem is in rx (ms): " + modemPowerStats.rxTimeMs);
        pw.println("Amount of time modem is in tx (ms): " + Arrays.toString(modemPowerStats.txTimeMs));
        pw.decreaseIndent();
    }

    private static String convertProtoToBase64String(TelephonyProto.TelephonyLog proto) {
        return Base64.encodeToString(TelephonyProto.TelephonyLog.toByteArray(proto), 0);
    }

    private synchronized void reset() {
        TelephonyProto.TelephonyEvent event;
        int key;
        int i;
        this.mTelephonyEvents.clear();
        this.mCompletedCallSessions.clear();
        this.mCompletedSmsSessions.clear();
        this.mTelephonyEventsDropped = false;
        this.mStartSystemTimeMs = System.currentTimeMillis();
        this.mStartElapsedTimeMs = SystemClock.elapsedRealtime();
        for (i = 0; i < this.mLastServiceState.size(); ++i) {
            key = this.mLastServiceState.keyAt(i);
            event = new TelephonyEventBuilder(this.mStartElapsedTimeMs, key).setServiceState(this.mLastServiceState.get(key)).build();
            this.addTelephonyEvent(event);
        }
        for (i = 0; i < this.mLastImsCapabilities.size(); ++i) {
            key = this.mLastImsCapabilities.keyAt(i);
            event = new TelephonyEventBuilder(this.mStartElapsedTimeMs, key).setImsCapabilities(this.mLastImsCapabilities.get(key)).build();
            this.addTelephonyEvent(event);
        }
        for (i = 0; i < this.mLastImsConnectionState.size(); ++i) {
            key = this.mLastImsConnectionState.keyAt(i);
            event = new TelephonyEventBuilder(this.mStartElapsedTimeMs, key).setImsConnectionState(this.mLastImsConnectionState.get(key)).build();
            this.addTelephonyEvent(event);
        }
    }

    private synchronized TelephonyProto.TelephonyLog buildProto() {
        TelephonyProto.TelephonyLog log = new TelephonyProto.TelephonyLog();
        log.events = new TelephonyProto.TelephonyEvent[this.mTelephonyEvents.size()];
        this.mTelephonyEvents.toArray(log.events);
        log.eventsDropped = this.mTelephonyEventsDropped;
        log.callSessions = new TelephonyProto.TelephonyCallSession[this.mCompletedCallSessions.size()];
        this.mCompletedCallSessions.toArray(log.callSessions);
        log.smsSessions = new TelephonyProto.SmsSession[this.mCompletedSmsSessions.size()];
        this.mCompletedSmsSessions.toArray(log.smsSessions);
        List<TelephonyHistogram> rilHistograms = RIL.getTelephonyRILTimingHistograms();
        log.histograms = new TelephonyProto.TelephonyHistogram[rilHistograms.size()];
        for (int i = 0; i < rilHistograms.size(); ++i) {
            log.histograms[i] = new TelephonyProto.TelephonyHistogram();
            TelephonyHistogram rilHistogram = rilHistograms.get(i);
            TelephonyProto.TelephonyHistogram histogramProto = log.histograms[i];
            histogramProto.category = rilHistogram.getCategory();
            histogramProto.id = rilHistogram.getId();
            histogramProto.minTimeMillis = rilHistogram.getMinTime();
            histogramProto.maxTimeMillis = rilHistogram.getMaxTime();
            histogramProto.avgTimeMillis = rilHistogram.getAverageTime();
            histogramProto.count = rilHistogram.getSampleCount();
            histogramProto.bucketCount = rilHistogram.getBucketCount();
            histogramProto.bucketEndPoints = rilHistogram.getBucketEndPoints();
            histogramProto.bucketCounters = rilHistogram.getBucketCounters();
        }
        log.modemPowerStats = new ModemPowerMetrics().buildProto();
        log.startTime = new TelephonyProto.Time();
        log.startTime.systemTimestampMillis = this.mStartSystemTimeMs;
        log.startTime.elapsedTimestampMillis = this.mStartElapsedTimeMs;
        log.endTime = new TelephonyProto.Time();
        log.endTime.systemTimestampMillis = System.currentTimeMillis();
        log.endTime.elapsedTimestampMillis = SystemClock.elapsedRealtime();
        return log;
    }

    static int roundSessionStart(long timestamp) {
        return (int)(timestamp / 300000L * 5L);
    }

    public void writeCarrierKeyEvent(int phoneId, int keyType, boolean isDownloadSuccessful) {
        TelephonyProto.TelephonyEvent.CarrierKeyChange carrierKeyChange = new TelephonyProto.TelephonyEvent.CarrierKeyChange();
        carrierKeyChange.keyType = keyType;
        carrierKeyChange.isDownloadSuccessful = isDownloadSuccessful;
        TelephonyProto.TelephonyEvent event = new TelephonyEventBuilder(phoneId).setCarrierKeyChange(carrierKeyChange).build();
        this.addTelephonyEvent(event);
    }

    static int toPrivacyFuzzedTimeInterval(long previousTimestamp, long currentTimestamp) {
        long diff = currentTimestamp - previousTimestamp;
        if (diff < 0L) {
            return 0;
        }
        if (diff <= 10L) {
            return 1;
        }
        if (diff <= 20L) {
            return 2;
        }
        if (diff <= 50L) {
            return 3;
        }
        if (diff <= 100L) {
            return 4;
        }
        if (diff <= 200L) {
            return 5;
        }
        if (diff <= 500L) {
            return 6;
        }
        if (diff <= 1000L) {
            return 7;
        }
        if (diff <= 2000L) {
            return 8;
        }
        if (diff <= 5000L) {
            return 9;
        }
        if (diff <= 10000L) {
            return 10;
        }
        if (diff <= 30000L) {
            return 11;
        }
        if (diff <= 60000L) {
            return 12;
        }
        if (diff <= 180000L) {
            return 13;
        }
        if (diff <= 600000L) {
            return 14;
        }
        if (diff <= 1800000L) {
            return 15;
        }
        if (diff <= 3600000L) {
            return 16;
        }
        if (diff <= 0x6DDD00L) {
            return 17;
        }
        if (diff <= 14400000L) {
            return 18;
        }
        return 19;
    }

    private TelephonyProto.TelephonyServiceState toServiceStateProto(ServiceState serviceState) {
        TelephonyProto.TelephonyServiceState ssProto = new TelephonyProto.TelephonyServiceState();
        ssProto.voiceRoamingType = serviceState.getVoiceRoamingType();
        ssProto.dataRoamingType = serviceState.getDataRoamingType();
        ssProto.voiceOperator = new TelephonyProto.TelephonyServiceState.TelephonyOperator();
        if (serviceState.getVoiceOperatorAlphaLong() != null) {
            ssProto.voiceOperator.alphaLong = serviceState.getVoiceOperatorAlphaLong();
        }
        if (serviceState.getVoiceOperatorAlphaShort() != null) {
            ssProto.voiceOperator.alphaShort = serviceState.getVoiceOperatorAlphaShort();
        }
        if (serviceState.getVoiceOperatorNumeric() != null) {
            ssProto.voiceOperator.numeric = serviceState.getVoiceOperatorNumeric();
        }
        ssProto.dataOperator = new TelephonyProto.TelephonyServiceState.TelephonyOperator();
        if (serviceState.getDataOperatorAlphaLong() != null) {
            ssProto.dataOperator.alphaLong = serviceState.getDataOperatorAlphaLong();
        }
        if (serviceState.getDataOperatorAlphaShort() != null) {
            ssProto.dataOperator.alphaShort = serviceState.getDataOperatorAlphaShort();
        }
        if (serviceState.getDataOperatorNumeric() != null) {
            ssProto.dataOperator.numeric = serviceState.getDataOperatorNumeric();
        }
        ssProto.voiceRat = serviceState.getRilVoiceRadioTechnology();
        ssProto.dataRat = serviceState.getRilDataRadioTechnology();
        return ssProto;
    }

    private synchronized void annotateInProgressCallSession(long timestamp, int phoneId, CallSessionEventBuilder eventBuilder) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession != null) {
            callSession.addEvent(timestamp, eventBuilder);
        }
    }

    private synchronized void annotateInProgressSmsSession(long timestamp, int phoneId, SmsSessionEventBuilder eventBuilder) {
        InProgressSmsSession smsSession = this.mInProgressSmsSessions.get(phoneId);
        if (smsSession != null) {
            smsSession.addEvent(timestamp, eventBuilder);
        }
    }

    private synchronized InProgressCallSession startNewCallSessionIfNeeded(int phoneId) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            TelephonyProto.ImsConnectionState imsConnectionState;
            TelephonyProto.ImsCapabilities imsCapabilities;
            callSession = new InProgressCallSession(phoneId);
            this.mInProgressCallSessions.append(phoneId, callSession);
            TelephonyProto.TelephonyServiceState serviceState = this.mLastServiceState.get(phoneId);
            if (serviceState != null) {
                callSession.addEvent(callSession.startElapsedTimeMs, new CallSessionEventBuilder(2).setServiceState(serviceState));
            }
            if ((imsCapabilities = this.mLastImsCapabilities.get(phoneId)) != null) {
                callSession.addEvent(callSession.startElapsedTimeMs, new CallSessionEventBuilder(4).setImsCapabilities(imsCapabilities));
            }
            if ((imsConnectionState = this.mLastImsConnectionState.get(phoneId)) != null) {
                callSession.addEvent(callSession.startElapsedTimeMs, new CallSessionEventBuilder(3).setImsConnectionState(imsConnectionState));
            }
        }
        return callSession;
    }

    private synchronized InProgressSmsSession startNewSmsSessionIfNeeded(int phoneId) {
        InProgressSmsSession smsSession = this.mInProgressSmsSessions.get(phoneId);
        if (smsSession == null) {
            TelephonyProto.ImsConnectionState imsConnectionState;
            TelephonyProto.ImsCapabilities imsCapabilities;
            smsSession = new InProgressSmsSession(phoneId);
            this.mInProgressSmsSessions.append(phoneId, smsSession);
            TelephonyProto.TelephonyServiceState serviceState = this.mLastServiceState.get(phoneId);
            if (serviceState != null) {
                smsSession.addEvent(smsSession.startElapsedTimeMs, new SmsSessionEventBuilder(2).setServiceState(serviceState));
            }
            if ((imsCapabilities = this.mLastImsCapabilities.get(phoneId)) != null) {
                smsSession.addEvent(smsSession.startElapsedTimeMs, new SmsSessionEventBuilder(4).setImsCapabilities(imsCapabilities));
            }
            if ((imsConnectionState = this.mLastImsConnectionState.get(phoneId)) != null) {
                smsSession.addEvent(smsSession.startElapsedTimeMs, new SmsSessionEventBuilder(3).setImsConnectionState(imsConnectionState));
            }
        }
        return smsSession;
    }

    private synchronized void finishCallSession(InProgressCallSession inProgressCallSession) {
        TelephonyProto.TelephonyCallSession callSession = new TelephonyProto.TelephonyCallSession();
        callSession.events = new TelephonyProto.TelephonyCallSession.Event[inProgressCallSession.events.size()];
        inProgressCallSession.events.toArray(callSession.events);
        callSession.startTimeMinutes = inProgressCallSession.startSystemTimeMin;
        callSession.phoneId = inProgressCallSession.phoneId;
        callSession.eventsDropped = inProgressCallSession.isEventsDropped();
        if (this.mCompletedCallSessions.size() >= 50) {
            this.mCompletedCallSessions.removeFirst();
        }
        this.mCompletedCallSessions.add(callSession);
        this.mInProgressCallSessions.remove(inProgressCallSession.phoneId);
    }

    private synchronized void finishSmsSessionIfNeeded(InProgressSmsSession inProgressSmsSession) {
        if (inProgressSmsSession.getNumExpectedResponses() == 0) {
            TelephonyProto.SmsSession smsSession = new TelephonyProto.SmsSession();
            smsSession.events = new TelephonyProto.SmsSession.Event[inProgressSmsSession.events.size()];
            inProgressSmsSession.events.toArray(smsSession.events);
            smsSession.startTimeMinutes = inProgressSmsSession.startSystemTimeMin;
            smsSession.phoneId = inProgressSmsSession.phoneId;
            smsSession.eventsDropped = inProgressSmsSession.isEventsDropped();
            if (this.mCompletedSmsSessions.size() >= 500) {
                this.mCompletedSmsSessions.removeFirst();
            }
            this.mCompletedSmsSessions.add(smsSession);
            this.mInProgressSmsSessions.remove(inProgressSmsSession.phoneId);
        }
    }

    private synchronized void addTelephonyEvent(TelephonyProto.TelephonyEvent event) {
        if (this.mTelephonyEvents.size() >= 1000) {
            this.mTelephonyEvents.removeFirst();
            this.mTelephonyEventsDropped = true;
        }
        this.mTelephonyEvents.add(event);
    }

    public synchronized void writeServiceStateChanged(int phoneId, ServiceState serviceState) {
        TelephonyProto.TelephonyEvent event = new TelephonyEventBuilder(phoneId).setServiceState(this.toServiceStateProto(serviceState)).build();
        if (this.mLastServiceState.get(phoneId) != null && Arrays.equals(TelephonyProto.TelephonyServiceState.toByteArray(this.mLastServiceState.get(phoneId)), TelephonyProto.TelephonyServiceState.toByteArray(event.serviceState))) {
            return;
        }
        this.mLastServiceState.put(phoneId, event.serviceState);
        this.addTelephonyEvent(event);
        this.annotateInProgressCallSession(event.timestampMillis, phoneId, new CallSessionEventBuilder(2).setServiceState(event.serviceState));
        this.annotateInProgressSmsSession(event.timestampMillis, phoneId, new SmsSessionEventBuilder(2).setServiceState(event.serviceState));
    }

    public void writeDataStallEvent(int phoneId, int recoveryAction) {
        this.addTelephonyEvent(new TelephonyEventBuilder(phoneId).setDataStallRecoveryAction(recoveryAction).build());
    }

    public void writeImsSetFeatureValue(int phoneId, int feature, int network, int value) {
        TelephonyProto.TelephonySettings s = new TelephonyProto.TelephonySettings();
        if (network == 0) {
            switch (feature) {
                case 1: {
                    s.isEnhanced4GLteModeEnabled = value != 0;
                    break;
                }
                case 2: {
                    s.isVtOverLteEnabled = value != 0;
                }
            }
        } else if (network == 1) {
            switch (feature) {
                case 1: {
                    s.isWifiCallingEnabled = value != 0;
                    break;
                }
                case 2: {
                    boolean bl = s.isVtOverWifiEnabled = value != 0;
                }
            }
        }
        if (this.mLastSettings.get(phoneId) != null && Arrays.equals(TelephonyProto.TelephonySettings.toByteArray(this.mLastSettings.get(phoneId)), TelephonyProto.TelephonySettings.toByteArray(s))) {
            return;
        }
        this.mLastSettings.put(phoneId, s);
        TelephonyProto.TelephonyEvent event = new TelephonyEventBuilder(phoneId).setSettings(s).build();
        this.addTelephonyEvent(event);
        this.annotateInProgressCallSession(event.timestampMillis, phoneId, new CallSessionEventBuilder(1).setSettings(s));
        this.annotateInProgressSmsSession(event.timestampMillis, phoneId, new SmsSessionEventBuilder(1).setSettings(s));
    }

    public void writeSetPreferredNetworkType(int phoneId, int networkType) {
        TelephonyProto.TelephonySettings s = new TelephonyProto.TelephonySettings();
        s.preferredNetworkMode = networkType + 1;
        if (this.mLastSettings.get(phoneId) != null && Arrays.equals(TelephonyProto.TelephonySettings.toByteArray(this.mLastSettings.get(phoneId)), TelephonyProto.TelephonySettings.toByteArray(s))) {
            return;
        }
        this.mLastSettings.put(phoneId, s);
        this.addTelephonyEvent(new TelephonyEventBuilder(phoneId).setSettings(s).build());
    }

    public synchronized void writeOnImsConnectionState(int phoneId, int state, ImsReasonInfo reasonInfo) {
        TelephonyProto.ImsConnectionState imsState = new TelephonyProto.ImsConnectionState();
        imsState.state = state;
        if (reasonInfo != null) {
            TelephonyProto.ImsReasonInfo ri = new TelephonyProto.ImsReasonInfo();
            ri.reasonCode = reasonInfo.getCode();
            ri.extraCode = reasonInfo.getExtraCode();
            String extraMessage = reasonInfo.getExtraMessage();
            if (extraMessage != null) {
                ri.extraMessage = extraMessage;
            }
            imsState.reasonInfo = ri;
        }
        if (this.mLastImsConnectionState.get(phoneId) != null && Arrays.equals(TelephonyProto.ImsConnectionState.toByteArray(this.mLastImsConnectionState.get(phoneId)), TelephonyProto.ImsConnectionState.toByteArray(imsState))) {
            return;
        }
        this.mLastImsConnectionState.put(phoneId, imsState);
        TelephonyProto.TelephonyEvent event = new TelephonyEventBuilder(phoneId).setImsConnectionState(imsState).build();
        this.addTelephonyEvent(event);
        this.annotateInProgressCallSession(event.timestampMillis, phoneId, new CallSessionEventBuilder(3).setImsConnectionState(event.imsConnectionState));
        this.annotateInProgressSmsSession(event.timestampMillis, phoneId, new SmsSessionEventBuilder(3).setImsConnectionState(event.imsConnectionState));
    }

    public synchronized void writeOnImsCapabilities(int phoneId, int radioTech, MmTelFeature.MmTelCapabilities capabilities) {
        TelephonyProto.ImsCapabilities cap = new TelephonyProto.ImsCapabilities();
        if (radioTech == 0) {
            cap.voiceOverLte = capabilities.isCapable(1);
            cap.videoOverLte = capabilities.isCapable(2);
            cap.utOverLte = capabilities.isCapable(4);
        } else if (radioTech == 1) {
            cap.voiceOverWifi = capabilities.isCapable(1);
            cap.videoOverWifi = capabilities.isCapable(2);
            cap.utOverWifi = capabilities.isCapable(4);
        }
        TelephonyProto.TelephonyEvent event = new TelephonyEventBuilder(phoneId).setImsCapabilities(cap).build();
        if (this.mLastImsCapabilities.get(phoneId) != null && Arrays.equals(TelephonyProto.ImsCapabilities.toByteArray(this.mLastImsCapabilities.get(phoneId)), TelephonyProto.ImsCapabilities.toByteArray(cap))) {
            return;
        }
        this.mLastImsCapabilities.put(phoneId, cap);
        this.addTelephonyEvent(event);
        this.annotateInProgressCallSession(event.timestampMillis, phoneId, new CallSessionEventBuilder(4).setImsCapabilities(event.imsCapabilities));
        this.annotateInProgressSmsSession(event.timestampMillis, phoneId, new SmsSessionEventBuilder(4).setImsCapabilities(event.imsCapabilities));
    }

    private int toPdpType(String type) {
        switch (type) {
            case "IP": {
                return 1;
            }
            case "IPV6": {
                return 2;
            }
            case "IPV4V6": {
                return 3;
            }
            case "PPP": {
                return 4;
            }
        }
        Rlog.e(TAG, "Unknown type: " + type);
        return 0;
    }

    public void writeSetupDataCall(int phoneId, int radioTechnology, int profileId, String apn, String protocol) {
        TelephonyProto.TelephonyEvent.RilSetupDataCall setupDataCall = new TelephonyProto.TelephonyEvent.RilSetupDataCall();
        setupDataCall.rat = radioTechnology;
        setupDataCall.dataProfile = profileId + 1;
        if (apn != null) {
            setupDataCall.apn = apn;
        }
        if (protocol != null) {
            setupDataCall.type = this.toPdpType(protocol);
        }
        this.addTelephonyEvent(new TelephonyEventBuilder(phoneId).setSetupDataCall(setupDataCall).build());
    }

    public void writeRilDeactivateDataCall(int phoneId, int rilSerial, int cid, int reason) {
        TelephonyProto.TelephonyEvent.RilDeactivateDataCall deactivateDataCall = new TelephonyProto.TelephonyEvent.RilDeactivateDataCall();
        deactivateDataCall.cid = cid;
        switch (reason) {
            case 1: {
                deactivateDataCall.reason = 1;
                break;
            }
            case 2: {
                deactivateDataCall.reason = 2;
                break;
            }
            case 3: {
                deactivateDataCall.reason = 4;
                break;
            }
            default: {
                deactivateDataCall.reason = 0;
            }
        }
        this.addTelephonyEvent(new TelephonyEventBuilder(phoneId).setDeactivateDataCall(deactivateDataCall).build());
    }

    public void writeRilDataCallList(int phoneId, ArrayList<DataCallResponse> dcsList) {
        TelephonyProto.RilDataCall[] dataCalls = new TelephonyProto.RilDataCall[dcsList.size()];
        for (int i = 0; i < dcsList.size(); ++i) {
            dataCalls[i] = new TelephonyProto.RilDataCall();
            dataCalls[i].cid = dcsList.get(i).getCallId();
            if (!TextUtils.isEmpty(dcsList.get(i).getIfname())) {
                dataCalls[i].iframe = dcsList.get(i).getIfname();
            }
            if (TextUtils.isEmpty(dcsList.get(i).getType())) continue;
            dataCalls[i].type = this.toPdpType(dcsList.get(i).getType());
        }
        this.addTelephonyEvent(new TelephonyEventBuilder(phoneId).setDataCalls(dataCalls).build());
    }

    public void writeRilCallList(int phoneId, ArrayList<GsmCdmaConnection> connections) {
        InProgressCallSession callSession = this.startNewCallSessionIfNeeded(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "writeRilCallList: Call session is missing");
        } else {
            TelephonyProto.TelephonyCallSession.Event.RilCall[] calls = this.convertConnectionsToRilCalls(connections);
            callSession.addEvent(new CallSessionEventBuilder(10).setRilCalls(calls));
            if (callSession.isPhoneIdle() && this.disconnectReasonsKnown(calls)) {
                this.finishCallSession(callSession);
            }
        }
    }

    private boolean disconnectReasonsKnown(TelephonyProto.TelephonyCallSession.Event.RilCall[] calls) {
        for (TelephonyProto.TelephonyCallSession.Event.RilCall call : calls) {
            if (call.callEndReason != 0) continue;
            return false;
        }
        return true;
    }

    private TelephonyProto.TelephonyCallSession.Event.RilCall[] convertConnectionsToRilCalls(ArrayList<GsmCdmaConnection> mConnections) {
        TelephonyProto.TelephonyCallSession.Event.RilCall[] calls = new TelephonyProto.TelephonyCallSession.Event.RilCall[mConnections.size()];
        for (int i = 0; i < mConnections.size(); ++i) {
            calls[i] = new TelephonyProto.TelephonyCallSession.Event.RilCall();
            calls[i].index = i;
            this.convertConnectionToRilCall(mConnections.get(i), calls[i]);
        }
        return calls;
    }

    private void convertConnectionToRilCall(GsmCdmaConnection conn, TelephonyProto.TelephonyCallSession.Event.RilCall call) {
        call.type = conn.isIncoming() ? 2 : 1;
        switch (conn.getState()) {
            case IDLE: {
                call.state = 1;
                break;
            }
            case ACTIVE: {
                call.state = 2;
                break;
            }
            case HOLDING: {
                call.state = 3;
                break;
            }
            case DIALING: {
                call.state = 4;
                break;
            }
            case ALERTING: {
                call.state = 5;
                break;
            }
            case INCOMING: {
                call.state = 6;
                break;
            }
            case WAITING: {
                call.state = 7;
                break;
            }
            case DISCONNECTED: {
                call.state = 8;
                break;
            }
            case DISCONNECTING: {
                call.state = 9;
                break;
            }
            default: {
                call.state = 0;
            }
        }
        call.callEndReason = conn.getDisconnectCause();
        call.isMultiparty = conn.isMultiparty();
    }

    public void writeRilDial(int phoneId, GsmCdmaConnection conn, int clirMode, UUSInfo uusInfo) {
        InProgressCallSession callSession = this.startNewCallSessionIfNeeded(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "writeRilDial: Call session is missing");
        } else {
            TelephonyProto.TelephonyCallSession.Event.RilCall[] calls = new TelephonyProto.TelephonyCallSession.Event.RilCall[]{new TelephonyProto.TelephonyCallSession.Event.RilCall()};
            calls[0].index = -1;
            this.convertConnectionToRilCall(conn, calls[0]);
            callSession.addEvent(callSession.startElapsedTimeMs, new CallSessionEventBuilder(6).setRilRequest(1).setRilCalls(calls));
        }
    }

    public void writeRilCallRing(int phoneId, char[] response) {
        InProgressCallSession callSession = this.startNewCallSessionIfNeeded(phoneId);
        callSession.addEvent(callSession.startElapsedTimeMs, new CallSessionEventBuilder(8));
    }

    public void writeRilHangup(int phoneId, GsmCdmaConnection conn, int callId) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "writeRilHangup: Call session is missing");
        } else {
            TelephonyProto.TelephonyCallSession.Event.RilCall[] calls = new TelephonyProto.TelephonyCallSession.Event.RilCall[]{new TelephonyProto.TelephonyCallSession.Event.RilCall()};
            calls[0].index = callId;
            this.convertConnectionToRilCall(conn, calls[0]);
            callSession.addEvent(new CallSessionEventBuilder(6).setRilRequest(3).setRilCalls(calls));
        }
    }

    public void writeRilAnswer(int phoneId, int rilSerial) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "writeRilAnswer: Call session is missing");
        } else {
            callSession.addEvent(new CallSessionEventBuilder(6).setRilRequest(2).setRilRequestId(rilSerial));
        }
    }

    public void writeRilSrvcc(int phoneId, int rilSrvccState) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "writeRilSrvcc: Call session is missing");
        } else {
            callSession.addEvent(new CallSessionEventBuilder(9).setSrvccState(rilSrvccState + 1));
        }
    }

    private int toCallSessionRilRequest(int r) {
        switch (r) {
            case 10: {
                return 1;
            }
            case 40: {
                return 2;
            }
            case 12: 
            case 13: 
            case 14: {
                return 3;
            }
            case 36: {
                return 4;
            }
            case 15: {
                return 5;
            }
            case 84: {
                return 6;
            }
            case 16: {
                return 7;
            }
        }
        Rlog.e(TAG, "Unknown RIL request: " + r);
        return 0;
    }

    private void writeOnSetupDataCallResponse(int phoneId, int rilSerial, int rilError, int rilRequest, SetupDataCallResult result) {
        TelephonyProto.TelephonyEvent.RilSetupDataCallResponse setupDataCallResponse = new TelephonyProto.TelephonyEvent.RilSetupDataCallResponse();
        TelephonyProto.RilDataCall dataCall = new TelephonyProto.RilDataCall();
        if (result != null) {
            setupDataCallResponse.status = result.status == 0 ? 1 : result.status;
            setupDataCallResponse.suggestedRetryTimeMillis = result.suggestedRetryTime;
            dataCall.cid = result.cid;
            if (!TextUtils.isEmpty(result.type)) {
                dataCall.type = this.toPdpType(result.type);
            }
            if (!TextUtils.isEmpty(result.ifname)) {
                dataCall.iframe = result.ifname;
            }
        }
        setupDataCallResponse.call = dataCall;
        this.addTelephonyEvent(new TelephonyEventBuilder(phoneId).setSetupDataCallResponse(setupDataCallResponse).build());
    }

    private void writeOnCallSolicitedResponse(int phoneId, int rilSerial, int rilError, int rilRequest) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "writeOnCallSolicitedResponse: Call session is missing");
        } else {
            callSession.addEvent(new CallSessionEventBuilder(7).setRilRequest(this.toCallSessionRilRequest(rilRequest)).setRilRequestId(rilSerial).setRilError(rilError + 1));
        }
    }

    private synchronized void writeOnSmsSolicitedResponse(int phoneId, int rilSerial, int rilError, SmsResponse response) {
        InProgressSmsSession smsSession = this.mInProgressSmsSessions.get(phoneId);
        if (smsSession == null) {
            Rlog.e(TAG, "SMS session is missing");
        } else {
            int errorCode = 0;
            if (response != null) {
                errorCode = response.mErrorCode;
            }
            smsSession.addEvent(new SmsSessionEventBuilder(7).setErrorCode(errorCode).setRilErrno(rilError + 1).setRilRequestId(rilSerial));
            smsSession.decreaseExpectedResponse();
            this.finishSmsSessionIfNeeded(smsSession);
        }
    }

    private void writeOnDeactivateDataCallResponse(int phoneId, int rilError) {
        this.addTelephonyEvent(new TelephonyEventBuilder(phoneId).setDeactivateDataCallResponse(rilError + 1).build());
    }

    public void writeOnRilSolicitedResponse(int phoneId, int rilSerial, int rilError, int rilRequest, Object ret) {
        switch (rilRequest) {
            case 27: {
                SetupDataCallResult result = (SetupDataCallResult)ret;
                this.writeOnSetupDataCallResponse(phoneId, rilSerial, rilError, rilRequest, result);
                break;
            }
            case 41: {
                this.writeOnDeactivateDataCallResponse(phoneId, rilError);
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 40: {
                this.writeOnCallSolicitedResponse(phoneId, rilSerial, rilError, rilRequest);
                break;
            }
            case 25: 
            case 26: 
            case 87: 
            case 113: {
                SmsResponse smsResponse = (SmsResponse)ret;
                this.writeOnSmsSolicitedResponse(phoneId, rilSerial, rilError, smsResponse);
            }
        }
    }

    public void writePhoneState(int phoneId, PhoneConstants.State phoneState) {
        int state;
        switch (phoneState) {
            case IDLE: {
                state = 1;
                break;
            }
            case RINGING: {
                state = 2;
                break;
            }
            case OFFHOOK: {
                state = 3;
                break;
            }
            default: {
                state = 0;
            }
        }
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "writePhoneState: Call session is missing");
        } else {
            callSession.setLastKnownPhoneState(state);
            if (state == 1 && !callSession.containsCsCalls()) {
                this.finishCallSession(callSession);
            }
            callSession.addEvent(new CallSessionEventBuilder(20).setPhoneState(state));
        }
    }

    private int getCallId(ImsCallSession session) {
        if (session == null) {
            return -1;
        }
        try {
            return Integer.parseInt(session.getCallId());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public void writeImsCallState(int phoneId, ImsCallSession session, Call.State callState) {
        int state;
        switch (callState) {
            case IDLE: {
                state = 1;
                break;
            }
            case ACTIVE: {
                state = 2;
                break;
            }
            case HOLDING: {
                state = 3;
                break;
            }
            case DIALING: {
                state = 4;
                break;
            }
            case ALERTING: {
                state = 5;
                break;
            }
            case INCOMING: {
                state = 6;
                break;
            }
            case WAITING: {
                state = 7;
                break;
            }
            case DISCONNECTED: {
                state = 8;
                break;
            }
            case DISCONNECTING: {
                state = 9;
                break;
            }
            default: {
                state = 0;
            }
        }
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "Call session is missing");
        } else {
            callSession.addEvent(new CallSessionEventBuilder(16).setCallIndex(this.getCallId(session)).setCallState(state));
        }
    }

    public void writeOnImsCallStart(int phoneId, ImsCallSession session) {
        InProgressCallSession callSession = this.startNewCallSessionIfNeeded(phoneId);
        callSession.addEvent(new CallSessionEventBuilder(11).setCallIndex(this.getCallId(session)).setImsCommand(1));
    }

    public void writeOnImsCallReceive(int phoneId, ImsCallSession session) {
        InProgressCallSession callSession = this.startNewCallSessionIfNeeded(phoneId);
        callSession.addEvent(new CallSessionEventBuilder(15).setCallIndex(this.getCallId(session)));
    }

    public void writeOnImsCommand(int phoneId, ImsCallSession session, int command) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "Call session is missing");
        } else {
            callSession.addEvent(new CallSessionEventBuilder(11).setCallIndex(this.getCallId(session)).setImsCommand(command));
        }
    }

    private TelephonyProto.ImsReasonInfo toImsReasonInfoProto(ImsReasonInfo reasonInfo) {
        TelephonyProto.ImsReasonInfo ri = new TelephonyProto.ImsReasonInfo();
        if (reasonInfo != null) {
            ri.reasonCode = reasonInfo.getCode();
            ri.extraCode = reasonInfo.getExtraCode();
            String extraMessage = reasonInfo.getExtraMessage();
            if (extraMessage != null) {
                ri.extraMessage = extraMessage;
            }
        }
        return ri;
    }

    public void writeOnImsCallTerminated(int phoneId, ImsCallSession session, ImsReasonInfo reasonInfo) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "Call session is missing");
        } else {
            callSession.addEvent(new CallSessionEventBuilder(17).setCallIndex(this.getCallId(session)).setImsReasonInfo(this.toImsReasonInfoProto(reasonInfo)));
        }
    }

    public void writeOnImsCallHandoverEvent(int phoneId, int eventType, ImsCallSession session, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
        InProgressCallSession callSession = this.mInProgressCallSessions.get(phoneId);
        if (callSession == null) {
            Rlog.e(TAG, "Call session is missing");
        } else {
            callSession.addEvent(new CallSessionEventBuilder(eventType).setCallIndex(this.getCallId(session)).setSrcAccessTech(srcAccessTech).setTargetAccessTech(targetAccessTech).setImsReasonInfo(this.toImsReasonInfoProto(reasonInfo)));
        }
    }

    public synchronized void writeRilSendSms(int phoneId, int rilSerial, int tech, int format) {
        InProgressSmsSession smsSession = this.startNewSmsSessionIfNeeded(phoneId);
        smsSession.addEvent(new SmsSessionEventBuilder(6).setTech(tech).setRilRequestId(rilSerial).setFormat(format));
        smsSession.increaseExpectedResponse();
    }

    public synchronized void writeRilNewSms(int phoneId, int tech, int format) {
        InProgressSmsSession smsSession = this.startNewSmsSessionIfNeeded(phoneId);
        smsSession.addEvent(new SmsSessionEventBuilder(8).setTech(tech).setFormat(format));
        this.finishSmsSessionIfNeeded(smsSession);
    }

    public synchronized void writeNewCBSms(int phoneId, int format, int priority, boolean isCMAS, boolean isETWS, int serviceCategory) {
        InProgressSmsSession smsSession = this.startNewSmsSessionIfNeeded(phoneId);
        int type = isCMAS ? 2 : (isETWS ? 1 : 3);
        TelephonyProto.SmsSession.Event.CBMessage cbm = new TelephonyProto.SmsSession.Event.CBMessage();
        cbm.msgFormat = format;
        cbm.msgPriority = priority + 1;
        cbm.msgType = type;
        cbm.serviceCategory = serviceCategory;
        smsSession.addEvent(new SmsSessionEventBuilder(9).setCellBroadcastMessage(cbm));
        this.finishSmsSessionIfNeeded(smsSession);
    }

    public void writeNITZEvent(int phoneId, long timestamp) {
        TelephonyProto.TelephonyEvent event = new TelephonyEventBuilder(phoneId).setNITZ(timestamp).build();
        this.addTelephonyEvent(event);
        this.annotateInProgressCallSession(event.timestampMillis, phoneId, new CallSessionEventBuilder(21).setNITZ(timestamp));
    }

    public void writeModemRestartEvent(int phoneId, String reason) {
        TelephonyProto.TelephonyEvent.ModemRestart modemRestart = new TelephonyProto.TelephonyEvent.ModemRestart();
        String basebandVersion = Build.getRadioVersion();
        if (basebandVersion != null) {
            modemRestart.basebandVersion = basebandVersion;
        }
        if (reason != null) {
            modemRestart.reason = reason;
        }
        TelephonyProto.TelephonyEvent event = new TelephonyEventBuilder(phoneId).setModemRestart(modemRestart).build();
        this.addTelephonyEvent(event);
    }

    public void writeCarrierIdMatchingEvent(int phoneId, int version, int cid, String gid1) {
        TelephonyProto.TelephonyEvent.CarrierIdMatching carrierIdMatching = new TelephonyProto.TelephonyEvent.CarrierIdMatching();
        TelephonyProto.TelephonyEvent.CarrierIdMatchingResult carrierIdMatchingResult = new TelephonyProto.TelephonyEvent.CarrierIdMatchingResult();
        if (cid != -1) {
            carrierIdMatchingResult.carrierId = cid;
            if (gid1 != null) {
                carrierIdMatchingResult.gid1 = gid1;
            }
        }
        carrierIdMatching.cidTableVersion = version;
        carrierIdMatching.result = carrierIdMatchingResult;
        TelephonyProto.TelephonyEvent event = new TelephonyEventBuilder(phoneId).setCarrierIdMatching(carrierIdMatching).build();
        this.addTelephonyEvent(event);
    }

    public void writeOnImsCallProgressing(int phoneId, ImsCallSession session) {
    }

    public void writeOnImsCallStarted(int phoneId, ImsCallSession session) {
    }

    public void writeOnImsCallStartFailed(int phoneId, ImsCallSession session, ImsReasonInfo reasonInfo) {
    }

    public void writeOnImsCallHeld(int phoneId, ImsCallSession session) {
    }

    public void writeOnImsCallHoldReceived(int phoneId, ImsCallSession session) {
    }

    public void writeOnImsCallHoldFailed(int phoneId, ImsCallSession session, ImsReasonInfo reasonInfo) {
    }

    public void writeOnImsCallResumed(int phoneId, ImsCallSession session) {
    }

    public void writeOnImsCallResumeReceived(int phoneId, ImsCallSession session) {
    }

    public void writeOnImsCallResumeFailed(int phoneId, ImsCallSession session, ImsReasonInfo reasonInfo) {
    }

    public void writeOnRilTimeoutResponse(int phoneId, int rilSerial, int rilRequest) {
    }
}

