/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import android.hardware.radio.V1_0.DataRegStateResult;
import android.hardware.radio.V1_0.SetupDataCallResult;
import android.hardware.radio.V1_0.VoiceRegStateResult;
import android.net.KeepalivePacketData;
import android.net.LinkProperties;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.SystemClock;
import android.os.WorkSource;
import android.service.carrier.CarrierIdentifier;
import android.telephony.CellInfo;
import android.telephony.CellInfoGsm;
import android.telephony.ImsiEncryptionInfo;
import android.telephony.NetworkScanRequest;
import android.telephony.Rlog;
import android.telephony.SignalStrength;
import android.telephony.data.DataProfile;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.BaseCommands;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.LastCallFailCause;
import com.android.internal.telephony.RadioCapability;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CdmaSmsBroadcastConfigInfo;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.test.SimulatedCommandsVerifier;
import com.android.internal.telephony.test.SimulatedGsmCallState;
import com.android.internal.telephony.test.SimulatedRadioControl;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccSlotStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class SimulatedCommands
extends BaseCommands
implements CommandsInterface,
SimulatedRadioControl {
    private static final String LOG_TAG = "SimulatedCommands";
    private static final SimLockState INITIAL_LOCK_STATE = SimLockState.NONE;
    public static final String DEFAULT_SIM_PIN_CODE = "1234";
    private static final String SIM_PUK_CODE = "12345678";
    private static final SimFdnState INITIAL_FDN_STATE = SimFdnState.NONE;
    public static final String DEFAULT_SIM_PIN2_CODE = "5678";
    private static final String SIM_PUK2_CODE = "87654321";
    public static final String FAKE_LONG_NAME = "Fake long name";
    public static final String FAKE_SHORT_NAME = "Fake short name";
    public static final String FAKE_MCC_MNC = "310260";
    public static final String FAKE_IMEI = "012345678901234";
    public static final String FAKE_IMEISV = "99";
    public static final String FAKE_ESN = "1234";
    public static final String FAKE_MEID = "1234";
    public static final int DEFAULT_PIN1_ATTEMPT = 5;
    public static final int DEFAULT_PIN2_ATTEMPT = 5;
    private String mImei;
    private String mImeiSv;
    SimulatedGsmCallState simulatedCallState;
    HandlerThread mHandlerThread;
    SimLockState mSimLockedState;
    boolean mSimLockEnabled;
    int mPinUnlockAttempts;
    int mPukUnlockAttempts;
    String mPinCode;
    int mPin1attemptsRemaining = 5;
    SimFdnState mSimFdnEnabledState;
    boolean mSimFdnEnabled;
    int mPin2UnlockAttempts;
    int mPuk2UnlockAttempts;
    int mNetworkType;
    String mPin2Code;
    boolean mSsnNotifyOn = false;
    private int mVoiceRegState = 1;
    private int mVoiceRadioTech = 3;
    private int mDataRegState = 1;
    private int mDataRadioTech = 3;
    public boolean mCssSupported;
    public int mRoamingIndicator;
    public int mSystemIsInPrl;
    public int mDefaultRoamingIndicator;
    public int mReasonForDenial;
    public int mMaxDataCalls;
    private SignalStrength mSignalStrength;
    private List<CellInfo> mCellInfoList;
    private int[] mImsRegState;
    private IccCardStatus mIccCardStatus;
    private IccSlotStatus mIccSlotStatus;
    private IccIoResult mIccIoResultForApduLogicalChannel;
    private int mChannelId = -1;
    int mPausedResponseCount;
    ArrayList<Message> mPausedResponses = new ArrayList();
    int mNextCallFailCause = 16;
    private boolean mDcSuccess = true;
    private SetupDataCallResult mSetupDataCallResult;
    private boolean mIsRadioPowerFailResponse = false;
    private final AtomicInteger mGetVoiceRegistrationStateCallCount = new AtomicInteger(0);
    private final AtomicInteger mGetDataRegistrationStateCallCount = new AtomicInteger(0);
    private final AtomicInteger mGetOperatorCallCount = new AtomicInteger(0);
    private final AtomicInteger getNetworkSelectionModeCallCount = new AtomicInteger(0);
    private AtomicBoolean mAllowed = new AtomicBoolean(false);

    public SimulatedCommands() {
        super(null);
        this.mHandlerThread = new HandlerThread(LOG_TAG);
        this.mHandlerThread.start();
        Looper looper = this.mHandlerThread.getLooper();
        this.simulatedCallState = new SimulatedGsmCallState(looper);
        this.setRadioState(CommandsInterface.RadioState.RADIO_ON);
        this.mSimLockedState = INITIAL_LOCK_STATE;
        this.mSimLockEnabled = this.mSimLockedState != SimLockState.NONE;
        this.mPinCode = "1234";
        this.mSimFdnEnabledState = INITIAL_FDN_STATE;
        this.mSimFdnEnabled = this.mSimFdnEnabledState != SimFdnState.NONE;
        this.mPin2Code = DEFAULT_SIM_PIN2_CODE;
    }

    public void dispose() {
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quit();
        }
    }

    private void log(String str) {
        Rlog.d(LOG_TAG, str);
    }

    @Override
    public void getIccCardStatus(Message result) {
        SimulatedCommandsVerifier.getInstance().getIccCardStatus(result);
        if (this.mIccCardStatus != null) {
            this.resultSuccess(result, this.mIccCardStatus);
        } else {
            this.resultFail(result, null, new RuntimeException("IccCardStatus not set"));
        }
    }

    public void setIccSlotStatus(IccSlotStatus iccSlotStatus) {
        this.mIccSlotStatus = iccSlotStatus;
    }

    @Override
    public void getIccSlotsStatus(Message result) {
        SimulatedCommandsVerifier.getInstance().getIccSlotsStatus(result);
        if (this.mIccSlotStatus != null) {
            this.resultSuccess(result, this.mIccSlotStatus);
        } else {
            this.resultFail(result, null, new CommandException(CommandException.Error.REQUEST_NOT_SUPPORTED));
        }
    }

    @Override
    public void setLogicalToPhysicalSlotMapping(int[] physicalSlots, Message result) {
        this.unimplemented(result);
    }

    @Override
    public void supplyIccPin(String pin, Message result) {
        if (this.mSimLockedState != SimLockState.REQUIRE_PIN) {
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPin: wrong state, state=" + (Object)((Object)this.mSimLockedState));
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            this.resultFail(result, null, ex);
            return;
        }
        if (pin != null && pin.equals(this.mPinCode)) {
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPin: success!");
            this.mPinUnlockAttempts = 0;
            this.mSimLockedState = SimLockState.NONE;
            this.mIccStatusChangedRegistrants.notifyRegistrants();
            this.resultSuccess(result, null);
            return;
        }
        if (result != null) {
            ++this.mPinUnlockAttempts;
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPin: failed! attempt=" + this.mPinUnlockAttempts);
            if (this.mPinUnlockAttempts >= 5) {
                Rlog.i(LOG_TAG, "[SimCmd] supplyIccPin: set state to REQUIRE_PUK");
                this.mSimLockedState = SimLockState.REQUIRE_PUK;
            }
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            this.resultFail(result, null, ex);
        }
    }

    @Override
    public void supplyIccPuk(String puk, String newPin, Message result) {
        if (this.mSimLockedState != SimLockState.REQUIRE_PUK) {
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPuk: wrong state, state=" + (Object)((Object)this.mSimLockedState));
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            this.resultFail(result, null, ex);
            return;
        }
        if (puk != null && puk.equals(SIM_PUK_CODE)) {
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPuk: success!");
            this.mSimLockedState = SimLockState.NONE;
            this.mPukUnlockAttempts = 0;
            this.mIccStatusChangedRegistrants.notifyRegistrants();
            this.resultSuccess(result, null);
            return;
        }
        if (result != null) {
            ++this.mPukUnlockAttempts;
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPuk: failed! attempt=" + this.mPukUnlockAttempts);
            if (this.mPukUnlockAttempts >= 10) {
                Rlog.i(LOG_TAG, "[SimCmd] supplyIccPuk: set state to SIM_PERM_LOCKED");
                this.mSimLockedState = SimLockState.SIM_PERM_LOCKED;
            }
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            this.resultFail(result, null, ex);
        }
    }

    @Override
    public void supplyIccPin2(String pin2, Message result) {
        if (this.mSimFdnEnabledState != SimFdnState.REQUIRE_PIN2) {
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPin2: wrong state, state=" + (Object)((Object)this.mSimFdnEnabledState));
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            this.resultFail(result, null, ex);
            return;
        }
        if (pin2 != null && pin2.equals(this.mPin2Code)) {
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPin2: success!");
            this.mPin2UnlockAttempts = 0;
            this.mSimFdnEnabledState = SimFdnState.NONE;
            this.resultSuccess(result, null);
            return;
        }
        if (result != null) {
            ++this.mPin2UnlockAttempts;
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPin2: failed! attempt=" + this.mPin2UnlockAttempts);
            if (this.mPin2UnlockAttempts >= 5) {
                Rlog.i(LOG_TAG, "[SimCmd] supplyIccPin2: set state to REQUIRE_PUK2");
                this.mSimFdnEnabledState = SimFdnState.REQUIRE_PUK2;
            }
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            this.resultFail(result, null, ex);
        }
    }

    @Override
    public void supplyIccPuk2(String puk2, String newPin2, Message result) {
        if (this.mSimFdnEnabledState != SimFdnState.REQUIRE_PUK2) {
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPuk2: wrong state, state=" + (Object)((Object)this.mSimLockedState));
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            this.resultFail(result, null, ex);
            return;
        }
        if (puk2 != null && puk2.equals(SIM_PUK2_CODE)) {
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPuk2: success!");
            this.mSimFdnEnabledState = SimFdnState.NONE;
            this.mPuk2UnlockAttempts = 0;
            this.resultSuccess(result, null);
            return;
        }
        if (result != null) {
            ++this.mPuk2UnlockAttempts;
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPuk2: failed! attempt=" + this.mPuk2UnlockAttempts);
            if (this.mPuk2UnlockAttempts >= 10) {
                Rlog.i(LOG_TAG, "[SimCmd] supplyIccPuk2: set state to SIM_PERM_LOCKED");
                this.mSimFdnEnabledState = SimFdnState.SIM_PERM_LOCKED;
            }
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            this.resultFail(result, null, ex);
        }
    }

    @Override
    public void changeIccPin(String oldPin, String newPin, Message result) {
        if (oldPin != null && oldPin.equals(this.mPinCode)) {
            this.mPinCode = newPin;
            this.resultSuccess(result, null);
            return;
        }
        Rlog.i(LOG_TAG, "[SimCmd] changeIccPin: pin failed!");
        CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
        this.resultFail(result, null, ex);
    }

    @Override
    public void changeIccPin2(String oldPin2, String newPin2, Message result) {
        if (oldPin2 != null && oldPin2.equals(this.mPin2Code)) {
            this.mPin2Code = newPin2;
            this.resultSuccess(result, null);
            return;
        }
        Rlog.i(LOG_TAG, "[SimCmd] changeIccPin2: pin2 failed!");
        CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
        this.resultFail(result, null, ex);
    }

    @Override
    public void changeBarringPassword(String facility, String oldPwd, String newPwd, Message result) {
        this.unimplemented(result);
    }

    @Override
    public void setSuppServiceNotifications(boolean enable, Message result) {
        this.resultSuccess(result, null);
        if (enable && this.mSsnNotifyOn) {
            Rlog.w(LOG_TAG, "Supp Service Notifications already enabled!");
        }
        this.mSsnNotifyOn = enable;
    }

    @Override
    public void queryFacilityLock(String facility, String pin, int serviceClass, Message result) {
        this.queryFacilityLockForApp(facility, pin, serviceClass, null, result);
    }

    @Override
    public void queryFacilityLockForApp(String facility, String pin, int serviceClass, String appId, Message result) {
        if (facility != null && facility.equals("SC")) {
            if (result != null) {
                int[] r = new int[]{this.mSimLockEnabled ? 1 : 0};
                Rlog.i(LOG_TAG, "[SimCmd] queryFacilityLock: SIM is " + (r[0] == 0 ? "unlocked" : "locked"));
                this.resultSuccess(result, r);
            }
            return;
        }
        if (facility != null && facility.equals("FD")) {
            if (result != null) {
                int[] r = new int[]{this.mSimFdnEnabled ? 1 : 0};
                Rlog.i(LOG_TAG, "[SimCmd] queryFacilityLock: FDN is " + (r[0] == 0 ? "disabled" : "enabled"));
                this.resultSuccess(result, r);
            }
            return;
        }
        this.unimplemented(result);
    }

    @Override
    public void setFacilityLock(String facility, boolean lockEnabled, String pin, int serviceClass, Message result) {
        this.setFacilityLockForApp(facility, lockEnabled, pin, serviceClass, null, result);
    }

    @Override
    public void setFacilityLockForApp(String facility, boolean lockEnabled, String pin, int serviceClass, String appId, Message result) {
        if (facility != null && facility.equals("SC")) {
            if (pin != null && pin.equals(this.mPinCode)) {
                Rlog.i(LOG_TAG, "[SimCmd] setFacilityLock: pin is valid");
                this.mSimLockEnabled = lockEnabled;
                this.resultSuccess(result, null);
                return;
            }
            Rlog.i(LOG_TAG, "[SimCmd] setFacilityLock: pin failed!");
            CommandException ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
            this.resultFail(result, null, ex);
            return;
        }
        if (facility != null && facility.equals("FD")) {
            if (pin != null && pin.equals(this.mPin2Code)) {
                Rlog.i(LOG_TAG, "[SimCmd] setFacilityLock: pin2 is valid");
                this.mSimFdnEnabled = lockEnabled;
                this.resultSuccess(result, null);
                return;
            }
            Rlog.i(LOG_TAG, "[SimCmd] setFacilityLock: pin2 failed!");
            CommandException ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
            this.resultFail(result, null, ex);
            return;
        }
        this.unimplemented(result);
    }

    @Override
    public void supplyNetworkDepersonalization(String netpin, Message result) {
        this.unimplemented(result);
    }

    @Override
    public void getCurrentCalls(Message result) {
        SimulatedCommandsVerifier.getInstance().getCurrentCalls(result);
        if (this.mState == CommandsInterface.RadioState.RADIO_ON && !this.isSimLocked()) {
            this.resultSuccess(result, this.simulatedCallState.getDriverCalls());
        } else {
            this.resultFail(result, null, new CommandException(CommandException.Error.RADIO_NOT_AVAILABLE));
        }
    }

    @Override
    @Deprecated
    public void getPDPContextList(Message result) {
        this.getDataCallList(result);
    }

    @Override
    public void getDataCallList(Message result) {
        this.resultSuccess(result, new ArrayList(0));
    }

    @Override
    public void dial(String address, int clirMode, Message result) {
        SimulatedCommandsVerifier.getInstance().dial(address, clirMode, result);
        this.simulatedCallState.onDial(address);
        this.resultSuccess(result, null);
    }

    @Override
    public void dial(String address, int clirMode, UUSInfo uusInfo, Message result) {
        SimulatedCommandsVerifier.getInstance().dial(address, clirMode, uusInfo, result);
        this.simulatedCallState.onDial(address);
        this.resultSuccess(result, null);
    }

    @Override
    public void getIMSI(Message result) {
        this.getIMSIForApp(null, result);
    }

    @Override
    public void getIMSIForApp(String aid, Message result) {
        this.resultSuccess(result, FAKE_IMEI);
    }

    public void setIMEI(String imei) {
        this.mImei = imei;
    }

    @Override
    public void getIMEI(Message result) {
        SimulatedCommandsVerifier.getInstance().getIMEI(result);
        this.resultSuccess(result, this.mImei != null ? this.mImei : FAKE_IMEI);
    }

    public void setIMEISV(String imeisv) {
        this.mImeiSv = imeisv;
    }

    @Override
    public void getIMEISV(Message result) {
        SimulatedCommandsVerifier.getInstance().getIMEISV(result);
        this.resultSuccess(result, this.mImeiSv != null ? this.mImeiSv : FAKE_IMEISV);
    }

    @Override
    public void hangupConnection(int gsmIndex, Message result) {
        boolean success = this.simulatedCallState.onChld('1', (char)(48 + gsmIndex));
        if (!success) {
            Rlog.i("GSM", "[SimCmd] hangupConnection: resultFail");
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            Rlog.i("GSM", "[SimCmd] hangupConnection: resultSuccess");
            this.resultSuccess(result, null);
        }
    }

    @Override
    public void hangupWaitingOrBackground(Message result) {
        boolean success = this.simulatedCallState.onChld('0', '\u0000');
        if (!success) {
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    @Override
    public void hangupForegroundResumeBackground(Message result) {
        boolean success = this.simulatedCallState.onChld('1', '\u0000');
        if (!success) {
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    @Override
    public void switchWaitingOrHoldingAndActive(Message result) {
        boolean success = this.simulatedCallState.onChld('2', '\u0000');
        if (!success) {
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    @Override
    public void conference(Message result) {
        boolean success = this.simulatedCallState.onChld('3', '\u0000');
        if (!success) {
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    @Override
    public void explicitCallTransfer(Message result) {
        boolean success = this.simulatedCallState.onChld('4', '\u0000');
        if (!success) {
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    @Override
    public void separateConnection(int gsmIndex, Message result) {
        char ch = (char)(gsmIndex + 48);
        boolean success = this.simulatedCallState.onChld('2', ch);
        if (!success) {
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    @Override
    public void acceptCall(Message result) {
        SimulatedCommandsVerifier.getInstance().acceptCall(result);
        boolean success = this.simulatedCallState.onAnswer();
        if (!success) {
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    @Override
    public void rejectCall(Message result) {
        boolean success = this.simulatedCallState.onChld('0', '\u0000');
        if (!success) {
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    @Override
    public void getLastCallFailCause(Message result) {
        LastCallFailCause mFailCause = new LastCallFailCause();
        mFailCause.causeCode = this.mNextCallFailCause;
        this.resultSuccess(result, mFailCause);
    }

    @Override
    @Deprecated
    public void getLastPdpFailCause(Message result) {
        this.unimplemented(result);
    }

    @Override
    public void getLastDataCallFailCause(Message result) {
        this.unimplemented(result);
    }

    @Override
    public void setMute(boolean enableMute, Message result) {
        this.unimplemented(result);
    }

    @Override
    public void getMute(Message result) {
        this.unimplemented(result);
    }

    public void setSignalStrength(SignalStrength signalStrength) {
        this.mSignalStrength = signalStrength;
    }

    @Override
    public void getSignalStrength(Message result) {
        if (this.mSignalStrength == null) {
            this.mSignalStrength = new SignalStrength(20, 0, -1, -1, -1, -1, -1, 99, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        this.resultSuccess(result, this.mSignalStrength);
    }

    @Override
    public void setBandMode(int bandMode, Message result) {
        this.resultSuccess(result, null);
    }

    @Override
    public void queryAvailableBandMode(Message result) {
        int[] ret = new int[]{4, 2, 3, 4};
        this.resultSuccess(result, ret);
    }

    @Override
    public void sendTerminalResponse(String contents, Message response) {
        this.resultSuccess(response, null);
    }

    @Override
    public void sendEnvelope(String contents, Message response) {
        this.resultSuccess(response, null);
    }

    @Override
    public void sendEnvelopeWithStatus(String contents, Message response) {
        this.resultSuccess(response, null);
    }

    @Override
    public void handleCallSetupRequestFromSim(boolean accept, Message response) {
        this.resultSuccess(response, null);
    }

    public void setVoiceRadioTech(int voiceRadioTech) {
        this.mVoiceRadioTech = voiceRadioTech;
    }

    public void setVoiceRegState(int voiceRegState) {
        this.mVoiceRegState = voiceRegState;
    }

    @Override
    public void getVoiceRegistrationState(Message result) {
        this.mGetVoiceRegistrationStateCallCount.incrementAndGet();
        VoiceRegStateResult ret = new VoiceRegStateResult();
        ret.regState = this.mVoiceRegState;
        ret.rat = this.mVoiceRadioTech;
        ret.cssSupported = this.mCssSupported;
        ret.roamingIndicator = this.mRoamingIndicator;
        ret.systemIsInPrl = this.mSystemIsInPrl;
        ret.defaultRoamingIndicator = this.mDefaultRoamingIndicator;
        ret.reasonForDenial = this.mReasonForDenial;
        this.resultSuccess(result, ret);
    }

    @VisibleForTesting
    public int getGetVoiceRegistrationStateCallCount() {
        return this.mGetVoiceRegistrationStateCallCount.get();
    }

    public void setDataRadioTech(int radioTech) {
        this.mDataRadioTech = radioTech;
    }

    public void setDataRegState(int dataRegState) {
        this.mDataRegState = dataRegState;
    }

    @Override
    public void getDataRegistrationState(Message result) {
        this.mGetDataRegistrationStateCallCount.incrementAndGet();
        DataRegStateResult ret = new DataRegStateResult();
        ret.regState = this.mDataRegState;
        ret.rat = this.mDataRadioTech;
        ret.maxDataCalls = this.mMaxDataCalls;
        ret.reasonDataDenied = this.mReasonForDenial;
        this.resultSuccess(result, ret);
    }

    @VisibleForTesting
    public int getGetDataRegistrationStateCallCount() {
        return this.mGetDataRegistrationStateCallCount.get();
    }

    @Override
    public void getOperator(Message result) {
        this.mGetOperatorCallCount.incrementAndGet();
        String[] ret = new String[]{FAKE_LONG_NAME, FAKE_SHORT_NAME, FAKE_MCC_MNC};
        this.resultSuccess(result, ret);
    }

    @VisibleForTesting
    public int getGetOperatorCallCount() {
        int count = this.mGetOperatorCallCount.get();
        return this.mGetOperatorCallCount.get();
    }

    @Override
    public void sendDtmf(char c, Message result) {
        this.resultSuccess(result, null);
    }

    @Override
    public void startDtmf(char c, Message result) {
        this.resultSuccess(result, null);
    }

    @Override
    public void stopDtmf(Message result) {
        this.resultSuccess(result, null);
    }

    @Override
    public void sendBurstDtmf(String dtmfString, int on, int off, Message result) {
        SimulatedCommandsVerifier.getInstance().sendBurstDtmf(dtmfString, on, off, result);
        this.resultSuccess(result, null);
    }

    @Override
    public void sendSMS(String smscPDU, String pdu, Message result) {
        SimulatedCommandsVerifier.getInstance().sendSMS(smscPDU, pdu, result);
        this.resultSuccess(result, new SmsResponse(0, null, 0));
    }

    @Override
    public void sendSMSExpectMore(String smscPDU, String pdu, Message result) {
        this.unimplemented(result);
    }

    @Override
    public void deleteSmsOnSim(int index, Message response) {
        Rlog.d(LOG_TAG, "Delete message at index " + index);
        this.unimplemented(response);
    }

    @Override
    public void deleteSmsOnRuim(int index, Message response) {
        Rlog.d(LOG_TAG, "Delete RUIM message at index " + index);
        this.unimplemented(response);
    }

    @Override
    public void writeSmsToSim(int status, String smsc, String pdu, Message response) {
        Rlog.d(LOG_TAG, "Write SMS to SIM with status " + status);
        this.unimplemented(response);
    }

    @Override
    public void writeSmsToRuim(int status, String pdu, Message response) {
        Rlog.d(LOG_TAG, "Write SMS to RUIM with status " + status);
        this.unimplemented(response);
    }

    public void setDataCallResult(boolean success, SetupDataCallResult dcResult) {
        this.mSetupDataCallResult = dcResult;
        this.mDcSuccess = success;
    }

    public void triggerNITZupdate(String NITZStr) {
        if (NITZStr != null) {
            this.mNITZTimeRegistrant.notifyRegistrant(new AsyncResult(null, new Object[]{NITZStr, SystemClock.elapsedRealtime()}, null));
        }
    }

    @Override
    public void setupDataCall(int accessNetworkType, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, int reason, LinkProperties linkProperties, Message result) {
        SimulatedCommandsVerifier.getInstance().setupDataCall(accessNetworkType, dataProfile, isRoaming, allowRoaming, reason, linkProperties, result);
        if (this.mSetupDataCallResult == null) {
            try {
                this.mSetupDataCallResult = new SetupDataCallResult();
                this.mSetupDataCallResult.status = 0;
                this.mSetupDataCallResult.suggestedRetryTime = -1;
                this.mSetupDataCallResult.cid = 1;
                this.mSetupDataCallResult.active = 2;
                this.mSetupDataCallResult.type = "IP";
                this.mSetupDataCallResult.ifname = "rmnet_data7";
                this.mSetupDataCallResult.addresses = "12.34.56.78";
                this.mSetupDataCallResult.dnses = "98.76.54.32";
                this.mSetupDataCallResult.gateways = "11.22.33.44";
                this.mSetupDataCallResult.pcscf = "";
                this.mSetupDataCallResult.mtu = 1440;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mDcSuccess) {
            this.resultSuccess(result, this.mSetupDataCallResult);
        } else {
            this.resultFail(result, this.mSetupDataCallResult, new RuntimeException("Setup data call failed!"));
        }
    }

    @Override
    public void deactivateDataCall(int cid, int reason, Message result) {
        SimulatedCommandsVerifier.getInstance().deactivateDataCall(cid, reason, result);
        this.resultSuccess(result, null);
    }

    @Override
    public void setPreferredNetworkType(int networkType, Message result) {
        SimulatedCommandsVerifier.getInstance().setPreferredNetworkType(networkType, result);
        this.mNetworkType = networkType;
        this.resultSuccess(result, null);
    }

    @Override
    public void getPreferredNetworkType(Message result) {
        SimulatedCommandsVerifier.getInstance().getPreferredNetworkType(result);
        int[] ret = new int[]{this.mNetworkType};
        this.resultSuccess(result, ret);
    }

    @Override
    public void getNeighboringCids(Message result, WorkSource workSource) {
        int[] ret = new int[7];
        ret[0] = 6;
        for (int i = 1; i < 7; ++i) {
            ret[i] = i;
        }
        this.resultSuccess(result, ret);
    }

    @Override
    public void setLocationUpdates(boolean enable, Message response) {
        SimulatedCommandsVerifier.getInstance().setLocationUpdates(enable, response);
        this.resultSuccess(response, null);
    }

    @Override
    public void getSmscAddress(Message result) {
        this.unimplemented(result);
    }

    @Override
    public void setSmscAddress(String address, Message result) {
        this.unimplemented(result);
    }

    @Override
    public void reportSmsMemoryStatus(boolean available, Message result) {
        this.resultSuccess(result, null);
        SimulatedCommandsVerifier.getInstance().reportSmsMemoryStatus(available, result);
    }

    @Override
    public void reportStkServiceIsRunning(Message result) {
        this.resultSuccess(result, null);
    }

    @Override
    public void getCdmaSubscriptionSource(Message result) {
        this.unimplemented(result);
    }

    private boolean isSimLocked() {
        return this.mSimLockedState != SimLockState.NONE;
    }

    @Override
    public void setRadioPower(boolean on, Message result) {
        if (this.mIsRadioPowerFailResponse) {
            this.resultFail(result, null, new RuntimeException("setRadioPower failed!"));
            return;
        }
        if (on) {
            this.setRadioState(CommandsInterface.RadioState.RADIO_ON);
        } else {
            this.setRadioState(CommandsInterface.RadioState.RADIO_OFF);
        }
        this.resultSuccess(result, null);
    }

    @Override
    public void acknowledgeLastIncomingGsmSms(boolean success, int cause, Message result) {
        this.unimplemented(result);
        SimulatedCommandsVerifier.getInstance().acknowledgeLastIncomingGsmSms(success, cause, result);
    }

    @Override
    public void acknowledgeLastIncomingCdmaSms(boolean success, int cause, Message result) {
        this.unimplemented(result);
    }

    @Override
    public void acknowledgeIncomingGsmSmsWithPdu(boolean success, String ackPdu, Message result) {
        this.unimplemented(result);
    }

    @Override
    public void iccIO(int command, int fileid, String path, int p1, int p2, int p3, String data, String pin2, Message response) {
        this.iccIOForApp(command, fileid, path, p1, p2, p3, data, pin2, null, response);
    }

    @Override
    public void iccIOForApp(int command, int fileid, String path, int p1, int p2, int p3, String data, String pin2, String aid, Message result) {
        this.unimplemented(result);
    }

    @Override
    public void queryCLIP(Message response) {
        this.unimplemented(response);
    }

    @Override
    public void getCLIR(Message result) {
        this.unimplemented(result);
    }

    @Override
    public void setCLIR(int clirMode, Message result) {
        this.unimplemented(result);
    }

    @Override
    public void queryCallWaiting(int serviceClass, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void setCallWaiting(boolean enable, int serviceClass, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void setCallForward(int action, int cfReason, int serviceClass, String number, int timeSeconds, Message result) {
        SimulatedCommandsVerifier.getInstance().setCallForward(action, cfReason, serviceClass, number, timeSeconds, result);
        this.resultSuccess(result, null);
    }

    @Override
    public void queryCallForwardStatus(int cfReason, int serviceClass, String number, Message result) {
        SimulatedCommandsVerifier.getInstance().queryCallForwardStatus(cfReason, serviceClass, number, result);
        this.resultSuccess(result, null);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message result) {
        this.unimplemented(result);
    }

    @Override
    public void exitEmergencyCallbackMode(Message result) {
        this.unimplemented(result);
    }

    @Override
    public void setNetworkSelectionModeManual(String operatorNumeric, Message result) {
        this.unimplemented(result);
    }

    @Override
    public void getNetworkSelectionMode(Message result) {
        SimulatedCommandsVerifier.getInstance().getNetworkSelectionMode(result);
        this.getNetworkSelectionModeCallCount.incrementAndGet();
        int[] ret = new int[]{0};
        this.resultSuccess(result, ret);
    }

    @VisibleForTesting
    public int getGetNetworkSelectionModeCallCount() {
        return this.getNetworkSelectionModeCallCount.get();
    }

    @Override
    public void getAvailableNetworks(Message result) {
        this.unimplemented(result);
    }

    @Override
    public void startNetworkScan(NetworkScanRequest nsr, Message result) {
        this.unimplemented(result);
    }

    @Override
    public void stopNetworkScan(Message result) {
        this.unimplemented(result);
    }

    @Override
    public void getBasebandVersion(Message result) {
        SimulatedCommandsVerifier.getInstance().getBasebandVersion(result);
        this.resultSuccess(result, LOG_TAG);
    }

    public void triggerIncomingStkCcAlpha(String alphaString) {
        if (this.mCatCcAlphaRegistrant != null) {
            this.mCatCcAlphaRegistrant.notifyResult(alphaString);
        }
    }

    public void sendStkCcAplha(String alphaString) {
        this.triggerIncomingStkCcAlpha(alphaString);
    }

    @Override
    public void triggerIncomingUssd(String statusCode, String message) {
        if (this.mUSSDRegistrant != null) {
            String[] result = new String[]{statusCode, message};
            this.mUSSDRegistrant.notifyResult(result);
        }
    }

    @Override
    public void sendUSSD(String ussdString, Message result) {
        if (ussdString.equals("#646#")) {
            this.resultSuccess(result, null);
            this.triggerIncomingUssd("0", "You have NNN minutes remaining.");
        } else {
            this.resultSuccess(result, null);
            this.triggerIncomingUssd("0", "All Done");
        }
    }

    @Override
    public void cancelPendingUssd(Message response) {
        this.resultSuccess(response, null);
    }

    @Override
    public void resetRadio(Message result) {
        this.unimplemented(result);
    }

    @Override
    public void setCarrierInfoForImsiEncryption(ImsiEncryptionInfo imsiEncryptionInfo, Message response) {
        if (response != null) {
            AsyncResult.forMessage((Message)response).result = imsiEncryptionInfo;
            response.sendToTarget();
        }
    }

    @Override
    public void triggerRing(String number) {
        this.simulatedCallState.triggerRing(number);
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void progressConnectingCallState() {
        this.simulatedCallState.progressConnectingCallState();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void progressConnectingToActive() {
        this.simulatedCallState.progressConnectingToActive();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void setAutoProgressConnectingCall(boolean b) {
        this.simulatedCallState.setAutoProgressConnectingCall(b);
    }

    @Override
    public void setNextDialFailImmediately(boolean b) {
        this.simulatedCallState.setNextDialFailImmediately(b);
    }

    @Override
    public void setNextCallFailCause(int gsmCause) {
        this.mNextCallFailCause = gsmCause;
    }

    @Override
    public void triggerHangupForeground() {
        this.simulatedCallState.triggerHangupForeground();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void triggerHangupBackground() {
        this.simulatedCallState.triggerHangupBackground();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void triggerSsn(int type, int code) {
        SuppServiceNotification not = new SuppServiceNotification();
        not.notificationType = type;
        not.code = code;
        this.mSsnRegistrant.notifyRegistrant(new AsyncResult(null, not, null));
    }

    @Override
    public void shutdown() {
        this.setRadioState(CommandsInterface.RadioState.RADIO_UNAVAILABLE);
        Looper looper = this.mHandlerThread.getLooper();
        if (looper != null) {
            looper.quit();
        }
    }

    @Override
    public void triggerHangupAll() {
        this.simulatedCallState.triggerHangupAll();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void triggerIncomingSMS(String message) {
    }

    @Override
    public void pauseResponses() {
        ++this.mPausedResponseCount;
    }

    @Override
    public void resumeResponses() {
        --this.mPausedResponseCount;
        if (this.mPausedResponseCount == 0) {
            int s = this.mPausedResponses.size();
            for (int i = 0; i < s; ++i) {
                this.mPausedResponses.get(i).sendToTarget();
            }
            this.mPausedResponses.clear();
        } else {
            Rlog.e("GSM", "SimulatedCommands.resumeResponses < 0");
        }
    }

    private void unimplemented(Message result) {
        if (result != null) {
            AsyncResult.forMessage((Message)result).exception = new RuntimeException("Unimplemented");
            if (this.mPausedResponseCount > 0) {
                this.mPausedResponses.add(result);
            } else {
                result.sendToTarget();
            }
        }
    }

    private void resultSuccess(Message result, Object ret) {
        if (result != null) {
            AsyncResult.forMessage((Message)result).result = ret;
            if (this.mPausedResponseCount > 0) {
                this.mPausedResponses.add(result);
            } else {
                result.sendToTarget();
            }
        }
    }

    private void resultFail(Message result, Object ret, Throwable tr) {
        if (result != null) {
            AsyncResult.forMessage(result, ret, tr);
            if (this.mPausedResponseCount > 0) {
                this.mPausedResponses.add(result);
            } else {
                result.sendToTarget();
            }
        }
    }

    @Override
    public void getDeviceIdentity(Message response) {
        SimulatedCommandsVerifier.getInstance().getDeviceIdentity(response);
        this.resultSuccess(response, new String[]{FAKE_IMEI, FAKE_IMEISV, "1234", "1234"});
    }

    @Override
    public void getCDMASubscription(Message result) {
        String[] ret = new String[]{"123", "456", "789", "234", "345"};
        this.resultSuccess(result, ret);
    }

    @Override
    public void setCdmaSubscriptionSource(int cdmaSubscriptionType, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void queryCdmaRoamingPreference(Message response) {
        this.unimplemented(response);
    }

    @Override
    public void setCdmaRoamingPreference(int cdmaRoamingType, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void setPhoneType(int phoneType) {
    }

    @Override
    public void getPreferredVoicePrivacy(Message result) {
        this.unimplemented(result);
    }

    @Override
    public void setPreferredVoicePrivacy(boolean enable, Message result) {
        this.unimplemented(result);
    }

    @Override
    public void setTTYMode(int ttyMode, Message response) {
        Rlog.w(LOG_TAG, "Not implemented in SimulatedCommands");
        this.unimplemented(response);
    }

    @Override
    public void queryTTYMode(Message response) {
        this.unimplemented(response);
    }

    @Override
    public void sendCDMAFeatureCode(String FeatureCode, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void sendCdmaSms(byte[] pdu, Message response) {
        SimulatedCommandsVerifier.getInstance().sendCdmaSms(pdu, response);
        this.resultSuccess(response, null);
    }

    @Override
    public void setCdmaBroadcastActivation(boolean activate, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void getCdmaBroadcastConfig(Message response) {
        this.unimplemented(response);
    }

    @Override
    public void setCdmaBroadcastConfig(CdmaSmsBroadcastConfigInfo[] configs, Message response) {
        this.unimplemented(response);
    }

    public void forceDataDormancy(Message response) {
        this.unimplemented(response);
    }

    @Override
    public void setGsmBroadcastActivation(boolean activate, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void setGsmBroadcastConfig(SmsBroadcastConfigInfo[] config, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void getGsmBroadcastConfig(Message response) {
        this.unimplemented(response);
    }

    @Override
    public void supplyIccPinForApp(String pin, String aid, Message response) {
        SimulatedCommandsVerifier.getInstance().supplyIccPinForApp(pin, aid, response);
        if (this.mPinCode != null && this.mPinCode.equals(pin)) {
            this.resultSuccess(response, null);
            return;
        }
        Rlog.i(LOG_TAG, "[SimCmd] supplyIccPinForApp: pin failed!");
        CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
        this.resultFail(response, new int[]{--this.mPin1attemptsRemaining < 0 ? 0 : this.mPin1attemptsRemaining}, ex);
    }

    @Override
    public void supplyIccPukForApp(String puk, String newPin, String aid, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void supplyIccPin2ForApp(String pin2, String aid, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void supplyIccPuk2ForApp(String puk2, String newPin2, String aid, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void changeIccPinForApp(String oldPin, String newPin, String aidPtr, Message response) {
        SimulatedCommandsVerifier.getInstance().changeIccPinForApp(oldPin, newPin, aidPtr, response);
        this.changeIccPin(oldPin, newPin, response);
    }

    @Override
    public void changeIccPin2ForApp(String oldPin2, String newPin2, String aidPtr, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void requestIccSimAuthentication(int authContext, String data, String aid, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void getVoiceRadioTechnology(Message response) {
        SimulatedCommandsVerifier.getInstance().getVoiceRadioTechnology(response);
        int[] ret = new int[]{this.mVoiceRadioTech};
        this.resultSuccess(response, ret);
    }

    public void setCellInfoList(List<CellInfo> list) {
        this.mCellInfoList = list;
    }

    @Override
    public void getCellInfoList(Message response, WorkSource WorkSource2) {
        if (this.mCellInfoList == null) {
            Parcel p = Parcel.obtain();
            p.writeInt(1);
            p.writeInt(1);
            p.writeInt(2);
            p.writeLong(1453510289108L);
            p.writeInt(310);
            p.writeInt(260);
            p.writeInt(123);
            p.writeInt(456);
            p.writeInt(99);
            p.writeInt(3);
            p.setDataPosition(0);
            CellInfoGsm cellInfo = CellInfoGsm.CREATOR.createFromParcel(p);
            ArrayList<CellInfoGsm> mCellInfoList = new ArrayList<CellInfoGsm>();
            mCellInfoList.add(cellInfo);
        }
        this.resultSuccess(response, this.mCellInfoList);
    }

    @Override
    public int getRilVersion() {
        return 11;
    }

    @Override
    public void setCellInfoListRate(int rateInMillis, Message response, WorkSource workSource) {
        this.unimplemented(response);
    }

    @Override
    public void setInitialAttachApn(DataProfile dataProfile, boolean isRoaming, Message result) {
    }

    @Override
    public void setDataProfile(DataProfile[] dps, boolean isRoaming, Message result) {
    }

    public void setImsRegistrationState(int[] regState) {
        this.mImsRegState = regState;
    }

    @Override
    public void getImsRegistrationState(Message response) {
        if (this.mImsRegState == null) {
            this.mImsRegState = new int[]{1, 0};
        }
        this.resultSuccess(response, this.mImsRegState);
    }

    @Override
    public void sendImsCdmaSms(byte[] pdu, int retry, int messageRef, Message response) {
        SimulatedCommandsVerifier.getInstance().sendImsCdmaSms(pdu, retry, messageRef, response);
        this.resultSuccess(response, new SmsResponse(0, null, 0));
    }

    @Override
    public void sendImsGsmSms(String smscPDU, String pdu, int retry, int messageRef, Message response) {
        SimulatedCommandsVerifier.getInstance().sendImsGsmSms(smscPDU, pdu, retry, messageRef, response);
        this.resultSuccess(response, new SmsResponse(0, null, 0));
    }

    @Override
    public void iccOpenLogicalChannel(String AID, int p2, Message response) {
        SimulatedCommandsVerifier.getInstance().iccOpenLogicalChannel(AID, p2, response);
        int[] result = new int[]{this.mChannelId};
        this.resultSuccess(response, result);
    }

    @Override
    public void iccCloseLogicalChannel(int channel, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void iccTransmitApduLogicalChannel(int channel, int cla, int instruction, int p1, int p2, int p3, String data, Message response) {
        SimulatedCommandsVerifier.getInstance().iccTransmitApduLogicalChannel(channel, cla, instruction, p1, p2, p3, data, response);
        if (this.mIccIoResultForApduLogicalChannel != null) {
            this.resultSuccess(response, this.mIccIoResultForApduLogicalChannel);
        } else {
            this.resultFail(response, null, new RuntimeException("IccIoResult not set"));
        }
    }

    @Override
    public void iccTransmitApduBasicChannel(int cla, int instruction, int p1, int p2, int p3, String data, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void nvReadItem(int itemID, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void nvWriteItem(int itemID, String itemValue, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void nvWriteCdmaPrl(byte[] preferredRoamingList, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void nvResetConfig(int resetType, Message response) {
        this.unimplemented(response);
    }

    @Override
    public void getHardwareConfig(Message result) {
        this.unimplemented(result);
    }

    @Override
    public void requestShutdown(Message result) {
        this.setRadioState(CommandsInterface.RadioState.RADIO_UNAVAILABLE);
    }

    @Override
    public void startLceService(int report_interval_ms, boolean pullMode, Message result) {
        SimulatedCommandsVerifier.getInstance().startLceService(report_interval_ms, pullMode, result);
        this.unimplemented(result);
    }

    @Override
    public void stopLceService(Message result) {
        this.unimplemented(result);
    }

    @Override
    public void pullLceData(Message result) {
        this.unimplemented(result);
    }

    @Override
    public void getModemActivityInfo(Message result) {
        this.unimplemented(result);
    }

    @Override
    public void setAllowedCarriers(List<CarrierIdentifier> carriers, Message result) {
        this.unimplemented(result);
    }

    @Override
    public void getAllowedCarriers(Message result) {
        this.unimplemented(result);
    }

    @Override
    public void getRadioCapability(Message result) {
        SimulatedCommandsVerifier.getInstance().getRadioCapability(result);
        this.resultSuccess(result, new RadioCapability(0, 0, 0, 65535, null, 0));
    }

    public void notifySmsStatus(Object result) {
        if (this.mSmsStatusRegistrant != null) {
            this.mSmsStatusRegistrant.notifyRegistrant(new AsyncResult(null, result, null));
        }
    }

    public void notifyGsmBroadcastSms(Object result) {
        if (this.mGsmBroadcastSmsRegistrant != null) {
            this.mGsmBroadcastSmsRegistrant.notifyRegistrant(new AsyncResult(null, result, null));
        }
    }

    public void notifyIccSmsFull() {
        if (this.mIccSmsFullRegistrant != null) {
            this.mIccSmsFullRegistrant.notifyRegistrant();
        }
    }

    public void notifyEmergencyCallbackMode() {
        if (this.mEmergencyCallbackModeRegistrant != null) {
            this.mEmergencyCallbackModeRegistrant.notifyRegistrant();
        }
    }

    @Override
    public void setEmergencyCallbackMode(Handler h, int what, Object obj) {
        SimulatedCommandsVerifier.getInstance().setEmergencyCallbackMode(h, what, obj);
        super.setEmergencyCallbackMode(h, what, obj);
    }

    public void notifyExitEmergencyCallbackMode() {
        if (this.mExitEmergencyCallbackModeRegistrants != null) {
            this.mExitEmergencyCallbackModeRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
    }

    public void notifyImsNetworkStateChanged() {
        if (this.mImsNetworkStateChangedRegistrants != null) {
            this.mImsNetworkStateChangedRegistrants.notifyRegistrants();
        }
    }

    public void notifyModemReset() {
        if (this.mModemResetRegistrants != null) {
            this.mModemResetRegistrants.notifyRegistrants(new AsyncResult(null, "Test", null));
        }
    }

    @Override
    public void registerForExitEmergencyCallbackMode(Handler h, int what, Object obj) {
        SimulatedCommandsVerifier.getInstance().registerForExitEmergencyCallbackMode(h, what, obj);
        super.registerForExitEmergencyCallbackMode(h, what, obj);
    }

    public void notifyRadioOn() {
        this.mOnRegistrants.notifyRegistrants();
    }

    @VisibleForTesting
    public void notifyNetworkStateChanged() {
        this.mNetworkStateRegistrants.notifyRegistrants();
    }

    @VisibleForTesting
    public void notifyOtaProvisionStatusChanged() {
        if (this.mOtaProvisionRegistrants != null) {
            int[] ret = new int[]{8};
            this.mOtaProvisionRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
        }
    }

    public void notifySignalStrength() {
        if (this.mSignalStrength == null) {
            this.mSignalStrength = new SignalStrength(20, 0, -1, -1, -1, -1, -1, 99, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        if (this.mSignalStrengthRegistrant != null) {
            this.mSignalStrengthRegistrant.notifyRegistrant(new AsyncResult(null, this.mSignalStrength, null));
        }
    }

    public void setIccCardStatus(IccCardStatus iccCardStatus) {
        this.mIccCardStatus = iccCardStatus;
    }

    public void setIccIoResultForApduLogicalChannel(IccIoResult iccIoResult) {
        this.mIccIoResultForApduLogicalChannel = iccIoResult;
    }

    public void setOpenChannelId(int channelId) {
        this.mChannelId = channelId;
    }

    public void setPin1RemainingAttempt(int pin1attemptsRemaining) {
        this.mPin1attemptsRemaining = pin1attemptsRemaining;
    }

    @Override
    public void setDataAllowed(boolean allowed, Message result) {
        this.log("setDataAllowed = " + allowed);
        this.mAllowed.set(allowed);
        this.resultSuccess(result, null);
    }

    @VisibleForTesting
    public boolean isDataAllowed() {
        return this.mAllowed.get();
    }

    @Override
    public void registerForPcoData(Handler h, int what, Object obj) {
    }

    @Override
    public void unregisterForPcoData(Handler h) {
    }

    @Override
    public void registerForModemReset(Handler h, int what, Object obj) {
        SimulatedCommandsVerifier.getInstance().registerForModemReset(h, what, obj);
        super.registerForModemReset(h, what, obj);
    }

    @Override
    public void sendDeviceState(int stateType, boolean state, Message result) {
        SimulatedCommandsVerifier.getInstance().sendDeviceState(stateType, state, result);
        this.resultSuccess(result, null);
    }

    @Override
    public void setUnsolResponseFilter(int filter, Message result) {
        SimulatedCommandsVerifier.getInstance().setUnsolResponseFilter(filter, result);
        this.resultSuccess(result, null);
    }

    @Override
    public void setSimCardPower(int state, Message result) {
    }

    @VisibleForTesting
    public void triggerRestrictedStateChanged(int restrictedState) {
        if (this.mRestrictedStateRegistrant != null) {
            this.mRestrictedStateRegistrant.notifyRegistrant(new AsyncResult(null, restrictedState, null));
        }
    }

    @Override
    public void setOnRestrictedStateChanged(Handler h, int what, Object obj) {
        super.setOnRestrictedStateChanged(h, what, obj);
        SimulatedCommandsVerifier.getInstance().setOnRestrictedStateChanged(h, what, obj);
    }

    public void setRadioPowerFailResponse(boolean fail) {
        this.mIsRadioPowerFailResponse = fail;
    }

    @Override
    public void registerForIccRefresh(Handler h, int what, Object obj) {
        super.registerForIccRefresh(h, what, obj);
        SimulatedCommandsVerifier.getInstance().registerForIccRefresh(h, what, obj);
    }

    @Override
    public void unregisterForIccRefresh(Handler h) {
        super.unregisterForIccRefresh(h);
        SimulatedCommandsVerifier.getInstance().unregisterForIccRefresh(h);
    }

    @Override
    public void startNattKeepalive(int contextId, KeepalivePacketData packetData, int intervalMillis, Message result) {
    }

    @Override
    public void stopNattKeepalive(int sessionHandle, Message result) {
    }

    private static enum SimFdnState {
        NONE,
        REQUIRE_PIN2,
        REQUIRE_PUK2,
        SIM_PERM_LOCKED;

    }

    private static enum SimLockState {
        NONE,
        REQUIRE_PIN,
        REQUIRE_PUK,
        SIM_PERM_LOCKED;

    }
}

