/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.telephony.Rlog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.uicc.IccUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AnswerToReset {
    private static final String TAG = "AnswerToReset";
    private static final boolean VDBG = false;
    public static final byte EUICC_SUPPORTED = -126;
    public static final byte DIRECT_CONVENTION = 59;
    public static final byte INVERSE_CONVENTION = 63;
    public static final int INTERFACE_BYTES_MASK = 240;
    public static final int T_MASK = 15;
    public static final int T_VALUE_FOR_GLOBAL_INTERFACE = 15;
    public static final int TA_MASK = 16;
    public static final int TB_MASK = 32;
    public static final int TC_MASK = 64;
    public static final int TD_MASK = 128;
    private boolean mIsDirectConvention;
    private boolean mOnlyTEqualsZero = true;
    private boolean mIsEuiccSupported;
    private byte mFormatByte;
    private ArrayList<InterfaceByte> mInterfaceBytes = new ArrayList();
    private byte[] mHistoricalBytes;
    private Byte mCheckByte;

    public static AnswerToReset parseAtr(String atr) {
        AnswerToReset answerToReset = new AnswerToReset();
        if (answerToReset.parseAtrString(atr)) {
            return answerToReset;
        }
        return null;
    }

    private AnswerToReset() {
    }

    private static String byteToStringHex(Byte b) {
        return b == null ? null : IccUtils.byteToHex(b);
    }

    private void checkIsEuiccSupported() {
        for (int i = 0; i < this.mInterfaceBytes.size() - 1; ++i) {
            if (this.mInterfaceBytes.get(i).getTD() == null || (this.mInterfaceBytes.get(i).getTD() & 0xF) != 15 || this.mInterfaceBytes.get(i + 1).getTB() == null || this.mInterfaceBytes.get(i + 1).getTB() != -126) continue;
            this.mIsEuiccSupported = true;
            return;
        }
    }

    private int parseConventionByte(byte[] atrBytes, int index) {
        if (index >= atrBytes.length) {
            AnswerToReset.loge("Failed to read the convention byte.");
            return -1;
        }
        byte value = atrBytes[index];
        if (value == 59) {
            this.mIsDirectConvention = true;
        } else if (value == 63) {
            this.mIsDirectConvention = false;
        } else {
            AnswerToReset.loge("Unrecognized convention byte " + IccUtils.byteToHex(value));
            return -1;
        }
        return index + 1;
    }

    private int parseFormatByte(byte[] atrBytes, int index) {
        if (index >= atrBytes.length) {
            AnswerToReset.loge("Failed to read the format byte.");
            return -1;
        }
        this.mFormatByte = atrBytes[index];
        this.mHistoricalBytes = new byte[this.mFormatByte & 0xF];
        return index + 1;
    }

    private int parseInterfaceBytes(byte[] atrBytes, int index) {
        byte lastTD = this.mFormatByte;
        while ((lastTD & 0xF0) != 0) {
            InterfaceByte interfaceByte = new InterfaceByte();
            if ((lastTD & 0x10) != 0) {
                if (index >= atrBytes.length) {
                    AnswerToReset.loge("Failed to read the byte for TA.");
                    return -1;
                }
                interfaceByte.setTA(atrBytes[index]);
                ++index;
            }
            if ((lastTD & 0x20) != 0) {
                if (index >= atrBytes.length) {
                    AnswerToReset.loge("Failed to read the byte for TB.");
                    return -1;
                }
                interfaceByte.setTB(atrBytes[index]);
                ++index;
            }
            if ((lastTD & 0x40) != 0) {
                if (index >= atrBytes.length) {
                    AnswerToReset.loge("Failed to read the byte for TC.");
                    return -1;
                }
                interfaceByte.setTC(atrBytes[index]);
                ++index;
            }
            if ((lastTD & 0x80) != 0) {
                if (index >= atrBytes.length) {
                    AnswerToReset.loge("Failed to read the byte for TD.");
                    return -1;
                }
                interfaceByte.setTD(atrBytes[index]);
                ++index;
            }
            this.mInterfaceBytes.add(interfaceByte);
            Byte newTD = interfaceByte.getTD();
            if (newTD == null) break;
            lastTD = newTD;
            if ((lastTD & 0xF) == 0) continue;
            this.mOnlyTEqualsZero = false;
        }
        return index;
    }

    private int parseHistoricalBytes(byte[] atrBytes, int index) {
        if (this.mHistoricalBytes.length + index > atrBytes.length) {
            AnswerToReset.loge("Failed to read the historical bytes.");
            return -1;
        }
        if (this.mHistoricalBytes.length > 0) {
            System.arraycopy((byte[])atrBytes, (int)index, (byte[])this.mHistoricalBytes, (int)0, (int)this.mHistoricalBytes.length);
        }
        return index + this.mHistoricalBytes.length;
    }

    private int parseCheckBytes(byte[] atrBytes, int index) {
        if (index < atrBytes.length) {
            this.mCheckByte = atrBytes[index];
            ++index;
        } else {
            if (!this.mOnlyTEqualsZero) {
                AnswerToReset.loge("Check byte must be present because T equals to values other than 0.");
                return -1;
            }
            AnswerToReset.log("Check byte can be absent because T=0.");
        }
        return index;
    }

    private boolean parseAtrString(String atr) {
        if (atr == null) {
            AnswerToReset.loge("The input ATR string can not be null");
            return false;
        }
        if (atr.length() % 2 != 0) {
            AnswerToReset.loge("The length of input ATR string " + atr.length() + " is not even.");
            return false;
        }
        if (atr.length() < 4) {
            AnswerToReset.loge("Valid ATR string must at least contains TS and T0.");
            return false;
        }
        byte[] atrBytes = IccUtils.hexStringToBytes(atr);
        if (atrBytes == null) {
            return false;
        }
        int index = this.parseConventionByte(atrBytes, 0);
        if (index == -1) {
            return false;
        }
        if ((index = this.parseFormatByte(atrBytes, index)) == -1) {
            return false;
        }
        if ((index = this.parseInterfaceBytes(atrBytes, index)) == -1) {
            return false;
        }
        if ((index = this.parseHistoricalBytes(atrBytes, index)) == -1) {
            return false;
        }
        if ((index = this.parseCheckBytes(atrBytes, index)) == -1) {
            return false;
        }
        if (index != atrBytes.length) {
            AnswerToReset.loge("Unexpected bytes after the check byte.");
            return false;
        }
        AnswerToReset.log("Successfully parsed the ATR string " + atr + " into " + this.toString());
        this.checkIsEuiccSupported();
        return true;
    }

    private static void log(String msg) {
        Rlog.d(TAG, msg);
    }

    private static void loge(String msg) {
        Rlog.e(TAG, msg);
    }

    public byte getConventionByte() {
        return this.mIsDirectConvention ? (byte)59 : 63;
    }

    public byte getFormatByte() {
        return this.mFormatByte;
    }

    public List<InterfaceByte> getInterfaceBytes() {
        return this.mInterfaceBytes;
    }

    public byte[] getHistoricalBytes() {
        return this.mHistoricalBytes;
    }

    public Byte getCheckByte() {
        return this.mCheckByte;
    }

    public boolean isEuiccSupported() {
        return this.mIsEuiccSupported;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AnswerToReset:{");
        sb.append("mConventionByte=").append(IccUtils.byteToHex(this.getConventionByte())).append(",");
        sb.append("mFormatByte=").append(AnswerToReset.byteToStringHex(this.mFormatByte)).append(",");
        sb.append("mInterfaceBytes={");
        for (InterfaceByte ib : this.mInterfaceBytes) {
            sb.append(ib.toString());
        }
        sb.append("},");
        sb.append("mHistoricalBytes={");
        for (Object b : (Object)this.mHistoricalBytes) {
            sb.append(IccUtils.byteToHex((byte)b)).append(",");
        }
        sb.append("},");
        sb.append("mCheckByte=").append(AnswerToReset.byteToStringHex(this.mCheckByte));
        sb.append("}");
        return sb.toString();
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("AnswerToReset:");
        pw.println(this.toString());
        pw.flush();
    }

    public static class InterfaceByte {
        private Byte mTA;
        private Byte mTB;
        private Byte mTC;
        private Byte mTD;

        public Byte getTA() {
            return this.mTA;
        }

        public Byte getTB() {
            return this.mTB;
        }

        public Byte getTC() {
            return this.mTC;
        }

        public Byte getTD() {
            return this.mTD;
        }

        public void setTA(Byte tA) {
            this.mTA = tA;
        }

        public void setTB(Byte tB) {
            this.mTB = tB;
        }

        public void setTC(Byte tC) {
            this.mTC = tC;
        }

        public void setTD(Byte tD) {
            this.mTD = tD;
        }

        private InterfaceByte() {
            this.mTA = null;
            this.mTB = null;
            this.mTC = null;
            this.mTD = null;
        }

        @VisibleForTesting
        public InterfaceByte(Byte tA, Byte tB, Byte tC, Byte tD) {
            this.mTA = tA;
            this.mTB = tB;
            this.mTC = tC;
            this.mTD = tD;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InterfaceByte ib = (InterfaceByte)o;
            return Objects.equals(this.mTA, ib.getTA()) && Objects.equals(this.mTB, ib.getTB()) && Objects.equals(this.mTC, ib.getTC()) && Objects.equals(this.mTD, ib.getTD());
        }

        public int hashCode() {
            return Objects.hash(this.mTA, this.mTB, this.mTC, this.mTD);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            sb.append("TA=").append(AnswerToReset.byteToStringHex(this.mTA)).append(",");
            sb.append("TB=").append(AnswerToReset.byteToStringHex(this.mTB)).append(",");
            sb.append("TC=").append(AnswerToReset.byteToStringHex(this.mTC)).append(",");
            sb.append("TD=").append(AnswerToReset.byteToStringHex(this.mTD));
            sb.append("}");
            return sb.toString();
        }
    }
}

