/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccCardConstants;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.uicc.UiccSlot;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class IccCardProxy
extends Handler
implements IccCard {
    private static final boolean DBG = true;
    private static final String LOG_TAG = "IccCardProxy";
    private static final int EVENT_RADIO_OFF_OR_UNAVAILABLE = 1;
    private static final int EVENT_RADIO_ON = 2;
    private static final int EVENT_ICC_CHANGED = 3;
    private static final int EVENT_ICC_ABSENT = 4;
    private static final int EVENT_ICC_LOCKED = 5;
    private static final int EVENT_APP_READY = 6;
    private static final int EVENT_RECORDS_LOADED = 7;
    private static final int EVENT_IMSI_READY = 8;
    private static final int EVENT_NETWORK_LOCKED = 9;
    private static final int EVENT_ICC_RECORD_EVENTS = 500;
    private static final int EVENT_CARRIER_PRIVILEGES_LOADED = 503;
    private Integer mPhoneId = null;
    private final Object mLock = new Object();
    private Context mContext;
    private CommandsInterface mCi;
    private TelephonyManager mTelephonyManager;
    private RegistrantList mNetworkLockedRegistrants = new RegistrantList();
    private int mCurrentAppType = 1;
    private UiccController mUiccController = null;
    private UiccSlot mUiccSlot = null;
    private UiccCard mUiccCard = null;
    private UiccCardApplication mUiccApplication = null;
    private IccRecords mIccRecords = null;
    private CommandsInterface.RadioState mRadioState = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
    private boolean mInitialized = false;
    private IccCardConstants.State mExternalState = IccCardConstants.State.UNKNOWN;
    public static final String ACTION_INTERNAL_SIM_STATE_CHANGED = "android.intent.action.internal_sim_state_changed";

    public IccCardProxy(Context context, CommandsInterface ci, int phoneId) {
        this.log("ctor: ci=" + ci + " phoneId=" + phoneId);
        this.mContext = context;
        this.mCi = ci;
        this.mPhoneId = phoneId;
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 3, null);
        ci.registerForOn(this, 2, null);
        ci.registerForOffOrNotAvailable(this, 1, null);
        this.resetProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.mLock;
        synchronized (object) {
            this.log("Disposing");
            this.mUiccController.unregisterForIccChanged(this);
            this.mUiccController = null;
            this.mCi.unregisterForOn(this);
            this.mCi.unregisterForOffOrNotAvailable(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVoiceRadioTech(int radioTech) {
        Object object = this.mLock;
        synchronized (object) {
            this.log("Setting radio tech " + ServiceState.rilRadioTechnologyToString(radioTech));
            this.mCurrentAppType = ServiceState.isGsm(radioTech) ? 1 : 2;
            this.updateCurrentAppType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentAppType() {
        Object object = this.mLock;
        synchronized (object) {
            boolean isLteOnCdmaMode;
            boolean bl = isLteOnCdmaMode = TelephonyManager.getLteOnCdmaModeStatic() == 1;
            if (this.mCurrentAppType == 2) {
                if (isLteOnCdmaMode) {
                    this.log("updateCurrentAppType: is cdma/lte device, force IccCardProxy into 3gpp mode");
                    this.mCurrentAppType = 1;
                }
                this.log("updateCurrentAppType:  mCurrentAppType=" + this.mCurrentAppType + " isLteOnCdmaMode=" + isLteOnCdmaMode);
            }
            this.mInitialized = true;
            this.sendMessage(this.obtainMessage(3));
        }
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.mRadioState = this.mCi.getRadioState();
                this.updateExternalState();
                break;
            }
            case 2: {
                this.mRadioState = CommandsInterface.RadioState.RADIO_ON;
                if (!this.mInitialized) {
                    this.updateCurrentAppType();
                    break;
                }
                this.updateExternalState();
                break;
            }
            case 3: {
                if (!this.mInitialized) break;
                this.updateIccAvailability();
                break;
            }
            case 4: {
                this.setExternalState(IccCardConstants.State.ABSENT);
                break;
            }
            case 5: {
                this.processLockedState();
                break;
            }
            case 6: {
                this.setExternalState(IccCardConstants.State.READY);
                break;
            }
            case 7: {
                if (this.mIccRecords != null) {
                    String operator = this.mIccRecords.getOperatorNumeric();
                    this.log("operator=" + operator + " mPhoneId=" + this.mPhoneId);
                    if (!TextUtils.isEmpty(operator)) {
                        this.mTelephonyManager.setSimOperatorNumericForPhone(this.mPhoneId, operator);
                        String countryCode = operator.substring(0, 3);
                        if (countryCode != null) {
                            this.mTelephonyManager.setSimCountryIsoForPhone(this.mPhoneId, MccTable.countryCodeForMcc(Integer.parseInt(countryCode)));
                        } else {
                            this.loge("EVENT_RECORDS_LOADED Country code is null");
                        }
                    } else {
                        this.loge("EVENT_RECORDS_LOADED Operator name is null");
                    }
                }
                if (this.mUiccCard != null && !this.mUiccCard.areCarrierPriviligeRulesLoaded()) {
                    this.mUiccCard.registerForCarrierPrivilegeRulesLoaded(this, 503, null);
                    break;
                }
                this.setExternalState(IccCardConstants.State.LOADED);
                break;
            }
            case 8: {
                this.broadcastInternalIccStateChangedIntent("IMSI", null);
                break;
            }
            case 9: {
                this.mNetworkLockedRegistrants.notifyRegistrants();
                this.setExternalState(IccCardConstants.State.NETWORK_LOCKED);
                break;
            }
            case 500: {
                if (this.mCurrentAppType != 1 || this.mIccRecords == null) break;
                AsyncResult ar = (AsyncResult)msg.obj;
                int eventCode = (Integer)ar.result;
                if (eventCode != 2) break;
                this.mTelephonyManager.setSimOperatorNameForPhone(this.mPhoneId, this.mIccRecords.getServiceProviderName());
                break;
            }
            case 503: {
                this.log("EVENT_CARRIER_PRIVILEGES_LOADED");
                if (this.mUiccCard != null) {
                    this.mUiccCard.unregisterForCarrierPrivilegeRulesLoaded(this);
                }
                this.setExternalState(IccCardConstants.State.LOADED);
                break;
            }
            default: {
                this.loge("Unhandled message with number: " + msg.what);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIccAvailability() {
        Object object = this.mLock;
        synchronized (object) {
            UiccSlot newSlot = this.mUiccController.getUiccSlotForPhone(this.mPhoneId);
            UiccCard newCard = this.mUiccController.getUiccCard(this.mPhoneId);
            UiccCardApplication newApp = null;
            IccRecords newRecords = null;
            if (newCard != null && (newApp = newCard.getApplication(this.mCurrentAppType)) != null) {
                newRecords = newApp.getIccRecords();
            }
            if (this.mIccRecords != newRecords || this.mUiccApplication != newApp || this.mUiccCard != newCard || this.mUiccSlot != newSlot) {
                this.log("Icc changed. Reregistering.");
                this.unregisterUiccCardEvents();
                this.mUiccSlot = newSlot;
                this.mUiccCard = newCard;
                this.mUiccApplication = newApp;
                this.mIccRecords = newRecords;
                this.registerUiccCardEvents();
            }
            this.updateExternalState();
        }
    }

    void resetProperties() {
        if (this.mCurrentAppType == 1) {
            this.log("update icc_operator_numeric=");
            this.mTelephonyManager.setSimOperatorNumericForPhone(this.mPhoneId, "");
            this.mTelephonyManager.setSimCountryIsoForPhone(this.mPhoneId, "");
            this.mTelephonyManager.setSimOperatorNameForPhone(this.mPhoneId, "");
        }
    }

    private void HandleDetectedState() {
    }

    private void updateExternalState() {
        if (this.mUiccCard == null) {
            this.setExternalState(IccCardConstants.State.UNKNOWN);
            return;
        }
        if (this.mUiccCard.getCardState() == IccCardStatus.CardState.CARDSTATE_ABSENT) {
            if (this.mRadioState == CommandsInterface.RadioState.RADIO_UNAVAILABLE) {
                this.setExternalState(IccCardConstants.State.UNKNOWN);
            } else {
                this.setExternalState(IccCardConstants.State.ABSENT);
            }
            return;
        }
        if (this.mUiccCard.getCardState() == IccCardStatus.CardState.CARDSTATE_ERROR) {
            this.setExternalState(IccCardConstants.State.CARD_IO_ERROR);
            return;
        }
        if (this.mUiccCard.getCardState() == IccCardStatus.CardState.CARDSTATE_RESTRICTED) {
            this.setExternalState(IccCardConstants.State.CARD_RESTRICTED);
            return;
        }
        if (this.mUiccApplication == null) {
            this.setExternalState(IccCardConstants.State.NOT_READY);
            return;
        }
        switch (this.mUiccApplication.getState()) {
            case APPSTATE_UNKNOWN: {
                this.setExternalState(IccCardConstants.State.NOT_READY);
                break;
            }
            case APPSTATE_DETECTED: {
                this.HandleDetectedState();
                break;
            }
            case APPSTATE_SUBSCRIPTION_PERSO: {
                if (this.mUiccApplication.getPersoSubState() != IccCardApplicationStatus.PersoSubState.PERSOSUBSTATE_SIM_NETWORK) break;
                this.setExternalState(IccCardConstants.State.NETWORK_LOCKED);
                break;
            }
            case APPSTATE_READY: {
                this.setExternalState(IccCardConstants.State.READY);
            }
        }
    }

    private void registerUiccCardEvents() {
        if (this.mUiccApplication != null) {
            this.mUiccApplication.registerForReady(this, 6, null);
        }
        if (this.mIccRecords != null) {
            this.mIccRecords.registerForImsiReady(this, 8, null);
            this.mIccRecords.registerForRecordsLoaded(this, 7, null);
            this.mIccRecords.registerForLockedRecordsLoaded(this, 5, null);
            this.mIccRecords.registerForNetworkLockedRecordsLoaded(this, 9, null);
            this.mIccRecords.registerForRecordsEvents(this, 500, null);
        }
    }

    private void unregisterUiccCardEvents() {
        if (this.mUiccCard != null) {
            this.mUiccCard.unregisterForCarrierPrivilegeRulesLoaded(this);
        }
        if (this.mUiccApplication != null) {
            this.mUiccApplication.unregisterForReady(this);
        }
        if (this.mIccRecords != null) {
            this.mIccRecords.unregisterForImsiReady(this);
            this.mIccRecords.unregisterForRecordsLoaded(this);
            this.mIccRecords.unregisterForLockedRecordsLoaded(this);
            this.mIccRecords.unregisterForNetworkLockedRecordsLoaded(this);
            this.mIccRecords.unregisterForRecordsEvents(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastInternalIccStateChangedIntent(String value, String reason) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPhoneId == null) {
                this.loge("broadcastInternalIccStateChangedIntent: Card Index is not set; Return!!");
                return;
            }
            Intent intent = new Intent(ACTION_INTERNAL_SIM_STATE_CHANGED);
            intent.addFlags(0x14000000);
            intent.putExtra("phoneName", "Phone");
            intent.putExtra("ss", value);
            intent.putExtra("reason", reason);
            intent.putExtra("phone", this.mPhoneId);
            this.log("broadcastInternalIccStateChangedIntent: Sending intent ACTION_INTERNAL_SIM_STATE_CHANGED value = " + value + " for mPhoneId : " + this.mPhoneId);
            ActivityManager.broadcastStickyIntent(intent, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExternalState(IccCardConstants.State newState, boolean override) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPhoneId == null || !SubscriptionManager.isValidSlotIndex(this.mPhoneId)) {
                this.loge("setExternalState: mPhoneId=" + this.mPhoneId + " is invalid; Return!!");
                return;
            }
            if (!override && newState == this.mExternalState) {
                this.log("setExternalState: !override and newstate unchanged from " + (Object)((Object)newState));
                return;
            }
            this.mExternalState = newState;
            this.log("setExternalState: set mPhoneId=" + this.mPhoneId + " mExternalState=" + (Object)((Object)this.mExternalState));
            this.mTelephonyManager.setSimStateForPhone(this.mPhoneId, this.getState().toString());
            this.broadcastInternalIccStateChangedIntent(this.getIccStateIntentString(this.mExternalState), this.getIccStateReason(this.mExternalState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLockedState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication == null) {
                return;
            }
            IccCardStatus.PinState pin1State = this.mUiccApplication.getPin1State();
            if (pin1State == IccCardStatus.PinState.PINSTATE_ENABLED_PERM_BLOCKED) {
                this.setExternalState(IccCardConstants.State.PERM_DISABLED);
                return;
            }
            IccCardApplicationStatus.AppState appState = this.mUiccApplication.getState();
            switch (appState) {
                case APPSTATE_PIN: {
                    this.setExternalState(IccCardConstants.State.PIN_REQUIRED);
                    break;
                }
                case APPSTATE_PUK: {
                    this.setExternalState(IccCardConstants.State.PUK_REQUIRED);
                    break;
                }
            }
        }
    }

    private void setExternalState(IccCardConstants.State newState) {
        this.setExternalState(newState, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIccRecordsLoaded() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIccRecords != null) {
                return this.mIccRecords.getRecordsLoaded();
            }
            return false;
        }
    }

    private String getIccStateIntentString(IccCardConstants.State state) {
        switch (state) {
            case ABSENT: {
                return "ABSENT";
            }
            case PIN_REQUIRED: {
                return "LOCKED";
            }
            case PUK_REQUIRED: {
                return "LOCKED";
            }
            case NETWORK_LOCKED: {
                return "LOCKED";
            }
            case READY: {
                return "READY";
            }
            case NOT_READY: {
                return "NOT_READY";
            }
            case PERM_DISABLED: {
                return "LOCKED";
            }
            case CARD_IO_ERROR: {
                return "CARD_IO_ERROR";
            }
            case CARD_RESTRICTED: {
                return "CARD_RESTRICTED";
            }
            case LOADED: {
                return "LOADED";
            }
        }
        return "UNKNOWN";
    }

    private String getIccStateReason(IccCardConstants.State state) {
        switch (state) {
            case PIN_REQUIRED: {
                return "PIN";
            }
            case PUK_REQUIRED: {
                return "PUK";
            }
            case NETWORK_LOCKED: {
                return "NETWORK";
            }
            case PERM_DISABLED: {
                return "PERM_DISABLED";
            }
            case CARD_IO_ERROR: {
                return "CARD_IO_ERROR";
            }
            case CARD_RESTRICTED: {
                return "CARD_RESTRICTED";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IccCardConstants.State getState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mExternalState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IccRecords getIccRecords() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIccRecords;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerForNetworkLocked(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mNetworkLockedRegistrants.add(r);
            if (this.getState() == IccCardConstants.State.NETWORK_LOCKED) {
                r.notifyRegistrant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterForNetworkLocked(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mNetworkLockedRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplyPin(String pin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPin(pin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplyPuk(String puk, String newPin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPuk(puk, newPin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplyPin2(String pin2, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPin2(pin2, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplyPuk2(String puk2, String newPin2, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPuk2(puk2, newPin2, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplyNetworkDepersonalization(String pin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyNetworkDepersonalization(pin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("CommandsInterface is not set.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getIccLockEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            Boolean retValue = this.mUiccApplication != null ? this.mUiccApplication.getIccLockEnabled() : false;
            return retValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getIccFdnEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            Boolean retValue = this.mUiccApplication != null ? this.mUiccApplication.getIccFdnEnabled() : false;
            return retValue;
        }
    }

    @Override
    public boolean getIccPin2Blocked() {
        Boolean retValue = this.mUiccApplication != null ? this.mUiccApplication.getIccPin2Blocked() : false;
        return retValue;
    }

    @Override
    public boolean getIccPuk2Blocked() {
        Boolean retValue = this.mUiccApplication != null ? this.mUiccApplication.getIccPuk2Blocked() : false;
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIccLockEnabled(boolean enabled, String password, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.setIccLockEnabled(enabled, password, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIccFdnEnabled(boolean enabled, String password, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.setIccFdnEnabled(enabled, password, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeIccLockPassword(String oldPassword, String newPassword, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.changeIccLockPassword(oldPassword, newPassword, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeIccFdnPassword(String oldPassword, String newPassword, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.changeIccFdnPassword(oldPassword, newPassword, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getServiceProviderName() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIccRecords != null) {
                return this.mIccRecords.getServiceProviderName();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isApplicationOnIcc(IccCardApplicationStatus.AppType type) {
        Object object = this.mLock;
        synchronized (object) {
            Boolean retValue = this.mUiccCard != null ? this.mUiccCard.isApplicationOnIcc(type) : false;
            return retValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasIccCard() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUiccCard != null && this.mUiccCard.getCardState() != IccCardStatus.CardState.CARDSTATE_ABSENT;
            {
            }
        }
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, s);
    }

    private void loge(String msg) {
        Rlog.e(LOG_TAG, msg);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("IccCardProxy: " + this);
        pw.println(" mContext=" + this.mContext);
        pw.println(" mCi=" + this.mCi);
        pw.println(" mNetworkLockedRegistrants: size=" + this.mNetworkLockedRegistrants.size());
        for (int i = 0; i < this.mNetworkLockedRegistrants.size(); ++i) {
            pw.println("  mNetworkLockedRegistrants[" + i + "]=" + ((Registrant)this.mNetworkLockedRegistrants.get(i)).getHandler());
        }
        pw.println(" mCurrentAppType=" + this.mCurrentAppType);
        pw.println(" mUiccController=" + this.mUiccController);
        pw.println(" mUiccCard=" + this.mUiccCard);
        pw.println(" mUiccApplication=" + this.mUiccApplication);
        pw.println(" mIccRecords=" + this.mIccRecords);
        pw.println(" mRadioState=" + (Object)((Object)this.mRadioState));
        pw.println(" mInitialized=" + this.mInitialized);
        pw.println(" mExternalState=" + (Object)((Object)this.mExternalState));
        pw.flush();
    }
}

