/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionInfo;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.uicc.AdnRecordCache;
import com.android.internal.telephony.uicc.CarrierTestOverride;
import com.android.internal.telephony.uicc.IccConstants;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccRefreshResponse;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.PlmnActRecord;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccProfile;
import com.android.internal.telephony.uicc.UsimServiceTable;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class IccRecords
extends Handler
implements IccConstants {
    protected static final boolean DBG = true;
    protected static final boolean VDBG = false;
    protected AtomicBoolean mDestroyed = new AtomicBoolean(false);
    protected AtomicBoolean mLoaded = new AtomicBoolean(false);
    protected Context mContext;
    protected CommandsInterface mCi;
    protected IccFileHandler mFh;
    protected UiccCardApplication mParentApp;
    protected TelephonyManager mTelephonyManager;
    protected RegistrantList mRecordsLoadedRegistrants = new RegistrantList();
    protected RegistrantList mLockedRecordsLoadedRegistrants = new RegistrantList();
    protected RegistrantList mNetworkLockedRecordsLoadedRegistrants = new RegistrantList();
    protected RegistrantList mImsiReadyRegistrants = new RegistrantList();
    protected RegistrantList mRecordsEventsRegistrants = new RegistrantList();
    protected RegistrantList mNewSmsRegistrants = new RegistrantList();
    protected RegistrantList mNetworkSelectionModeAutomaticRegistrants = new RegistrantList();
    protected RegistrantList mSpnUpdatedRegistrants = new RegistrantList();
    protected int mRecordsToLoad;
    protected AdnRecordCache mAdnCache;
    protected static final int LOCKED_RECORDS_REQ_REASON_NONE = 0;
    protected static final int LOCKED_RECORDS_REQ_REASON_LOCKED = 1;
    protected static final int LOCKED_RECORDS_REQ_REASON_NETWORK_LOCKED = 2;
    protected boolean mRecordsRequested = false;
    protected int mLockedRecordsReqReason = 0;
    protected String mIccId;
    protected String mFakeIccId;
    protected String mFullIccId;
    protected String mMsisdn = null;
    protected String mMsisdnTag = null;
    protected String mNewMsisdn = null;
    protected String mNewMsisdnTag = null;
    protected String mVoiceMailNum = null;
    protected String mVoiceMailTag = null;
    protected String mNewVoiceMailNum = null;
    protected String mNewVoiceMailTag = null;
    protected boolean mIsVoiceMailFixed = false;
    protected String mImsi;
    protected String mFakeImsi;
    private IccIoResult auth_rsp;
    protected int mMncLength = -1;
    protected int mMailboxIndex = 0;
    private String mSpn;
    private String mFakeSpn;
    protected String mGid1;
    protected String mFakeGid1;
    protected String mGid2;
    protected String mFakeGid2;
    protected String mPnnHomeName;
    protected String mFakePnnHomeName;
    protected String mPrefLang;
    protected PlmnActRecord[] mHplmnActRecords;
    protected PlmnActRecord[] mOplmnActRecords;
    protected PlmnActRecord[] mPlmnActRecords;
    protected String[] mEhplmns;
    protected String[] mFplmns;
    private final Object mLock = new Object();
    CarrierTestOverride mCarrierTestOverride;
    protected static final int HANDLER_ACTION_BASE = 1238272;
    protected static final int HANDLER_ACTION_NONE = 1238272;
    protected static final int HANDLER_ACTION_SEND_RESPONSE = 1238273;
    protected static AtomicInteger sNextRequestId = new AtomicInteger(1);
    protected final HashMap<Integer, Message> mPendingResponses = new HashMap();
    protected static final int UNINITIALIZED = -1;
    protected static final int UNKNOWN = 0;
    public static final int SPN_RULE_SHOW_SPN = 1;
    public static final int SPN_RULE_SHOW_PLMN = 2;
    public static final int EVENT_MWI = 0;
    public static final int EVENT_CFI = 1;
    public static final int EVENT_SPN = 2;
    public static final int EVENT_GET_ICC_RECORD_DONE = 100;
    public static final int EVENT_REFRESH = 31;
    protected static final int EVENT_APP_READY = 1;
    private static final int EVENT_AKA_AUTHENTICATE_DONE = 90;
    public static final int CALL_FORWARDING_STATUS_DISABLED = 0;
    public static final int CALL_FORWARDING_STATUS_ENABLED = 1;
    public static final int CALL_FORWARDING_STATUS_UNKNOWN = -1;
    public static final int DEFAULT_VOICE_MESSAGE_COUNT = -2;
    public static final int UNKNOWN_VOICE_MESSAGE_COUNT = -1;

    @Override
    public String toString() {
        String iccIdToPrint = SubscriptionInfo.givePrintableIccid(this.mFullIccId);
        return "mDestroyed=" + this.mDestroyed + " mContext=" + this.mContext + " mCi=" + this.mCi + " mFh=" + this.mFh + " mParentApp=" + this.mParentApp + " recordsToLoad=" + this.mRecordsToLoad + " adnCache=" + this.mAdnCache + " recordsRequested=" + this.mRecordsRequested + " lockedRecordsReqReason=" + this.mLockedRecordsReqReason + " iccid=" + iccIdToPrint + (this.mCarrierTestOverride.isInTestMode() ? "mFakeIccid=" + this.mFakeIccId : "") + " msisdnTag=" + this.mMsisdnTag + " voiceMailNum=" + Rlog.pii(false, (Object)this.mVoiceMailNum) + " voiceMailTag=" + this.mVoiceMailTag + " voiceMailNum=" + Rlog.pii(false, (Object)this.mNewVoiceMailNum) + " newVoiceMailTag=" + this.mNewVoiceMailTag + " isVoiceMailFixed=" + this.mIsVoiceMailFixed + " mImsi=" + (this.mImsi != null ? this.mImsi.substring(0, 6) + Rlog.pii(false, (Object)this.mImsi.substring(6)) : "null") + (this.mCarrierTestOverride.isInTestMode() ? " mFakeImsi=" + this.mFakeImsi : "") + " mncLength=" + this.mMncLength + " mailboxIndex=" + this.mMailboxIndex + " spn=" + this.mSpn + (this.mCarrierTestOverride.isInTestMode() ? " mFakeSpn=" + this.mFakeSpn : "");
    }

    public IccRecords(UiccCardApplication app, Context c, CommandsInterface ci) {
        this.mContext = c;
        this.mCi = ci;
        this.mFh = app.getIccFileHandler();
        this.mParentApp = app;
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.mCarrierTestOverride = new CarrierTestOverride();
        if (this.mCarrierTestOverride.isInTestMode()) {
            this.mFakeImsi = this.mCarrierTestOverride.getFakeIMSI();
            this.log("load mFakeImsi: " + this.mFakeImsi);
            this.mFakeGid1 = this.mCarrierTestOverride.getFakeGid1();
            this.log("load mFakeGid1: " + this.mFakeGid1);
            this.mFakeGid2 = this.mCarrierTestOverride.getFakeGid2();
            this.log("load mFakeGid2: " + this.mFakeGid2);
            this.mFakeSpn = this.mCarrierTestOverride.getFakeSpn();
            this.log("load mFakeSpn: " + this.mFakeSpn);
            this.mFakePnnHomeName = this.mCarrierTestOverride.getFakePnnHomeName();
            this.log("load mFakePnnHomeName: " + this.mFakePnnHomeName);
            this.mFakeIccId = this.mCarrierTestOverride.getFakeIccid();
            this.log("load mFakeIccId: " + this.mFakeIccId);
        }
        this.mCi.registerForIccRefresh(this, 31, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.mDestroyed.set(true);
        this.auth_rsp = null;
        Object object = this.mLock;
        synchronized (object) {
            this.mLock.notifyAll();
        }
        this.mCi.unregisterForIccRefresh(this);
        this.mParentApp = null;
        this.mFh = null;
        this.mCi = null;
        this.mContext = null;
        if (this.mAdnCache != null) {
            this.mAdnCache.reset();
        }
        this.mLoaded.set(false);
    }

    public abstract void onReady();

    public AdnRecordCache getAdnCache() {
        return this.mAdnCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int storePendingResponseMessage(Message msg) {
        int key = sNextRequestId.getAndIncrement();
        HashMap<Integer, Message> hashMap = this.mPendingResponses;
        synchronized (hashMap) {
            this.mPendingResponses.put(key, msg);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message retrievePendingResponseMessage(Integer key) {
        HashMap<Integer, Message> hashMap = this.mPendingResponses;
        synchronized (hashMap) {
            return this.mPendingResponses.remove(key);
        }
    }

    public String getIccId() {
        if (this.mCarrierTestOverride.isInTestMode() && this.mFakeIccId != null) {
            return this.mFakeIccId;
        }
        return this.mIccId;
    }

    public String getFullIccId() {
        return this.mFullIccId;
    }

    public void registerForRecordsLoaded(Handler h, int what, Object obj) {
        if (this.mDestroyed.get()) {
            return;
        }
        Registrant r = new Registrant(h, what, obj);
        this.mRecordsLoadedRegistrants.add(r);
        if (this.getRecordsLoaded()) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    public void unregisterForRecordsLoaded(Handler h) {
        this.mRecordsLoadedRegistrants.remove(h);
    }

    public void registerForLockedRecordsLoaded(Handler h, int what, Object obj) {
        if (this.mDestroyed.get()) {
            return;
        }
        Registrant r = new Registrant(h, what, obj);
        this.mLockedRecordsLoadedRegistrants.add(r);
        if (this.getLockedRecordsLoaded()) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    public void unregisterForLockedRecordsLoaded(Handler h) {
        this.mLockedRecordsLoadedRegistrants.remove(h);
    }

    public void registerForNetworkLockedRecordsLoaded(Handler h, int what, Object obj) {
        if (this.mDestroyed.get()) {
            return;
        }
        Registrant r = new Registrant(h, what, obj);
        this.mNetworkLockedRecordsLoadedRegistrants.add(r);
        if (this.getNetworkLockedRecordsLoaded()) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    public void unregisterForNetworkLockedRecordsLoaded(Handler h) {
        this.mNetworkLockedRecordsLoadedRegistrants.remove(h);
    }

    public void registerForImsiReady(Handler h, int what, Object obj) {
        if (this.mDestroyed.get()) {
            return;
        }
        Registrant r = new Registrant(h, what, obj);
        this.mImsiReadyRegistrants.add(r);
        if (this.getIMSI() != null) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    public void unregisterForImsiReady(Handler h) {
        this.mImsiReadyRegistrants.remove(h);
    }

    public void registerForSpnUpdate(Handler h, int what, Object obj) {
        if (this.mDestroyed.get()) {
            return;
        }
        Registrant r = new Registrant(h, what, obj);
        this.mSpnUpdatedRegistrants.add(r);
        if (!TextUtils.isEmpty(this.mSpn)) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    public void unregisterForSpnUpdate(Handler h) {
        this.mSpnUpdatedRegistrants.remove(h);
    }

    public void registerForRecordsEvents(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mRecordsEventsRegistrants.add(r);
        r.notifyResult(0);
        r.notifyResult(1);
    }

    public void unregisterForRecordsEvents(Handler h) {
        this.mRecordsEventsRegistrants.remove(h);
    }

    public void registerForNewSms(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mNewSmsRegistrants.add(r);
    }

    public void unregisterForNewSms(Handler h) {
        this.mNewSmsRegistrants.remove(h);
    }

    public void registerForNetworkSelectionModeAutomatic(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mNetworkSelectionModeAutomaticRegistrants.add(r);
    }

    public void unregisterForNetworkSelectionModeAutomatic(Handler h) {
        this.mNetworkSelectionModeAutomaticRegistrants.remove(h);
    }

    public String getIMSI() {
        if (this.mCarrierTestOverride.isInTestMode() && this.mFakeImsi != null) {
            return this.mFakeImsi;
        }
        return this.mImsi;
    }

    public void setImsi(String imsi) {
        this.mImsi = imsi;
        this.mImsiReadyRegistrants.notifyRegistrants();
    }

    public String getNAI() {
        return null;
    }

    public String getMsisdnNumber() {
        return this.mMsisdn;
    }

    public String getGid1() {
        if (this.mCarrierTestOverride.isInTestMode() && this.mFakeGid1 != null) {
            return this.mFakeGid1;
        }
        return this.mGid1;
    }

    public String getGid2() {
        if (this.mCarrierTestOverride.isInTestMode() && this.mFakeGid2 != null) {
            return this.mFakeGid2;
        }
        return this.mGid2;
    }

    public String getPnnHomeName() {
        if (this.mCarrierTestOverride.isInTestMode() && this.mFakePnnHomeName != null) {
            return this.mFakePnnHomeName;
        }
        return this.mPnnHomeName;
    }

    public void setMsisdnNumber(String alphaTag, String number, Message onComplete) {
        this.loge("setMsisdn() should not be invoked on base IccRecords");
        AsyncResult.forMessage((Message)onComplete).exception = new IccIoResult(106, 130, (byte[])null).getException();
        onComplete.sendToTarget();
    }

    public String getMsisdnAlphaTag() {
        return this.mMsisdnTag;
    }

    public String getVoiceMailNumber() {
        return this.mVoiceMailNum;
    }

    public String getServiceProviderName() {
        if (this.mCarrierTestOverride.isInTestMode() && this.mFakeSpn != null) {
            return this.mFakeSpn;
        }
        String providerName = this.mSpn;
        UiccCardApplication parentApp = this.mParentApp;
        if (parentApp != null) {
            UiccProfile profile = parentApp.getUiccProfile();
            if (profile != null) {
                String brandOverride = profile.getOperatorBrandOverride();
                if (brandOverride != null) {
                    this.log("getServiceProviderName: override, providerName=" + providerName);
                    providerName = brandOverride;
                } else {
                    this.log("getServiceProviderName: no brandOverride, providerName=" + providerName);
                }
            } else {
                this.log("getServiceProviderName: card is null, providerName=" + providerName);
            }
        } else {
            this.log("getServiceProviderName: mParentApp is null, providerName=" + providerName);
        }
        return providerName;
    }

    protected void setServiceProviderName(String spn) {
        if (!TextUtils.equals(this.mSpn, spn)) {
            this.mSpnUpdatedRegistrants.notifyRegistrants();
            this.mSpn = spn;
        }
    }

    public abstract void setVoiceMailNumber(String var1, String var2, Message var3);

    public String getVoiceMailAlphaTag() {
        return this.mVoiceMailTag;
    }

    public abstract void setVoiceMessageWaiting(int var1, int var2);

    public abstract int getVoiceMessageCount();

    public abstract void onRefresh(boolean var1, int[] var2);

    public boolean getRecordsLoaded() {
        return this.mRecordsToLoad == 0 && this.mRecordsRequested;
    }

    protected boolean getLockedRecordsLoaded() {
        return this.mRecordsToLoad == 0 && this.mLockedRecordsReqReason == 1;
    }

    protected boolean getNetworkLockedRecordsLoaded() {
        return this.mRecordsToLoad == 0 && this.mLockedRecordsReqReason == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                try {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    IccRecordLoaded recordLoaded = (IccRecordLoaded)ar.userObj;
                    this.log(recordLoaded.getEfName() + " LOADED");
                    if (ar.exception != null) {
                        this.loge("Record Load Exception: " + ar.exception);
                        break;
                    }
                    recordLoaded.onRecordLoaded(ar);
                    break;
                }
                catch (RuntimeException exc) {
                    this.loge("Exception parsing SIM record: " + exc);
                    break;
                }
                finally {
                    this.onRecordLoaded();
                }
            }
            case 31: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.log("Card REFRESH occurred: ");
                if (ar.exception == null) {
                    this.handleRefresh((IccRefreshResponse)ar.result);
                    break;
                }
                this.loge("Icc refresh Exception: " + ar.exception);
                break;
            }
            case 90: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.auth_rsp = null;
                this.log("EVENT_AKA_AUTHENTICATE_DONE");
                if (ar.exception != null) {
                    this.loge("Exception ICC SIM AKA: " + ar.exception);
                } else {
                    try {
                        this.auth_rsp = (IccIoResult)ar.result;
                        this.log("ICC SIM AKA: auth_rsp = " + this.auth_rsp);
                    }
                    catch (Exception e) {
                        this.loge("Failed to parse ICC SIM AKA contents: " + e);
                    }
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notifyAll();
                    break;
                }
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    public String getSimLanguage() {
        return this.mPrefLang;
    }

    protected void setSimLanguage(byte[] efLi, byte[] efPl) {
        String[] locales = this.mContext.getAssets().getLocales();
        try {
            this.mPrefLang = IccRecords.findBestLanguage(efLi, locales);
        }
        catch (UnsupportedEncodingException uee) {
            this.log("Unable to parse EF-LI: " + Arrays.toString(efLi));
        }
        if (this.mPrefLang == null) {
            try {
                this.mPrefLang = IccRecords.findBestLanguage(efPl, locales);
            }
            catch (UnsupportedEncodingException uee) {
                this.log("Unable to parse EF-PL: " + Arrays.toString(efLi));
            }
        }
    }

    protected static String findBestLanguage(byte[] languages, String[] locales) throws UnsupportedEncodingException {
        if (languages == null || locales == null) {
            return null;
        }
        int i = 0;
        while (i + 1 < languages.length) {
            String lang = new String(languages, i, 2, "ISO-8859-1");
            for (int j = 0; j < locales.length; ++j) {
                if (locales[j] == null || locales[j].length() < 2 || !locales[j].substring(0, 2).equalsIgnoreCase(lang)) continue;
                return lang;
            }
            i += 2;
        }
        return null;
    }

    protected abstract void handleFileUpdate(int var1);

    protected void handleRefresh(IccRefreshResponse refreshResponse) {
        if (refreshResponse == null) {
            this.log("handleRefresh received without input");
            return;
        }
        if (!TextUtils.isEmpty(refreshResponse.aid) && !refreshResponse.aid.equals(this.mParentApp.getAid())) {
            return;
        }
        switch (refreshResponse.refreshResult) {
            case 0: {
                this.log("handleRefresh with SIM_FILE_UPDATED");
                this.handleFileUpdate(refreshResponse.efId);
                break;
            }
            default: {
                this.log("handleRefresh with unknown operation");
            }
        }
    }

    protected abstract void onRecordLoaded();

    protected abstract void onAllRecordsLoaded();

    public abstract int getDisplayRule(ServiceState var1);

    public boolean isCspPlmnEnabled() {
        return false;
    }

    public String getOperatorNumeric() {
        return null;
    }

    public int getVoiceCallForwardingFlag() {
        return -1;
    }

    public void setVoiceCallForwardingFlag(int line, boolean enable, String number) {
    }

    public boolean isLoaded() {
        return this.mLoaded.get();
    }

    public boolean isProvisioned() {
        return true;
    }

    protected abstract void log(String var1);

    protected abstract void loge(String var1);

    public IsimRecords getIsimRecords() {
        return null;
    }

    public UsimServiceTable getUsimServiceTable() {
        return null;
    }

    protected void setSystemProperty(String key, String val) {
        TelephonyManager.getDefault();
        TelephonyManager.setTelephonyProperty(this.mParentApp.getPhoneId(), key, val);
        this.log("[key, value]=" + key + ", " + val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIccSimChallengeResponse(int authContext, String data) {
        this.log("getIccSimChallengeResponse:");
        try {
            Object object = this.mLock;
            synchronized (object) {
                CommandsInterface ci = this.mCi;
                UiccCardApplication parentApp = this.mParentApp;
                if (ci != null && parentApp != null) {
                    ci.requestIccSimAuthentication(authContext, data, parentApp.getAid(), this.obtainMessage(90));
                    try {
                        this.mLock.wait();
                    }
                    catch (InterruptedException e) {
                        this.loge("getIccSimChallengeResponse: Fail, interrupted while trying to request Icc Sim Auth");
                        return null;
                    }
                } else {
                    this.loge("getIccSimChallengeResponse: Fail, ci or parentApp is null");
                    return null;
                }
            }
        }
        catch (Exception e) {
            this.loge("getIccSimChallengeResponse: Fail while trying to request Icc Sim Auth");
            return null;
        }
        if (this.auth_rsp == null) {
            this.loge("getIccSimChallengeResponse: No authentication response");
            return null;
        }
        this.log("getIccSimChallengeResponse: return auth_rsp");
        return Base64.encodeToString(this.auth_rsp.payload, 2);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("IccRecords: " + this);
        pw.println(" mDestroyed=" + this.mDestroyed);
        pw.println(" mCi=" + this.mCi);
        pw.println(" mFh=" + this.mFh);
        pw.println(" mParentApp=" + this.mParentApp);
        pw.println(" recordsLoadedRegistrants: size=" + this.mRecordsLoadedRegistrants.size());
        for (i = 0; i < this.mRecordsLoadedRegistrants.size(); ++i) {
            pw.println("  recordsLoadedRegistrants[" + i + "]=" + ((Registrant)this.mRecordsLoadedRegistrants.get(i)).getHandler());
        }
        pw.println(" mLockedRecordsLoadedRegistrants: size=" + this.mLockedRecordsLoadedRegistrants.size());
        for (i = 0; i < this.mLockedRecordsLoadedRegistrants.size(); ++i) {
            pw.println("  mLockedRecordsLoadedRegistrants[" + i + "]=" + ((Registrant)this.mLockedRecordsLoadedRegistrants.get(i)).getHandler());
        }
        pw.println(" mNetworkLockedRecordsLoadedRegistrants: size=" + this.mNetworkLockedRecordsLoadedRegistrants.size());
        for (i = 0; i < this.mNetworkLockedRecordsLoadedRegistrants.size(); ++i) {
            pw.println("  mLockedRecordsLoadedRegistrants[" + i + "]=" + ((Registrant)this.mNetworkLockedRecordsLoadedRegistrants.get(i)).getHandler());
        }
        pw.println(" mImsiReadyRegistrants: size=" + this.mImsiReadyRegistrants.size());
        for (i = 0; i < this.mImsiReadyRegistrants.size(); ++i) {
            pw.println("  mImsiReadyRegistrants[" + i + "]=" + ((Registrant)this.mImsiReadyRegistrants.get(i)).getHandler());
        }
        pw.println(" mRecordsEventsRegistrants: size=" + this.mRecordsEventsRegistrants.size());
        for (i = 0; i < this.mRecordsEventsRegistrants.size(); ++i) {
            pw.println("  mRecordsEventsRegistrants[" + i + "]=" + ((Registrant)this.mRecordsEventsRegistrants.get(i)).getHandler());
        }
        pw.println(" mNewSmsRegistrants: size=" + this.mNewSmsRegistrants.size());
        for (i = 0; i < this.mNewSmsRegistrants.size(); ++i) {
            pw.println("  mNewSmsRegistrants[" + i + "]=" + ((Registrant)this.mNewSmsRegistrants.get(i)).getHandler());
        }
        pw.println(" mNetworkSelectionModeAutomaticRegistrants: size=" + this.mNetworkSelectionModeAutomaticRegistrants.size());
        for (i = 0; i < this.mNetworkSelectionModeAutomaticRegistrants.size(); ++i) {
            pw.println("  mNetworkSelectionModeAutomaticRegistrants[" + i + "]=" + ((Registrant)this.mNetworkSelectionModeAutomaticRegistrants.get(i)).getHandler());
        }
        pw.println(" mRecordsRequested=" + this.mRecordsRequested);
        pw.println(" mLockedRecordsReqReason=" + this.mLockedRecordsReqReason);
        pw.println(" mRecordsToLoad=" + this.mRecordsToLoad);
        pw.println(" mRdnCache=" + this.mAdnCache);
        String iccIdToPrint = SubscriptionInfo.givePrintableIccid(this.mFullIccId);
        pw.println(" iccid=" + iccIdToPrint);
        pw.println(" mMsisdn=" + Rlog.pii(false, (Object)this.mMsisdn));
        pw.println(" mMsisdnTag=" + this.mMsisdnTag);
        pw.println(" mVoiceMailNum=" + Rlog.pii(false, (Object)this.mVoiceMailNum));
        pw.println(" mVoiceMailTag=" + this.mVoiceMailTag);
        pw.println(" mNewVoiceMailNum=" + Rlog.pii(false, (Object)this.mNewVoiceMailNum));
        pw.println(" mNewVoiceMailTag=" + this.mNewVoiceMailTag);
        pw.println(" mIsVoiceMailFixed=" + this.mIsVoiceMailFixed);
        pw.println(" mImsi=" + (this.mImsi != null ? this.mImsi.substring(0, 6) + Rlog.pii(false, (Object)this.mImsi.substring(6)) : "null"));
        if (this.mCarrierTestOverride.isInTestMode()) {
            pw.println(" mFakeImsi=" + this.mFakeImsi);
        }
        pw.println(" mMncLength=" + this.mMncLength);
        pw.println(" mMailboxIndex=" + this.mMailboxIndex);
        pw.println(" mSpn=" + this.mSpn);
        if (this.mCarrierTestOverride.isInTestMode()) {
            pw.println(" mFakeSpn=" + this.mFakeSpn);
        }
        pw.flush();
    }

    public static interface IccRecordLoaded {
        public String getEfName();

        public void onRecordLoaded(AsyncResult var1);
    }
}

