/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Message;
import android.os.PersistableBundle;
import android.telephony.CarrierConfigManager;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SmsMessage;
import android.telephony.SubscriptionInfo;
import android.text.TextUtils;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.gsm.SimTlv;
import com.android.internal.telephony.uicc.AdnRecord;
import com.android.internal.telephony.uicc.AdnRecordCache;
import com.android.internal.telephony.uicc.AdnRecordLoader;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.IccVmFixedException;
import com.android.internal.telephony.uicc.IccVmNotSupportedException;
import com.android.internal.telephony.uicc.PlmnActRecord;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UsimServiceTable;
import com.android.internal.telephony.uicc.VoiceMailConstants;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class SIMRecords
extends IccRecords {
    protected static final String LOG_TAG = "SIMRecords";
    private static final boolean CRASH_RIL = false;
    private static final boolean VDBG = false;
    VoiceMailConstants mVmConfig;
    private int mCallForwardingStatus;
    private GetSpnFsmState mSpnState;
    private byte[] mCphsInfo = null;
    boolean mCspPlmnEnabled = true;
    byte[] mEfMWIS = null;
    byte[] mEfCPHS_MWI = null;
    byte[] mEfCff = null;
    byte[] mEfCfis = null;
    byte[] mEfLi = null;
    byte[] mEfPl = null;
    int mSpnDisplayCondition;
    ArrayList<String> mSpdiNetworks = null;
    UsimServiceTable mUsimServiceTable;
    static final int TAG_SPDI = 163;
    static final int TAG_SPDI_PLMN_LIST = 128;
    static final int TAG_FULL_NETWORK_NAME = 67;
    static final int TAG_SHORT_NETWORK_NAME = 69;
    static final int CFF_UNCONDITIONAL_ACTIVE = 10;
    static final int CFF_UNCONDITIONAL_DEACTIVE = 5;
    static final int CFF_LINE1_MASK = 15;
    static final int CFF_LINE1_RESET = 240;
    private static final int CPHS_SST_MBN_MASK = 48;
    private static final int CPHS_SST_MBN_ENABLED = 48;
    private static final int CFIS_BCD_NUMBER_LENGTH_OFFSET = 2;
    private static final int CFIS_TON_NPI_OFFSET = 3;
    private static final int CFIS_ADN_CAPABILITY_ID_OFFSET = 14;
    private static final int CFIS_ADN_EXTENSION_ID_OFFSET = 15;
    private static final int SIM_RECORD_EVENT_BASE = 0;
    private static final int EVENT_GET_IMSI_DONE = 3;
    private static final int EVENT_GET_ICCID_DONE = 4;
    private static final int EVENT_GET_MBI_DONE = 5;
    private static final int EVENT_GET_MBDN_DONE = 6;
    private static final int EVENT_GET_MWIS_DONE = 7;
    private static final int EVENT_GET_VOICE_MAIL_INDICATOR_CPHS_DONE = 8;
    private static final int EVENT_GET_AD_DONE = 9;
    private static final int EVENT_GET_MSISDN_DONE = 10;
    private static final int EVENT_GET_CPHS_MAILBOX_DONE = 11;
    private static final int EVENT_GET_SPN_DONE = 12;
    private static final int EVENT_GET_SPDI_DONE = 13;
    private static final int EVENT_UPDATE_DONE = 14;
    private static final int EVENT_GET_PNN_DONE = 15;
    private static final int EVENT_GET_SST_DONE = 17;
    private static final int EVENT_GET_ALL_SMS_DONE = 18;
    private static final int EVENT_MARK_SMS_READ_DONE = 19;
    private static final int EVENT_SET_MBDN_DONE = 20;
    private static final int EVENT_SMS_ON_SIM = 21;
    private static final int EVENT_GET_SMS_DONE = 22;
    private static final int EVENT_GET_CFF_DONE = 24;
    private static final int EVENT_SET_CPHS_MAILBOX_DONE = 25;
    private static final int EVENT_GET_INFO_CPHS_DONE = 26;
    private static final int EVENT_SET_MSISDN_DONE = 30;
    private static final int EVENT_GET_CFIS_DONE = 32;
    private static final int EVENT_GET_CSP_CPHS_DONE = 33;
    private static final int EVENT_GET_GID1_DONE = 34;
    private static final int EVENT_GET_GID2_DONE = 36;
    private static final int EVENT_GET_PLMN_W_ACT_DONE = 37;
    private static final int EVENT_GET_OPLMN_W_ACT_DONE = 38;
    private static final int EVENT_GET_HPLMN_W_ACT_DONE = 39;
    private static final int EVENT_GET_EHPLMN_DONE = 40;
    private static final int EVENT_GET_FPLMN_DONE = 41;
    private static final int SYSTEM_EVENT_BASE = 256;
    private static final int EVENT_CARRIER_CONFIG_CHANGED = 257;
    private static final int EVENT_APP_LOCKED = 258;
    private static final int EVENT_APP_NETWORK_LOCKED = 259;
    private static final String[] MCCMNC_CODES_HAVING_3DIGITS_MNC = new String[]{"302370", "302720", "310260", "405025", "405026", "405027", "405028", "405029", "405030", "405031", "405032", "405033", "405034", "405035", "405036", "405037", "405038", "405039", "405040", "405041", "405042", "405043", "405044", "405045", "405046", "405047", "405750", "405751", "405752", "405753", "405754", "405755", "405756", "405799", "405800", "405801", "405802", "405803", "405804", "405805", "405806", "405807", "405808", "405809", "405810", "405811", "405812", "405813", "405814", "405815", "405816", "405817", "405818", "405819", "405820", "405821", "405822", "405823", "405824", "405825", "405826", "405827", "405828", "405829", "405830", "405831", "405832", "405833", "405834", "405835", "405836", "405837", "405838", "405839", "405840", "405841", "405842", "405843", "405844", "405845", "405846", "405847", "405848", "405849", "405850", "405851", "405852", "405853", "405854", "405855", "405856", "405857", "405858", "405859", "405860", "405861", "405862", "405863", "405864", "405865", "405866", "405867", "405868", "405869", "405870", "405871", "405872", "405873", "405874", "405875", "405876", "405877", "405878", "405879", "405880", "405881", "405882", "405883", "405884", "405885", "405886", "405908", "405909", "405910", "405911", "405912", "405913", "405914", "405915", "405916", "405917", "405918", "405919", "405920", "405921", "405922", "405923", "405924", "405925", "405926", "405927", "405928", "405929", "405930", "405931", "405932", "502142", "502143", "502145", "502146", "502147", "502148"};
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                SIMRecords.this.sendMessage(SIMRecords.this.obtainMessage(257));
            }
        }
    };

    @Override
    public String toString() {
        return "SimRecords: " + super.toString() + " mVmConfig" + this.mVmConfig + " callForwardingEnabled=" + this.mCallForwardingStatus + " spnState=" + (Object)((Object)this.mSpnState) + " mCphsInfo=" + this.mCphsInfo + " mCspPlmnEnabled=" + this.mCspPlmnEnabled + " efMWIS=" + this.mEfMWIS + " efCPHS_MWI=" + this.mEfCPHS_MWI + " mEfCff=" + this.mEfCff + " mEfCfis=" + this.mEfCfis + " getOperatorNumeric=" + this.getOperatorNumeric();
    }

    public SIMRecords(UiccCardApplication app, Context c, CommandsInterface ci) {
        super(app, c, ci);
        this.mAdnCache = new AdnRecordCache(this.mFh);
        this.mVmConfig = new VoiceMailConstants();
        this.mRecordsRequested = false;
        this.mLockedRecordsReqReason = 0;
        this.mRecordsToLoad = 0;
        this.mCi.setOnSmsOnSim(this, 21, null);
        this.resetRecords();
        this.mParentApp.registerForReady(this, 1, null);
        this.mParentApp.registerForLocked(this, 258, null);
        this.mParentApp.registerForNetworkLocked(this, 259, null);
        this.log("SIMRecords X ctor this=" + this);
        IntentFilter intentfilter = new IntentFilter();
        intentfilter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        c.registerReceiver(this.mReceiver, intentfilter);
    }

    @Override
    public void dispose() {
        this.log("Disposing SIMRecords this=" + this);
        this.mCi.unSetOnSmsOnSim(this);
        this.mParentApp.unregisterForReady(this);
        this.mParentApp.unregisterForLocked(this);
        this.mParentApp.unregisterForNetworkLocked(this);
        this.mContext.unregisterReceiver(this.mReceiver);
        this.resetRecords();
        super.dispose();
    }

    protected void finalize() {
        this.log("finalized");
    }

    protected void resetRecords() {
        this.mImsi = null;
        this.mMsisdn = null;
        this.mVoiceMailNum = null;
        this.mMncLength = -1;
        this.log("setting0 mMncLength" + this.mMncLength);
        this.mIccId = null;
        this.mFullIccId = null;
        this.mSpnDisplayCondition = -1;
        this.mEfMWIS = null;
        this.mEfCPHS_MWI = null;
        this.mSpdiNetworks = null;
        this.mPnnHomeName = null;
        this.mGid1 = null;
        this.mGid2 = null;
        this.mPlmnActRecords = null;
        this.mOplmnActRecords = null;
        this.mHplmnActRecords = null;
        this.mFplmns = null;
        this.mEhplmns = null;
        this.mAdnCache.reset();
        this.log("SIMRecords: onRadioOffOrNotAvailable set 'gsm.sim.operator.numeric' to operator=null");
        this.log("update icc_operator_numeric=" + null);
        this.mTelephonyManager.setSimOperatorNumericForPhone(this.mParentApp.getPhoneId(), "");
        this.mTelephonyManager.setSimOperatorNameForPhone(this.mParentApp.getPhoneId(), "");
        this.mTelephonyManager.setSimCountryIsoForPhone(this.mParentApp.getPhoneId(), "");
        this.mRecordsRequested = false;
        this.mLockedRecordsReqReason = 0;
        this.mLoaded.set(false);
    }

    @Override
    public String getMsisdnNumber() {
        return this.mMsisdn;
    }

    @Override
    public UsimServiceTable getUsimServiceTable() {
        return this.mUsimServiceTable;
    }

    private int getExtFromEf(int ef) {
        int ext;
        switch (ef) {
            case 28480: {
                if (this.mParentApp.getType() == IccCardApplicationStatus.AppType.APPTYPE_USIM) {
                    ext = 28494;
                    break;
                }
                ext = 28490;
                break;
            }
            default: {
                ext = 28490;
            }
        }
        return ext;
    }

    @Override
    public void setMsisdnNumber(String alphaTag, String number, Message onComplete) {
        this.mNewMsisdn = number;
        this.mNewMsisdnTag = alphaTag;
        this.log("Set MSISDN: " + this.mNewMsisdnTag + " " + Rlog.pii(LOG_TAG, (Object)this.mNewMsisdn));
        AdnRecord adn = new AdnRecord(this.mNewMsisdnTag, this.mNewMsisdn);
        new AdnRecordLoader(this.mFh).updateEF(adn, 28480, this.getExtFromEf(28480), 1, null, this.obtainMessage(30, onComplete));
    }

    @Override
    public String getMsisdnAlphaTag() {
        return this.mMsisdnTag;
    }

    @Override
    public String getVoiceMailNumber() {
        return this.mVoiceMailNum;
    }

    @Override
    public void setVoiceMailNumber(String alphaTag, String voiceNumber, Message onComplete) {
        if (this.mIsVoiceMailFixed) {
            AsyncResult.forMessage((Message)onComplete).exception = new IccVmFixedException("Voicemail number is fixed by operator");
            onComplete.sendToTarget();
            return;
        }
        this.mNewVoiceMailNum = voiceNumber;
        this.mNewVoiceMailTag = alphaTag;
        AdnRecord adn = new AdnRecord(this.mNewVoiceMailTag, this.mNewVoiceMailNum);
        if (this.mMailboxIndex != 0 && this.mMailboxIndex != 255) {
            new AdnRecordLoader(this.mFh).updateEF(adn, 28615, 28616, this.mMailboxIndex, null, this.obtainMessage(20, onComplete));
        } else if (this.isCphsMailboxEnabled()) {
            new AdnRecordLoader(this.mFh).updateEF(adn, 28439, 28490, 1, null, this.obtainMessage(25, onComplete));
        } else {
            AsyncResult.forMessage((Message)onComplete).exception = new IccVmNotSupportedException("Update SIM voice mailbox error");
            onComplete.sendToTarget();
        }
    }

    @Override
    public String getVoiceMailAlphaTag() {
        return this.mVoiceMailTag;
    }

    @Override
    public void setVoiceMessageWaiting(int line, int countWaiting) {
        if (line != 1) {
            return;
        }
        try {
            if (this.mEfMWIS != null) {
                this.mEfMWIS[0] = (byte)(this.mEfMWIS[0] & 0xFE | (countWaiting == 0 ? 0 : 1));
                this.mEfMWIS[1] = countWaiting < 0 ? (byte)0 : (byte)countWaiting;
                this.mFh.updateEFLinearFixed(28618, 1, this.mEfMWIS, null, this.obtainMessage(14, 28618, 0));
            }
            if (this.mEfCPHS_MWI != null) {
                this.mEfCPHS_MWI[0] = (byte)(this.mEfCPHS_MWI[0] & 0xF0 | (countWaiting == 0 ? 5 : 10));
                this.mFh.updateEFTransparent(28433, this.mEfCPHS_MWI, this.obtainMessage(14, 28433));
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.logw("Error saving voice mail state to SIM. Probably malformed SIM record", ex);
        }
    }

    private boolean validEfCfis(byte[] data) {
        if (data != null) {
            if (data[0] < 1 || data[0] > 4) {
                this.logw("MSP byte: " + data[0] + " is not between 1 and 4", null);
            }
            for (byte b : data) {
                if (b == -1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getVoiceMessageCount() {
        boolean voiceMailWaiting = false;
        int countVoiceMessages = -2;
        if (this.mEfMWIS != null) {
            voiceMailWaiting = (this.mEfMWIS[0] & 1) != 0;
            countVoiceMessages = this.mEfMWIS[1] & 0xFF;
            if (voiceMailWaiting && (countVoiceMessages == 0 || countVoiceMessages == 255)) {
                countVoiceMessages = -1;
            }
            this.log(" VoiceMessageCount from SIM MWIS = " + countVoiceMessages);
        } else if (this.mEfCPHS_MWI != null) {
            int indicator = this.mEfCPHS_MWI[0] & 0xF;
            if (indicator == 10) {
                countVoiceMessages = -1;
            } else if (indicator == 5) {
                countVoiceMessages = 0;
            }
            this.log(" VoiceMessageCount from SIM CPHS = " + countVoiceMessages);
        }
        return countVoiceMessages;
    }

    @Override
    public int getVoiceCallForwardingFlag() {
        return this.mCallForwardingStatus;
    }

    @Override
    public void setVoiceCallForwardingFlag(int line, boolean enable, String dialNumber) {
        if (line != 1) {
            return;
        }
        this.mCallForwardingStatus = enable ? 1 : 0;
        this.mRecordsEventsRegistrants.notifyResult(1);
        try {
            if (this.validEfCfis(this.mEfCfis)) {
                this.mEfCfis[1] = enable ? (byte)(this.mEfCfis[1] | 1) : (byte)(this.mEfCfis[1] & 0xFE);
                this.log("setVoiceCallForwardingFlag: enable=" + enable + " mEfCfis=" + IccUtils.bytesToHexString(this.mEfCfis));
                if (enable && !TextUtils.isEmpty(dialNumber)) {
                    this.logv("EF_CFIS: updating cf number, " + Rlog.pii(LOG_TAG, (Object)dialNumber));
                    byte[] bcdNumber = PhoneNumberUtils.numberToCalledPartyBCD(dialNumber, 1);
                    System.arraycopy((byte[])bcdNumber, (int)0, (byte[])this.mEfCfis, (int)3, (int)bcdNumber.length);
                    this.mEfCfis[2] = (byte)bcdNumber.length;
                    this.mEfCfis[14] = -1;
                    this.mEfCfis[15] = -1;
                }
                this.mFh.updateEFLinearFixed(28619, 1, this.mEfCfis, null, this.obtainMessage(14, 28619));
            } else {
                this.log("setVoiceCallForwardingFlag: ignoring enable=" + enable + " invalid mEfCfis=" + IccUtils.bytesToHexString(this.mEfCfis));
            }
            if (this.mEfCff != null) {
                this.mEfCff[0] = enable ? (byte)(this.mEfCff[0] & 0xF0 | 0xA) : (byte)(this.mEfCff[0] & 0xF0 | 5);
                this.mFh.updateEFTransparent(28435, this.mEfCff, this.obtainMessage(14, 28435));
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.logw("Error saving call forwarding flag to SIM. Probably malformed SIM record", ex);
        }
    }

    @Override
    public void onRefresh(boolean fileChanged, int[] fileList) {
        if (fileChanged) {
            this.fetchSimRecords();
        }
    }

    @Override
    public String getOperatorNumeric() {
        String imsi = this.getIMSI();
        if (imsi == null) {
            this.log("getOperatorNumeric: IMSI == null");
            return null;
        }
        if (this.mMncLength == -1 || this.mMncLength == 0) {
            this.log("getSIMOperatorNumeric: bad mncLength");
            return null;
        }
        if (imsi.length() >= 3 + this.mMncLength) {
            return imsi.substring(0, 3 + this.mMncLength);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message msg) {
        boolean isRecordLoadResponse = false;
        if (this.mDestroyed.get()) {
            this.loge("Received message " + msg + "[" + msg.what + "]  while being destroyed. Ignoring.");
            return;
        }
        try {
            switch (msg.what) {
                case 1: {
                    this.onReady();
                    return;
                }
                case 258: 
                case 259: {
                    this.onLocked(msg.what);
                    return;
                }
                case 3: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.loge("Exception querying IMSI, Exception:" + ar.exception);
                        return;
                    }
                    this.mImsi = (String)ar.result;
                    if (this.mImsi != null && (this.mImsi.length() < 6 || this.mImsi.length() > 15)) {
                        this.loge("invalid IMSI " + this.mImsi);
                        this.mImsi = null;
                    }
                    this.log("IMSI: mMncLength=" + this.mMncLength);
                    if (this.mImsi != null && this.mImsi.length() >= 6) {
                        this.log("IMSI: " + this.mImsi.substring(0, 6) + Rlog.pii(LOG_TAG, (Object)this.mImsi.substring(6)));
                    }
                    String imsi = this.getIMSI();
                    if ((this.mMncLength == 0 || this.mMncLength == 2) && imsi != null && imsi.length() >= 6) {
                        String mccmncCode = imsi.substring(0, 6);
                        for (String mccmnc : MCCMNC_CODES_HAVING_3DIGITS_MNC) {
                            if (!mccmnc.equals(mccmncCode)) continue;
                            this.mMncLength = 3;
                            this.log("IMSI: setting1 mMncLength=" + this.mMncLength);
                            break;
                        }
                    }
                    if (this.mMncLength == 0) {
                        try {
                            int mcc = Integer.parseInt(imsi.substring(0, 3));
                            this.mMncLength = MccTable.smallestDigitsMccForMnc(mcc);
                            this.log("setting2 mMncLength=" + this.mMncLength);
                        }
                        catch (NumberFormatException e) {
                            this.mMncLength = 0;
                            this.loge("Corrupt IMSI! setting3 mMncLength=" + this.mMncLength);
                        }
                    }
                    if (this.mMncLength != 0 && this.mMncLength != -1 && imsi.length() >= 3 + this.mMncLength) {
                        this.log("update mccmnc=" + imsi.substring(0, 3 + this.mMncLength));
                        MccTable.updateMccMncConfiguration(this.mContext, imsi.substring(0, 3 + this.mMncLength), false);
                    }
                    this.mImsiReadyRegistrants.notifyRegistrants();
                    return;
                }
                case 5: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    boolean isValidMbdn = false;
                    if (ar.exception == null) {
                        this.log("EF_MBI: " + IccUtils.bytesToHexString(data));
                        this.mMailboxIndex = data[0] & 0xFF;
                        if (this.mMailboxIndex != 0 && this.mMailboxIndex != 255) {
                            this.log("Got valid mailbox number for MBDN");
                            isValidMbdn = true;
                        }
                    }
                    ++this.mRecordsToLoad;
                    if (isValidMbdn) {
                        new AdnRecordLoader(this.mFh).loadFromEF(28615, 28616, this.mMailboxIndex, this.obtainMessage(6));
                        return;
                    }
                    new AdnRecordLoader(this.mFh).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
                    return;
                }
                case 6: 
                case 11: {
                    this.mVoiceMailNum = null;
                    this.mVoiceMailTag = null;
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.log("Invalid or missing EF" + (msg.what == 11 ? "[MAILBOX]" : "[MBDN]"));
                        if (msg.what != 6) return;
                        ++this.mRecordsToLoad;
                        new AdnRecordLoader(this.mFh).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
                        return;
                    }
                    AdnRecord adn = (AdnRecord)ar.result;
                    this.log("VM: " + adn + (msg.what == 11 ? " EF[MAILBOX]" : " EF[MBDN]"));
                    if (adn.isEmpty() && msg.what == 6) {
                        ++this.mRecordsToLoad;
                        new AdnRecordLoader(this.mFh).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
                        return;
                    }
                    this.mVoiceMailNum = adn.getNumber();
                    this.mVoiceMailTag = adn.getAlphaTag();
                    return;
                }
                case 10: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.log("Invalid or missing EF[MSISDN]");
                        return;
                    }
                    AdnRecord adn = (AdnRecord)ar.result;
                    this.mMsisdn = adn.getNumber();
                    this.mMsisdnTag = adn.getAlphaTag();
                    this.log("MSISDN: " + Rlog.pii(LOG_TAG, (Object)this.mMsisdn));
                    return;
                }
                case 30: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        this.mMsisdn = this.mNewMsisdn;
                        this.mMsisdnTag = this.mNewMsisdnTag;
                        this.log("Success to update EF[MSISDN]");
                    }
                    if (ar.userObj == null) return;
                    AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                    ((Message)ar.userObj).sendToTarget();
                    return;
                }
                case 7: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    this.log("EF_MWIS : " + IccUtils.bytesToHexString(data));
                    if (ar.exception != null) {
                        this.log("EVENT_GET_MWIS_DONE exception = " + ar.exception);
                        return;
                    }
                    if ((data[0] & 0xFF) == 255) {
                        this.log("SIMRecords: Uninitialized record MWIS");
                        return;
                    }
                    this.mEfMWIS = data;
                    return;
                }
                case 8: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    this.log("EF_CPHS_MWI: " + IccUtils.bytesToHexString(data));
                    if (ar.exception != null) {
                        this.log("EVENT_GET_VOICE_MAIL_INDICATOR_CPHS_DONE exception = " + ar.exception);
                        return;
                    }
                    this.mEfCPHS_MWI = data;
                    return;
                }
                case 4: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    }
                    this.mIccId = IccUtils.bcdToString(data, 0, data.length);
                    this.mFullIccId = IccUtils.bchToString(data, 0, data.length);
                    this.log("iccid: " + SubscriptionInfo.givePrintableIccid(this.mFullIccId));
                    return;
                }
                case 9: {
                    try {
                        isRecordLoadResponse = true;
                        if (this.mCarrierTestOverride.isInTestMode() && this.getIMSI() != null) {
                            String imsi = this.getIMSI();
                            try {
                                int mcc = Integer.parseInt(imsi.substring(0, 3));
                                this.mMncLength = MccTable.smallestDigitsMccForMnc(mcc);
                                this.log("[TestMode] mMncLength=" + this.mMncLength);
                            }
                            catch (NumberFormatException e) {
                                this.mMncLength = 0;
                                this.loge("[TestMode] Corrupt IMSI! mMncLength=" + this.mMncLength);
                            }
                        } else {
                            AsyncResult ar = (AsyncResult)msg.obj;
                            byte[] data = (byte[])ar.result;
                            if (ar.exception != null) {
                                return;
                            }
                            this.log("EF_AD: " + IccUtils.bytesToHexString(data));
                            if (data.length < 3) {
                                this.log("Corrupt AD data on SIM");
                                return;
                            }
                            if (data.length == 3) {
                                this.log("MNC length not present in EF_AD");
                                return;
                            }
                            this.mMncLength = data[3] & 0xF;
                            this.log("setting4 mMncLength=" + this.mMncLength);
                        }
                        if (this.mMncLength == 15) {
                            this.mMncLength = 0;
                            this.log("setting5 mMncLength=" + this.mMncLength);
                            return;
                        }
                        if (this.mMncLength == 2) return;
                        if (this.mMncLength == 3) return;
                        this.mMncLength = -1;
                        this.log("setting5 mMncLength=" + this.mMncLength);
                        return;
                    }
                    finally {
                        String imsi = this.getIMSI();
                        if ((this.mMncLength == -1 || this.mMncLength == 0 || this.mMncLength == 2) && imsi != null && imsi.length() >= 6) {
                            String mccmncCode = imsi.substring(0, 6);
                            this.log("mccmncCode=" + mccmncCode);
                            for (String mccmnc : MCCMNC_CODES_HAVING_3DIGITS_MNC) {
                                if (!mccmnc.equals(mccmncCode)) continue;
                                this.mMncLength = 3;
                                this.log("setting6 mMncLength=" + this.mMncLength);
                                break;
                            }
                        }
                        if (this.mMncLength == 0 || this.mMncLength == -1) {
                            if (imsi != null) {
                                try {
                                    int mcc = Integer.parseInt(imsi.substring(0, 3));
                                    this.mMncLength = MccTable.smallestDigitsMccForMnc(mcc);
                                    this.log("setting7 mMncLength=" + this.mMncLength);
                                }
                                catch (NumberFormatException e) {
                                    this.mMncLength = 0;
                                    this.loge("Corrupt IMSI! setting8 mMncLength=" + this.mMncLength);
                                }
                            } else {
                                this.mMncLength = 0;
                                this.log("MNC length not present in EF_AD setting9 mMncLength=" + this.mMncLength);
                            }
                        }
                        if (imsi != null && this.mMncLength != 0 && imsi.length() >= 3 + this.mMncLength) {
                            this.log("update mccmnc=" + imsi.substring(0, 3 + this.mMncLength));
                            MccTable.updateMccMncConfiguration(this.mContext, imsi.substring(0, 3 + this.mMncLength), false);
                        }
                    }
                }
                case 12: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    this.getSpnFsm(false, ar);
                    return;
                }
                case 24: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        this.mEfCff = null;
                        return;
                    }
                    this.log("EF_CFF_CPHS: " + IccUtils.bytesToHexString(data));
                    this.mEfCff = data;
                    return;
                }
                case 13: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    }
                    this.parseEfSpdi(data);
                    return;
                }
                case 14: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) return;
                    this.logw("update failed. ", ar.exception);
                    return;
                }
                case 15: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    }
                    SimTlv tlv = new SimTlv(data, 0, data.length);
                    while (tlv.isValidObject()) {
                        if (tlv.getTag() == 67) {
                            this.mPnnHomeName = IccUtils.networkNameToString(tlv.getData(), 0, tlv.getData().length);
                            this.log("PNN: " + this.mPnnHomeName);
                            return;
                        }
                        tlv.nextObject();
                    }
                    return;
                }
                case 18: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        return;
                    }
                    this.handleSmses((ArrayList)ar.result);
                    return;
                }
                case 19: {
                    Rlog.i("ENF", "marked read: sms " + msg.arg1);
                    return;
                }
                case 21: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Integer index = (Integer)ar.result;
                    if (ar.exception == null && index != null) {
                        this.log("READ EF_SMS RECORD index=" + index);
                        this.mFh.loadEFLinearFixed(28476, index, this.obtainMessage(22));
                        return;
                    }
                    this.loge("Error on SMS_ON_SIM with exp " + ar.exception + " index " + index);
                    return;
                }
                case 22: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        this.handleSms((byte[])ar.result);
                        return;
                    }
                    this.loge("Error on GET_SMS with exp " + ar.exception);
                    return;
                }
                case 17: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    }
                    this.mUsimServiceTable = new UsimServiceTable(data);
                    this.log("SST: " + this.mUsimServiceTable);
                    return;
                }
                case 26: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        return;
                    }
                    this.mCphsInfo = (byte[])ar.result;
                    this.log("iCPHS: " + IccUtils.bytesToHexString(this.mCphsInfo));
                    return;
                }
                case 20: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    this.log("EVENT_SET_MBDN_DONE ex:" + ar.exception);
                    if (ar.exception == null) {
                        this.mVoiceMailNum = this.mNewVoiceMailNum;
                        this.mVoiceMailTag = this.mNewVoiceMailTag;
                    }
                    if (this.isCphsMailboxEnabled()) {
                        AdnRecord adn = new AdnRecord(this.mVoiceMailTag, this.mVoiceMailNum);
                        Message onCphsCompleted = (Message)ar.userObj;
                        if (ar.exception == null && ar.userObj != null) {
                            AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = null;
                            ((Message)ar.userObj).sendToTarget();
                            this.log("Callback with MBDN successful.");
                            onCphsCompleted = null;
                        }
                        new AdnRecordLoader(this.mFh).updateEF(adn, 28439, 28490, 1, null, this.obtainMessage(25, onCphsCompleted));
                        return;
                    }
                    if (ar.userObj == null) return;
                    CarrierConfigManager configLoader = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
                    AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception != null && configLoader != null && configLoader.getConfig().getBoolean("editable_voicemail_number_bool") ? new IccVmNotSupportedException("Update SIM voice mailbox error") : ar.exception;
                    ((Message)ar.userObj).sendToTarget();
                    return;
                }
                case 25: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        this.mVoiceMailNum = this.mNewVoiceMailNum;
                        this.mVoiceMailTag = this.mNewVoiceMailTag;
                    } else {
                        this.log("Set CPHS MailBox with exception: " + ar.exception);
                    }
                    if (ar.userObj == null) return;
                    this.log("Callback with CPHS MB successful.");
                    AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                    ((Message)ar.userObj).sendToTarget();
                    return;
                }
                case 32: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        this.mEfCfis = null;
                        return;
                    }
                    this.log("EF_CFIS: " + IccUtils.bytesToHexString(data));
                    this.mEfCfis = data;
                    return;
                }
                case 33: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.loge("Exception in fetching EF_CSP data " + ar.exception);
                        return;
                    }
                    byte[] data = (byte[])ar.result;
                    this.log("EF_CSP: " + IccUtils.bytesToHexString(data));
                    this.handleEfCspData(data);
                    return;
                }
                case 34: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        this.loge("Exception in get GID1 " + ar.exception);
                        this.mGid1 = null;
                        return;
                    }
                    this.mGid1 = IccUtils.bytesToHexString(data);
                    this.log("GID1: " + this.mGid1);
                    return;
                }
                case 36: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        this.loge("Exception in get GID2 " + ar.exception);
                        this.mGid2 = null;
                        return;
                    }
                    this.mGid2 = IccUtils.bytesToHexString(data);
                    this.log("GID2: " + this.mGid2);
                    return;
                }
                case 37: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception == null && data != null) {
                        this.log("Received a PlmnActRecord, raw=" + IccUtils.bytesToHexString(data));
                        this.mPlmnActRecords = PlmnActRecord.getRecords(data);
                        return;
                    }
                    this.loge("Failed getting User PLMN with Access Tech Records: " + ar.exception);
                    return;
                }
                case 38: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception == null && data != null) {
                        this.log("Received a PlmnActRecord, raw=" + IccUtils.bytesToHexString(data));
                        this.mOplmnActRecords = PlmnActRecord.getRecords(data);
                        return;
                    }
                    this.loge("Failed getting Operator PLMN with Access Tech Records: " + ar.exception);
                    return;
                }
                case 39: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception == null && data != null) {
                        this.log("Received a PlmnActRecord, raw=" + IccUtils.bytesToHexString(data));
                        this.mHplmnActRecords = PlmnActRecord.getRecords(data);
                        this.log("HplmnActRecord[]=" + Arrays.toString(this.mHplmnActRecords));
                        return;
                    }
                    this.loge("Failed getting Home PLMN with Access Tech Records: " + ar.exception);
                    return;
                }
                case 40: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception == null && data != null) {
                        this.mEhplmns = this.parseBcdPlmnList(data, "Equivalent Home");
                        return;
                    }
                    this.loge("Failed getting Equivalent Home PLMNs: " + ar.exception);
                    return;
                }
                case 41: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null || data == null) {
                        this.loge("Failed getting Forbidden PLMNs: " + ar.exception);
                        return;
                    }
                    this.mFplmns = this.parseBcdPlmnList(data, "Forbidden");
                    if (msg.arg1 != 1238273) return;
                    isRecordLoadResponse = false;
                    Message response = this.retrievePendingResponseMessage(msg.arg2);
                    if (response != null) {
                        AsyncResult.forMessage(response, Arrays.copyOf(this.mFplmns, this.mFplmns.length), null);
                        response.sendToTarget();
                        return;
                    }
                    this.loge("Failed to retrieve a response message for FPLMN");
                    return;
                }
                case 257: {
                    this.handleCarrierNameOverride();
                    return;
                }
            }
            super.handleMessage(msg);
            return;
        }
        catch (RuntimeException exc) {
            this.logw("Exception parsing SIM record", exc);
            return;
        }
        finally {
            if (isRecordLoadResponse) {
                this.onRecordLoaded();
            }
        }
    }

    @Override
    protected void handleFileUpdate(int efid) {
        switch (efid) {
            case 28615: {
                ++this.mRecordsToLoad;
                new AdnRecordLoader(this.mFh).loadFromEF(28615, 28616, this.mMailboxIndex, this.obtainMessage(6));
                break;
            }
            case 28439: {
                ++this.mRecordsToLoad;
                new AdnRecordLoader(this.mFh).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
                break;
            }
            case 28437: {
                ++this.mRecordsToLoad;
                this.log("[CSP] SIM Refresh for EF_CSP_CPHS");
                this.mFh.loadEFTransparent(28437, this.obtainMessage(33));
                break;
            }
            case 28475: {
                this.log("SIM Refresh called for EF_FDN");
                this.mParentApp.queryFdn();
                this.mAdnCache.reset();
                break;
            }
            case 28480: {
                ++this.mRecordsToLoad;
                this.log("SIM Refresh called for EF_MSISDN");
                new AdnRecordLoader(this.mFh).loadFromEF(28480, this.getExtFromEf(28480), 1, this.obtainMessage(10));
                break;
            }
            case 28435: 
            case 28619: {
                this.log("SIM Refresh called for EF_CFIS or EF_CFF_CPHS");
                this.loadCallForwardingRecords();
                break;
            }
            default: {
                this.mAdnCache.reset();
                this.fetchSimRecords();
            }
        }
    }

    private int dispatchGsmMessage(SmsMessage message) {
        this.mNewSmsRegistrants.notifyResult(message);
        return 0;
    }

    private void handleSms(byte[] ba) {
        if (ba[0] != 0) {
            Rlog.d("ENF", "status : " + ba[0]);
        }
        if (ba[0] == 3) {
            int n = ba.length;
            byte[] pdu = new byte[n - 1];
            System.arraycopy((byte[])ba, (int)1, (byte[])pdu, (int)0, (int)(n - 1));
            SmsMessage message = SmsMessage.createFromPdu(pdu, "3gpp");
            this.dispatchGsmMessage(message);
        }
    }

    private void handleSmses(ArrayList<byte[]> messages) {
        int count = messages.size();
        for (int i = 0; i < count; ++i) {
            byte[] ba = messages.get(i);
            if (ba[0] != 0) {
                Rlog.i("ENF", "status " + i + ": " + ba[0]);
            }
            if (ba[0] != 3) continue;
            int n = ba.length;
            byte[] pdu = new byte[n - 1];
            System.arraycopy((byte[])ba, (int)1, (byte[])pdu, (int)0, (int)(n - 1));
            SmsMessage message = SmsMessage.createFromPdu(pdu, "3gpp");
            this.dispatchGsmMessage(message);
            ba[0] = 1;
        }
    }

    @Override
    protected void onRecordLoaded() {
        --this.mRecordsToLoad;
        this.log("onRecordLoaded " + this.mRecordsToLoad + " requested: " + this.mRecordsRequested);
        if (this.getRecordsLoaded()) {
            this.onAllRecordsLoaded();
        } else if (this.getLockedRecordsLoaded() || this.getNetworkLockedRecordsLoaded()) {
            this.onLockedAllRecordsLoaded();
        } else if (this.mRecordsToLoad < 0) {
            this.loge("recordsToLoad <0, programmer error suspected");
            this.mRecordsToLoad = 0;
        }
    }

    private void setVoiceCallForwardingFlagFromSimRecords() {
        if (this.validEfCfis(this.mEfCfis)) {
            this.mCallForwardingStatus = this.mEfCfis[1] & 1;
            this.log("EF_CFIS: callForwardingEnabled=" + this.mCallForwardingStatus);
        } else if (this.mEfCff != null) {
            this.mCallForwardingStatus = (this.mEfCff[0] & 0xF) == 10 ? 1 : 0;
            this.log("EF_CFF: callForwardingEnabled=" + this.mCallForwardingStatus);
        } else {
            this.mCallForwardingStatus = -1;
            this.log("EF_CFIS and EF_CFF not valid. callForwardingEnabled=" + this.mCallForwardingStatus);
        }
    }

    private void setSimLanguageFromEF() {
        Resources resource = Resources.getSystem();
        if (resource.getBoolean(17957055)) {
            this.setSimLanguage(this.mEfLi, this.mEfPl);
        } else {
            this.log("Not using EF LI/EF PL");
        }
    }

    private void onLockedAllRecordsLoaded() {
        this.setSimLanguageFromEF();
        if (this.mLockedRecordsReqReason == 1) {
            this.mLockedRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (this.mLockedRecordsReqReason == 2) {
            this.mNetworkLockedRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else {
            this.loge("onLockedAllRecordsLoaded: unexpected mLockedRecordsReqReason " + this.mLockedRecordsReqReason);
        }
    }

    @Override
    protected void onAllRecordsLoaded() {
        this.log("record load complete");
        this.setSimLanguageFromEF();
        this.setVoiceCallForwardingFlagFromSimRecords();
        String operator = this.getOperatorNumeric();
        if (!TextUtils.isEmpty(operator)) {
            this.log("onAllRecordsLoaded set 'gsm.sim.operator.numeric' to operator='" + operator + "'");
            this.mTelephonyManager.setSimOperatorNumericForPhone(this.mParentApp.getPhoneId(), operator);
        } else {
            this.log("onAllRecordsLoaded empty 'gsm.sim.operator.numeric' skipping");
        }
        String imsi = this.getIMSI();
        if (!TextUtils.isEmpty(imsi) && imsi.length() >= 3) {
            this.log("onAllRecordsLoaded set mcc imsi" + "");
            this.mTelephonyManager.setSimCountryIsoForPhone(this.mParentApp.getPhoneId(), MccTable.countryCodeForMcc(Integer.parseInt(imsi.substring(0, 3))));
        } else {
            this.log("onAllRecordsLoaded empty imsi skipping setting mcc");
        }
        this.setVoiceMailByCountry(operator);
        this.mLoaded.set(true);
        this.mRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
    }

    private void handleCarrierNameOverride() {
        int phoneId = this.mParentApp.getPhoneId();
        SubscriptionController subCon = SubscriptionController.getInstance();
        int subId = subCon.getSubIdUsingPhoneId(phoneId);
        if (subId == -1) {
            this.loge("subId not valid for Phone " + phoneId);
            return;
        }
        CarrierConfigManager configLoader = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        if (configLoader == null) {
            this.loge("Failed to load a Carrier Config");
            return;
        }
        PersistableBundle config = configLoader.getConfigForSubId(subId);
        boolean preferCcName = config.getBoolean("carrier_name_override_bool", false);
        String ccName = config.getString("carrier_name_string");
        if (preferCcName || TextUtils.isEmpty(this.getServiceProviderName()) && !TextUtils.isEmpty(ccName)) {
            this.setServiceProviderName(ccName);
            this.mTelephonyManager.setSimOperatorNameForPhone(phoneId, ccName);
        }
        this.updateCarrierNameForSubscription(subCon, subId);
    }

    private void updateCarrierNameForSubscription(SubscriptionController subCon, int subId) {
        SubscriptionInfo subInfo = subCon.getActiveSubscriptionInfo(subId, this.mContext.getOpPackageName());
        if (subInfo == null || subInfo.getNameSource() == 2) {
            return;
        }
        CharSequence oldSubName = subInfo.getDisplayName();
        String newCarrierName = this.mTelephonyManager.getSimOperatorName(subId);
        if (!TextUtils.isEmpty(newCarrierName) && !newCarrierName.equals(oldSubName)) {
            this.log("sim name[" + this.mParentApp.getPhoneId() + "] = " + newCarrierName);
            subCon.setDisplayName(newCarrierName, subId);
        }
    }

    private void setVoiceMailByCountry(String spn) {
        if (this.mVmConfig.containsCarrier(spn)) {
            this.mIsVoiceMailFixed = true;
            this.mVoiceMailNum = this.mVmConfig.getVoiceMailNumber(spn);
            this.mVoiceMailTag = this.mVmConfig.getVoiceMailTag(spn);
        }
    }

    public void getForbiddenPlmns(Message response) {
        int key = this.storePendingResponseMessage(response);
        this.mFh.loadEFTransparent(28539, this.obtainMessage(41, 1238273, key));
    }

    @Override
    public void onReady() {
        this.fetchSimRecords();
    }

    private void onLocked(int msg) {
        this.log("only fetch EF_LI, EF_PL and EF_ICCID in locked state");
        this.mLockedRecordsReqReason = msg == 258 ? 1 : 2;
        this.loadEfLiAndEfPl();
        this.mFh.loadEFTransparent(12258, this.obtainMessage(4));
        ++this.mRecordsToLoad;
    }

    private void loadEfLiAndEfPl() {
        if (this.mParentApp.getType() == IccCardApplicationStatus.AppType.APPTYPE_USIM) {
            this.mFh.loadEFTransparent(28421, this.obtainMessage(100, new EfUsimLiLoaded()));
            ++this.mRecordsToLoad;
            this.mFh.loadEFTransparent(12037, this.obtainMessage(100, new EfPlLoaded()));
            ++this.mRecordsToLoad;
        }
    }

    private void loadCallForwardingRecords() {
        this.mRecordsRequested = true;
        this.mFh.loadEFLinearFixed(28619, 1, this.obtainMessage(32));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28435, this.obtainMessage(24));
        ++this.mRecordsToLoad;
    }

    protected void fetchSimRecords() {
        this.mRecordsRequested = true;
        this.log("fetchSimRecords " + this.mRecordsToLoad);
        this.mCi.getIMSIForApp(this.mParentApp.getAid(), this.obtainMessage(3));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(12258, this.obtainMessage(4));
        ++this.mRecordsToLoad;
        new AdnRecordLoader(this.mFh).loadFromEF(28480, this.getExtFromEf(28480), 1, this.obtainMessage(10));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixed(28617, 1, this.obtainMessage(5));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28589, this.obtainMessage(9));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixed(28618, 1, this.obtainMessage(7));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28433, this.obtainMessage(8));
        ++this.mRecordsToLoad;
        this.loadCallForwardingRecords();
        this.getSpnFsm(true, null);
        this.mFh.loadEFTransparent(28621, this.obtainMessage(13));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixed(28613, 1, this.obtainMessage(15));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28472, this.obtainMessage(17));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28438, this.obtainMessage(26));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28437, this.obtainMessage(33));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28478, this.obtainMessage(34));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28479, this.obtainMessage(36));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28512, this.obtainMessage(37));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28513, this.obtainMessage(38));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28514, this.obtainMessage(39));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28633, this.obtainMessage(40));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28539, this.obtainMessage(41, 1238272, -1));
        ++this.mRecordsToLoad;
        this.loadEfLiAndEfPl();
        this.log("fetchSimRecords " + this.mRecordsToLoad + " requested: " + this.mRecordsRequested);
    }

    @Override
    public int getDisplayRule(ServiceState serviceState) {
        int rule;
        if (this.mParentApp != null && this.mParentApp.getUiccProfile() != null && this.mParentApp.getUiccProfile().getOperatorBrandOverride() != null) {
            rule = 2;
        } else if (TextUtils.isEmpty(this.getServiceProviderName()) || this.mSpnDisplayCondition == -1) {
            rule = 2;
        } else if (this.useRoamingFromServiceState() ? !serviceState.getRoaming() : this.isOnMatchingPlmn(serviceState.getOperatorNumeric())) {
            rule = 1;
            if ((this.mSpnDisplayCondition & 1) == 1) {
                rule |= 2;
            }
        } else {
            rule = 2;
            if ((this.mSpnDisplayCondition & 2) == 0) {
                rule |= 1;
            }
        }
        return rule;
    }

    private boolean useRoamingFromServiceState() {
        PersistableBundle b;
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        return configManager != null && (b = configManager.getConfigForSubId(SubscriptionController.getInstance().getSubIdUsingPhoneId(this.mParentApp.getPhoneId()))) != null && b.getBoolean("spn_display_rule_use_roaming_from_service_state_bool");
    }

    private boolean isOnMatchingPlmn(String plmn) {
        if (plmn == null) {
            return false;
        }
        if (plmn.equals(this.getOperatorNumeric())) {
            return true;
        }
        if (this.mSpdiNetworks != null) {
            for (String spdiNet : this.mSpdiNetworks) {
                if (!plmn.equals(spdiNet)) continue;
                return true;
            }
        }
        return false;
    }

    private void getSpnFsm(boolean start, AsyncResult ar) {
        if (start) {
            if (this.mSpnState == GetSpnFsmState.READ_SPN_3GPP || this.mSpnState == GetSpnFsmState.READ_SPN_CPHS || this.mSpnState == GetSpnFsmState.READ_SPN_SHORT_CPHS || this.mSpnState == GetSpnFsmState.INIT) {
                this.mSpnState = GetSpnFsmState.INIT;
                return;
            }
            this.mSpnState = GetSpnFsmState.INIT;
        }
        switch (this.mSpnState) {
            case INIT: {
                this.setServiceProviderName(null);
                this.mFh.loadEFTransparent(28486, this.obtainMessage(12));
                ++this.mRecordsToLoad;
                this.mSpnState = GetSpnFsmState.READ_SPN_3GPP;
                break;
            }
            case READ_SPN_3GPP: {
                if (ar != null && ar.exception == null) {
                    byte[] data = (byte[])ar.result;
                    this.mSpnDisplayCondition = 0xFF & data[0];
                    this.setServiceProviderName(IccUtils.adnStringFieldToString(data, 1, data.length - 1));
                    String spn = this.getServiceProviderName();
                    if (spn == null || spn.length() == 0) {
                        this.mSpnState = GetSpnFsmState.READ_SPN_CPHS;
                    } else {
                        this.log("Load EF_SPN: " + spn + " spnDisplayCondition: " + this.mSpnDisplayCondition);
                        this.mTelephonyManager.setSimOperatorNameForPhone(this.mParentApp.getPhoneId(), spn);
                        this.mSpnState = GetSpnFsmState.IDLE;
                    }
                } else {
                    this.mSpnState = GetSpnFsmState.READ_SPN_CPHS;
                }
                if (this.mSpnState != GetSpnFsmState.READ_SPN_CPHS) break;
                this.mFh.loadEFTransparent(28436, this.obtainMessage(12));
                ++this.mRecordsToLoad;
                this.mSpnDisplayCondition = -1;
                break;
            }
            case READ_SPN_CPHS: {
                if (ar != null && ar.exception == null) {
                    byte[] data = (byte[])ar.result;
                    this.setServiceProviderName(IccUtils.adnStringFieldToString(data, 0, data.length));
                    String spn = this.getServiceProviderName();
                    if (spn == null || spn.length() == 0) {
                        this.mSpnState = GetSpnFsmState.READ_SPN_SHORT_CPHS;
                    } else {
                        this.mSpnDisplayCondition = 2;
                        this.log("Load EF_SPN_CPHS: " + spn);
                        this.mTelephonyManager.setSimOperatorNameForPhone(this.mParentApp.getPhoneId(), spn);
                        this.mSpnState = GetSpnFsmState.IDLE;
                    }
                } else {
                    this.mSpnState = GetSpnFsmState.READ_SPN_SHORT_CPHS;
                }
                if (this.mSpnState != GetSpnFsmState.READ_SPN_SHORT_CPHS) break;
                this.mFh.loadEFTransparent(28440, this.obtainMessage(12));
                ++this.mRecordsToLoad;
                break;
            }
            case READ_SPN_SHORT_CPHS: {
                if (ar != null && ar.exception == null) {
                    byte[] data = (byte[])ar.result;
                    this.setServiceProviderName(IccUtils.adnStringFieldToString(data, 0, data.length));
                    String spn = this.getServiceProviderName();
                    if (spn == null || spn.length() == 0) {
                        this.log("No SPN loaded in either CHPS or 3GPP");
                    } else {
                        this.mSpnDisplayCondition = 2;
                        this.log("Load EF_SPN_SHORT_CPHS: " + spn);
                        this.mTelephonyManager.setSimOperatorNameForPhone(this.mParentApp.getPhoneId(), spn);
                    }
                } else {
                    this.setServiceProviderName(null);
                    this.log("No SPN loaded in either CHPS or 3GPP");
                }
                this.mSpnState = GetSpnFsmState.IDLE;
                break;
            }
            default: {
                this.mSpnState = GetSpnFsmState.IDLE;
            }
        }
    }

    private void parseEfSpdi(byte[] data) {
        SimTlv tlv = new SimTlv(data, 0, data.length);
        byte[] plmnEntries = null;
        while (tlv.isValidObject()) {
            if (tlv.getTag() == 163) {
                tlv = new SimTlv(tlv.getData(), 0, tlv.getData().length);
            }
            if (tlv.getTag() == 128) {
                plmnEntries = tlv.getData();
                break;
            }
            tlv.nextObject();
        }
        if (plmnEntries == null) {
            return;
        }
        this.mSpdiNetworks = new ArrayList(plmnEntries.length / 3);
        int i = 0;
        while (i + 2 < plmnEntries.length) {
            String plmnCode = IccUtils.bcdPlmnToString(plmnEntries, i);
            if (plmnCode != null && plmnCode.length() >= 5) {
                this.log("EF_SPDI network: " + plmnCode);
                this.mSpdiNetworks.add(plmnCode);
            }
            i += 3;
        }
    }

    private String[] parseBcdPlmnList(byte[] data, String description) {
        int packedBcdPlmnLenBytes = 3;
        this.log("Received " + description + " PLMNs, raw=" + IccUtils.bytesToHexString(data));
        if (data.length == 0 || data.length % 3 != 0) {
            this.loge("Received invalid " + description + " PLMN list");
            return null;
        }
        int numPlmns = data.length / 3;
        int numValidPlmns = 0;
        String[] parsed = new String[numPlmns];
        for (int i = 0; i < numPlmns; ++i) {
            parsed[numValidPlmns] = IccUtils.bcdPlmnToString(data, i * 3);
            if (TextUtils.isEmpty(parsed[numValidPlmns])) continue;
            ++numValidPlmns;
        }
        String[] ret = Arrays.copyOf(parsed, numValidPlmns);
        return ret;
    }

    private boolean isCphsMailboxEnabled() {
        if (this.mCphsInfo == null) {
            return false;
        }
        return (this.mCphsInfo[1] & 0x30) == 48;
    }

    @Override
    protected void log(String s) {
        Rlog.d(LOG_TAG, "[SIMRecords] " + s);
    }

    @Override
    protected void loge(String s) {
        Rlog.e(LOG_TAG, "[SIMRecords] " + s);
    }

    protected void logw(String s, Throwable tr) {
        Rlog.w(LOG_TAG, "[SIMRecords] " + s, tr);
    }

    protected void logv(String s) {
        Rlog.v(LOG_TAG, "[SIMRecords] " + s);
    }

    @Override
    public boolean isCspPlmnEnabled() {
        return this.mCspPlmnEnabled;
    }

    private void handleEfCspData(byte[] data) {
        int usedCspGroups = data.length / 2;
        byte valueAddedServicesGroup = -64;
        this.mCspPlmnEnabled = true;
        for (int i = 0; i < usedCspGroups; ++i) {
            if (data[2 * i] != valueAddedServicesGroup) continue;
            this.log("[CSP] found ValueAddedServicesGroup, value " + data[2 * i + 1]);
            if ((data[2 * i + 1] & 0x80) == 128) {
                this.mCspPlmnEnabled = true;
            } else {
                this.mCspPlmnEnabled = false;
                this.log("[CSP] Set Automatic Network Selection");
                this.mNetworkSelectionModeAutomaticRegistrants.notifyRegistrants();
            }
            return;
        }
        this.log("[CSP] Value Added Service Group (0xC0), not found!");
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("SIMRecords: " + this);
        pw.println(" extends:");
        super.dump(fd, pw, args);
        pw.println(" mVmConfig=" + this.mVmConfig);
        pw.println(" mCallForwardingStatus=" + this.mCallForwardingStatus);
        pw.println(" mSpnState=" + (Object)((Object)this.mSpnState));
        pw.println(" mCphsInfo=" + this.mCphsInfo);
        pw.println(" mCspPlmnEnabled=" + this.mCspPlmnEnabled);
        pw.println(" mEfMWIS[]=" + Arrays.toString(this.mEfMWIS));
        pw.println(" mEfCPHS_MWI[]=" + Arrays.toString(this.mEfCPHS_MWI));
        pw.println(" mEfCff[]=" + Arrays.toString(this.mEfCff));
        pw.println(" mEfCfis[]=" + Arrays.toString(this.mEfCfis));
        pw.println(" mSpnDisplayCondition=" + this.mSpnDisplayCondition);
        pw.println(" mSpdiNetworks[]=" + this.mSpdiNetworks);
        pw.println(" mUsimServiceTable=" + this.mUsimServiceTable);
        pw.println(" mGid1=" + this.mGid1);
        if (this.mCarrierTestOverride.isInTestMode()) {
            pw.println(" mFakeGid1=" + this.mFakeGid1);
        }
        pw.println(" mGid2=" + this.mGid2);
        if (this.mCarrierTestOverride.isInTestMode()) {
            pw.println(" mFakeGid2=" + this.mFakeGid2);
        }
        pw.println(" mPnnHomeName=" + this.mPnnHomeName);
        if (this.mCarrierTestOverride.isInTestMode()) {
            pw.println(" mFakePnnHomeName=" + this.mFakePnnHomeName);
        }
        pw.println(" mPlmnActRecords[]=" + Arrays.toString(this.mPlmnActRecords));
        pw.println(" mOplmnActRecords[]=" + Arrays.toString(this.mOplmnActRecords));
        pw.println(" mHplmnActRecords[]=" + Arrays.toString(this.mHplmnActRecords));
        pw.println(" mFplmns[]=" + Arrays.toString(this.mFplmns));
        pw.println(" mEhplmns[]=" + Arrays.toString(this.mEhplmns));
        pw.flush();
    }

    private static enum GetSpnFsmState {
        IDLE,
        INIT,
        READ_SPN_3GPP,
        READ_SPN_CPHS,
        READ_SPN_SHORT_CPHS;

    }

    private class EfUsimLiLoaded
    implements IccRecords.IccRecordLoaded {
        private EfUsimLiLoaded() {
        }

        @Override
        public String getEfName() {
            return "EF_LI";
        }

        @Override
        public void onRecordLoaded(AsyncResult ar) {
            SIMRecords.this.mEfLi = (byte[])ar.result;
            SIMRecords.this.log("EF_LI=" + IccUtils.bytesToHexString(SIMRecords.this.mEfLi));
        }
    }

    private class EfPlLoaded
    implements IccRecords.IccRecordLoaded {
        private EfPlLoaded() {
        }

        @Override
        public String getEfName() {
            return "EF_PL";
        }

        @Override
        public void onRecordLoaded(AsyncResult ar) {
            SIMRecords.this.mEfPl = (byte[])ar.result;
            SIMRecords.this.log("EF_PL=" + IccUtils.bytesToHexString(SIMRecords.this.mEfPl));
        }
    }
}

