/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.storage.StorageManager;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.text.format.Time;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.RadioConfig;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccRefreshResponse;
import com.android.internal.telephony.uicc.IccSlotStatus;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccProfile;
import com.android.internal.telephony.uicc.UiccSlot;
import com.android.internal.telephony.uicc.UiccStateChangedLauncher;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;

public class UiccController
extends Handler {
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final String LOG_TAG = "UiccController";
    public static final int INVALID_SLOT_ID = -1;
    public static final int APP_FAM_3GPP = 1;
    public static final int APP_FAM_3GPP2 = 2;
    public static final int APP_FAM_IMS = 3;
    private static final int EVENT_ICC_STATUS_CHANGED = 1;
    private static final int EVENT_SLOT_STATUS_CHANGED = 2;
    private static final int EVENT_GET_ICC_STATUS_DONE = 3;
    private static final int EVENT_GET_SLOT_STATUS_DONE = 4;
    private static final int EVENT_RADIO_ON = 5;
    private static final int EVENT_RADIO_AVAILABLE = 6;
    private static final int EVENT_RADIO_UNAVAILABLE = 7;
    private static final int EVENT_SIM_REFRESH = 8;
    private CommandsInterface[] mCis;
    private UiccSlot[] mUiccSlots;
    private int[] mPhoneIdToSlotId;
    private boolean mIsSlotStatusSupported = true;
    private static final Object mLock = new Object();
    private static UiccController mInstance;
    private static ArrayList<IccSlotStatus> sLastSlotStatus;
    private Context mContext;
    protected RegistrantList mIccChangedRegistrants = new RegistrantList();
    private UiccStateChangedLauncher mLauncher;
    private RadioConfig mRadioConfig;
    private static final int MAX_PROACTIVE_COMMANDS_TO_LOG = 20;
    private LinkedList<String> mCardLogs = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UiccController make(Context c, CommandsInterface[] ci) {
        Object object = mLock;
        synchronized (object) {
            if (mInstance != null) {
                throw new RuntimeException("MSimUiccController.make() should only be called once");
            }
            mInstance = new UiccController(c, ci);
            return mInstance;
        }
    }

    private UiccController(Context c, CommandsInterface[] ci) {
        this.log("Creating UiccController");
        this.mContext = c;
        this.mCis = ci;
        this.mUiccSlots = new UiccSlot[c.getResources().getInteger(17694842)];
        this.mPhoneIdToSlotId = new int[ci.length];
        Arrays.fill(this.mPhoneIdToSlotId, -1);
        this.mRadioConfig = RadioConfig.getInstance(this.mContext);
        this.mRadioConfig.registerForSimSlotStatusChanged(this, 2, null);
        for (int i = 0; i < this.mCis.length; ++i) {
            this.mCis[i].registerForIccStatusChanged(this, 1, i);
            if (!StorageManager.inCryptKeeperBounce()) {
                this.mCis[i].registerForAvailable(this, 6, i);
            } else {
                this.mCis[i].registerForOn(this, 5, i);
            }
            this.mCis[i].registerForNotAvailable(this, 7, i);
            this.mCis[i].registerForIccRefresh(this, 8, i);
        }
        this.mLauncher = new UiccStateChangedLauncher(c, this);
    }

    private int getSlotIdFromPhoneId(int phoneId) {
        return this.mPhoneIdToSlotId[phoneId];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UiccController getInstance() {
        Object object = mLock;
        synchronized (object) {
            if (mInstance == null) {
                throw new RuntimeException("UiccController.getInstance can't be called before make()");
            }
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCard getUiccCard(int phoneId) {
        Object object = mLock;
        synchronized (object) {
            return this.getUiccCardForPhone(phoneId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCard getUiccCardForSlot(int slotId) {
        Object object = mLock;
        synchronized (object) {
            UiccSlot uiccSlot = this.getUiccSlot(slotId);
            if (uiccSlot != null) {
                return uiccSlot.getUiccCard();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCard getUiccCardForPhone(int phoneId) {
        Object object = mLock;
        synchronized (object) {
            UiccSlot uiccSlot;
            if (this.isValidPhoneIndex(phoneId) && (uiccSlot = this.getUiccSlotForPhone(phoneId)) != null) {
                return uiccSlot.getUiccCard();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccProfile getUiccProfileForPhone(int phoneId) {
        Object object = mLock;
        synchronized (object) {
            if (this.isValidPhoneIndex(phoneId)) {
                UiccCard uiccCard = this.getUiccCardForPhone(phoneId);
                UiccProfile uiccProfile = uiccCard != null ? uiccCard.getUiccProfile() : null;
                return uiccProfile;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccSlot[] getUiccSlots() {
        Object object = mLock;
        synchronized (object) {
            return this.mUiccSlots;
        }
    }

    public void switchSlots(int[] physicalSlots, Message response) {
        this.mRadioConfig.setSimSlotsMapping(physicalSlots, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccSlot getUiccSlot(int slotId) {
        Object object = mLock;
        synchronized (object) {
            if (this.isValidSlotIndex(slotId)) {
                return this.mUiccSlots[slotId];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccSlot getUiccSlotForPhone(int phoneId) {
        Object object = mLock;
        synchronized (object) {
            int slotId;
            if (this.isValidPhoneIndex(phoneId) && this.isValidSlotIndex(slotId = this.getSlotIdFromPhoneId(phoneId))) {
                return this.mUiccSlots[slotId];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUiccSlotForCardId(String cardId) {
        Object object = mLock;
        synchronized (object) {
            int idx;
            for (idx = 0; idx < this.mUiccSlots.length; ++idx) {
                UiccCard uiccCard;
                if (this.mUiccSlots[idx] != null && (uiccCard = this.mUiccSlots[idx].getUiccCard()) == null) continue;
            }
            for (idx = 0; idx < this.mUiccSlots.length; ++idx) {
                if (this.mUiccSlots[idx] == null || !cardId.equals(this.mUiccSlots[idx].getIccId())) continue;
                return idx;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccRecords getIccRecords(int phoneId, int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCardApplication app = this.getUiccCardApplication(phoneId, family);
            if (app != null) {
                return app.getIccRecords();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccFileHandler getIccFileHandler(int phoneId, int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCardApplication app = this.getUiccCardApplication(phoneId, family);
            if (app != null) {
                return app.getIccFileHandler();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForIccChanged(Handler h, int what, Object obj) {
        Object object = mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mIccChangedRegistrants.add(r);
            r.notifyRegistrant();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForIccChanged(Handler h) {
        Object object = mLock;
        synchronized (object) {
            this.mIccChangedRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        Object object = mLock;
        synchronized (object) {
            Integer phoneId = this.getCiIndex(msg);
            if (phoneId < 0 || phoneId >= this.mCis.length) {
                Rlog.e(LOG_TAG, "Invalid phoneId : " + phoneId + " received with event " + msg.what);
                return;
            }
            AsyncResult ar = (AsyncResult)msg.obj;
            switch (msg.what) {
                case 1: {
                    this.log("Received EVENT_ICC_STATUS_CHANGED, calling getIccCardStatus");
                    this.mCis[phoneId].getIccCardStatus(this.obtainMessage(3, phoneId));
                    break;
                }
                case 5: 
                case 6: {
                    this.log("Received EVENT_RADIO_AVAILABLE/EVENT_RADIO_ON, calling getIccCardStatus");
                    this.mCis[phoneId].getIccCardStatus(this.obtainMessage(3, phoneId));
                    if (phoneId != 0) break;
                    this.log("Received EVENT_RADIO_AVAILABLE/EVENT_RADIO_ON for phoneId 0, calling getIccSlotsStatus");
                    this.mRadioConfig.getSimSlotsStatus(this.obtainMessage(4, phoneId));
                    break;
                }
                case 3: {
                    this.log("Received EVENT_GET_ICC_STATUS_DONE");
                    this.onGetIccCardStatusDone(ar, phoneId);
                    break;
                }
                case 2: 
                case 4: {
                    this.log("Received EVENT_SLOT_STATUS_CHANGED or EVENT_GET_SLOT_STATUS_DONE");
                    this.onGetSlotStatusDone(ar);
                    break;
                }
                case 7: {
                    this.log("EVENT_RADIO_UNAVAILABLE, dispose card");
                    UiccSlot uiccSlot = this.getUiccSlotForPhone(phoneId);
                    if (uiccSlot != null) {
                        uiccSlot.onRadioStateUnavailable();
                    }
                    this.mIccChangedRegistrants.notifyRegistrants(new AsyncResult(null, phoneId, null));
                    break;
                }
                case 8: {
                    this.log("Received EVENT_SIM_REFRESH");
                    this.onSimRefresh(ar, phoneId);
                    break;
                }
                default: {
                    Rlog.e(LOG_TAG, " Unknown Event " + msg.what);
                }
            }
        }
    }

    private Integer getCiIndex(Message msg) {
        Integer index = new Integer(0);
        if (msg != null) {
            if (msg.obj != null && msg.obj instanceof Integer) {
                index = (Integer)msg.obj;
            } else if (msg.obj != null && msg.obj instanceof AsyncResult) {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.userObj != null && ar.userObj instanceof Integer) {
                    index = (Integer)ar.userObj;
                }
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCardApplication getUiccCardApplication(int phoneId, int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCard uiccCard = this.getUiccCardForPhone(phoneId);
            if (uiccCard != null) {
                return uiccCard.getApplication(family);
            }
            return null;
        }
    }

    private synchronized void onGetIccCardStatusDone(AsyncResult ar, Integer index) {
        if (ar.exception != null) {
            Rlog.e(LOG_TAG, "Error getting ICC status. RIL_REQUEST_GET_ICC_STATUS should never return an error", ar.exception);
            return;
        }
        if (!this.isValidPhoneIndex(index)) {
            Rlog.e(LOG_TAG, "onGetIccCardStatusDone: invalid index : " + index);
            return;
        }
        IccCardStatus status = (IccCardStatus)ar.result;
        int slotId = status.physicalSlotIndex;
        if (slotId == -1) {
            this.mPhoneIdToSlotId[index.intValue()] = slotId = index.intValue();
        }
        if (this.mUiccSlots[slotId] == null) {
            this.mUiccSlots[slotId] = new UiccSlot(this.mContext, true);
        }
        this.mUiccSlots[slotId].update(this.mCis[index], status, index);
        this.log("Notifying IccChangedRegistrants");
        this.mIccChangedRegistrants.notifyRegistrants(new AsyncResult(null, index, null));
    }

    private synchronized void onGetSlotStatusDone(AsyncResult ar) {
        if (!this.mIsSlotStatusSupported) {
            return;
        }
        Throwable e = ar.exception;
        if (e != null) {
            if (!(e instanceof CommandException) || ((CommandException)e).getCommandError() != CommandException.Error.REQUEST_NOT_SUPPORTED) {
                Rlog.e(LOG_TAG, "Unexpected error getting slot status.", ar.exception);
            } else {
                this.log("onGetSlotStatusDone: request not supported; marking mIsSlotStatusSupported to false");
                this.mIsSlotStatusSupported = false;
            }
            return;
        }
        ArrayList status = (ArrayList)ar.result;
        if (!this.slotStatusChanged(status)) {
            this.log("onGetSlotStatusDone: No change in slot status");
            return;
        }
        int numActiveSlots = 0;
        for (int i = 0; i < status.size(); ++i) {
            boolean isActive;
            IccSlotStatus iss = (IccSlotStatus)status.get(i);
            boolean bl = isActive = iss.slotState == IccSlotStatus.SlotState.SLOTSTATE_ACTIVE;
            if (isActive) {
                ++numActiveSlots;
                if (!this.isValidPhoneIndex(iss.logicalSlotIndex)) {
                    throw new RuntimeException("Logical slot index " + iss.logicalSlotIndex + " invalid for physical slot " + i);
                }
                this.mPhoneIdToSlotId[iss.logicalSlotIndex] = i;
            }
            if (this.mUiccSlots[i] == null) {
                this.mUiccSlots[i] = new UiccSlot(this.mContext, isActive);
            }
            this.mUiccSlots[i].update(isActive ? this.mCis[iss.logicalSlotIndex] : null, iss);
        }
        if (numActiveSlots != this.mPhoneIdToSlotId.length) {
            throw new RuntimeException("Number of active slots " + numActiveSlots + " does not match the expected value " + this.mPhoneIdToSlotId.length);
        }
        HashSet<Integer> slotIds = new HashSet<Integer>();
        for (Object slotId : (IccSlotStatus)this.mPhoneIdToSlotId) {
            if (slotIds.contains((int)slotId)) {
                throw new RuntimeException("slotId " + (int)slotId + " mapped to multiple phoneIds");
            }
            slotIds.add((int)slotId);
        }
        Intent intent = new Intent("android.telephony.action.SIM_SLOT_STATUS_CHANGED");
        this.mContext.sendBroadcast(intent, "android.permission.READ_PRIVILEGED_PHONE_STATE");
    }

    private boolean slotStatusChanged(ArrayList<IccSlotStatus> slotStatusList) {
        if (sLastSlotStatus == null || sLastSlotStatus.size() != slotStatusList.size()) {
            return true;
        }
        for (IccSlotStatus iccSlotStatus : slotStatusList) {
            if (sLastSlotStatus.contains(iccSlotStatus)) continue;
            return true;
        }
        return false;
    }

    private void logPhoneIdToSlotIdMapping() {
        this.log("mPhoneIdToSlotId mapping:");
        for (int i = 0; i < this.mPhoneIdToSlotId.length; ++i) {
            this.log("    phoneId " + i + " slotId " + this.mPhoneIdToSlotId[i]);
        }
    }

    private synchronized boolean areSlotsInitialized() {
        for (UiccSlot slot : this.mUiccSlots) {
            if (slot != null) continue;
            return false;
        }
        return true;
    }

    private void onSimRefresh(AsyncResult ar, Integer index) {
        boolean requirePowerOffOnSimRefreshReset;
        if (ar.exception != null) {
            Rlog.e(LOG_TAG, "Sim REFRESH with exception: " + ar.exception);
            return;
        }
        if (!this.isValidPhoneIndex(index)) {
            Rlog.e(LOG_TAG, "onSimRefresh: invalid index : " + index);
            return;
        }
        IccRefreshResponse resp = (IccRefreshResponse)ar.result;
        this.log("onSimRefresh: " + resp);
        if (resp == null) {
            Rlog.e(LOG_TAG, "onSimRefresh: received without input");
            return;
        }
        UiccCard uiccCard = this.getUiccCardForPhone(index);
        if (uiccCard == null) {
            Rlog.e(LOG_TAG, "onSimRefresh: refresh on null card : " + index);
            return;
        }
        this.log("Handling refresh: " + resp);
        boolean changed = false;
        switch (resp.refreshResult) {
            case 1: 
            case 2: {
                changed = uiccCard.resetAppWithAid(resp.aid);
                break;
            }
            default: {
                return;
            }
        }
        if (changed && resp.refreshResult == 2 && (requirePowerOffOnSimRefreshReset = this.mContext.getResources().getBoolean(17957002))) {
            this.mCis[index].setRadioPower(false, null);
        }
        this.mCis[index].getIccCardStatus(this.obtainMessage(3, index));
    }

    private boolean isValidPhoneIndex(int index) {
        return index >= 0 && index < TelephonyManager.getDefault().getPhoneCount();
    }

    private boolean isValidSlotIndex(int index) {
        return index >= 0 && index < this.mUiccSlots.length;
    }

    private void log(String string2) {
        Rlog.d(LOG_TAG, string2);
    }

    public void addCardLog(String data) {
        Time t = new Time();
        t.setToNow();
        this.mCardLogs.addLast(t.format("%m-%d %H:%M:%S") + " " + data);
        if (this.mCardLogs.size() > 20) {
            this.mCardLogs.removeFirst();
        }
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("UiccController: " + this);
        pw.println(" mContext=" + this.mContext);
        pw.println(" mInstance=" + mInstance);
        pw.println(" mIccChangedRegistrants: size=" + this.mIccChangedRegistrants.size());
        for (i = 0; i < this.mIccChangedRegistrants.size(); ++i) {
            pw.println("  mIccChangedRegistrants[" + i + "]=" + ((Registrant)this.mIccChangedRegistrants.get(i)).getHandler());
        }
        pw.println();
        pw.flush();
        pw.println(" mUiccSlots: size=" + this.mUiccSlots.length);
        for (i = 0; i < this.mUiccSlots.length; ++i) {
            if (this.mUiccSlots[i] == null) {
                pw.println("  mUiccSlots[" + i + "]=null");
                continue;
            }
            pw.println("  mUiccSlots[" + i + "]=" + this.mUiccSlots[i]);
            this.mUiccSlots[i].dump(fd, pw, args);
        }
        pw.println("mCardLogs: ");
        for (i = 0; i < this.mCardLogs.size(); ++i) {
            pw.println("  " + this.mCardLogs.get(i));
        }
    }
}

