/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.uicc.IccException;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCarrierPrivilegeRules;
import com.android.internal.telephony.uicc.UiccProfile;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class UiccPkcs15
extends Handler {
    private static final String LOG_TAG = "UiccPkcs15";
    private static final boolean DBG = true;
    private UiccProfile mUiccProfile;
    private Message mLoadedCallback;
    private int mChannelId = -1;
    private List<String> mRules = new ArrayList<String>();
    private Pkcs15Selector mPkcs15Selector;
    private FileHandler mFh;
    private static final int EVENT_SELECT_PKCS15_DONE = 1;
    private static final int EVENT_LOAD_ODF_DONE = 2;
    private static final int EVENT_LOAD_DODF_DONE = 3;
    private static final int EVENT_LOAD_ACMF_DONE = 4;
    private static final int EVENT_LOAD_ACRF_DONE = 5;
    private static final int EVENT_LOAD_ACCF_DONE = 6;
    private static final int EVENT_CLOSE_LOGICAL_CHANNEL_DONE = 7;
    private static final String CARRIER_RULE_AID = "FFFFFFFFFFFF";
    private static final String ID_ACRF = "4300";
    private static final String TAG_ASN_SEQUENCE = "30";
    private static final String TAG_ASN_OCTET_STRING = "04";
    private static final String TAG_TARGET_AID = "A0";

    public UiccPkcs15(UiccProfile uiccProfile, Message loadedCallback) {
        UiccPkcs15.log("Creating UiccPkcs15");
        this.mUiccProfile = uiccProfile;
        this.mLoadedCallback = loadedCallback;
        this.mPkcs15Selector = new Pkcs15Selector(this.obtainMessage(1));
    }

    @Override
    public void handleMessage(Message msg) {
        UiccPkcs15.log("handleMessage: " + msg.what);
        AsyncResult ar = (AsyncResult)msg.obj;
        switch (msg.what) {
            case 1: {
                if (ar.exception == null) {
                    this.mFh = new FileHandler((String)ar.result);
                    if (this.mFh.loadFile(ID_ACRF, this.obtainMessage(5))) break;
                    this.cleanUp();
                    break;
                }
                UiccPkcs15.log("select pkcs15 failed: " + ar.exception);
                this.mLoadedCallback.sendToTarget();
                break;
            }
            case 5: {
                if (ar.exception == null && ar.result != null) {
                    String idAccf = this.parseAcrf((String)ar.result);
                    if (this.mFh.loadFile(idAccf, this.obtainMessage(6))) break;
                    this.cleanUp();
                    break;
                }
                this.cleanUp();
                break;
            }
            case 6: {
                if (ar.exception == null && ar.result != null) {
                    this.parseAccf((String)ar.result);
                }
                this.cleanUp();
                break;
            }
            case 7: {
                break;
            }
            default: {
                Rlog.e(LOG_TAG, "Unknown event " + msg.what);
            }
        }
    }

    private void cleanUp() {
        UiccPkcs15.log("cleanUp");
        if (this.mChannelId >= 0) {
            this.mUiccProfile.iccCloseLogicalChannel(this.mChannelId, this.obtainMessage(7));
            this.mChannelId = -1;
        }
        this.mLoadedCallback.sendToTarget();
    }

    private String parseAcrf(String data) {
        String ret = null;
        String acRules = data;
        while (!acRules.isEmpty()) {
            UiccCarrierPrivilegeRules.TLV tlvRule = new UiccCarrierPrivilegeRules.TLV(TAG_ASN_SEQUENCE);
            try {
                acRules = tlvRule.parse(acRules, false);
                String ruleString = tlvRule.getValue();
                if (!ruleString.startsWith(TAG_TARGET_AID)) continue;
                UiccCarrierPrivilegeRules.TLV tlvTarget = new UiccCarrierPrivilegeRules.TLV(TAG_TARGET_AID);
                UiccCarrierPrivilegeRules.TLV tlvAid = new UiccCarrierPrivilegeRules.TLV(TAG_ASN_OCTET_STRING);
                UiccCarrierPrivilegeRules.TLV tlvAsnPath = new UiccCarrierPrivilegeRules.TLV(TAG_ASN_SEQUENCE);
                UiccCarrierPrivilegeRules.TLV tlvPath = new UiccCarrierPrivilegeRules.TLV(TAG_ASN_OCTET_STRING);
                ruleString = tlvTarget.parse(ruleString, false);
                tlvAid.parse(tlvTarget.getValue(), true);
                if (!CARRIER_RULE_AID.equals(tlvAid.getValue())) continue;
                tlvAsnPath.parse(ruleString, true);
                tlvPath.parse(tlvAsnPath.getValue(), true);
                ret = tlvPath.getValue();
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException ex) {
                UiccPkcs15.log("Error: " + ex);
                break;
            }
        }
        return ret;
    }

    private void parseAccf(String data) {
        String acCondition = data;
        while (!acCondition.isEmpty()) {
            UiccCarrierPrivilegeRules.TLV tlvCondition = new UiccCarrierPrivilegeRules.TLV(TAG_ASN_SEQUENCE);
            UiccCarrierPrivilegeRules.TLV tlvCert = new UiccCarrierPrivilegeRules.TLV(TAG_ASN_OCTET_STRING);
            try {
                acCondition = tlvCondition.parse(acCondition, false);
                tlvCert.parse(tlvCondition.getValue(), true);
                if (tlvCert.getValue().isEmpty()) continue;
                this.mRules.add(tlvCert.getValue());
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException ex) {
                UiccPkcs15.log("Error: " + ex);
                break;
            }
        }
    }

    public List<String> getRules() {
        return this.mRules;
    }

    private static void log(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mRules != null) {
            pw.println(" mRules:");
            for (String cert : this.mRules) {
                pw.println("  " + cert);
            }
        }
    }

    private class Pkcs15Selector
    extends Handler {
        private static final String PKCS15_AID = "A000000063504B43532D3135";
        private Message mCallback;
        private static final int EVENT_OPEN_LOGICAL_CHANNEL_DONE = 201;

        public Pkcs15Selector(Message callBack) {
            this.mCallback = callBack;
            int p2 = 4;
            UiccPkcs15.this.mUiccProfile.iccOpenLogicalChannel(PKCS15_AID, p2, this.obtainMessage(201));
        }

        @Override
        public void handleMessage(Message msg) {
            UiccPkcs15.log("handleMessage: " + msg.what);
            switch (msg.what) {
                case 201: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null && ar.result != null) {
                        UiccPkcs15.this.mChannelId = ((int[])ar.result)[0];
                        UiccPkcs15.log("mChannelId: " + UiccPkcs15.this.mChannelId);
                        AsyncResult.forMessage(this.mCallback, null, null);
                    } else {
                        UiccPkcs15.log("error: " + ar.exception);
                        AsyncResult.forMessage(this.mCallback, null, ar.exception);
                    }
                    this.mCallback.sendToTarget();
                    break;
                }
                default: {
                    UiccPkcs15.log("Unknown event" + msg.what);
                }
            }
        }
    }

    private class FileHandler
    extends Handler {
        private final String mPkcs15Path;
        private Message mCallback;
        private String mFileId;
        protected static final int EVENT_SELECT_FILE_DONE = 101;
        protected static final int EVENT_READ_BINARY_DONE = 102;

        public FileHandler(String pkcs15Path) {
            UiccPkcs15.log("Creating FileHandler, pkcs15Path: " + pkcs15Path);
            this.mPkcs15Path = pkcs15Path;
        }

        public boolean loadFile(String fileId, Message callBack) {
            UiccPkcs15.log("loadFile: " + fileId);
            if (fileId == null || callBack == null) {
                return false;
            }
            this.mFileId = fileId;
            this.mCallback = callBack;
            this.selectFile();
            return true;
        }

        private void selectFile() {
            if (UiccPkcs15.this.mChannelId >= 0) {
                UiccPkcs15.this.mUiccProfile.iccTransmitApduLogicalChannel(UiccPkcs15.this.mChannelId, 0, 164, 0, 4, 2, this.mFileId, this.obtainMessage(101));
            } else {
                UiccPkcs15.log("EF based");
            }
        }

        private void readBinary() {
            if (UiccPkcs15.this.mChannelId >= 0) {
                UiccPkcs15.this.mUiccProfile.iccTransmitApduLogicalChannel(UiccPkcs15.this.mChannelId, 0, 176, 0, 0, 0, "", this.obtainMessage(102));
            } else {
                UiccPkcs15.log("EF based");
            }
        }

        @Override
        public void handleMessage(Message msg) {
            UiccPkcs15.log("handleMessage: " + msg.what);
            AsyncResult ar = (AsyncResult)msg.obj;
            if (ar.exception != null || ar.result == null) {
                UiccPkcs15.log("Error: " + ar.exception);
                AsyncResult.forMessage(this.mCallback, null, ar.exception);
                this.mCallback.sendToTarget();
                return;
            }
            switch (msg.what) {
                case 101: {
                    this.readBinary();
                    break;
                }
                case 102: {
                    IccIoResult response = (IccIoResult)ar.result;
                    String result = IccUtils.bytesToHexString(response.payload).toUpperCase(Locale.US);
                    UiccPkcs15.log("IccIoResult: " + response + " payload: " + result);
                    AsyncResult.forMessage(this.mCallback, result, result == null ? new IccException("Error: null response for " + this.mFileId) : null);
                    this.mCallback.sendToTarget();
                    break;
                }
                default: {
                    UiccPkcs15.log("Unknown event" + msg.what);
                }
            }
        }
    }
}

