/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Registrant;
import android.os.RegistrantList;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.LocalLog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccCardConstants;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.cat.CatService;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccCarrierPrivilegeRules;
import com.android.internal.telephony.uicc.euicc.EuiccCard;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class UiccProfile
extends Handler
implements IccCard {
    protected static final String LOG_TAG = "UiccProfile";
    protected static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final boolean ICC_CARD_PROXY_REMOVED = true;
    private static final String OPERATOR_BRAND_OVERRIDE_PREFIX = "operator_branding_";
    private final Object mLock = new Object();
    private IccCardStatus.PinState mUniversalPinState;
    private int mGsmUmtsSubscriptionAppIndex;
    private int mCdmaSubscriptionAppIndex;
    private int mImsSubscriptionAppIndex;
    private UiccCardApplication[] mUiccApplications = new UiccCardApplication[8];
    private Context mContext;
    private CommandsInterface mCi;
    private UiccCard mUiccCard;
    private CatService mCatService;
    private UiccCarrierPrivilegeRules mCarrierPrivilegeRules;
    private boolean mDisposed = false;
    private RegistrantList mCarrierPrivilegeRegistrants = new RegistrantList();
    private static final int EVENT_OPEN_LOGICAL_CHANNEL_DONE = 15;
    private static final int EVENT_CLOSE_LOGICAL_CHANNEL_DONE = 16;
    private static final int EVENT_TRANSMIT_APDU_LOGICAL_CHANNEL_DONE = 17;
    private static final int EVENT_TRANSMIT_APDU_BASIC_CHANNEL_DONE = 18;
    private static final int EVENT_SIM_IO_DONE = 19;
    private static final int EVENT_CARRIER_PRIVILEGES_LOADED = 20;
    private static final LocalLog sLocalLog = new LocalLog(100);
    private final int mPhoneId;
    private static final int EVENT_RADIO_OFF_OR_UNAVAILABLE = 1;
    private static final int EVENT_ICC_LOCKED = 5;
    private static final int EVENT_APP_READY = 6;
    private static final int EVENT_RECORDS_LOADED = 7;
    private static final int EVENT_NETWORK_LOCKED = 9;
    private static final int EVENT_EID_READY = 10;
    private static final int EVENT_ICC_RECORD_EVENTS = 500;
    private TelephonyManager mTelephonyManager;
    private RegistrantList mNetworkLockedRegistrants = new RegistrantList();
    private int mCurrentAppType = 1;
    private UiccCardApplication mUiccApplication = null;
    private IccRecords mIccRecords = null;
    private IccCardConstants.State mExternalState = IccCardConstants.State.UNKNOWN;
    public static final String ACTION_INTERNAL_SIM_STATE_CHANGED = "android.intent.action.internal_sim_state_changed";

    public UiccProfile(Context c, CommandsInterface ci, IccCardStatus ics, int phoneId, UiccCard uiccCard) {
        UiccProfile.log("Creating profile");
        this.mUiccCard = uiccCard;
        this.mPhoneId = phoneId;
        Phone phone = PhoneFactory.getPhone(phoneId);
        if (phone != null) {
            this.setCurrentAppType(phone.getPhoneType() == 1);
        }
        if (this.mUiccCard instanceof EuiccCard) {
            ((EuiccCard)this.mUiccCard).registerForEidReady(this, 10, null);
        }
        this.update(c, ci, ics);
        ci.registerForOffOrNotAvailable(this, 1, null);
        this.resetProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.mLock;
        synchronized (object) {
            UiccProfile.log("Disposing profile");
            this.unregisterAllAppEvents();
            this.unregisterCurrAppEvents();
            if (this.mUiccCard instanceof EuiccCard) {
                ((EuiccCard)this.mUiccCard).unregisterForEidReady(this);
            }
            this.mCi.unregisterForOffOrNotAvailable(this);
            if (this.mCatService != null) {
                this.mCatService.dispose();
            }
            for (UiccCardApplication app : this.mUiccApplications) {
                if (app == null) continue;
                app.dispose();
            }
            this.mCatService = null;
            this.mUiccApplications = null;
            this.mCarrierPrivilegeRules = null;
            this.mDisposed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVoiceRadioTech(int radioTech) {
        Object object = this.mLock;
        synchronized (object) {
            UiccProfile.log("Setting radio tech " + ServiceState.rilRadioTechnologyToString(radioTech));
            this.setCurrentAppType(ServiceState.isGsm(radioTech));
            this.updateIccAvailability(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentAppType(boolean isGsm) {
        Object object = this.mLock;
        synchronized (object) {
            boolean isLteOnCdmaMode = TelephonyManager.getLteOnCdmaModeStatic() == 1;
            this.mCurrentAppType = isGsm || isLteOnCdmaMode ? 1 : 2;
        }
    }

    @Override
    public void handleMessage(Message msg) {
        if (this.mDisposed) {
            this.loge("handleMessage: Received " + msg.what + " after dispose(); ignoring the message");
            return;
        }
        switch (msg.what) {
            case 9: {
                this.mNetworkLockedRegistrants.notifyRegistrants();
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                this.updateExternalState();
                break;
            }
            case 500: {
                if (this.mCurrentAppType != 1 || this.mIccRecords == null) break;
                AsyncResult ar = (AsyncResult)msg.obj;
                int eventCode = (Integer)ar.result;
                if (eventCode != 2) break;
                this.mTelephonyManager.setSimOperatorNameForPhone(this.mPhoneId, this.mIccRecords.getServiceProviderName());
                break;
            }
            case 20: {
                this.onCarrierPriviligesLoadedMessage();
                this.updateExternalState();
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    this.loglocal("Exception: " + ar.exception);
                    UiccProfile.log("Error in SIM access with exception" + ar.exception);
                }
                AsyncResult.forMessage((Message)ar.userObj, ar.result, ar.exception);
                ((Message)ar.userObj).sendToTarget();
                break;
            }
            default: {
                this.loge("Unhandled message with number: " + msg.what);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIccAvailability(boolean allAppsChanged) {
        Object object = this.mLock;
        synchronized (object) {
            IccRecords newRecords = null;
            UiccCardApplication newApp = this.getApplication(this.mCurrentAppType);
            if (newApp != null) {
                newRecords = newApp.getIccRecords();
            }
            if (allAppsChanged) {
                this.unregisterAllAppEvents();
                this.registerAllAppEvents();
            }
            if (this.mIccRecords != newRecords || this.mUiccApplication != newApp) {
                UiccProfile.log("Icc changed. Reregistering.");
                this.unregisterCurrAppEvents();
                this.mUiccApplication = newApp;
                this.mIccRecords = newRecords;
                this.registerCurrAppEvents();
            }
            this.updateExternalState();
        }
    }

    void resetProperties() {
        if (this.mCurrentAppType == 1) {
            UiccProfile.log("update icc_operator_numeric=");
            this.mTelephonyManager.setSimOperatorNumericForPhone(this.mPhoneId, "");
            this.mTelephonyManager.setSimCountryIsoForPhone(this.mPhoneId, "");
            this.mTelephonyManager.setSimOperatorNameForPhone(this.mPhoneId, "");
        }
    }

    private void updateExternalState() {
        if (this.mUiccCard.getCardState() == IccCardStatus.CardState.CARDSTATE_ERROR) {
            this.setExternalState(IccCardConstants.State.CARD_IO_ERROR);
            return;
        }
        if (this.mUiccCard.getCardState() == IccCardStatus.CardState.CARDSTATE_RESTRICTED) {
            this.setExternalState(IccCardConstants.State.CARD_RESTRICTED);
            return;
        }
        if (this.mUiccCard instanceof EuiccCard && ((EuiccCard)this.mUiccCard).getEid() == null) {
            UiccProfile.log("EID is not ready yet.");
            return;
        }
        if (this.mUiccApplication == null) {
            this.loge("updateExternalState: setting state to NOT_READY because mUiccApplication is null");
            this.setExternalState(IccCardConstants.State.NOT_READY);
            return;
        }
        boolean cardLocked = false;
        IccCardConstants.State lockedState = null;
        IccCardApplicationStatus.AppState appState = this.mUiccApplication.getState();
        IccCardStatus.PinState pin1State = this.mUiccApplication.getPin1State();
        if (pin1State == IccCardStatus.PinState.PINSTATE_ENABLED_PERM_BLOCKED) {
            cardLocked = true;
            lockedState = IccCardConstants.State.PERM_DISABLED;
        } else if (appState == IccCardApplicationStatus.AppState.APPSTATE_PIN) {
            cardLocked = true;
            lockedState = IccCardConstants.State.PIN_REQUIRED;
        } else if (appState == IccCardApplicationStatus.AppState.APPSTATE_PUK) {
            cardLocked = true;
            lockedState = IccCardConstants.State.PUK_REQUIRED;
        } else if (appState == IccCardApplicationStatus.AppState.APPSTATE_SUBSCRIPTION_PERSO && this.mUiccApplication.getPersoSubState() == IccCardApplicationStatus.PersoSubState.PERSOSUBSTATE_SIM_NETWORK) {
            cardLocked = true;
            lockedState = IccCardConstants.State.NETWORK_LOCKED;
        }
        if (cardLocked) {
            if (this.mIccRecords != null && (this.mIccRecords.getLockedRecordsLoaded() || this.mIccRecords.getNetworkLockedRecordsLoaded())) {
                this.setExternalState(lockedState);
            } else {
                this.setExternalState(IccCardConstants.State.NOT_READY);
            }
            return;
        }
        switch (appState) {
            case APPSTATE_UNKNOWN: {
                this.setExternalState(IccCardConstants.State.NOT_READY);
                break;
            }
            case APPSTATE_READY: {
                if (this.areAllApplicationsReady()) {
                    if (this.areAllRecordsLoaded() && this.areCarrierPriviligeRulesLoaded()) {
                        this.setExternalState(IccCardConstants.State.LOADED);
                        break;
                    }
                    this.setExternalState(IccCardConstants.State.READY);
                    break;
                }
                this.setExternalState(IccCardConstants.State.NOT_READY);
            }
        }
    }

    private void registerAllAppEvents() {
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null) continue;
            app.registerForReady(this, 6, null);
            IccRecords ir = app.getIccRecords();
            if (ir == null) continue;
            ir.registerForRecordsLoaded(this, 7, null);
            ir.registerForRecordsEvents(this, 500, null);
        }
    }

    private void unregisterAllAppEvents() {
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null) continue;
            app.unregisterForReady(this);
            IccRecords ir = app.getIccRecords();
            if (ir == null) continue;
            ir.unregisterForRecordsLoaded(this);
            ir.unregisterForRecordsEvents(this);
        }
    }

    private void registerCurrAppEvents() {
        if (this.mIccRecords != null) {
            this.mIccRecords.registerForLockedRecordsLoaded(this, 5, null);
            this.mIccRecords.registerForNetworkLockedRecordsLoaded(this, 9, null);
        }
    }

    private void unregisterCurrAppEvents() {
        if (this.mIccRecords != null) {
            this.mIccRecords.unregisterForLockedRecordsLoaded(this);
            this.mIccRecords.unregisterForNetworkLockedRecordsLoaded(this);
        }
    }

    static void broadcastInternalIccStateChangedIntent(String value, String reason, int phoneId) {
        Intent intent = new Intent(ACTION_INTERNAL_SIM_STATE_CHANGED);
        intent.addFlags(0x14000000);
        intent.putExtra("phoneName", "Phone");
        intent.putExtra("ss", value);
        intent.putExtra("reason", reason);
        intent.putExtra("phone", phoneId);
        UiccProfile.log("Sending intent ACTION_INTERNAL_SIM_STATE_CHANGED value=" + value + " for mPhoneId : " + phoneId);
        ActivityManager.broadcastStickyIntent(intent, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExternalState(IccCardConstants.State newState, boolean override) {
        Object object = this.mLock;
        synchronized (object) {
            if (!SubscriptionManager.isValidSlotIndex(this.mPhoneId)) {
                this.loge("setExternalState: mPhoneId=" + this.mPhoneId + " is invalid; Return!!");
                return;
            }
            if (!override && newState == this.mExternalState) {
                UiccProfile.log("setExternalState: !override and newstate unchanged from " + (Object)((Object)newState));
                return;
            }
            this.mExternalState = newState;
            if (this.mExternalState == IccCardConstants.State.LOADED && this.mIccRecords != null) {
                String operator = this.mIccRecords.getOperatorNumeric();
                UiccProfile.log("operator=" + operator + " mPhoneId=" + this.mPhoneId);
                if (!TextUtils.isEmpty(operator)) {
                    this.mTelephonyManager.setSimOperatorNumericForPhone(this.mPhoneId, operator);
                    String countryCode = operator.substring(0, 3);
                    if (countryCode != null) {
                        this.mTelephonyManager.setSimCountryIsoForPhone(this.mPhoneId, MccTable.countryCodeForMcc(Integer.parseInt(countryCode)));
                    } else {
                        this.loge("EVENT_RECORDS_LOADED Country code is null");
                    }
                } else {
                    this.loge("EVENT_RECORDS_LOADED Operator name is null");
                }
            }
            UiccProfile.log("setExternalState: set mPhoneId=" + this.mPhoneId + " mExternalState=" + (Object)((Object)this.mExternalState));
            this.mTelephonyManager.setSimStateForPhone(this.mPhoneId, this.getState().toString());
            UiccProfile.broadcastInternalIccStateChangedIntent(this.getIccStateIntentString(this.mExternalState), this.getIccStateReason(this.mExternalState), this.mPhoneId);
        }
    }

    private void setExternalState(IccCardConstants.State newState) {
        this.setExternalState(newState, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIccRecordsLoaded() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIccRecords != null) {
                return this.mIccRecords.getRecordsLoaded();
            }
            return false;
        }
    }

    private String getIccStateIntentString(IccCardConstants.State state) {
        switch (state) {
            case ABSENT: {
                return "ABSENT";
            }
            case PIN_REQUIRED: {
                return "LOCKED";
            }
            case PUK_REQUIRED: {
                return "LOCKED";
            }
            case NETWORK_LOCKED: {
                return "LOCKED";
            }
            case READY: {
                return "READY";
            }
            case NOT_READY: {
                return "NOT_READY";
            }
            case PERM_DISABLED: {
                return "LOCKED";
            }
            case CARD_IO_ERROR: {
                return "CARD_IO_ERROR";
            }
            case CARD_RESTRICTED: {
                return "CARD_RESTRICTED";
            }
            case LOADED: {
                return "LOADED";
            }
        }
        return "UNKNOWN";
    }

    private String getIccStateReason(IccCardConstants.State state) {
        switch (state) {
            case PIN_REQUIRED: {
                return "PIN";
            }
            case PUK_REQUIRED: {
                return "PUK";
            }
            case NETWORK_LOCKED: {
                return "NETWORK";
            }
            case PERM_DISABLED: {
                return "PERM_DISABLED";
            }
            case CARD_IO_ERROR: {
                return "CARD_IO_ERROR";
            }
            case CARD_RESTRICTED: {
                return "CARD_RESTRICTED";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IccCardConstants.State getState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mExternalState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IccRecords getIccRecords() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIccRecords;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerForNetworkLocked(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mNetworkLockedRegistrants.add(r);
            if (this.getState() == IccCardConstants.State.NETWORK_LOCKED) {
                r.notifyRegistrant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterForNetworkLocked(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mNetworkLockedRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplyPin(String pin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPin(pin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplyPuk(String puk, String newPin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPuk(puk, newPin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplyPin2(String pin2, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPin2(pin2, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplyPuk2(String puk2, String newPin2, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPuk2(puk2, newPin2, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplyNetworkDepersonalization(String pin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyNetworkDepersonalization(pin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("CommandsInterface is not set.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getIccLockEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUiccApplication != null && this.mUiccApplication.getIccLockEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getIccFdnEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUiccApplication != null && this.mUiccApplication.getIccFdnEnabled();
        }
    }

    @Override
    public boolean getIccPin2Blocked() {
        return this.mUiccApplication != null && this.mUiccApplication.getIccPin2Blocked();
    }

    @Override
    public boolean getIccPuk2Blocked() {
        return this.mUiccApplication != null && this.mUiccApplication.getIccPuk2Blocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIccLockEnabled(boolean enabled, String password, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.setIccLockEnabled(enabled, password, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIccFdnEnabled(boolean enabled, String password, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.setIccFdnEnabled(enabled, password, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeIccLockPassword(String oldPassword, String newPassword, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.changeIccLockPassword(oldPassword, newPassword, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeIccFdnPassword(String oldPassword, String newPassword, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.changeIccFdnPassword(oldPassword, newPassword, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getServiceProviderName() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIccRecords != null) {
                return this.mIccRecords.getServiceProviderName();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasIccCard() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccCard != null && this.mUiccCard.getCardState() != IccCardStatus.CardState.CARDSTATE_ABSENT) {
                return true;
            }
            this.loge("hasIccCard: UiccProfile is not null but UiccCard is null or card state is ABSENT");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Context c, CommandsInterface ci, IccCardStatus ics) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUniversalPinState = ics.mUniversalPinState;
            this.mGsmUmtsSubscriptionAppIndex = ics.mGsmUmtsSubscriptionAppIndex;
            this.mCdmaSubscriptionAppIndex = ics.mCdmaSubscriptionAppIndex;
            this.mImsSubscriptionAppIndex = ics.mImsSubscriptionAppIndex;
            this.mContext = c;
            this.mCi = ci;
            this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
            UiccProfile.log(ics.mApplications.length + " applications");
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null) {
                    if (i >= ics.mApplications.length) continue;
                    this.mUiccApplications[i] = new UiccCardApplication(this, ics.mApplications[i], this.mContext, this.mCi);
                    continue;
                }
                if (i >= ics.mApplications.length) {
                    this.mUiccApplications[i].dispose();
                    this.mUiccApplications[i] = null;
                    continue;
                }
                this.mUiccApplications[i].update(ics.mApplications[i], this.mContext, this.mCi);
            }
            this.createAndUpdateCatServiceLocked();
            UiccProfile.log("Before privilege rules: " + this.mCarrierPrivilegeRules + " : " + (Object)((Object)ics.mCardState));
            if (this.mCarrierPrivilegeRules == null && ics.mCardState == IccCardStatus.CardState.CARDSTATE_PRESENT) {
                this.mCarrierPrivilegeRules = new UiccCarrierPrivilegeRules(this, this.obtainMessage(20));
            } else if (this.mCarrierPrivilegeRules != null && ics.mCardState != IccCardStatus.CardState.CARDSTATE_PRESENT) {
                this.mCarrierPrivilegeRules = null;
            }
            this.sanitizeApplicationIndexesLocked();
            this.updateIccAvailability(true);
        }
    }

    private void createAndUpdateCatServiceLocked() {
        if (this.mUiccApplications.length > 0 && this.mUiccApplications[0] != null) {
            if (this.mCatService == null) {
                this.mCatService = CatService.getInstance(this.mCi, this.mContext, this, this.mPhoneId);
            } else {
                this.mCatService.update(this.mCi, this.mContext, this);
            }
        } else {
            if (this.mCatService != null) {
                this.mCatService.dispose();
            }
            this.mCatService = null;
        }
    }

    protected void finalize() {
        UiccProfile.log("UiccProfile finalized");
    }

    private void sanitizeApplicationIndexesLocked() {
        this.mGsmUmtsSubscriptionAppIndex = this.checkIndexLocked(this.mGsmUmtsSubscriptionAppIndex, IccCardApplicationStatus.AppType.APPTYPE_SIM, IccCardApplicationStatus.AppType.APPTYPE_USIM);
        this.mCdmaSubscriptionAppIndex = this.checkIndexLocked(this.mCdmaSubscriptionAppIndex, IccCardApplicationStatus.AppType.APPTYPE_RUIM, IccCardApplicationStatus.AppType.APPTYPE_CSIM);
        this.mImsSubscriptionAppIndex = this.checkIndexLocked(this.mImsSubscriptionAppIndex, IccCardApplicationStatus.AppType.APPTYPE_ISIM, null);
    }

    private boolean isSupportedApplication(UiccCardApplication app) {
        return app.getType() == IccCardApplicationStatus.AppType.APPTYPE_USIM || app.getType() == IccCardApplicationStatus.AppType.APPTYPE_CSIM || app.getType() == IccCardApplicationStatus.AppType.APPTYPE_ISIM || app.getType() == IccCardApplicationStatus.AppType.APPTYPE_SIM || app.getType() == IccCardApplicationStatus.AppType.APPTYPE_RUIM;
    }

    private boolean areAllApplicationsReady() {
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null || !this.isSupportedApplication(app) || app.isReady()) continue;
            return false;
        }
        return this.mUiccApplication != null;
    }

    private boolean areAllRecordsLoaded() {
        for (UiccCardApplication app : this.mUiccApplications) {
            IccRecords ir;
            if (app == null || !this.isSupportedApplication(app) || (ir = app.getIccRecords()) != null && ir.isLoaded()) continue;
            return false;
        }
        return this.mUiccApplication != null;
    }

    private int checkIndexLocked(int index, IccCardApplicationStatus.AppType expectedAppType, IccCardApplicationStatus.AppType altExpectedAppType) {
        if (this.mUiccApplications == null || index >= this.mUiccApplications.length) {
            this.loge("App index " + index + " is invalid since there are no applications");
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (this.mUiccApplications[index].getType() != expectedAppType && this.mUiccApplications[index].getType() != altExpectedAppType) {
            this.loge("App index " + index + " is invalid since it's not " + (Object)((Object)expectedAppType) + " and not " + (Object)((Object)altExpectedAppType));
            return -1;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForCarrierPrivilegeRulesLoaded(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mCarrierPrivilegeRegistrants.add(r);
            if (this.areCarrierPriviligeRulesLoaded()) {
                r.notifyRegistrant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForCarrierPrivilegeRulesLoaded(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCarrierPrivilegeRegistrants.remove(h);
        }
    }

    private boolean isPackageInstalled(String pkgName) {
        PackageManager pm = this.mContext.getPackageManager();
        try {
            pm.getPackageInfo(pkgName, 1);
            UiccProfile.log(pkgName + " is installed.");
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            UiccProfile.log(pkgName + " is not installed.");
            return false;
        }
    }

    private void promptInstallCarrierApp(String pkgName) {
        ClickListener listener = new ClickListener(pkgName);
        Resources r = Resources.getSystem();
        String message = r.getString(17039604);
        String buttonTxt = r.getString(17039603);
        String notNowTxt = r.getString(17039605);
        AlertDialog dialog = new AlertDialog.Builder(this.mContext).setMessage(message).setNegativeButton(notNowTxt, (DialogInterface.OnClickListener)listener).setPositiveButton(buttonTxt, (DialogInterface.OnClickListener)listener).create();
        dialog.getWindow().setType(2003);
        dialog.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCarrierPriviligesLoadedMessage() {
        UsageStatsManager usm = (UsageStatsManager)this.mContext.getSystemService("usagestats");
        if (usm != null) {
            usm.onCarrierPrivilegedAppsChanged();
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mCarrierPrivilegeRegistrants.notifyRegistrants();
            String whitelistSetting = Settings.Global.getString(this.mContext.getContentResolver(), "carrier_app_whitelist");
            if (TextUtils.isEmpty(whitelistSetting)) {
                return;
            }
            HashSet<String> carrierAppSet = new HashSet<String>(Arrays.asList(whitelistSetting.split("\\s*;\\s*")));
            if (carrierAppSet.isEmpty()) {
                return;
            }
            List<String> pkgNames = this.mCarrierPrivilegeRules.getPackageNames();
            for (String pkgName : pkgNames) {
                if (TextUtils.isEmpty(pkgName) || !carrierAppSet.contains(pkgName) || this.isPackageInstalled(pkgName)) continue;
                this.promptInstallCarrierApp(pkgName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isApplicationOnIcc(IccCardApplicationStatus.AppType type) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null || this.mUiccApplications[i].getType() != type) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccCardStatus.PinState getUniversalPinState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUniversalPinState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCardApplication getApplication(int family) {
        Object object = this.mLock;
        synchronized (object) {
            int index = 8;
            switch (family) {
                case 1: {
                    index = this.mGsmUmtsSubscriptionAppIndex;
                    break;
                }
                case 2: {
                    index = this.mCdmaSubscriptionAppIndex;
                    break;
                }
                case 3: {
                    index = this.mImsSubscriptionAppIndex;
                }
            }
            if (index >= 0 && index < this.mUiccApplications.length) {
                return this.mUiccApplications[index];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCardApplication getApplicationIndex(int index) {
        Object object = this.mLock;
        synchronized (object) {
            if (index >= 0 && index < this.mUiccApplications.length) {
                return this.mUiccApplications[index];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCardApplication getApplicationByType(int type) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null || this.mUiccApplications[i].getType().ordinal() != type) continue;
                return this.mUiccApplications[i];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetAppWithAid(String aid) {
        Object object = this.mLock;
        synchronized (object) {
            boolean changed = false;
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null || !TextUtils.isEmpty(aid) && !aid.equals(this.mUiccApplications[i].getAid())) continue;
                this.mUiccApplications[i].dispose();
                this.mUiccApplications[i] = null;
                changed = true;
            }
            if (TextUtils.isEmpty(aid)) {
                if (this.mCarrierPrivilegeRules != null) {
                    this.mCarrierPrivilegeRules = null;
                    changed = true;
                }
                if (this.mCatService != null) {
                    this.mCatService.dispose();
                    this.mCatService = null;
                    changed = true;
                }
            }
            return changed;
        }
    }

    public void iccOpenLogicalChannel(String aid, int p2, Message response) {
        this.loglocal("Open Logical Channel: " + aid + " , " + p2 + " by pid:" + Binder.getCallingPid() + " uid:" + Binder.getCallingUid());
        this.mCi.iccOpenLogicalChannel(aid, p2, this.obtainMessage(15, response));
    }

    public void iccCloseLogicalChannel(int channel, Message response) {
        this.loglocal("Close Logical Channel: " + channel);
        this.mCi.iccCloseLogicalChannel(channel, this.obtainMessage(16, response));
    }

    public void iccTransmitApduLogicalChannel(int channel, int cla, int command, int p1, int p2, int p3, String data, Message response) {
        this.mCi.iccTransmitApduLogicalChannel(channel, cla, command, p1, p2, p3, data, this.obtainMessage(17, response));
    }

    public void iccTransmitApduBasicChannel(int cla, int command, int p1, int p2, int p3, String data, Message response) {
        this.mCi.iccTransmitApduBasicChannel(cla, command, p1, p2, p3, data, this.obtainMessage(18, response));
    }

    public void iccExchangeSimIO(int fileID, int command, int p1, int p2, int p3, String pathID, Message response) {
        this.mCi.iccIO(command, fileID, pathID, p1, p2, p3, null, null, this.obtainMessage(19, response));
    }

    public void sendEnvelopeWithStatus(String contents, Message response) {
        this.mCi.sendEnvelopeWithStatus(contents, response);
    }

    public int getNumApplications() {
        int count = 0;
        for (UiccCardApplication a : this.mUiccApplications) {
            if (a == null) continue;
            ++count;
        }
        return count;
    }

    public int getPhoneId() {
        return this.mPhoneId;
    }

    public boolean areCarrierPriviligeRulesLoaded() {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null || carrierPrivilegeRules.areCarrierPriviligeRulesLoaded();
    }

    public boolean hasCarrierPrivilegeRules() {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules != null && carrierPrivilegeRules.hasCarrierPrivilegeRules();
    }

    public int getCarrierPrivilegeStatus(Signature signature, String packageName) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? -1 : carrierPrivilegeRules.getCarrierPrivilegeStatus(signature, packageName);
    }

    public int getCarrierPrivilegeStatus(PackageManager packageManager, String packageName) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? -1 : carrierPrivilegeRules.getCarrierPrivilegeStatus(packageManager, packageName);
    }

    public int getCarrierPrivilegeStatus(PackageInfo packageInfo) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? -1 : carrierPrivilegeRules.getCarrierPrivilegeStatus(packageInfo);
    }

    public int getCarrierPrivilegeStatusForCurrentTransaction(PackageManager packageManager) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? -1 : carrierPrivilegeRules.getCarrierPrivilegeStatusForCurrentTransaction(packageManager);
    }

    public List<String> getCarrierPackageNamesForIntent(PackageManager packageManager, Intent intent) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? null : carrierPrivilegeRules.getCarrierPackageNamesForIntent(packageManager, intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UiccCarrierPrivilegeRules getCarrierPrivilegeRules() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCarrierPrivilegeRules;
        }
    }

    public boolean setOperatorBrandOverride(String brand) {
        UiccProfile.log("setOperatorBrandOverride: " + brand);
        UiccProfile.log("current iccId: " + SubscriptionInfo.givePrintableIccid(this.getIccId()));
        String iccId = this.getIccId();
        if (TextUtils.isEmpty(iccId)) {
            return false;
        }
        SharedPreferences.Editor spEditor = PreferenceManager.getDefaultSharedPreferences(this.mContext).edit();
        String key = OPERATOR_BRAND_OVERRIDE_PREFIX + iccId;
        if (brand == null) {
            spEditor.remove(key).commit();
        } else {
            spEditor.putString(key, brand).commit();
        }
        return true;
    }

    public String getOperatorBrandOverride() {
        String iccId = this.getIccId();
        if (TextUtils.isEmpty(iccId)) {
            return null;
        }
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
        String brandName = sp.getString(OPERATOR_BRAND_OVERRIDE_PREFIX + iccId, null);
        if (brandName == null) {
            PersistableBundle bundle;
            CarrierConfigManager manager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
            int subId = SubscriptionController.getInstance().getSubIdUsingPhoneId(this.mPhoneId);
            if (manager != null && (bundle = manager.getConfigForSubId(subId)) != null && bundle.getBoolean("carrier_name_override_bool")) {
                brandName = bundle.getString("carrier_name_string");
            }
        }
        return brandName;
    }

    public String getIccId() {
        for (UiccCardApplication app : this.mUiccApplications) {
            IccRecords ir;
            if (app == null || (ir = app.getIccRecords()) == null || ir.getIccId() == null) continue;
            return ir.getIccId();
        }
        return null;
    }

    private static void log(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    private void loge(String msg) {
        Rlog.e(LOG_TAG, msg);
    }

    private void loglocal(String msg) {
        sLocalLog.log(msg);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        int i2;
        pw.println("UiccProfile:");
        pw.println(" mCi=" + this.mCi);
        pw.println(" mCatService=" + this.mCatService);
        for (i2 = 0; i2 < this.mCarrierPrivilegeRegistrants.size(); ++i2) {
            pw.println("  mCarrierPrivilegeRegistrants[" + i2 + "]=" + ((Registrant)this.mCarrierPrivilegeRegistrants.get(i2)).getHandler());
        }
        pw.println(" mUniversalPinState=" + (Object)((Object)this.mUniversalPinState));
        pw.println(" mGsmUmtsSubscriptionAppIndex=" + this.mGsmUmtsSubscriptionAppIndex);
        pw.println(" mCdmaSubscriptionAppIndex=" + this.mCdmaSubscriptionAppIndex);
        pw.println(" mImsSubscriptionAppIndex=" + this.mImsSubscriptionAppIndex);
        pw.println(" mUiccApplications: length=" + this.mUiccApplications.length);
        for (i2 = 0; i2 < this.mUiccApplications.length; ++i2) {
            if (this.mUiccApplications[i2] == null) {
                pw.println("  mUiccApplications[" + i2 + "]=" + null);
                continue;
            }
            pw.println("  mUiccApplications[" + i2 + "]=" + (Object)((Object)this.mUiccApplications[i2].getType()) + " " + this.mUiccApplications[i2]);
        }
        pw.println();
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null) continue;
            app.dump(fd, pw, args);
            pw.println();
        }
        for (UiccCardApplication app : this.mUiccApplications) {
            IccRecords ir;
            if (app == null || (ir = app.getIccRecords()) == null) continue;
            ir.dump(fd, pw, args);
            pw.println();
        }
        if (this.mCarrierPrivilegeRules == null) {
            pw.println(" mCarrierPrivilegeRules: null");
        } else {
            pw.println(" mCarrierPrivilegeRules: " + this.mCarrierPrivilegeRules);
            this.mCarrierPrivilegeRules.dump(fd, pw, args);
        }
        pw.println(" mCarrierPrivilegeRegistrants: size=" + this.mCarrierPrivilegeRegistrants.size());
        for (i = 0; i < this.mCarrierPrivilegeRegistrants.size(); ++i) {
            pw.println("  mCarrierPrivilegeRegistrants[" + i + "]=" + ((Registrant)this.mCarrierPrivilegeRegistrants.get(i)).getHandler());
        }
        pw.flush();
        pw.println(" mNetworkLockedRegistrants: size=" + this.mNetworkLockedRegistrants.size());
        for (i = 0; i < this.mNetworkLockedRegistrants.size(); ++i) {
            pw.println("  mNetworkLockedRegistrants[" + i + "]=" + ((Registrant)this.mNetworkLockedRegistrants.get(i)).getHandler());
        }
        pw.println(" mCurrentAppType=" + this.mCurrentAppType);
        pw.println(" mUiccCard=" + this.mUiccCard);
        pw.println(" mUiccApplication=" + this.mUiccApplication);
        pw.println(" mIccRecords=" + this.mIccRecords);
        pw.println(" mExternalState=" + (Object)((Object)this.mExternalState));
        pw.flush();
        pw.println("sLocalLog:");
        sLocalLog.dump(fd, pw, args);
        pw.flush();
    }

    private class ClickListener
    implements DialogInterface.OnClickListener {
        String mPkgName;

        ClickListener(String pkgName) {
            this.mPkgName = pkgName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClick(DialogInterface dialog, int which) {
            Object object = UiccProfile.this.mLock;
            synchronized (object) {
                if (which == -1) {
                    Intent market = new Intent("android.intent.action.VIEW");
                    market.setData(Uri.parse("market://details?id=" + this.mPkgName));
                    market.addFlags(0x10000000);
                    UiccProfile.this.mContext.startActivity(market);
                } else if (which == -2) {
                    UiccProfile.log("Not now clicked for carrier app dialog.");
                }
            }
        }
    }
}

