/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.telephony.Rlog;
import android.util.LocalLog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.uicc.AnswerToReset;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccSlotStatus;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccProfile;
import com.android.internal.telephony.uicc.euicc.EuiccCard;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class UiccSlot
extends Handler {
    private static final String TAG = "UiccSlot";
    private static final boolean DBG = true;
    public static final String EXTRA_ICC_CARD_ADDED = "com.android.internal.telephony.uicc.ICC_CARD_ADDED";
    public static final int INVALID_PHONE_ID = -1;
    private final Object mLock = new Object();
    private boolean mActive;
    private IccCardStatus.CardState mCardState;
    private Context mContext;
    private CommandsInterface mCi;
    private UiccCard mUiccCard;
    private CommandsInterface.RadioState mLastRadioState = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
    private boolean mIsEuicc;
    private String mIccId;
    private AnswerToReset mAtr;
    private int mPhoneId = -1;
    private static final int EVENT_CARD_REMOVED = 13;
    private static final int EVENT_CARD_ADDED = 14;
    private static final LocalLog sLocalLog = new LocalLog(100);

    public UiccSlot(Context c, boolean isActive) {
        this.log("Creating");
        this.mContext = c;
        this.mActive = isActive;
        this.mCardState = IccCardStatus.CardState.CARDSTATE_ABSENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CommandsInterface ci, IccCardStatus ics, int phoneId) {
        Object object = this.mLock;
        synchronized (object) {
            IccCardStatus.CardState oldState = this.mCardState;
            this.mCardState = ics.mCardState;
            this.mPhoneId = phoneId;
            this.parseAtr(ics.atr);
            this.mCi = ci;
            CommandsInterface.RadioState radioState = this.mCi.getRadioState();
            this.log("update: radioState=" + (Object)((Object)radioState) + " mLastRadioState=" + (Object)((Object)this.mLastRadioState));
            if (oldState != IccCardStatus.CardState.CARDSTATE_ABSENT && this.mCardState == IccCardStatus.CardState.CARDSTATE_ABSENT) {
                if (radioState == CommandsInterface.RadioState.RADIO_ON && this.mLastRadioState == CommandsInterface.RadioState.RADIO_ON) {
                    this.log("update: notify card removed");
                    this.sendMessage(this.obtainMessage(13, null));
                }
                UiccProfile.broadcastInternalIccStateChangedIntent("ABSENT", null, this.mPhoneId);
                this.mUiccCard.dispose();
                this.mUiccCard = null;
            } else if (oldState == IccCardStatus.CardState.CARDSTATE_ABSENT && this.mCardState != IccCardStatus.CardState.CARDSTATE_ABSENT) {
                if (radioState == CommandsInterface.RadioState.RADIO_ON && this.mLastRadioState == CommandsInterface.RadioState.RADIO_ON) {
                    this.log("update: notify card added");
                    this.sendMessage(this.obtainMessage(14, null));
                }
                if (this.mUiccCard != null) {
                    this.loge("update: mUiccCard != null when card was present; disposing it now");
                    this.mUiccCard.dispose();
                }
                this.mUiccCard = !this.mIsEuicc ? new UiccCard(this.mContext, this.mCi, ics, this.mPhoneId) : new EuiccCard(this.mContext, this.mCi, ics, phoneId);
            } else if (this.mUiccCard != null) {
                this.mUiccCard.update(this.mContext, this.mCi, ics);
            }
            this.mLastRadioState = radioState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CommandsInterface ci, IccSlotStatus iss) {
        this.log("slotStatus update");
        Object object = this.mLock;
        synchronized (object) {
            this.mCi = ci;
            if (iss.slotState == IccSlotStatus.SlotState.SLOTSTATE_INACTIVE) {
                if (this.mActive) {
                    this.mActive = false;
                    this.mLastRadioState = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
                    this.mPhoneId = -1;
                    if (this.mUiccCard != null) {
                        this.mUiccCard.dispose();
                    }
                    this.mUiccCard = null;
                }
                this.parseAtr(iss.atr);
                this.mCardState = iss.cardState;
                this.mIccId = iss.iccid;
            } else if (!this.mActive && iss.slotState == IccSlotStatus.SlotState.SLOTSTATE_ACTIVE) {
                this.mActive = true;
                this.parseAtr(iss.atr);
            }
        }
    }

    private void checkIsEuiccSupported() {
        this.mIsEuicc = this.mAtr != null && this.mAtr.isEuiccSupported();
    }

    private void parseAtr(String atr) {
        this.mAtr = AnswerToReset.parseAtr(atr);
        if (this.mAtr == null) {
            return;
        }
        this.checkIsEuiccSupported();
    }

    public boolean isEuicc() {
        return this.mIsEuicc;
    }

    public boolean isActive() {
        return this.mActive;
    }

    public int getPhoneId() {
        return this.mPhoneId;
    }

    public String getIccId() {
        if (this.mIccId != null) {
            return this.mIccId;
        }
        if (this.mUiccCard != null) {
            return this.mUiccCard.getIccId();
        }
        return null;
    }

    protected void finalize() {
        this.log("UiccSlot finalized");
    }

    private void onIccSwap(boolean isAdded) {
        boolean isHotSwapSupported = this.mContext.getResources().getBoolean(17956979);
        if (isHotSwapSupported) {
            this.log("onIccSwap: isHotSwapSupported is true, don't prompt for rebooting");
            return;
        }
        this.log("onIccSwap: isHotSwapSupported is false, prompt for rebooting");
        this.promptForRestart(isAdded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promptForRestart(boolean isAdded) {
        Object object = this.mLock;
        synchronized (object) {
            Resources res = this.mContext.getResources();
            String dialogComponent = res.getString(17039682);
            if (dialogComponent != null) {
                Intent intent = new Intent().setComponent(ComponentName.unflattenFromString(dialogComponent)).addFlags(0x10000000).putExtra(EXTRA_ICC_CARD_ADDED, isAdded);
                try {
                    this.mContext.startActivity(intent);
                    return;
                }
                catch (ActivityNotFoundException e) {
                    this.loge("Unable to find ICC hotswap prompt for restart activity: " + e);
                }
            }
            DialogInterface.OnClickListener listener = null;
            listener = new DialogInterface.OnClickListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    Object object = UiccSlot.this.mLock;
                    synchronized (object) {
                        if (which == -1) {
                            UiccSlot.this.log("Reboot due to SIM swap");
                            PowerManager pm = (PowerManager)UiccSlot.this.mContext.getSystemService("power");
                            pm.reboot("SIM is added.");
                        }
                    }
                }
            };
            Resources r = Resources.getSystem();
            String title = isAdded ? r.getString(17040835) : r.getString(17040838);
            String message = isAdded ? r.getString(17040834) : r.getString(17040837);
            String buttonTxt = r.getString(17040839);
            AlertDialog dialog = new AlertDialog.Builder(this.mContext).setTitle(title).setMessage(message).setPositiveButton(buttonTxt, listener).create();
            dialog.getWindow().setType(2003);
            dialog.show();
        }
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 13: {
                this.onIccSwap(false);
                break;
            }
            case 14: {
                this.onIccSwap(true);
                break;
            }
            default: {
                this.loge("Unknown Event " + msg.what);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccCardStatus.CardState getCardState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCardState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCard getUiccCard() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUiccCard;
        }
    }

    public void onRadioStateUnavailable() {
        if (this.mUiccCard != null) {
            this.mUiccCard.dispose();
        }
        this.mUiccCard = null;
        if (this.mPhoneId != -1) {
            UiccProfile.broadcastInternalIccStateChangedIntent("UNKNOWN", null, this.mPhoneId);
        }
        this.mCardState = IccCardStatus.CardState.CARDSTATE_ABSENT;
        this.mLastRadioState = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
    }

    private void log(String msg) {
        Rlog.d(TAG, msg);
    }

    private void loge(String msg) {
        Rlog.e(TAG, msg);
    }

    private void loglocal(String msg) {
        sLocalLog.log(msg);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("UiccSlot:");
        pw.println(" mCi=" + this.mCi);
        pw.println(" mActive=" + this.mActive);
        pw.println(" mLastRadioState=" + (Object)((Object)this.mLastRadioState));
        pw.println(" mCardState=" + (Object)((Object)this.mCardState));
        if (this.mUiccCard != null) {
            pw.println(" mUiccCard=" + this.mUiccCard);
            this.mUiccCard.dump(fd, pw, args);
        } else {
            pw.println(" mUiccCard=null");
        }
        pw.println();
        pw.flush();
        pw.println("sLocalLog:");
        sLocalLog.dump(fd, pw, args);
        pw.flush();
    }
}

