/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc.euicc.apdu;

import android.os.Handler;
import android.telephony.IccOpenLogicalChannelResponse;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.euicc.apdu.ApduCommand;
import com.android.internal.telephony.uicc.euicc.apdu.ApduException;
import com.android.internal.telephony.uicc.euicc.apdu.CloseLogicalChannelInvocation;
import com.android.internal.telephony.uicc.euicc.apdu.OpenLogicalChannelInvocation;
import com.android.internal.telephony.uicc.euicc.apdu.RequestBuilder;
import com.android.internal.telephony.uicc.euicc.apdu.RequestProvider;
import com.android.internal.telephony.uicc.euicc.apdu.TransmitApduLogicalChannelInvocation;
import com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback;
import com.android.internal.telephony.uicc.euicc.async.AsyncResultHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;

public class ApduSender {
    private static final String LOG_TAG = "ApduSender";
    private static final int INS_GET_MORE_RESPONSE = 192;
    private static final int SW1_MORE_RESPONSE = 97;
    private static final int STATUS_NO_ERROR = 36864;
    private final String mAid;
    private final boolean mSupportExtendedApdu;
    private final OpenLogicalChannelInvocation mOpenChannel;
    private final CloseLogicalChannelInvocation mCloseChannel;
    private final TransmitApduLogicalChannelInvocation mTransmitApdu;
    private final Object mChannelLock = new Object();
    private boolean mChannelOpened;

    private static void logv(String msg) {
        Rlog.v(LOG_TAG, msg);
    }

    public ApduSender(CommandsInterface ci, String aid, boolean supportExtendedApdu) {
        this.mAid = aid;
        this.mSupportExtendedApdu = supportExtendedApdu;
        this.mOpenChannel = new OpenLogicalChannelInvocation(ci);
        this.mCloseChannel = new CloseLogicalChannelInvocation(ci);
        this.mTransmitApdu = new TransmitApduLogicalChannelInvocation(ci);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(final RequestProvider requestProvider, final AsyncResultCallback<byte[]> resultCallback, final Handler handler) {
        Object object = this.mChannelLock;
        synchronized (object) {
            if (this.mChannelOpened) {
                AsyncResultHelper.throwException(new ApduException("Logical channel has already been opened."), resultCallback, handler);
                return;
            }
            this.mChannelOpened = true;
        }
        this.mOpenChannel.invoke(this.mAid, new AsyncResultCallback<IccOpenLogicalChannelResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(IccOpenLogicalChannelResponse openChannelResponse) {
                int channel = openChannelResponse.getChannel();
                int status = openChannelResponse.getStatus();
                if (channel == -1 || status != 1) {
                    Object object = ApduSender.this.mChannelLock;
                    synchronized (object) {
                        ApduSender.this.mChannelOpened = false;
                    }
                    resultCallback.onException(new ApduException("Failed to open logical channel opened for AID: " + ApduSender.this.mAid + ", with status: " + status));
                    return;
                }
                RequestBuilder builder = new RequestBuilder(channel, ApduSender.this.mSupportExtendedApdu);
                Throwable requestException = null;
                try {
                    requestProvider.buildRequest(openChannelResponse.getSelectResponse(), builder);
                }
                catch (Throwable e) {
                    requestException = e;
                }
                if (builder.getCommands().isEmpty() || requestException != null) {
                    ApduSender.this.closeAndReturn(channel, null, requestException, resultCallback, handler);
                    return;
                }
                ApduSender.this.sendCommand(builder.getCommands(), 0, resultCallback, handler);
            }
        }, handler);
    }

    private void sendCommand(final List<ApduCommand> commands, final int index, final AsyncResultCallback<byte[]> resultCallback, final Handler handler) {
        final ApduCommand command = commands.get(index);
        this.mTransmitApdu.invoke(command, new AsyncResultCallback<IccIoResult>(){

            @Override
            public void onResult(IccIoResult response) {
                ApduSender.this.getCompleteResponse(command.channel, response, null, new AsyncResultCallback<IccIoResult>(){

                    @Override
                    public void onResult(IccIoResult fullResponse) {
                        ApduSender.logv("Full APDU response: " + fullResponse);
                        int status = fullResponse.sw1 << 8 | fullResponse.sw2;
                        if (status != 36864) {
                            ApduSender.this.closeAndReturn(command.channel, null, new ApduException(status), resultCallback, handler);
                            return;
                        }
                        if (index == commands.size() - 1) {
                            ApduSender.this.closeAndReturn(command.channel, fullResponse.payload, null, resultCallback, handler);
                            return;
                        }
                        ApduSender.this.sendCommand(commands, index + 1, resultCallback, handler);
                    }
                }, handler);
            }
        }, handler);
    }

    private void getCompleteResponse(final int channel, IccIoResult lastResponse, ByteArrayOutputStream responseBuilder, final AsyncResultCallback<IccIoResult> resultCallback, final Handler handler) {
        final ByteArrayOutputStream resultBuilder = responseBuilder == null ? new ByteArrayOutputStream() : responseBuilder;
        try {
            resultBuilder.write(lastResponse.payload);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (lastResponse.sw1 != 97) {
            lastResponse.payload = resultBuilder.toByteArray();
            resultCallback.onResult(lastResponse);
            return;
        }
        this.mTransmitApdu.invoke(new ApduCommand(channel, 0, 192, 0, 0, lastResponse.sw2, ""), new AsyncResultCallback<IccIoResult>(){

            @Override
            public void onResult(IccIoResult response) {
                ApduSender.this.getCompleteResponse(channel, response, resultBuilder, resultCallback, handler);
            }
        }, handler);
    }

    private void closeAndReturn(int channel, final byte[] response, final Throwable exception, final AsyncResultCallback<byte[]> resultCallback, Handler handler) {
        this.mCloseChannel.invoke(channel, new AsyncResultCallback<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(Boolean aBoolean) {
                Object object = ApduSender.this.mChannelLock;
                synchronized (object) {
                    ApduSender.this.mChannelOpened = false;
                }
                if (exception == null) {
                    resultCallback.onResult(response);
                } else {
                    resultCallback.onException(exception);
                }
            }
        }, handler);
    }
}

