/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc.euicc.apdu;

import com.android.internal.telephony.uicc.euicc.apdu.ApduCommand;
import java.util.ArrayList;
import java.util.List;

public class RequestBuilder {
    private static final int MAX_APDU_DATA_LEN = 255;
    private static final int MAX_EXT_APDU_DATA_LEN = 65535;
    private static final int CLA_STORE_DATA = 128;
    private static final int INS_STORE_DATA = 226;
    private static final int P1_STORE_DATA_INTERM = 17;
    private static final int P1_STORE_DATA_END = 145;
    private final int mChannel;
    private final int mMaxApduDataLen;
    private final List<ApduCommand> mCommands = new ArrayList<ApduCommand>();

    public void addApdu(int cla, int ins, int p1, int p2, int p3, String cmdHex) {
        this.mCommands.add(new ApduCommand(this.mChannel, cla, ins, p1, p2, p3, cmdHex));
    }

    public void addApdu(int cla, int ins, int p1, int p2, String cmdHex) {
        this.mCommands.add(new ApduCommand(this.mChannel, cla, ins, p1, p2, cmdHex.length() / 2, cmdHex));
    }

    public void addApdu(int cla, int ins, int p1, int p2) {
        this.mCommands.add(new ApduCommand(this.mChannel, cla, ins, p1, p2, 0, ""));
    }

    public void addStoreData(String cmdHex) {
        int cmdLen = this.mMaxApduDataLen * 2;
        int startPos = 0;
        int totalLen = cmdHex.length() / 2;
        int totalSubCmds = totalLen == 0 ? 1 : (totalLen + this.mMaxApduDataLen - 1) / this.mMaxApduDataLen;
        for (int i = 1; i < totalSubCmds; ++i) {
            String data = cmdHex.substring(startPos, startPos + cmdLen);
            this.addApdu(128, 226, 17, i - 1, this.mMaxApduDataLen, data);
            startPos += cmdLen;
        }
        String data = cmdHex.substring(startPos);
        this.addApdu(128, 226, 145, totalSubCmds - 1, totalLen % this.mMaxApduDataLen, data);
    }

    List<ApduCommand> getCommands() {
        return this.mCommands;
    }

    RequestBuilder(int channel, boolean supportExtendedApdu) {
        this.mChannel = channel;
        this.mMaxApduDataLen = supportExtendedApdu ? 65535 : 255;
    }
}

