/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.graphics.drawable.VectorDrawable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.TextAppearanceSpan;
import android.util.Log;
import android.util.Pair;
import com.android.internal.util.ImageUtils;
import java.util.Arrays;
import java.util.WeakHashMap;

public class NotificationColorUtil {
    private static final String TAG = "NotificationColorUtil";
    private static final boolean DEBUG = false;
    private static final Object sLock = new Object();
    private static NotificationColorUtil sInstance;
    private final ImageUtils mImageUtils = new ImageUtils();
    private final WeakHashMap<Bitmap, Pair<Boolean, Integer>> mGrayscaleBitmapCache = new WeakHashMap();
    private final int mGrayscaleIconMaxSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NotificationColorUtil getInstance(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new NotificationColorUtil(context);
            }
            return sInstance;
        }
    }

    private NotificationColorUtil(Context context) {
        this.mGrayscaleIconMaxSize = context.getResources().getDimensionPixelSize(0x1050005);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGrayscaleIcon(Bitmap bitmap) {
        int generationId;
        boolean result;
        if (bitmap.getWidth() > this.mGrayscaleIconMaxSize || bitmap.getHeight() > this.mGrayscaleIconMaxSize) {
            return false;
        }
        Object object = sLock;
        synchronized (object) {
            Pair<Boolean, Integer> cached = this.mGrayscaleBitmapCache.get(bitmap);
            if (cached != null && ((Integer)cached.second).intValue() == bitmap.getGenerationId()) {
                return (Boolean)cached.first;
            }
        }
        Object object2 = this.mImageUtils;
        synchronized (object2) {
            result = this.mImageUtils.isGrayscale(bitmap);
            generationId = bitmap.getGenerationId();
        }
        object2 = sLock;
        synchronized (object2) {
            this.mGrayscaleBitmapCache.put(bitmap, Pair.create(result, generationId));
        }
        return result;
    }

    public boolean isGrayscaleIcon(Drawable d) {
        if (d == null) {
            return false;
        }
        if (d instanceof BitmapDrawable) {
            BitmapDrawable bd = (BitmapDrawable)d;
            return bd.getBitmap() != null && this.isGrayscaleIcon(bd.getBitmap());
        }
        if (d instanceof AnimationDrawable) {
            AnimationDrawable ad = (AnimationDrawable)d;
            int count = ad.getNumberOfFrames();
            return count > 0 && this.isGrayscaleIcon(ad.getFrame(0));
        }
        return d instanceof VectorDrawable;
    }

    public boolean isGrayscaleIcon(Context context, Icon icon) {
        if (icon == null) {
            return false;
        }
        switch (icon.getType()) {
            case 1: {
                return this.isGrayscaleIcon(icon.getBitmap());
            }
            case 2: {
                return this.isGrayscaleIcon(context, icon.getResId());
            }
        }
        return false;
    }

    public boolean isGrayscaleIcon(Context context, int drawableResId) {
        if (drawableResId != 0) {
            try {
                return this.isGrayscaleIcon(context.getDrawable(drawableResId));
            }
            catch (Resources.NotFoundException ex) {
                Log.e(TAG, "Drawable not found: " + drawableResId);
                return false;
            }
        }
        return false;
    }

    public CharSequence invertCharSequenceColors(CharSequence charSequence) {
        if (charSequence instanceof Spanned) {
            Spanned ss = (Spanned)charSequence;
            Object[] spans = ss.getSpans(0, ss.length(), Object.class);
            SpannableStringBuilder builder = new SpannableStringBuilder(ss.toString());
            for (Object span : spans) {
                Object resultSpan = span;
                if (resultSpan instanceof CharacterStyle) {
                    resultSpan = ((CharacterStyle)span).getUnderlying();
                }
                if (resultSpan instanceof TextAppearanceSpan) {
                    TextAppearanceSpan processedSpan = this.processTextAppearanceSpan((TextAppearanceSpan)span);
                    resultSpan = processedSpan != resultSpan ? processedSpan : span;
                } else if (resultSpan instanceof ForegroundColorSpan) {
                    ForegroundColorSpan originalSpan = (ForegroundColorSpan)resultSpan;
                    int foregroundColor = originalSpan.getForegroundColor();
                    resultSpan = new ForegroundColorSpan(this.processColor(foregroundColor));
                } else {
                    resultSpan = span;
                }
                builder.setSpan(resultSpan, ss.getSpanStart(span), ss.getSpanEnd(span), ss.getSpanFlags(span));
            }
            return builder;
        }
        return charSequence;
    }

    private TextAppearanceSpan processTextAppearanceSpan(TextAppearanceSpan span) {
        ColorStateList colorStateList = span.getTextColor();
        if (colorStateList != null) {
            int[] colors = colorStateList.getColors();
            boolean changed = false;
            for (int i = 0; i < colors.length; ++i) {
                if (!ImageUtils.isGrayscale(colors[i])) continue;
                if (!changed) {
                    colors = Arrays.copyOf(colors, colors.length);
                }
                colors[i] = this.processColor(colors[i]);
                changed = true;
            }
            if (changed) {
                return new TextAppearanceSpan(span.getFamily(), span.getTextStyle(), span.getTextSize(), new ColorStateList(colorStateList.getStates(), colors), span.getLinkTextColor());
            }
        }
        return span;
    }

    public static CharSequence clearColorSpans(CharSequence charSequence) {
        if (charSequence instanceof Spanned) {
            Spanned ss = (Spanned)charSequence;
            Object[] spans = ss.getSpans(0, ss.length(), Object.class);
            SpannableStringBuilder builder = new SpannableStringBuilder(ss.toString());
            for (Object span : spans) {
                Object resultSpan = span;
                if (resultSpan instanceof CharacterStyle) {
                    resultSpan = ((CharacterStyle)span).getUnderlying();
                }
                if (resultSpan instanceof TextAppearanceSpan) {
                    TextAppearanceSpan originalSpan = (TextAppearanceSpan)resultSpan;
                    if (originalSpan.getTextColor() != null) {
                        resultSpan = new TextAppearanceSpan(originalSpan.getFamily(), originalSpan.getTextStyle(), originalSpan.getTextSize(), null, originalSpan.getLinkTextColor());
                    }
                } else {
                    if (resultSpan instanceof ForegroundColorSpan || resultSpan instanceof BackgroundColorSpan) continue;
                    resultSpan = span;
                }
                builder.setSpan(resultSpan, ss.getSpanStart(span), ss.getSpanEnd(span), ss.getSpanFlags(span));
            }
            return builder;
        }
        return charSequence;
    }

    private int processColor(int color2) {
        return Color.argb(Color.alpha(color2), 255 - Color.red(color2), 255 - Color.green(color2), 255 - Color.blue(color2));
    }

    public static int findContrastColor(int color2, int other, boolean findFg, double minRatio) {
        int bg;
        int fg = findFg ? color2 : other;
        int n = bg = findFg ? other : color2;
        if (ColorUtilsFromCompat.calculateContrast(fg, bg) >= minRatio) {
            return color2;
        }
        double[] lab = new double[3];
        ColorUtilsFromCompat.colorToLAB(findFg ? fg : bg, lab);
        double low = 0.0;
        double high = lab[0];
        double a = lab[1];
        double b = lab[2];
        for (int i = 0; i < 15 && high - low > 1.0E-5; ++i) {
            double l = (low + high) / 2.0;
            if (findFg) {
                fg = ColorUtilsFromCompat.LABToColor(l, a, b);
            } else {
                bg = ColorUtilsFromCompat.LABToColor(l, a, b);
            }
            if (ColorUtilsFromCompat.calculateContrast(fg, bg) > minRatio) {
                low = l;
                continue;
            }
            high = l;
        }
        return ColorUtilsFromCompat.LABToColor(low, a, b);
    }

    public static int findAlphaToMeetContrast(int color2, int backgroundColor, double minRatio) {
        int fg = color2;
        int bg = backgroundColor;
        if (ColorUtilsFromCompat.calculateContrast(fg, bg) >= minRatio) {
            return color2;
        }
        int startAlpha = Color.alpha(color2);
        int r = Color.red(color2);
        int g = Color.green(color2);
        int b = Color.blue(color2);
        int low = startAlpha;
        int high = 255;
        for (int i = 0; i < 15 && high - low > 0; ++i) {
            int alpha = (low + high) / 2;
            fg = Color.argb(alpha, r, g, b);
            if (ColorUtilsFromCompat.calculateContrast(fg, bg) > minRatio) {
                high = alpha;
                continue;
            }
            low = alpha;
        }
        return Color.argb(high, r, g, b);
    }

    public static int findContrastColorAgainstDark(int color2, int other, boolean findFg, double minRatio) {
        int bg;
        int fg = findFg ? color2 : other;
        int n = bg = findFg ? other : color2;
        if (ColorUtilsFromCompat.calculateContrast(fg, bg) >= minRatio) {
            return color2;
        }
        float[] hsl = new float[3];
        ColorUtilsFromCompat.colorToHSL(findFg ? fg : bg, hsl);
        float low = hsl[2];
        float high = 1.0f;
        for (int i = 0; i < 15 && (double)(high - low) > 1.0E-5; ++i) {
            float l;
            hsl[2] = l = (low + high) / 2.0f;
            if (findFg) {
                fg = ColorUtilsFromCompat.HSLToColor(hsl);
            } else {
                bg = ColorUtilsFromCompat.HSLToColor(hsl);
            }
            if (ColorUtilsFromCompat.calculateContrast(fg, bg) > minRatio) {
                high = l;
                continue;
            }
            low = l;
        }
        return findFg ? fg : bg;
    }

    public static int ensureTextContrastOnBlack(int color2) {
        return NotificationColorUtil.findContrastColorAgainstDark(color2, -16777216, true, 12.0);
    }

    public static int ensureLargeTextContrast(int color2, int bg, boolean isBgDarker) {
        return isBgDarker ? NotificationColorUtil.findContrastColorAgainstDark(color2, bg, true, 3.0) : NotificationColorUtil.findContrastColor(color2, bg, true, 3.0);
    }

    private static int ensureTextContrast(int color2, int bg, boolean isBgDarker) {
        return isBgDarker ? NotificationColorUtil.findContrastColorAgainstDark(color2, bg, true, 4.5) : NotificationColorUtil.findContrastColor(color2, bg, true, 4.5);
    }

    public static int ensureTextBackgroundColor(int color2, int textColor, int hintColor) {
        color2 = NotificationColorUtil.findContrastColor(color2, hintColor, false, 3.0);
        return NotificationColorUtil.findContrastColor(color2, textColor, false, 4.5);
    }

    private static String contrastChange(int colorOld, int colorNew, int bg) {
        return String.format("from %.2f:1 to %.2f:1", ColorUtilsFromCompat.calculateContrast(colorOld, bg), ColorUtilsFromCompat.calculateContrast(colorNew, bg));
    }

    public static int resolveColor(Context context, int color2) {
        if (color2 == 0) {
            return context.getColor(17170662);
        }
        return color2;
    }

    public static int resolveContrastColor(Context context, int notificationColor, int backgroundColor) {
        return NotificationColorUtil.resolveContrastColor(context, notificationColor, backgroundColor, false);
    }

    public static int resolveContrastColor(Context context, int notificationColor, int backgroundColor, boolean isDark) {
        int resolvedColor = NotificationColorUtil.resolveColor(context, notificationColor);
        int actionBg = context.getColor(17170659);
        int color2 = resolvedColor;
        color2 = NotificationColorUtil.ensureLargeTextContrast(color2, actionBg, isDark);
        if ((color2 = NotificationColorUtil.ensureTextContrast(color2, backgroundColor, isDark)) != resolvedColor) {
            // empty if block
        }
        return color2;
    }

    public static int changeColorLightness(int baseColor, int amount) {
        double[] result = ColorUtilsFromCompat.getTempDouble3Array();
        ColorUtilsFromCompat.colorToLAB(baseColor, result);
        result[0] = Math.max(Math.min(100.0, result[0] + (double)amount), 0.0);
        return ColorUtilsFromCompat.LABToColor(result[0], result[1], result[2]);
    }

    public static int resolveAmbientColor(Context context, int notificationColor) {
        int resolvedColor;
        int color2 = resolvedColor = NotificationColorUtil.resolveColor(context, notificationColor);
        if ((color2 = NotificationColorUtil.ensureTextContrastOnBlack(color2)) != resolvedColor) {
            // empty if block
        }
        return color2;
    }

    public static int resolvePrimaryColor(Context context, int backgroundColor) {
        boolean useDark = NotificationColorUtil.shouldUseDark(backgroundColor);
        if (useDark) {
            return context.getColor(17170665);
        }
        return context.getColor(17170664);
    }

    public static int resolveSecondaryColor(Context context, int backgroundColor) {
        boolean useDark = NotificationColorUtil.shouldUseDark(backgroundColor);
        if (useDark) {
            return context.getColor(17170668);
        }
        return context.getColor(17170667);
    }

    public static int resolveActionBarColor(Context context, int backgroundColor) {
        if (backgroundColor == 0) {
            return context.getColor(17170659);
        }
        return NotificationColorUtil.getShiftedColor(backgroundColor, 7);
    }

    public static int getShiftedColor(int color2, int amount) {
        double[] result = ColorUtilsFromCompat.getTempDouble3Array();
        ColorUtilsFromCompat.colorToLAB(color2, result);
        result[0] = result[0] >= 4.0 ? Math.max(0.0, result[0] - (double)amount) : Math.min(100.0, result[0] + (double)amount);
        return ColorUtilsFromCompat.LABToColor(result[0], result[1], result[2]);
    }

    private static boolean shouldUseDark(int backgroundColor) {
        boolean useDark;
        boolean bl = useDark = backgroundColor == 0;
        if (!useDark) {
            useDark = ColorUtilsFromCompat.calculateLuminance(backgroundColor) > 0.5;
        }
        return useDark;
    }

    public static double calculateLuminance(int backgroundColor) {
        return ColorUtilsFromCompat.calculateLuminance(backgroundColor);
    }

    public static double calculateContrast(int foregroundColor, int backgroundColor) {
        return ColorUtilsFromCompat.calculateContrast(foregroundColor, backgroundColor);
    }

    public static boolean satisfiesTextContrast(int backgroundColor, int foregroundColor) {
        return NotificationColorUtil.calculateContrast(foregroundColor, backgroundColor) >= 4.5;
    }

    public static int compositeColors(int foreground, int background) {
        return ColorUtilsFromCompat.compositeColors(foreground, background);
    }

    public static boolean isColorLight(int backgroundColor) {
        return NotificationColorUtil.calculateLuminance(backgroundColor) > 0.5;
    }

    private static class ColorUtilsFromCompat {
        private static final double XYZ_WHITE_REFERENCE_X = 95.047;
        private static final double XYZ_WHITE_REFERENCE_Y = 100.0;
        private static final double XYZ_WHITE_REFERENCE_Z = 108.883;
        private static final double XYZ_EPSILON = 0.008856;
        private static final double XYZ_KAPPA = 903.3;
        private static final int MIN_ALPHA_SEARCH_MAX_ITERATIONS = 10;
        private static final int MIN_ALPHA_SEARCH_PRECISION = 1;
        private static final ThreadLocal<double[]> TEMP_ARRAY = new ThreadLocal();

        private ColorUtilsFromCompat() {
        }

        public static int compositeColors(int foreground, int background) {
            int bgAlpha = Color.alpha(background);
            int fgAlpha = Color.alpha(foreground);
            int a = ColorUtilsFromCompat.compositeAlpha(fgAlpha, bgAlpha);
            int r = ColorUtilsFromCompat.compositeComponent(Color.red(foreground), fgAlpha, Color.red(background), bgAlpha, a);
            int g = ColorUtilsFromCompat.compositeComponent(Color.green(foreground), fgAlpha, Color.green(background), bgAlpha, a);
            int b = ColorUtilsFromCompat.compositeComponent(Color.blue(foreground), fgAlpha, Color.blue(background), bgAlpha, a);
            return Color.argb(a, r, g, b);
        }

        private static int compositeAlpha(int foregroundAlpha, int backgroundAlpha) {
            return 255 - (255 - backgroundAlpha) * (255 - foregroundAlpha) / 255;
        }

        private static int compositeComponent(int fgC, int fgA, int bgC, int bgA, int a) {
            if (a == 0) {
                return 0;
            }
            return (255 * fgC * fgA + bgC * bgA * (255 - fgA)) / (a * 255);
        }

        public static double calculateLuminance(int color2) {
            double[] result = ColorUtilsFromCompat.getTempDouble3Array();
            ColorUtilsFromCompat.colorToXYZ(color2, result);
            return result[1] / 100.0;
        }

        public static double calculateContrast(int foreground, int background) {
            if (Color.alpha(background) != 255) {
                Log.wtf(NotificationColorUtil.TAG, "background can not be translucent: #" + Integer.toHexString(background));
            }
            if (Color.alpha(foreground) < 255) {
                foreground = ColorUtilsFromCompat.compositeColors(foreground, background);
            }
            double luminance1 = ColorUtilsFromCompat.calculateLuminance(foreground) + 0.05;
            double luminance2 = ColorUtilsFromCompat.calculateLuminance(background) + 0.05;
            return Math.max(luminance1, luminance2) / Math.min(luminance1, luminance2);
        }

        public static void colorToLAB(int color2, double[] outLab) {
            ColorUtilsFromCompat.RGBToLAB(Color.red(color2), Color.green(color2), Color.blue(color2), outLab);
        }

        public static void RGBToLAB(int r, int g, int b, double[] outLab) {
            ColorUtilsFromCompat.RGBToXYZ(r, g, b, outLab);
            ColorUtilsFromCompat.XYZToLAB(outLab[0], outLab[1], outLab[2], outLab);
        }

        public static void colorToXYZ(int color2, double[] outXyz) {
            ColorUtilsFromCompat.RGBToXYZ(Color.red(color2), Color.green(color2), Color.blue(color2), outXyz);
        }

        public static void RGBToXYZ(int r, int g, int b, double[] outXyz) {
            if (outXyz.length != 3) {
                throw new IllegalArgumentException("outXyz must have a length of 3.");
            }
            double sr = (double)r / 255.0;
            sr = sr < 0.04045 ? sr / 12.92 : Math.pow((sr + 0.055) / 1.055, 2.4);
            double sg = (double)g / 255.0;
            sg = sg < 0.04045 ? sg / 12.92 : Math.pow((sg + 0.055) / 1.055, 2.4);
            double sb = (double)b / 255.0;
            sb = sb < 0.04045 ? sb / 12.92 : Math.pow((sb + 0.055) / 1.055, 2.4);
            outXyz[0] = 100.0 * (sr * 0.4124 + sg * 0.3576 + sb * 0.1805);
            outXyz[1] = 100.0 * (sr * 0.2126 + sg * 0.7152 + sb * 0.0722);
            outXyz[2] = 100.0 * (sr * 0.0193 + sg * 0.1192 + sb * 0.9505);
        }

        public static void XYZToLAB(double x, double y, double z, double[] outLab) {
            if (outLab.length != 3) {
                throw new IllegalArgumentException("outLab must have a length of 3.");
            }
            x = ColorUtilsFromCompat.pivotXyzComponent(x / 95.047);
            y = ColorUtilsFromCompat.pivotXyzComponent(y / 100.0);
            z = ColorUtilsFromCompat.pivotXyzComponent(z / 108.883);
            outLab[0] = Math.max(0.0, 116.0 * y - 16.0);
            outLab[1] = 500.0 * (x - y);
            outLab[2] = 200.0 * (y - z);
        }

        public static void LABToXYZ(double l, double a, double b, double[] outXyz) {
            double fy = (l + 16.0) / 116.0;
            double fx = a / 500.0 + fy;
            double fz = fy - b / 200.0;
            double tmp = Math.pow(fx, 3.0);
            double xr = tmp > 0.008856 ? tmp : (116.0 * fx - 16.0) / 903.3;
            double yr = l > 7.9996247999999985 ? Math.pow(fy, 3.0) : l / 903.3;
            tmp = Math.pow(fz, 3.0);
            double zr = tmp > 0.008856 ? tmp : (116.0 * fz - 16.0) / 903.3;
            outXyz[0] = xr * 95.047;
            outXyz[1] = yr * 100.0;
            outXyz[2] = zr * 108.883;
        }

        public static int XYZToColor(double x, double y, double z) {
            double r = (x * 3.2406 + y * -1.5372 + z * -0.4986) / 100.0;
            double g = (x * -0.9689 + y * 1.8758 + z * 0.0415) / 100.0;
            double b = (x * 0.0557 + y * -0.204 + z * 1.057) / 100.0;
            r = r > 0.0031308 ? 1.055 * Math.pow(r, 0.4166666666666667) - 0.055 : 12.92 * r;
            g = g > 0.0031308 ? 1.055 * Math.pow(g, 0.4166666666666667) - 0.055 : 12.92 * g;
            b = b > 0.0031308 ? 1.055 * Math.pow(b, 0.4166666666666667) - 0.055 : 12.92 * b;
            return Color.rgb(ColorUtilsFromCompat.constrain((int)Math.round(r * 255.0), 0, 255), ColorUtilsFromCompat.constrain((int)Math.round(g * 255.0), 0, 255), ColorUtilsFromCompat.constrain((int)Math.round(b * 255.0), 0, 255));
        }

        public static int LABToColor(double l, double a, double b) {
            double[] result = ColorUtilsFromCompat.getTempDouble3Array();
            ColorUtilsFromCompat.LABToXYZ(l, a, b, result);
            return ColorUtilsFromCompat.XYZToColor(result[0], result[1], result[2]);
        }

        private static int constrain(int amount, int low, int high) {
            return amount < low ? low : (amount > high ? high : amount);
        }

        private static float constrain(float amount, float low, float high) {
            return amount < low ? low : (amount > high ? high : amount);
        }

        private static double pivotXyzComponent(double component) {
            return component > 0.008856 ? Math.pow(component, 0.3333333333333333) : (903.3 * component + 16.0) / 116.0;
        }

        public static double[] getTempDouble3Array() {
            double[] result = TEMP_ARRAY.get();
            if (result == null) {
                result = new double[3];
                TEMP_ARRAY.set(result);
            }
            return result;
        }

        public static int HSLToColor(float[] hsl) {
            float h = hsl[0];
            float s = hsl[1];
            float l = hsl[2];
            float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
            float m = l - 0.5f * c;
            float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
            int hueSegment = (int)h / 60;
            int r = 0;
            int g = 0;
            int b = 0;
            switch (hueSegment) {
                case 0: {
                    r = Math.round(255.0f * (c + m));
                    g = Math.round(255.0f * (x + m));
                    b = Math.round(255.0f * m);
                    break;
                }
                case 1: {
                    r = Math.round(255.0f * (x + m));
                    g = Math.round(255.0f * (c + m));
                    b = Math.round(255.0f * m);
                    break;
                }
                case 2: {
                    r = Math.round(255.0f * m);
                    g = Math.round(255.0f * (c + m));
                    b = Math.round(255.0f * (x + m));
                    break;
                }
                case 3: {
                    r = Math.round(255.0f * m);
                    g = Math.round(255.0f * (x + m));
                    b = Math.round(255.0f * (c + m));
                    break;
                }
                case 4: {
                    r = Math.round(255.0f * (x + m));
                    g = Math.round(255.0f * m);
                    b = Math.round(255.0f * (c + m));
                    break;
                }
                case 5: 
                case 6: {
                    r = Math.round(255.0f * (c + m));
                    g = Math.round(255.0f * m);
                    b = Math.round(255.0f * (x + m));
                }
            }
            r = ColorUtilsFromCompat.constrain(r, 0, 255);
            g = ColorUtilsFromCompat.constrain(g, 0, 255);
            b = ColorUtilsFromCompat.constrain(b, 0, 255);
            return Color.rgb(r, g, b);
        }

        public static void colorToHSL(int color2, float[] outHsl) {
            ColorUtilsFromCompat.RGBToHSL(Color.red(color2), Color.green(color2), Color.blue(color2), outHsl);
        }

        public static void RGBToHSL(int r, int g, int b, float[] outHsl) {
            float h;
            float s;
            float rf = (float)r / 255.0f;
            float gf = (float)g / 255.0f;
            float bf = (float)b / 255.0f;
            float max = Math.max(rf, Math.max(gf, bf));
            float min = Math.min(rf, Math.min(gf, bf));
            float deltaMaxMin = max - min;
            float l = (max + min) / 2.0f;
            if (max == min) {
                s = 0.0f;
                h = 0.0f;
            } else {
                h = max == rf ? (gf - bf) / deltaMaxMin % 6.0f : (max == gf ? (bf - rf) / deltaMaxMin + 2.0f : (rf - gf) / deltaMaxMin + 4.0f);
                s = deltaMaxMin / (1.0f - Math.abs(2.0f * l - 1.0f));
            }
            h = h * 60.0f % 360.0f;
            if (h < 0.0f) {
                h += 360.0f;
            }
            outHsl[0] = ColorUtilsFromCompat.constrain(h, 0.0f, 360.0f);
            outHsl[1] = ColorUtilsFromCompat.constrain(s, 0.0f, 1.0f);
            outHsl[2] = ColorUtilsFromCompat.constrain(l, 0.0f, 1.0f);
        }
    }
}

