/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.Notification;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Icon;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Pools;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RemoteViews;
import com.android.internal.widget.ImageFloatingTextView;
import com.android.internal.widget.MessagingImageMessage;
import com.android.internal.widget.MessagingLayout;
import com.android.internal.widget.MessagingLinearLayout;
import com.android.internal.widget.MessagingMessage;
import com.android.internal.widget.MessagingPropertyAnimator;
import java.util.ArrayList;
import java.util.List;

@RemoteViews.RemoteView
public class MessagingGroup
extends LinearLayout
implements MessagingLinearLayout.MessagingChild {
    private static Pools.SimplePool<MessagingGroup> sInstancePool = new Pools.SynchronizedPool<MessagingGroup>(10);
    private MessagingLinearLayout mMessageContainer;
    private ImageFloatingTextView mSenderName;
    private ImageView mAvatarView;
    private String mAvatarSymbol = "";
    private int mLayoutColor;
    private CharSequence mAvatarName = "";
    private Icon mAvatarIcon;
    private int mTextColor;
    private List<MessagingMessage> mMessages;
    private ArrayList<MessagingMessage> mAddedMessages = new ArrayList();
    private boolean mFirstLayout;
    private boolean mIsHidingAnimated;
    private boolean mNeedsGeneratedAvatar;
    private Notification.Person mSender;
    private boolean mAvatarsAtEnd;
    private ViewGroup mImageContainer;
    private MessagingImageMessage mIsolatedMessage;
    private boolean mTransformingImages;
    private Point mDisplaySize = new Point();

    public MessagingGroup(Context context) {
        super(context);
    }

    public MessagingGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public MessagingGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public MessagingGroup(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mMessageContainer = (MessagingLinearLayout)this.findViewById(16908926);
        this.mSenderName = (ImageFloatingTextView)this.findViewById(16909058);
        this.mSenderName.addOnLayoutChangeListener(MessagingLayout.MESSAGING_PROPERTY_ANIMATOR);
        this.mAvatarView = (ImageView)this.findViewById(16909057);
        this.mImageContainer = (ViewGroup)this.findViewById(16909060);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.mDisplaySize.x = displayMetrics.widthPixels;
        this.mDisplaySize.y = displayMetrics.heightPixels;
    }

    public void updateClipRect() {
        Rect clipRect;
        if (this.mSenderName.getVisibility() != 8 && !this.mTransformingImages) {
            ViewGroup parent = (ViewGroup)this.mSenderName.getParent();
            int top = this.getDistanceFromParent(this.mSenderName, parent) - this.getDistanceFromParent(this.mMessageContainer, parent) + this.mSenderName.getHeight();
            clipRect = new Rect(0, top, this.mDisplaySize.x, this.mDisplaySize.y);
        } else {
            clipRect = null;
        }
        this.mMessageContainer.setClipBounds(clipRect);
    }

    private int getDistanceFromParent(View searchedView, ViewGroup parent) {
        int position = 0;
        for (View view = searchedView; view != parent; view = (View)((Object)view.getParent())) {
            position = (int)((float)position + ((float)view.getTop() + view.getTranslationY()));
        }
        return position;
    }

    public void setSender(Notification.Person sender, CharSequence nameOverride) {
        this.mSender = sender;
        if (nameOverride == null) {
            nameOverride = sender.getName();
        }
        this.mSenderName.setText(nameOverride);
        boolean bl = this.mNeedsGeneratedAvatar = sender.getIcon() == null;
        if (!this.mNeedsGeneratedAvatar) {
            this.setAvatar(sender.getIcon());
        }
        this.mAvatarView.setVisibility(0);
        this.mSenderName.setVisibility(0);
        this.mTextColor = this.getNormalTextColor();
    }

    private int getNormalTextColor() {
        return this.mContext.getColor(17170668);
    }

    public void setAvatar(Icon icon) {
        this.mAvatarIcon = icon;
        this.mAvatarView.setImageIcon(icon);
        this.mAvatarSymbol = "";
        this.mLayoutColor = 0;
        this.mAvatarName = "";
    }

    static MessagingGroup createGroup(MessagingLinearLayout layout2) {
        MessagingGroup createdGroup = sInstancePool.acquire();
        if (createdGroup == null) {
            createdGroup = (MessagingGroup)LayoutInflater.from(layout2.getContext()).inflate(17367192, (ViewGroup)layout2, false);
            createdGroup.addOnLayoutChangeListener(MessagingLayout.MESSAGING_PROPERTY_ANIMATOR);
        }
        layout2.addView(createdGroup);
        return createdGroup;
    }

    public void removeMessage(MessagingMessage messagingMessage) {
        ViewGroup messageParent = (ViewGroup)messagingMessage.getView().getParent();
        messageParent.removeView(messagingMessage.getView());
        Runnable recycleRunnable = () -> {
            messageParent.removeTransientView(messagingMessage.getView());
            messagingMessage.recycle();
            if (this.mMessageContainer.getChildCount() == 0 && this.mMessageContainer.getTransientViewCount() == 0 && this.mImageContainer.getChildCount() == 0) {
                ViewParent parent = this.getParent();
                if (parent instanceof ViewGroup) {
                    ((ViewGroup)parent).removeView(this);
                }
                this.setAvatar(null);
                this.mAvatarView.setAlpha(1.0f);
                this.mAvatarView.setTranslationY(0.0f);
                this.mSenderName.setAlpha(1.0f);
                this.mSenderName.setTranslationY(0.0f);
                sInstancePool.release(this);
            }
        };
        if (this.isShown()) {
            messageParent.addTransientView(messagingMessage.getView(), 0);
            this.performRemoveAnimation(messagingMessage.getView(), recycleRunnable);
            if (this.mMessageContainer.getChildCount() == 0 && this.mImageContainer.getChildCount() == 0) {
                this.removeGroupAnimated(null);
            }
        } else {
            recycleRunnable.run();
        }
    }

    private void removeGroupAnimated(Runnable endAction) {
        this.performRemoveAnimation(this.mAvatarView, null);
        this.performRemoveAnimation(this.mSenderName, null);
        boolean endActionTriggered = false;
        for (int i = this.mMessageContainer.getChildCount() - 1; i >= 0; --i) {
            ViewGroup.LayoutParams lp;
            View child = this.mMessageContainer.getChildAt(i);
            if (child.getVisibility() == 8 || (lp = child.getLayoutParams()) instanceof MessagingLinearLayout.LayoutParams && ((MessagingLinearLayout.LayoutParams)lp).hide && !((MessagingLinearLayout.LayoutParams)lp).visibleBefore) continue;
            Runnable childEndAction = endActionTriggered ? null : endAction;
            this.performRemoveAnimation(child, childEndAction);
            endActionTriggered = true;
        }
        if (this.mIsolatedMessage != null) {
            this.performRemoveAnimation(this.mIsolatedMessage, !endActionTriggered ? endAction : null);
            endActionTriggered = true;
        }
        if (!endActionTriggered && endAction != null) {
            endAction.run();
        }
    }

    public void performRemoveAnimation(View message, Runnable endAction) {
        MessagingPropertyAnimator.fadeOut(message, endAction);
        MessagingPropertyAnimator.startLocalTranslationTo(message, (int)((float)(-this.getHeight()) * 0.5f), MessagingLayout.FAST_OUT_LINEAR_IN);
    }

    public CharSequence getSenderName() {
        return this.mSenderName.getText();
    }

    public static void dropCache() {
        sInstancePool = new Pools.SynchronizedPool<MessagingGroup>(10);
    }

    @Override
    public int getMeasuredType() {
        boolean hasNormal = false;
        for (int i = this.mMessageContainer.getChildCount() - 1; i >= 0; --i) {
            View child = this.mMessageContainer.getChildAt(i);
            if (!(child instanceof MessagingLinearLayout.MessagingChild)) continue;
            int type = ((MessagingLinearLayout.MessagingChild)((Object)child)).getMeasuredType();
            if (type == 2) {
                if (hasNormal) {
                    return 1;
                }
                return 2;
            }
            if (type == 1) {
                return 1;
            }
            hasNormal = true;
        }
        if (this.mMessageContainer.getChildCount() == 0 && this.mIsolatedMessage != null) {
            return this.mIsolatedMessage.getMeasuredType();
        }
        return 0;
    }

    @Override
    public int getConsumedLines() {
        int result = 0;
        for (int i = 0; i < this.mMessageContainer.getChildCount(); ++i) {
            View child = this.mMessageContainer.getChildAt(i);
            if (!(child instanceof MessagingLinearLayout.MessagingChild)) continue;
            result += ((MessagingLinearLayout.MessagingChild)((Object)child)).getConsumedLines();
        }
        result = this.mIsolatedMessage != null ? Math.max(result, 1) : result;
        return result + 1;
    }

    @Override
    public void setMaxDisplayedLines(int lines) {
        this.mMessageContainer.setMaxDisplayedLines(lines);
    }

    @Override
    public void hideAnimated() {
        this.setIsHidingAnimated(true);
        this.removeGroupAnimated(() -> this.setIsHidingAnimated(false));
    }

    @Override
    public boolean isHidingAnimated() {
        return this.mIsHidingAnimated;
    }

    private void setIsHidingAnimated(boolean isHiding) {
        ViewParent parent = this.getParent();
        this.mIsHidingAnimated = isHiding;
        this.invalidate();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).invalidate();
        }
    }

    public Icon getAvatarSymbolIfMatching(CharSequence avatarName, String avatarSymbol, int layoutColor) {
        if (this.mAvatarName.equals(avatarName) && this.mAvatarSymbol.equals(avatarSymbol) && layoutColor == this.mLayoutColor) {
            return this.mAvatarIcon;
        }
        return null;
    }

    public void setCreatedAvatar(Icon cachedIcon, CharSequence avatarName, String avatarSymbol, int layoutColor) {
        if (!this.mAvatarName.equals(avatarName) || !this.mAvatarSymbol.equals(avatarSymbol) || layoutColor != this.mLayoutColor) {
            this.setAvatar(cachedIcon);
            this.mAvatarSymbol = avatarSymbol;
            this.mLayoutColor = layoutColor;
            this.mAvatarName = avatarName;
        }
    }

    public void setLayoutColor(int layoutColor) {
        this.mLayoutColor = layoutColor;
    }

    public void setMessages(List<MessagingMessage> group) {
        int textMessageIndex = 0;
        MessagingImageMessage isolatedMessage = null;
        for (int messageIndex = 0; messageIndex < group.size(); ++messageIndex) {
            MessagingMessage message = group.get(messageIndex);
            message.setColor(this.mTextColor);
            if (message.getGroup() != this) {
                message.setMessagingGroup(this);
                this.mAddedMessages.add(message);
            }
            boolean isImage = message instanceof MessagingImageMessage;
            if (this.mAvatarsAtEnd && isImage) {
                isolatedMessage = (MessagingImageMessage)message;
                continue;
            }
            if (this.removeFromParentIfDifferent(message, this.mMessageContainer)) {
                ViewGroup.LayoutParams layoutParams = message.getView().getLayoutParams();
                if (layoutParams != null && !(layoutParams instanceof MessagingLinearLayout.LayoutParams)) {
                    message.getView().setLayoutParams(this.mMessageContainer.generateDefaultLayoutParams());
                }
                this.mMessageContainer.addView(message.getView(), textMessageIndex);
            }
            if (isImage) {
                ((MessagingImageMessage)message).setIsolated(false);
            }
            if (textMessageIndex != this.mMessageContainer.indexOfChild(message.getView())) {
                this.mMessageContainer.removeView(message.getView());
                this.mMessageContainer.addView(message.getView(), textMessageIndex);
            }
            ++textMessageIndex;
        }
        if (isolatedMessage != null) {
            if (this.removeFromParentIfDifferent(isolatedMessage, this.mImageContainer)) {
                this.mImageContainer.removeAllViews();
                this.mImageContainer.addView(isolatedMessage.getView());
            }
            isolatedMessage.setIsolated(true);
        } else if (this.mIsolatedMessage != null) {
            this.mImageContainer.removeAllViews();
        }
        this.mIsolatedMessage = isolatedMessage;
        this.mMessages = group;
    }

    private boolean removeFromParentIfDifferent(MessagingMessage message, ViewGroup newParent) {
        ViewParent parent = message.getView().getParent();
        if (parent != newParent) {
            if (parent instanceof ViewGroup) {
                ((ViewGroup)parent).removeView(message.getView());
            }
            return true;
        }
        return false;
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.mAddedMessages.isEmpty()) {
            this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                @Override
                public boolean onPreDraw() {
                    for (MessagingMessage message : MessagingGroup.this.mAddedMessages) {
                        if (!message.getView().isShown()) continue;
                        MessagingPropertyAnimator.fadeIn(message.getView());
                        if (MessagingGroup.this.mFirstLayout) continue;
                        MessagingPropertyAnimator.startLocalTranslationFrom(message.getView(), message.getView().getHeight(), MessagingLayout.LINEAR_OUT_SLOW_IN);
                    }
                    MessagingGroup.this.mAddedMessages.clear();
                    MessagingGroup.this.getViewTreeObserver().removeOnPreDrawListener(this);
                    return true;
                }
            });
        }
        this.mFirstLayout = false;
        this.updateClipRect();
    }

    public int calculateGroupCompatibility(MessagingGroup otherGroup) {
        if (TextUtils.equals(this.getSenderName(), otherGroup.getSenderName())) {
            int result = 1;
            for (int i = 0; i < this.mMessages.size() && i < otherGroup.mMessages.size(); ++i) {
                MessagingMessage otherMessage;
                MessagingMessage ownMessage = this.mMessages.get(this.mMessages.size() - 1 - i);
                if (!ownMessage.sameAs(otherMessage = otherGroup.mMessages.get(otherGroup.mMessages.size() - 1 - i))) {
                    return result;
                }
                ++result;
            }
            return result;
        }
        return 0;
    }

    public View getSenderView() {
        return this.mSenderName;
    }

    public View getAvatar() {
        return this.mAvatarView;
    }

    public MessagingLinearLayout getMessageContainer() {
        return this.mMessageContainer;
    }

    public MessagingImageMessage getIsolatedMessage() {
        return this.mIsolatedMessage;
    }

    public boolean needsGeneratedAvatar() {
        return this.mNeedsGeneratedAvatar;
    }

    public Notification.Person getSender() {
        return this.mSender;
    }

    public void setTransformingImages(boolean transformingImages) {
        this.mTransformingImages = transformingImages;
    }

    public void setDisplayAvatarsAtEnd(boolean atEnd) {
        if (this.mAvatarsAtEnd != atEnd) {
            this.mAvatarsAtEnd = atEnd;
            this.mImageContainer.setVisibility(atEnd ? 0 : 8);
        }
    }

    public List<MessagingMessage> getMessages() {
        return this.mMessages;
    }
}

