/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.Notification;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pools;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RemoteViews;
import com.android.internal.widget.LocalImageResolver;
import com.android.internal.widget.MessagingLayout;
import com.android.internal.widget.MessagingLinearLayout;
import com.android.internal.widget.MessagingMessage;
import com.android.internal.widget.MessagingMessageState;
import com.android.internal.widget.MessagingTextMessage;
import java.io.IOException;

@RemoteViews.RemoteView
public class MessagingImageMessage
extends ImageView
implements MessagingMessage {
    private static final String TAG = "MessagingImageMessage";
    private static Pools.SimplePool<MessagingImageMessage> sInstancePool = new Pools.SynchronizedPool<MessagingImageMessage>(10);
    private final MessagingMessageState mState = new MessagingMessageState(this);
    private final int mMinImageHeight;
    private final Path mPath = new Path();
    private final int mImageRounding;
    private final int mMaxImageHeight;
    private final int mIsolatedSize;
    private final int mExtraSpacing;
    private Drawable mDrawable;
    private float mAspectRatio;
    private int mActualWidth;
    private int mActualHeight;
    private boolean mIsIsolated;

    public MessagingImageMessage(Context context) {
        this(context, null);
    }

    public MessagingImageMessage(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MessagingImageMessage(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public MessagingImageMessage(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mMinImageHeight = context.getResources().getDimensionPixelSize(17105165);
        this.mMaxImageHeight = context.getResources().getDimensionPixelSize(17105164);
        this.mImageRounding = context.getResources().getDimensionPixelSize(17105166);
        this.mExtraSpacing = context.getResources().getDimensionPixelSize(17105163);
        this.setMaxHeight(this.mMaxImageHeight);
        this.mIsolatedSize = this.getResources().getDimensionPixelSize(17105162);
    }

    @Override
    public MessagingMessageState getState() {
        return this.mState;
    }

    @Override
    public boolean setMessage(Notification.MessagingStyle.Message message) {
        Drawable drawable2;
        MessagingMessage.super.setMessage(message);
        try {
            drawable2 = LocalImageResolver.resolveImage(message.getDataUri(), this.getContext());
        }
        catch (IOException | SecurityException e) {
            e.printStackTrace();
            return false;
        }
        int intrinsicHeight = drawable2.getIntrinsicHeight();
        if (intrinsicHeight == 0) {
            Log.w(TAG, "Drawable with 0 intrinsic height was returned");
            return false;
        }
        this.mDrawable = drawable2;
        this.mAspectRatio = (float)this.mDrawable.getIntrinsicWidth() / (float)intrinsicHeight;
        this.setImageDrawable(drawable2);
        this.setContentDescription(message.getText());
        return true;
    }

    static MessagingMessage createMessage(MessagingLayout layout2, Notification.MessagingStyle.Message m) {
        boolean created;
        MessagingLinearLayout messagingLinearLayout = layout2.getMessagingLinearLayout();
        MessagingImageMessage createdMessage = sInstancePool.acquire();
        if (createdMessage == null) {
            createdMessage = (MessagingImageMessage)LayoutInflater.from(layout2.getContext()).inflate(0x1090099, (ViewGroup)messagingLinearLayout, false);
            createdMessage.addOnLayoutChangeListener(MessagingLayout.MESSAGING_PROPERTY_ANIMATOR);
        }
        if (!(created = createdMessage.setMessage(m))) {
            createdMessage.recycle();
            return MessagingTextMessage.createMessage(layout2, m);
        }
        return createdMessage;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        canvas.save();
        canvas.clipPath(this.getRoundedRectPath());
        int width = (int)Math.max((float)this.getActualWidth(), (float)this.getActualHeight() * this.mAspectRatio);
        int height = (int)((float)width / this.mAspectRatio);
        int left = (int)((float)(this.getActualWidth() - width) / 2.0f);
        this.mDrawable.setBounds(left, 0, left + width, height);
        this.mDrawable.draw(canvas);
        canvas.restore();
    }

    public Path getRoundedRectPath() {
        int left = 0;
        int right = this.getActualWidth();
        int top = 0;
        int bottom = this.getActualHeight();
        this.mPath.reset();
        int width = right - left;
        float roundnessX = this.mImageRounding;
        float roundnessY = this.mImageRounding;
        roundnessX = Math.min((float)(width / 2), roundnessX);
        roundnessY = Math.min((float)((bottom - top) / 2), roundnessY);
        this.mPath.moveTo(left, (float)top + roundnessY);
        this.mPath.quadTo(left, top, (float)left + roundnessX, top);
        this.mPath.lineTo((float)right - roundnessX, top);
        this.mPath.quadTo(right, top, right, (float)top + roundnessY);
        this.mPath.lineTo(right, (float)bottom - roundnessY);
        this.mPath.quadTo(right, bottom, (float)right - roundnessX, bottom);
        this.mPath.lineTo((float)left + roundnessX, bottom);
        this.mPath.quadTo(left, bottom, left, (float)bottom - roundnessY);
        this.mPath.close();
        return this.mPath;
    }

    @Override
    public void recycle() {
        MessagingMessage.super.recycle();
        this.setAlpha(1.0f);
        this.setTranslationY(0.0f);
        this.setImageBitmap(null);
        this.mDrawable = null;
        sInstancePool.release(this);
    }

    public static void dropCache() {
        sInstancePool = new Pools.SynchronizedPool<MessagingImageMessage>(10);
    }

    @Override
    public int getMeasuredType() {
        boolean measuredTooSmall;
        int measuredHeight = this.getMeasuredHeight();
        int minImageHeight = this.mIsIsolated ? this.mIsolatedSize : this.mMinImageHeight;
        boolean bl = measuredTooSmall = measuredHeight < minImageHeight && measuredHeight != this.mDrawable.getIntrinsicHeight();
        if (measuredTooSmall) {
            return 2;
        }
        if (!this.mIsIsolated && measuredHeight != this.mDrawable.getIntrinsicHeight()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setMaxDisplayedLines(int lines) {
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mIsIsolated) {
            this.setMeasuredDimension(View.MeasureSpec.getSize(widthMeasureSpec), View.MeasureSpec.getSize(heightMeasureSpec));
        }
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.setActualWidth(this.getStaticWidth());
        this.setActualHeight(this.getHeight());
    }

    @Override
    public int getConsumedLines() {
        return 3;
    }

    public void setActualWidth(int actualWidth) {
        this.mActualWidth = actualWidth;
        this.invalidate();
    }

    public int getActualWidth() {
        return this.mActualWidth;
    }

    public void setActualHeight(int actualHeight) {
        this.mActualHeight = actualHeight;
        this.invalidate();
    }

    public int getActualHeight() {
        return this.mActualHeight;
    }

    public int getStaticWidth() {
        if (this.mIsIsolated) {
            return this.getWidth();
        }
        return (int)((float)this.getHeight() * this.mAspectRatio);
    }

    public void setIsolated(boolean isolated) {
        if (this.mIsIsolated != isolated) {
            this.mIsIsolated = isolated;
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
            layoutParams.topMargin = isolated ? 0 : this.mExtraSpacing;
            this.setLayoutParams(layoutParams);
        }
    }

    @Override
    public int getExtraSpacing() {
        return this.mExtraSpacing;
    }
}

