/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;
import android.view.animation.PathInterpolator;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.graphics.ColorUtils;
import com.android.internal.util.NotificationColorUtil;
import com.android.internal.widget.MessagingGroup;
import com.android.internal.widget.MessagingLinearLayout;
import com.android.internal.widget.MessagingMessage;
import com.android.internal.widget.MessagingPropertyAnimator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@RemoteViews.RemoteView
public class MessagingLayout
extends FrameLayout {
    private static final float COLOR_SHIFT_AMOUNT = 60.0f;
    private static final Consumer<MessagingMessage> REMOVE_MESSAGE = MessagingMessage::removeMessage;
    public static final Interpolator LINEAR_OUT_SLOW_IN = new PathInterpolator(0.0f, 0.0f, 0.2f, 1.0f);
    public static final Interpolator FAST_OUT_LINEAR_IN = new PathInterpolator(0.4f, 0.0f, 1.0f, 1.0f);
    public static final Interpolator FAST_OUT_SLOW_IN = new PathInterpolator(0.4f, 0.0f, 0.2f, 1.0f);
    public static final View.OnLayoutChangeListener MESSAGING_PROPERTY_ANIMATOR = new MessagingPropertyAnimator();
    private List<MessagingMessage> mMessages = new ArrayList<MessagingMessage>();
    private List<MessagingMessage> mHistoricMessages = new ArrayList<MessagingMessage>();
    private MessagingLinearLayout mMessagingLinearLayout;
    private boolean mShowHistoricMessages;
    private ArrayList<MessagingGroup> mGroups = new ArrayList();
    private TextView mTitleView;
    private int mLayoutColor;
    private int mAvatarSize;
    private Paint mPaint = new Paint(1);
    private Paint mTextPaint = new Paint();
    private CharSequence mConversationTitle;
    private Icon mLargeIcon;
    private boolean mIsOneToOne;
    private ArrayList<MessagingGroup> mAddedGroups = new ArrayList();
    private Notification.Person mUser;
    private CharSequence mNameReplacement;
    private boolean mIsCollapsed;

    public MessagingLayout(Context context) {
        super(context);
    }

    public MessagingLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public MessagingLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public MessagingLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mMessagingLinearLayout = (MessagingLinearLayout)this.findViewById(16909117);
        this.mMessagingLinearLayout.setMessagingLayout(this);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        Rect rect = new Rect(0, 0, displayMetrics.widthPixels, displayMetrics.heightPixels);
        this.mMessagingLinearLayout.setClipBounds(rect);
        this.mTitleView = (TextView)this.findViewById(16908310);
        this.mAvatarSize = this.getResources().getDimensionPixelSize(17105162);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mTextPaint.setAntiAlias(true);
    }

    @RemotableViewMethod
    public void setLargeIcon(Icon icon) {
        this.mLargeIcon = icon;
    }

    @RemotableViewMethod
    public void setNameReplacement(CharSequence nameReplacement) {
        this.mNameReplacement = nameReplacement;
    }

    @RemotableViewMethod
    public void setIsCollapsed(boolean isCollapsed) {
        this.mIsCollapsed = isCollapsed;
    }

    @RemotableViewMethod
    public void setData(Bundle extras) {
        Parcelable[] messages = extras.getParcelableArray("android.messages");
        List<Notification.MessagingStyle.Message> newMessages = Notification.MessagingStyle.Message.getMessagesFromBundleArray(messages);
        Parcelable[] histMessages = extras.getParcelableArray("android.messages.historic");
        List<Notification.MessagingStyle.Message> newHistoricMessages = Notification.MessagingStyle.Message.getMessagesFromBundleArray(histMessages);
        this.setUser((Notification.Person)extras.getParcelable("android.messagingUser"));
        this.mConversationTitle = null;
        TextView headerText = (TextView)this.findViewById(16908933);
        if (headerText != null) {
            this.mConversationTitle = headerText.getText();
        }
        this.addRemoteInputHistoryToMessages(newMessages, extras.getCharSequenceArray("android.remoteInputHistory"));
        this.bind(newMessages, newHistoricMessages);
    }

    private void addRemoteInputHistoryToMessages(List<Notification.MessagingStyle.Message> newMessages, CharSequence[] remoteInputHistory) {
        if (remoteInputHistory == null || remoteInputHistory.length == 0) {
            return;
        }
        for (int i = remoteInputHistory.length - 1; i >= 0; --i) {
            CharSequence message = remoteInputHistory[i];
            newMessages.add(new Notification.MessagingStyle.Message(message, 0L, (Notification.Person)null));
        }
    }

    private void bind(List<Notification.MessagingStyle.Message> newMessages, List<Notification.MessagingStyle.Message> newHistoricMessages) {
        List<MessagingMessage> historicMessages = this.createMessages(newHistoricMessages, true);
        List<MessagingMessage> messages = this.createMessages(newMessages, false);
        this.addMessagesToGroups(historicMessages, messages);
        this.mMessages.forEach(REMOVE_MESSAGE);
        this.mHistoricMessages.forEach(REMOVE_MESSAGE);
        this.mMessages = messages;
        this.mHistoricMessages = historicMessages;
        this.updateHistoricMessageVisibility();
        this.updateTitleAndNamesDisplay();
    }

    private void updateTitleAndNamesDisplay() {
        MessagingGroup group;
        int i;
        ArrayMap<CharSequence, String> uniqueNames = new ArrayMap<CharSequence, String>();
        ArrayMap<Character, CharSequence> uniqueCharacters = new ArrayMap<Character, CharSequence>();
        for (int i2 = 0; i2 < this.mGroups.size(); ++i2) {
            MessagingGroup group2 = this.mGroups.get(i2);
            CharSequence senderName = group2.getSenderName();
            if (!group2.needsGeneratedAvatar() || TextUtils.isEmpty(senderName) || uniqueNames.containsKey(senderName)) continue;
            char c = senderName.charAt(0);
            if (uniqueCharacters.containsKey(Character.valueOf(c))) {
                CharSequence existingName = (CharSequence)uniqueCharacters.get(Character.valueOf(c));
                if (existingName != null) {
                    uniqueNames.put(existingName, this.findNameSplit((String)existingName));
                    uniqueCharacters.put(Character.valueOf(c), null);
                }
                uniqueNames.put(senderName, this.findNameSplit((String)senderName));
                continue;
            }
            uniqueNames.put(senderName, Character.toString(c));
            uniqueCharacters.put(Character.valueOf(c), senderName);
        }
        ArrayMap<CharSequence, Icon> cachedAvatars = new ArrayMap<CharSequence, Icon>();
        for (i = 0; i < this.mGroups.size(); ++i) {
            String symbol;
            Icon cachedIcon;
            group = this.mGroups.get(i);
            boolean isOwnMessage = group.getSender() == this.mUser;
            CharSequence senderName = group.getSenderName();
            if (!group.needsGeneratedAvatar() || TextUtils.isEmpty(senderName) || this.mIsOneToOne && this.mLargeIcon != null && !isOwnMessage || (cachedIcon = group.getAvatarSymbolIfMatching(senderName, symbol = (String)uniqueNames.get(senderName), this.mLayoutColor)) == null) continue;
            cachedAvatars.put(senderName, cachedIcon);
        }
        for (i = 0; i < this.mGroups.size(); ++i) {
            group = this.mGroups.get(i);
            CharSequence senderName = group.getSenderName();
            if (!group.needsGeneratedAvatar() || TextUtils.isEmpty(senderName)) continue;
            if (this.mIsOneToOne && this.mLargeIcon != null && group.getSender() != this.mUser) {
                group.setAvatar(this.mLargeIcon);
                continue;
            }
            Icon cachedIcon = (Icon)cachedAvatars.get(senderName);
            if (cachedIcon == null) {
                cachedIcon = this.createAvatarSymbol(senderName, (String)uniqueNames.get(senderName), this.mLayoutColor);
                cachedAvatars.put(senderName, cachedIcon);
            }
            group.setCreatedAvatar(cachedIcon, senderName, (String)uniqueNames.get(senderName), this.mLayoutColor);
        }
    }

    public Icon createAvatarSymbol(CharSequence senderName, String symbol, int layoutColor) {
        Bitmap bitmap = Bitmap.createBitmap(this.mAvatarSize, this.mAvatarSize, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        float radius = (float)this.mAvatarSize / 2.0f;
        int color2 = this.findColor(senderName, layoutColor);
        this.mPaint.setColor(color2);
        canvas.drawCircle(radius, radius, radius, this.mPaint);
        boolean needDarkText = ColorUtils.calculateLuminance(color2) > 0.5;
        this.mTextPaint.setColor(needDarkText ? -16777216 : -1);
        this.mTextPaint.setTextSize(symbol.length() == 1 ? (float)this.mAvatarSize * 0.5f : (float)this.mAvatarSize * 0.3f);
        int yPos = (int)(radius - (this.mTextPaint.descent() + this.mTextPaint.ascent()) / 2.0f);
        canvas.drawText(symbol, radius, yPos, this.mTextPaint);
        return Icon.createWithBitmap(bitmap);
    }

    private int findColor(CharSequence senderName, int layoutColor) {
        double luminance = NotificationColorUtil.calculateLuminance(layoutColor);
        float shift = (float)(Math.abs(senderName.hashCode()) % 5) / 4.0f - 0.5f;
        shift = (float)((double)shift + Math.max((double)0.3f - luminance, 0.0));
        shift = (float)((double)shift - Math.max((double)0.3f - (1.0 - luminance), 0.0));
        return NotificationColorUtil.getShiftedColor(layoutColor, (int)(shift * 60.0f));
    }

    private String findNameSplit(String existingName) {
        String[] split = existingName.split(" ");
        if (split.length > 1) {
            return Character.toString(split[0].charAt(0)) + Character.toString(split[1].charAt(0));
        }
        return existingName.substring(0, 1);
    }

    @RemotableViewMethod
    public void setLayoutColor(int color2) {
        this.mLayoutColor = color2;
    }

    @RemotableViewMethod
    public void setIsOneToOne(boolean oneToOne) {
        this.mIsOneToOne = oneToOne;
    }

    public void setUser(Notification.Person user) {
        this.mUser = user;
        if (this.mUser.getIcon() == null) {
            Icon userIcon = Icon.createWithResource(this.getContext(), 17302945);
            userIcon.setTint(this.mLayoutColor);
            this.mUser.setIcon(userIcon);
        }
    }

    private void addMessagesToGroups(List<MessagingMessage> historicMessages, List<MessagingMessage> messages) {
        ArrayList<List<MessagingMessage>> groups = new ArrayList<List<MessagingMessage>>();
        ArrayList<Notification.Person> senders = new ArrayList<Notification.Person>();
        this.findGroups(historicMessages, messages, groups, senders);
        this.createGroupViews(groups, senders);
    }

    private void createGroupViews(List<List<MessagingMessage>> groups, List<Notification.Person> senders) {
        this.mGroups.clear();
        for (int groupIndex = 0; groupIndex < groups.size(); ++groupIndex) {
            MessagingMessage message;
            List<MessagingMessage> group = groups.get(groupIndex);
            MessagingGroup newGroup = null;
            for (int messageIndex = group.size() - 1; messageIndex >= 0 && (newGroup = (message = group.get(messageIndex)).getGroup()) == null; --messageIndex) {
            }
            if (newGroup == null) {
                newGroup = MessagingGroup.createGroup(this.mMessagingLinearLayout);
                this.mAddedGroups.add(newGroup);
            }
            newGroup.setDisplayAvatarsAtEnd(this.mIsCollapsed);
            newGroup.setLayoutColor(this.mLayoutColor);
            Notification.Person sender = senders.get(groupIndex);
            CharSequence nameOverride = null;
            if (sender != this.mUser && this.mNameReplacement != null) {
                nameOverride = this.mNameReplacement;
            }
            newGroup.setSender(sender, nameOverride);
            this.mGroups.add(newGroup);
            if (this.mMessagingLinearLayout.indexOfChild(newGroup) != groupIndex) {
                this.mMessagingLinearLayout.removeView(newGroup);
                this.mMessagingLinearLayout.addView((View)newGroup, groupIndex);
            }
            newGroup.setMessages(group);
        }
    }

    private void findGroups(List<MessagingMessage> historicMessages, List<MessagingMessage> messages, List<List<MessagingMessage>> groups, List<Notification.Person> senders) {
        CharSequence currentSenderKey = null;
        ArrayList<MessagingMessage> currentGroup = null;
        int histSize = historicMessages.size();
        for (int i = 0; i < histSize + messages.size(); ++i) {
            CharSequence key;
            MessagingMessage message = i < histSize ? historicMessages.get(i) : messages.get(i - histSize);
            boolean isNewGroup = currentGroup == null;
            Notification.Person sender = message.getMessage().getSenderPerson();
            CharSequence charSequence = key = sender == null ? null : (sender.getKey() == null ? sender.getName() : sender.getKey());
            if (isNewGroup |= !TextUtils.equals(key, currentSenderKey)) {
                currentGroup = new ArrayList<MessagingMessage>();
                groups.add(currentGroup);
                if (sender == null) {
                    sender = this.mUser;
                }
                senders.add(sender);
                currentSenderKey = key;
            }
            currentGroup.add(message);
        }
    }

    private List<MessagingMessage> createMessages(List<Notification.MessagingStyle.Message> newMessages, boolean historic) {
        ArrayList<MessagingMessage> result = new ArrayList<MessagingMessage>();
        for (int i = 0; i < newMessages.size(); ++i) {
            Notification.MessagingStyle.Message m = newMessages.get(i);
            MessagingMessage message = this.findAndRemoveMatchingMessage(m);
            if (message == null) {
                message = MessagingMessage.createMessage(this, m);
            }
            message.setIsHistoric(historic);
            result.add(message);
        }
        return result;
    }

    private MessagingMessage findAndRemoveMatchingMessage(Notification.MessagingStyle.Message m) {
        MessagingMessage existing;
        int i;
        for (i = 0; i < this.mMessages.size(); ++i) {
            existing = this.mMessages.get(i);
            if (!existing.sameAs(m)) continue;
            this.mMessages.remove(i);
            return existing;
        }
        for (i = 0; i < this.mHistoricMessages.size(); ++i) {
            existing = this.mHistoricMessages.get(i);
            if (!existing.sameAs(m)) continue;
            this.mHistoricMessages.remove(i);
            return existing;
        }
        return null;
    }

    public void showHistoricMessages(boolean show) {
        this.mShowHistoricMessages = show;
        this.updateHistoricMessageVisibility();
    }

    private void updateHistoricMessageVisibility() {
        for (int i = 0; i < this.mHistoricMessages.size(); ++i) {
            MessagingMessage existing = this.mHistoricMessages.get(i);
            existing.setVisibility(this.mShowHistoricMessages ? 0 : 8);
        }
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.mAddedGroups.isEmpty()) {
            this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                @Override
                public boolean onPreDraw() {
                    for (MessagingGroup group : MessagingLayout.this.mAddedGroups) {
                        if (!group.isShown()) continue;
                        MessagingPropertyAnimator.fadeIn(group.getAvatar());
                        MessagingPropertyAnimator.fadeIn(group.getSenderView());
                        MessagingPropertyAnimator.startLocalTranslationFrom(group, group.getHeight(), LINEAR_OUT_SLOW_IN);
                    }
                    MessagingLayout.this.mAddedGroups.clear();
                    MessagingLayout.this.getViewTreeObserver().removeOnPreDrawListener(this);
                    return true;
                }
            });
        }
    }

    public MessagingLinearLayout getMessagingLinearLayout() {
        return this.mMessagingLinearLayout;
    }

    public ArrayList<MessagingGroup> getMessagingGroups() {
        return this.mGroups;
    }
}

