/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.util.IntProperty;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.PathInterpolator;
import com.android.internal.widget.MessagingLayout;
import com.android.internal.widget.MessagingLinearLayout;
import com.android.internal.widget.ViewClippingUtil;

public class MessagingPropertyAnimator
implements View.OnLayoutChangeListener {
    static final long APPEAR_ANIMATION_LENGTH = 210L;
    private static final Interpolator ALPHA_IN = new PathInterpolator(0.4f, 0.0f, 1.0f, 1.0f);
    public static final Interpolator ALPHA_OUT = new PathInterpolator(0.0f, 0.0f, 0.8f, 1.0f);
    private static final int TAG_LOCAL_TRANSLATION_ANIMATOR = 16909361;
    private static final int TAG_LOCAL_TRANSLATION_Y = 16909360;
    private static final int TAG_LAYOUT_TOP = 16909359;
    private static final int TAG_ALPHA_ANIMATOR = 16909358;
    private static final ViewClippingUtil.ClippingParameters CLIPPING_PARAMETERS = view -> view.getId() == 16909117;
    private static final IntProperty<View> LOCAL_TRANSLATION_Y = new IntProperty<View>("localTranslationY"){

        @Override
        public void setValue(View object, int value) {
            MessagingPropertyAnimator.setLocalTranslationY(object, value);
        }

        @Override
        public Integer get(View object) {
            return MessagingPropertyAnimator.getLocalTranslationY(object);
        }
    };

    @Override
    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        int oldHeight = oldBottom - oldTop;
        Integer layoutTop = (Integer)v.getTag(16909359);
        if (layoutTop != null) {
            oldTop = layoutTop;
        }
        int topChange = oldTop - top;
        if (oldHeight == 0 || topChange == 0 || !v.isShown() || this.isGone(v)) {
            return;
        }
        if (layoutTop != null) {
            v.setTagInternal(16909359, top);
        }
        int newHeight = bottom - top;
        int heightDifference = oldHeight - newHeight;
        heightDifference = Math.max(heightDifference, 0);
        MessagingPropertyAnimator.startLocalTranslationFrom(v, topChange + heightDifference + MessagingPropertyAnimator.getLocalTranslationY(v));
    }

    private boolean isGone(View view) {
        if (view.getVisibility() == 8) {
            return true;
        }
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        return lp instanceof MessagingLinearLayout.LayoutParams && ((MessagingLinearLayout.LayoutParams)lp).hide;
    }

    public static void startLocalTranslationFrom(View v, int startTranslation) {
        MessagingPropertyAnimator.startLocalTranslationFrom(v, startTranslation, MessagingLayout.FAST_OUT_SLOW_IN);
    }

    public static void startLocalTranslationFrom(View v, int startTranslation, Interpolator interpolator2) {
        MessagingPropertyAnimator.startLocalTranslation(v, startTranslation, 0, interpolator2);
    }

    public static void startLocalTranslationTo(View v, int endTranslation, Interpolator interpolator2) {
        MessagingPropertyAnimator.startLocalTranslation(v, MessagingPropertyAnimator.getLocalTranslationY(v), endTranslation, interpolator2);
    }

    public static int getLocalTranslationY(View v) {
        Integer tag = (Integer)v.getTag(16909360);
        if (tag == null) {
            return 0;
        }
        return tag;
    }

    private static void setLocalTranslationY(View v, int value) {
        v.setTagInternal(16909360, value);
        MessagingPropertyAnimator.updateTopAndBottom(v);
    }

    private static void updateTopAndBottom(View v) {
        int layoutTop = (Integer)v.getTag(16909359);
        int localTranslation = MessagingPropertyAnimator.getLocalTranslationY(v);
        int height = v.getHeight();
        v.setTop(layoutTop + localTranslation);
        v.setBottom(layoutTop + height + localTranslation);
    }

    private static void startLocalTranslation(final View v, int start, int end, Interpolator interpolator2) {
        ObjectAnimator existing = (ObjectAnimator)v.getTag(16909361);
        if (existing != null) {
            existing.cancel();
        }
        ObjectAnimator animator2 = ObjectAnimator.ofInt(v, LOCAL_TRANSLATION_Y, start, end);
        Integer layoutTop = (Integer)v.getTag(16909359);
        if (layoutTop == null) {
            layoutTop = v.getTop();
            v.setTagInternal(16909359, layoutTop);
        }
        MessagingPropertyAnimator.setLocalTranslationY(v, start);
        animator2.setInterpolator(interpolator2);
        animator2.setDuration(210L);
        animator2.addListener(new AnimatorListenerAdapter(){
            public boolean mCancelled;

            @Override
            public void onAnimationEnd(Animator animation) {
                v.setTagInternal(16909361, null);
                MessagingPropertyAnimator.setClippingDeactivated(v, false);
                if (!this.mCancelled) {
                    MessagingPropertyAnimator.setLocalTranslationY(v, 0);
                    v.setTagInternal(16909359, null);
                }
            }

            @Override
            public void onAnimationCancel(Animator animation) {
                this.mCancelled = true;
            }
        });
        MessagingPropertyAnimator.setClippingDeactivated(v, true);
        v.setTagInternal(16909361, animator2);
        animator2.start();
    }

    public static void fadeIn(final View v) {
        ObjectAnimator existing = (ObjectAnimator)v.getTag(16909358);
        if (existing != null) {
            existing.cancel();
        }
        if (v.getVisibility() == 4) {
            v.setVisibility(0);
        }
        ObjectAnimator animator2 = ObjectAnimator.ofFloat(v, View.ALPHA, 0.0f, 1.0f);
        v.setAlpha(0.0f);
        animator2.setInterpolator(ALPHA_IN);
        animator2.setDuration(210L);
        animator2.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                v.setTagInternal(16909358, null);
                MessagingPropertyAnimator.updateLayerType(v, false);
            }
        });
        MessagingPropertyAnimator.updateLayerType(v, true);
        v.setTagInternal(16909358, animator2);
        animator2.start();
    }

    private static void updateLayerType(View view, boolean animating) {
        if (view.hasOverlappingRendering() && animating) {
            view.setLayerType(2, null);
        } else if (view.getLayerType() == 2) {
            view.setLayerType(0, null);
        }
    }

    public static void fadeOut(final View view, final Runnable endAction) {
        ObjectAnimator existing = (ObjectAnimator)view.getTag(16909358);
        if (existing != null) {
            existing.cancel();
        }
        ObjectAnimator animator2 = ObjectAnimator.ofFloat(view, View.ALPHA, view.getAlpha(), 0.0f);
        animator2.setInterpolator(ALPHA_OUT);
        animator2.setDuration(210L);
        animator2.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                view.setTagInternal(16909358, null);
                MessagingPropertyAnimator.updateLayerType(view, false);
                if (endAction != null) {
                    endAction.run();
                }
            }
        });
        MessagingPropertyAnimator.updateLayerType(view, true);
        view.setTagInternal(16909358, animator2);
        animator2.start();
    }

    public static void setClippingDeactivated(View transformedView, boolean deactivated) {
        ViewClippingUtil.setClippingDeactivated(transformedView, deactivated, CLIPPING_PARAMETERS);
    }

    public static boolean isAnimatingTranslation(View v) {
        return v.getTag(16909361) != null;
    }

    public static boolean isAnimatingAlpha(View v) {
        return v.getTag(16909358) != null;
    }
}

