/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ActionMenuPresenter;
import android.widget.AdapterView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.Toolbar;
import com.android.internal.R;
import com.android.internal.view.menu.ActionMenuItem;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.widget.DecorToolbar;
import com.android.internal.widget.ScrollingTabContainerView;

public class ToolbarWidgetWrapper
implements DecorToolbar {
    private static final String TAG = "ToolbarWidgetWrapper";
    private static final int AFFECTS_LOGO_MASK = 3;
    private static final long DEFAULT_FADE_DURATION_MS = 200L;
    private Toolbar mToolbar;
    private int mDisplayOpts;
    private View mTabView;
    private Spinner mSpinner;
    private View mCustomView;
    private Drawable mIcon;
    private Drawable mLogo;
    private Drawable mNavIcon;
    private boolean mTitleSet;
    private CharSequence mTitle;
    private CharSequence mSubtitle;
    private CharSequence mHomeDescription;
    private Window.Callback mWindowCallback;
    private boolean mMenuPrepared;
    private ActionMenuPresenter mActionMenuPresenter;
    private int mNavigationMode = 0;
    private int mDefaultNavigationContentDescription = 0;
    private Drawable mDefaultNavigationIcon;

    public ToolbarWidgetWrapper(Toolbar toolbar, boolean style2) {
        this(toolbar, style2, 17039431);
    }

    public ToolbarWidgetWrapper(Toolbar toolbar, boolean style2, int defaultNavigationContentDescription) {
        this.mToolbar = toolbar;
        this.mTitle = toolbar.getTitle();
        this.mSubtitle = toolbar.getSubtitle();
        this.mTitleSet = this.mTitle != null;
        this.mNavIcon = this.mToolbar.getNavigationIcon();
        TypedArray a = toolbar.getContext().obtainStyledAttributes(null, R.styleable.ActionBar, 16843470, 0);
        this.mDefaultNavigationIcon = a.getDrawable(13);
        if (style2) {
            int popupTheme;
            int subtitleTextStyle;
            int titleTextStyle;
            int height;
            Drawable icon;
            Drawable logo;
            CharSequence subtitle;
            CharSequence title = a.getText(5);
            if (!TextUtils.isEmpty(title)) {
                this.setTitle(title);
            }
            if (!TextUtils.isEmpty(subtitle = a.getText(9))) {
                this.setSubtitle(subtitle);
            }
            if ((logo = a.getDrawable(6)) != null) {
                this.setLogo(logo);
            }
            if ((icon = a.getDrawable(0)) != null) {
                this.setIcon(icon);
            }
            if (this.mNavIcon == null && this.mDefaultNavigationIcon != null) {
                this.setNavigationIcon(this.mDefaultNavigationIcon);
            }
            this.setDisplayOptions(a.getInt(8, 0));
            int customNavId = a.getResourceId(10, 0);
            if (customNavId != 0) {
                this.setCustomView(LayoutInflater.from(this.mToolbar.getContext()).inflate(customNavId, (ViewGroup)this.mToolbar, false));
                this.setDisplayOptions(this.mDisplayOpts | 0x10);
            }
            if ((height = a.getLayoutDimension(4, 0)) > 0) {
                ViewGroup.LayoutParams lp = this.mToolbar.getLayoutParams();
                lp.height = height;
                this.mToolbar.setLayoutParams(lp);
            }
            int contentInsetStart = a.getDimensionPixelOffset(22, -1);
            int contentInsetEnd = a.getDimensionPixelOffset(23, -1);
            if (contentInsetStart >= 0 || contentInsetEnd >= 0) {
                this.mToolbar.setContentInsetsRelative(Math.max(contentInsetStart, 0), Math.max(contentInsetEnd, 0));
            }
            if ((titleTextStyle = a.getResourceId(11, 0)) != 0) {
                this.mToolbar.setTitleTextAppearance(this.mToolbar.getContext(), titleTextStyle);
            }
            if ((subtitleTextStyle = a.getResourceId(12, 0)) != 0) {
                this.mToolbar.setSubtitleTextAppearance(this.mToolbar.getContext(), subtitleTextStyle);
            }
            if ((popupTheme = a.getResourceId(26, 0)) != 0) {
                this.mToolbar.setPopupTheme(popupTheme);
            }
        } else {
            this.mDisplayOpts = this.detectDisplayOptions();
        }
        a.recycle();
        this.setDefaultNavigationContentDescription(defaultNavigationContentDescription);
        this.mHomeDescription = this.mToolbar.getNavigationContentDescription();
        this.mToolbar.setNavigationOnClickListener(new View.OnClickListener(){
            final ActionMenuItem mNavItem;
            {
                this.mNavItem = new ActionMenuItem(ToolbarWidgetWrapper.this.mToolbar.getContext(), 0, 16908332, 0, 0, ToolbarWidgetWrapper.this.mTitle);
            }

            @Override
            public void onClick(View v) {
                if (ToolbarWidgetWrapper.this.mWindowCallback != null && ToolbarWidgetWrapper.this.mMenuPrepared) {
                    ToolbarWidgetWrapper.this.mWindowCallback.onMenuItemSelected(0, this.mNavItem);
                }
            }
        });
    }

    @Override
    public void setDefaultNavigationContentDescription(int defaultNavigationContentDescription) {
        if (defaultNavigationContentDescription == this.mDefaultNavigationContentDescription) {
            return;
        }
        this.mDefaultNavigationContentDescription = defaultNavigationContentDescription;
        if (TextUtils.isEmpty(this.mToolbar.getNavigationContentDescription())) {
            this.setNavigationContentDescription(this.mDefaultNavigationContentDescription);
        }
    }

    private int detectDisplayOptions() {
        int opts = 11;
        if (this.mToolbar.getNavigationIcon() != null) {
            opts |= 4;
            this.mDefaultNavigationIcon = this.mToolbar.getNavigationIcon();
        }
        return opts;
    }

    @Override
    public ViewGroup getViewGroup() {
        return this.mToolbar;
    }

    @Override
    public Context getContext() {
        return this.mToolbar.getContext();
    }

    @Override
    public boolean isSplit() {
        return false;
    }

    @Override
    public boolean hasExpandedActionView() {
        return this.mToolbar.hasExpandedActionView();
    }

    @Override
    public void collapseActionView() {
        this.mToolbar.collapseActionView();
    }

    @Override
    public void setWindowCallback(Window.Callback cb) {
        this.mWindowCallback = cb;
    }

    @Override
    public void setWindowTitle(CharSequence title) {
        if (!this.mTitleSet) {
            this.setTitleInt(title);
        }
    }

    @Override
    public CharSequence getTitle() {
        return this.mToolbar.getTitle();
    }

    @Override
    public void setTitle(CharSequence title) {
        this.mTitleSet = true;
        this.setTitleInt(title);
    }

    private void setTitleInt(CharSequence title) {
        this.mTitle = title;
        if ((this.mDisplayOpts & 8) != 0) {
            this.mToolbar.setTitle(title);
        }
    }

    @Override
    public CharSequence getSubtitle() {
        return this.mToolbar.getSubtitle();
    }

    @Override
    public void setSubtitle(CharSequence subtitle) {
        this.mSubtitle = subtitle;
        if ((this.mDisplayOpts & 8) != 0) {
            this.mToolbar.setSubtitle(subtitle);
        }
    }

    @Override
    public void initProgress() {
        Log.i(TAG, "Progress display unsupported");
    }

    @Override
    public void initIndeterminateProgress() {
        Log.i(TAG, "Progress display unsupported");
    }

    @Override
    public boolean canSplit() {
        return false;
    }

    @Override
    public void setSplitView(ViewGroup splitView) {
    }

    @Override
    public void setSplitToolbar(boolean split) {
        if (split) {
            throw new UnsupportedOperationException("Cannot split an android.widget.Toolbar");
        }
    }

    @Override
    public void setSplitWhenNarrow(boolean splitWhenNarrow) {
    }

    @Override
    public boolean hasIcon() {
        return this.mIcon != null;
    }

    @Override
    public boolean hasLogo() {
        return this.mLogo != null;
    }

    @Override
    public void setIcon(int resId) {
        this.setIcon(resId != 0 ? this.getContext().getDrawable(resId) : null);
    }

    @Override
    public void setIcon(Drawable d) {
        this.mIcon = d;
        this.updateToolbarLogo();
    }

    @Override
    public void setLogo(int resId) {
        this.setLogo(resId != 0 ? this.getContext().getDrawable(resId) : null);
    }

    @Override
    public void setLogo(Drawable d) {
        this.mLogo = d;
        this.updateToolbarLogo();
    }

    private void updateToolbarLogo() {
        Drawable logo = null;
        if ((this.mDisplayOpts & 2) != 0) {
            logo = (this.mDisplayOpts & 1) != 0 ? (this.mLogo != null ? this.mLogo : this.mIcon) : this.mIcon;
        }
        this.mToolbar.setLogo(logo);
    }

    @Override
    public boolean canShowOverflowMenu() {
        return this.mToolbar.canShowOverflowMenu();
    }

    @Override
    public boolean isOverflowMenuShowing() {
        return this.mToolbar.isOverflowMenuShowing();
    }

    @Override
    public boolean isOverflowMenuShowPending() {
        return this.mToolbar.isOverflowMenuShowPending();
    }

    @Override
    public boolean showOverflowMenu() {
        return this.mToolbar.showOverflowMenu();
    }

    @Override
    public boolean hideOverflowMenu() {
        return this.mToolbar.hideOverflowMenu();
    }

    @Override
    public void setMenuPrepared() {
        this.mMenuPrepared = true;
    }

    @Override
    public void setMenu(Menu menu2, MenuPresenter.Callback cb) {
        if (this.mActionMenuPresenter == null) {
            this.mActionMenuPresenter = new ActionMenuPresenter(this.mToolbar.getContext());
            this.mActionMenuPresenter.setId(16908680);
        }
        this.mActionMenuPresenter.setCallback(cb);
        this.mToolbar.setMenu((MenuBuilder)menu2, this.mActionMenuPresenter);
    }

    @Override
    public void dismissPopupMenus() {
        this.mToolbar.dismissPopupMenus();
    }

    @Override
    public int getDisplayOptions() {
        return this.mDisplayOpts;
    }

    @Override
    public void setDisplayOptions(int newOpts) {
        int oldOpts = this.mDisplayOpts;
        int changed = oldOpts ^ newOpts;
        this.mDisplayOpts = newOpts;
        if (changed != 0) {
            if ((changed & 4) != 0) {
                if ((newOpts & 4) != 0) {
                    this.updateHomeAccessibility();
                }
                this.updateNavigationIcon();
            }
            if ((changed & 3) != 0) {
                this.updateToolbarLogo();
            }
            if ((changed & 8) != 0) {
                if ((newOpts & 8) != 0) {
                    this.mToolbar.setTitle(this.mTitle);
                    this.mToolbar.setSubtitle(this.mSubtitle);
                } else {
                    this.mToolbar.setTitle(null);
                    this.mToolbar.setSubtitle(null);
                }
            }
            if ((changed & 0x10) != 0 && this.mCustomView != null) {
                if ((newOpts & 0x10) != 0) {
                    this.mToolbar.addView(this.mCustomView);
                } else {
                    this.mToolbar.removeView(this.mCustomView);
                }
            }
        }
    }

    @Override
    public void setEmbeddedTabView(ScrollingTabContainerView tabView) {
        if (this.mTabView != null && this.mTabView.getParent() == this.mToolbar) {
            this.mToolbar.removeView(this.mTabView);
        }
        this.mTabView = tabView;
        if (tabView != null && this.mNavigationMode == 2) {
            this.mToolbar.addView(this.mTabView, 0);
            Toolbar.LayoutParams lp = (Toolbar.LayoutParams)this.mTabView.getLayoutParams();
            lp.width = -2;
            lp.height = -2;
            lp.gravity = 8388691;
            tabView.setAllowCollapse(true);
        }
    }

    @Override
    public boolean hasEmbeddedTabs() {
        return this.mTabView != null;
    }

    @Override
    public boolean isTitleTruncated() {
        return this.mToolbar.isTitleTruncated();
    }

    @Override
    public void setCollapsible(boolean collapsible) {
        this.mToolbar.setCollapsible(collapsible);
    }

    @Override
    public void setHomeButtonEnabled(boolean enable) {
    }

    @Override
    public int getNavigationMode() {
        return this.mNavigationMode;
    }

    @Override
    public void setNavigationMode(int mode) {
        int oldMode = this.mNavigationMode;
        if (mode != oldMode) {
            switch (oldMode) {
                case 1: {
                    if (this.mSpinner == null || this.mSpinner.getParent() != this.mToolbar) break;
                    this.mToolbar.removeView(this.mSpinner);
                    break;
                }
                case 2: {
                    if (this.mTabView == null || this.mTabView.getParent() != this.mToolbar) break;
                    this.mToolbar.removeView(this.mTabView);
                }
            }
            this.mNavigationMode = mode;
            switch (mode) {
                case 0: {
                    break;
                }
                case 1: {
                    this.ensureSpinner();
                    this.mToolbar.addView((View)this.mSpinner, 0);
                    break;
                }
                case 2: {
                    if (this.mTabView == null) break;
                    this.mToolbar.addView(this.mTabView, 0);
                    Toolbar.LayoutParams lp = (Toolbar.LayoutParams)this.mTabView.getLayoutParams();
                    lp.width = -2;
                    lp.height = -2;
                    lp.gravity = 8388691;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid navigation mode " + mode);
                }
            }
        }
    }

    private void ensureSpinner() {
        if (this.mSpinner == null) {
            this.mSpinner = new Spinner(this.getContext(), null, 16843479);
            Toolbar.LayoutParams lp = new Toolbar.LayoutParams(-2, -2, 8388627);
            this.mSpinner.setLayoutParams(lp);
        }
    }

    @Override
    public void setDropdownParams(SpinnerAdapter adapter, AdapterView.OnItemSelectedListener listener) {
        this.ensureSpinner();
        this.mSpinner.setAdapter(adapter);
        this.mSpinner.setOnItemSelectedListener(listener);
    }

    @Override
    public void setDropdownSelectedPosition(int position) {
        if (this.mSpinner == null) {
            throw new IllegalStateException("Can't set dropdown selected position without an adapter");
        }
        this.mSpinner.setSelection(position);
    }

    @Override
    public int getDropdownSelectedPosition() {
        return this.mSpinner != null ? this.mSpinner.getSelectedItemPosition() : 0;
    }

    @Override
    public int getDropdownItemCount() {
        return this.mSpinner != null ? this.mSpinner.getCount() : 0;
    }

    @Override
    public void setCustomView(View view) {
        if (this.mCustomView != null && (this.mDisplayOpts & 0x10) != 0) {
            this.mToolbar.removeView(this.mCustomView);
        }
        this.mCustomView = view;
        if (view != null && (this.mDisplayOpts & 0x10) != 0) {
            this.mToolbar.addView(this.mCustomView);
        }
    }

    @Override
    public View getCustomView() {
        return this.mCustomView;
    }

    @Override
    public void animateToVisibility(int visibility) {
        Animator anim2 = this.setupAnimatorToVisibility(visibility, 200L);
        if (anim2 != null) {
            anim2.start();
        }
    }

    @Override
    public Animator setupAnimatorToVisibility(int visibility, long duration) {
        if (visibility == 8) {
            ObjectAnimator anim2 = ObjectAnimator.ofFloat(this.mToolbar, View.ALPHA, 1.0f, 0.0f);
            anim2.setDuration(duration);
            anim2.addListener(new AnimatorListenerAdapter(){
                private boolean mCanceled = false;

                @Override
                public void onAnimationEnd(Animator animation) {
                    if (!this.mCanceled) {
                        ToolbarWidgetWrapper.this.mToolbar.setVisibility(8);
                    }
                }

                @Override
                public void onAnimationCancel(Animator animation) {
                    this.mCanceled = true;
                }
            });
            return anim2;
        }
        if (visibility == 0) {
            ObjectAnimator anim3 = ObjectAnimator.ofFloat(this.mToolbar, View.ALPHA, 0.0f, 1.0f);
            anim3.setDuration(duration);
            anim3.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationStart(Animator animation) {
                    ToolbarWidgetWrapper.this.mToolbar.setVisibility(0);
                }
            });
            return anim3;
        }
        return null;
    }

    @Override
    public void setNavigationIcon(Drawable icon) {
        this.mNavIcon = icon;
        this.updateNavigationIcon();
    }

    @Override
    public void setNavigationIcon(int resId) {
        this.setNavigationIcon(resId != 0 ? this.mToolbar.getContext().getDrawable(resId) : null);
    }

    @Override
    public void setDefaultNavigationIcon(Drawable defaultNavigationIcon) {
        if (this.mDefaultNavigationIcon != defaultNavigationIcon) {
            this.mDefaultNavigationIcon = defaultNavigationIcon;
            this.updateNavigationIcon();
        }
    }

    private void updateNavigationIcon() {
        if ((this.mDisplayOpts & 4) != 0) {
            this.mToolbar.setNavigationIcon(this.mNavIcon != null ? this.mNavIcon : this.mDefaultNavigationIcon);
        } else {
            this.mToolbar.setNavigationIcon(null);
        }
    }

    @Override
    public void setNavigationContentDescription(CharSequence description) {
        this.mHomeDescription = description;
        this.updateHomeAccessibility();
    }

    @Override
    public void setNavigationContentDescription(int resId) {
        this.setNavigationContentDescription(resId == 0 ? null : this.getContext().getString(resId));
    }

    private void updateHomeAccessibility() {
        if ((this.mDisplayOpts & 4) != 0) {
            if (TextUtils.isEmpty(this.mHomeDescription)) {
                this.mToolbar.setNavigationContentDescription(this.mDefaultNavigationContentDescription);
            } else {
                this.mToolbar.setNavigationContentDescription(this.mHomeDescription);
            }
        }
    }

    @Override
    public void saveHierarchyState(SparseArray<Parcelable> toolbarStates) {
        this.mToolbar.saveHierarchyState(toolbarStates);
    }

    @Override
    public void restoreHierarchyState(SparseArray<Parcelable> toolbarStates) {
        this.mToolbar.restoreHierarchyState(toolbarStates);
    }

    @Override
    public void setBackgroundDrawable(Drawable d) {
        this.mToolbar.setBackgroundDrawable(d);
    }

    @Override
    public int getHeight() {
        return this.mToolbar.getHeight();
    }

    @Override
    public void setVisibility(int visible) {
        this.mToolbar.setVisibility(visible);
    }

    @Override
    public int getVisibility() {
        return this.mToolbar.getVisibility();
    }

    @Override
    public void setMenuCallbacks(MenuPresenter.Callback presenterCallback, MenuBuilder.Callback menuBuilderCallback) {
        this.mToolbar.setMenuCallbacks(presenterCallback, menuBuilderCallback);
    }

    @Override
    public Menu getMenu() {
        return this.mToolbar.getMenu();
    }
}

