/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.os.Build;
import android.os.DropBoxManager;
import android.os.Environment;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.RecoverySystem;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.storage.StorageManager;
import android.provider.Downloads;
import android.text.TextUtils;
import android.util.AtomicFile;
import android.util.EventLog;
import android.util.Slog;
import android.util.StatsLog;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BootReceiver
extends BroadcastReceiver {
    private static final String TAG = "BootReceiver";
    private static final int LOG_SIZE = SystemProperties.getInt("ro.debuggable", 0) == 1 ? 98304 : 65536;
    private static final File TOMBSTONE_DIR = new File("/data/tombstones");
    private static final String OLD_UPDATER_PACKAGE = "com.google.android.systemupdater";
    private static final String OLD_UPDATER_CLASS = "com.google.android.systemupdater.SystemUpdateReceiver";
    private static FileObserver sTombstoneObserver = null;
    private static final String LOG_FILES_FILE = "log-files.xml";
    private static final AtomicFile sFile = new AtomicFile(new File(Environment.getDataSystemDirectory(), "log-files.xml"), "log-files");
    private static final String LAST_HEADER_FILE = "last-header.txt";
    private static final File lastHeaderFile = new File(Environment.getDataSystemDirectory(), "last-header.txt");
    private static final String FS_STAT_PATTERN = "fs_stat,[^,]*/([^/,]+),(0x[0-9a-fA-F]+)";
    private static final int FS_STAT_FS_FIXED = 1024;
    private static final String FSCK_PASS_PATTERN = "Pass ([1-9]E?):";
    private static final String FSCK_TREE_OPTIMIZATION_PATTERN = "Inode [0-9]+ extent tree.*could be shorter";
    private static final String FSCK_FS_MODIFIED = "FILE SYSTEM WAS MODIFIED";
    private static final String[] MOUNT_DURATION_PROPS_POSTFIX = new String[]{"early", "default", "late"};
    private static final String[] LAST_KMSG_FILES = new String[]{"/sys/fs/pstore/console-ramoops", "/proc/last_kmsg"};
    private static final String LAST_SHUTDOWN_TIME_PATTERN = "powerctl_shutdown_time_ms:([0-9]+):([0-9]+)";
    private static final int UMOUNT_STATUS_NOT_AVAILABLE = 4;
    private static final String SHUTDOWN_METRICS_FILE = "/data/system/shutdown-metrics.txt";
    private static final String SHUTDOWN_TRON_METRICS_PREFIX = "shutdown_";
    private static final String METRIC_SYSTEM_SERVER = "shutdown_system_server";
    private static final String METRIC_SHUTDOWN_TIME_START = "begin_shutdown";

    @Override
    public void onReceive(final Context context, Intent intent) {
        new Thread(){

            @Override
            public void run() {
                try {
                    BootReceiver.this.logBootEvents(context);
                }
                catch (Exception e) {
                    Slog.e(BootReceiver.TAG, "Can't log boot events", e);
                }
                try {
                    boolean onlyCore = false;
                    try {
                        onlyCore = IPackageManager.Stub.asInterface(ServiceManager.getService("package")).isOnlyCoreApps();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (!onlyCore) {
                        BootReceiver.this.removeOldUpdatePackages(context);
                    }
                }
                catch (Exception e) {
                    Slog.e(BootReceiver.TAG, "Can't remove old update packages", e);
                }
            }
        }.start();
    }

    private void removeOldUpdatePackages(Context context) {
        Downloads.removeAllDownloadsByPackage(context, OLD_UPDATER_PACKAGE, OLD_UPDATER_CLASS);
    }

    private String getPreviousBootHeaders() {
        try {
            return FileUtils.readTextFile(lastHeaderFile, 0, null);
        }
        catch (IOException e) {
            return null;
        }
    }

    private String getCurrentBootHeaders() throws IOException {
        return new StringBuilder(512).append("Build: ").append(Build.FINGERPRINT).append("\n").append("Hardware: ").append(Build.BOARD).append("\n").append("Revision: ").append(SystemProperties.get("ro.revision", "")).append("\n").append("Bootloader: ").append(Build.BOOTLOADER).append("\n").append("Radio: ").append(Build.getRadioVersion()).append("\n").append("Kernel: ").append(FileUtils.readTextFile(new File("/proc/version"), 1024, "...\n")).append("\n").toString();
    }

    private String getBootHeadersToLogAndUpdate() throws IOException {
        String oldHeaders = this.getPreviousBootHeaders();
        String newHeaders = this.getCurrentBootHeaders();
        try {
            FileUtils.stringToFile(lastHeaderFile, newHeaders);
        }
        catch (IOException e) {
            Slog.e(TAG, "Error writing " + lastHeaderFile, e);
        }
        if (oldHeaders == null) {
            return "isPrevious: false\n" + newHeaders;
        }
        return "isPrevious: true\n" + oldHeaders;
    }

    private void logBootEvents(Context ctx) throws IOException {
        final DropBoxManager db = (DropBoxManager)ctx.getSystemService("dropbox");
        final String headers = this.getBootHeadersToLogAndUpdate();
        String bootReason = SystemProperties.get("ro.boot.bootreason", null);
        String recovery = RecoverySystem.handleAftermath(ctx);
        if (recovery != null && db != null) {
            db.addText("SYSTEM_RECOVERY_LOG", headers + recovery);
        }
        String lastKmsgFooter = "";
        if (bootReason != null) {
            lastKmsgFooter = new StringBuilder(512).append("\n").append("Boot info:\n").append("Last boot reason: ").append(bootReason).append("\n").toString();
        }
        HashMap<String, Long> timestamps = BootReceiver.readTimestamps();
        if (SystemProperties.getLong("ro.runtime.firstboot", 0L) == 0L) {
            if (!StorageManager.inCryptKeeperBounce()) {
                String now = Long.toString(System.currentTimeMillis());
                SystemProperties.set("ro.runtime.firstboot", now);
            }
            if (db != null) {
                db.addText("SYSTEM_BOOT", headers);
            }
            BootReceiver.addFileWithFootersToDropBox(db, timestamps, headers, lastKmsgFooter, "/proc/last_kmsg", -LOG_SIZE, "SYSTEM_LAST_KMSG");
            BootReceiver.addFileWithFootersToDropBox(db, timestamps, headers, lastKmsgFooter, "/sys/fs/pstore/console-ramoops", -LOG_SIZE, "SYSTEM_LAST_KMSG");
            BootReceiver.addFileWithFootersToDropBox(db, timestamps, headers, lastKmsgFooter, "/sys/fs/pstore/console-ramoops-0", -LOG_SIZE, "SYSTEM_LAST_KMSG");
            BootReceiver.addFileToDropBox(db, timestamps, headers, "/cache/recovery/log", -LOG_SIZE, "SYSTEM_RECOVERY_LOG");
            BootReceiver.addFileToDropBox(db, timestamps, headers, "/cache/recovery/last_kmsg", -LOG_SIZE, "SYSTEM_RECOVERY_KMSG");
            BootReceiver.addAuditErrorsToDropBox(db, timestamps, headers, -LOG_SIZE, "SYSTEM_AUDIT");
        } else if (db != null) {
            db.addText("SYSTEM_RESTART", headers);
        }
        BootReceiver.logFsShutdownTime();
        BootReceiver.logFsMountTime();
        BootReceiver.addFsckErrorsToDropBoxAndLogFsStat(db, timestamps, headers, -LOG_SIZE, "SYSTEM_FSCK");
        BootReceiver.logSystemServerShutdownTimeMetrics();
        File[] tombstoneFiles = TOMBSTONE_DIR.listFiles();
        for (int i = 0; tombstoneFiles != null && i < tombstoneFiles.length; ++i) {
            if (!tombstoneFiles[i].isFile()) continue;
            BootReceiver.addFileToDropBox(db, timestamps, headers, tombstoneFiles[i].getPath(), LOG_SIZE, "SYSTEM_TOMBSTONE");
        }
        this.writeTimestamps(timestamps);
        sTombstoneObserver = new FileObserver(TOMBSTONE_DIR.getPath(), 8){

            @Override
            public void onEvent(int event, String path) {
                HashMap timestamps = BootReceiver.readTimestamps();
                try {
                    File file = new File(TOMBSTONE_DIR, path);
                    if (file.isFile()) {
                        BootReceiver.addFileToDropBox(db, timestamps, headers, file.getPath(), LOG_SIZE, "SYSTEM_TOMBSTONE");
                    }
                }
                catch (IOException e) {
                    Slog.e(BootReceiver.TAG, "Can't log tombstone", e);
                }
                BootReceiver.this.writeTimestamps(timestamps);
            }
        };
        sTombstoneObserver.startWatching();
    }

    private static void addFileToDropBox(DropBoxManager db, HashMap<String, Long> timestamps, String headers, String filename, int maxSize, String tag) throws IOException {
        BootReceiver.addFileWithFootersToDropBox(db, timestamps, headers, "", filename, maxSize, tag);
    }

    private static void addFileWithFootersToDropBox(DropBoxManager db, HashMap<String, Long> timestamps, String headers, String footers, String filename, int maxSize, String tag) throws IOException {
        if (db == null || !db.isTagEnabled(tag)) {
            return;
        }
        File file = new File(filename);
        long fileTime = file.lastModified();
        if (fileTime <= 0L) {
            return;
        }
        if (timestamps.containsKey(filename) && timestamps.get(filename) == fileTime) {
            return;
        }
        timestamps.put(filename, fileTime);
        Slog.i(TAG, "Copying " + filename + " to DropBox (" + tag + ")");
        db.addText(tag, headers + FileUtils.readTextFile(file, maxSize, "[[TRUNCATED]]\n") + footers);
        EventLog.writeEvent(81002, filename, maxSize, tag);
    }

    private static void addAuditErrorsToDropBox(DropBoxManager db, HashMap<String, Long> timestamps, String headers, int maxSize, String tag) throws IOException {
        if (db == null || !db.isTagEnabled(tag)) {
            return;
        }
        Slog.i(TAG, "Copying audit failures to DropBox");
        File file = new File("/proc/last_kmsg");
        long fileTime = file.lastModified();
        if (fileTime <= 0L && (fileTime = (file = new File("/sys/fs/pstore/console-ramoops")).lastModified()) <= 0L) {
            file = new File("/sys/fs/pstore/console-ramoops-0");
            fileTime = file.lastModified();
        }
        if (fileTime <= 0L) {
            return;
        }
        if (timestamps.containsKey(tag) && timestamps.get(tag) == fileTime) {
            return;
        }
        timestamps.put(tag, fileTime);
        String log = FileUtils.readTextFile(file, maxSize, "[[TRUNCATED]]\n");
        StringBuilder sb = new StringBuilder();
        for (String line : log.split("\n")) {
            if (!line.contains("audit")) continue;
            sb.append(line + "\n");
        }
        Slog.i(TAG, "Copied " + sb.toString().length() + " worth of audits to DropBox");
        db.addText(tag, headers + sb.toString());
    }

    private static void addFsckErrorsToDropBoxAndLogFsStat(DropBoxManager db, HashMap<String, Long> timestamps, String headers, int maxSize, String tag) throws IOException {
        boolean uploadEnabled = true;
        if (db == null || !db.isTagEnabled(tag)) {
            uploadEnabled = false;
        }
        boolean uploadNeeded = false;
        Slog.i(TAG, "Checking for fsck errors");
        File file = new File("/dev/fscklogs/log");
        long fileTime = file.lastModified();
        if (fileTime <= 0L) {
            return;
        }
        String log = FileUtils.readTextFile(file, maxSize, "[[TRUNCATED]]\n");
        Pattern pattern = Pattern.compile(FS_STAT_PATTERN);
        String[] lines = log.split("\n");
        int lineNumber = 0;
        int lastFsStatLineNumber = 0;
        for (String line : lines) {
            if (line.contains(FSCK_FS_MODIFIED)) {
                uploadNeeded = true;
            } else if (line.contains("fs_stat")) {
                Matcher matcher = pattern.matcher(line);
                if (matcher.find()) {
                    BootReceiver.handleFsckFsStat(matcher, lines, lastFsStatLineNumber, lineNumber);
                    lastFsStatLineNumber = lineNumber;
                } else {
                    Slog.w(TAG, "cannot parse fs_stat:" + line);
                }
            }
            ++lineNumber;
        }
        if (uploadEnabled && uploadNeeded) {
            BootReceiver.addFileToDropBox(db, timestamps, headers, "/dev/fscklogs/log", maxSize, tag);
        }
        file.delete();
    }

    private static void logFsMountTime() {
        for (String propPostfix : MOUNT_DURATION_PROPS_POSTFIX) {
            int duration = SystemProperties.getInt("ro.boottime.init.mount_all." + propPostfix, 0);
            if (duration == 0) continue;
            MetricsLogger.histogram(null, "boot_mount_all_duration_" + propPostfix, duration);
        }
    }

    private static void logSystemServerShutdownTimeMetrics() {
        File metricsFile = new File(SHUTDOWN_METRICS_FILE);
        String metricsStr = null;
        if (metricsFile.exists()) {
            try {
                metricsStr = FileUtils.readTextFile(metricsFile, 0, null);
            }
            catch (IOException e) {
                Slog.e(TAG, "Problem reading " + metricsFile, e);
            }
        }
        if (!TextUtils.isEmpty(metricsStr)) {
            String[] array2;
            String reboot = null;
            String reason = null;
            String start_time = null;
            String duration = null;
            for (String keyValueStr : array2 = metricsStr.split(",")) {
                String[] keyValue = keyValueStr.split(":");
                if (keyValue.length != 2) {
                    Slog.e(TAG, "Wrong format of shutdown metrics - " + metricsStr);
                    continue;
                }
                if (keyValue[0].startsWith(SHUTDOWN_TRON_METRICS_PREFIX)) {
                    BootReceiver.logTronShutdownMetric(keyValue[0], keyValue[1]);
                    if (keyValue[0].equals(METRIC_SYSTEM_SERVER)) {
                        duration = keyValue[1];
                    }
                }
                if (keyValue[0].equals("reboot")) {
                    reboot = keyValue[1];
                    continue;
                }
                if (keyValue[0].equals("reason")) {
                    reason = keyValue[1];
                    continue;
                }
                if (!keyValue[0].equals(METRIC_SHUTDOWN_TIME_START)) continue;
                start_time = keyValue[1];
            }
            BootReceiver.logStatsdShutdownAtom(reboot, reason, start_time, duration);
        }
        metricsFile.delete();
    }

    private static void logTronShutdownMetric(String metricName, String valueStr) {
        int value;
        try {
            value = Integer.parseInt(valueStr);
        }
        catch (NumberFormatException e) {
            Slog.e(TAG, "Cannot parse metric " + metricName + " int value - " + valueStr);
            return;
        }
        if (value >= 0) {
            MetricsLogger.histogram(null, metricName, value);
        }
    }

    private static void logStatsdShutdownAtom(String rebootStr, String reasonStr, String startStr, String durationStr) {
        boolean reboot = false;
        String reason = "<EMPTY>";
        long start = 0L;
        long duration = 0L;
        if (rebootStr != null) {
            if (rebootStr.equals("y")) {
                reboot = true;
            } else if (!rebootStr.equals("n")) {
                Slog.e(TAG, "Unexpected value for reboot : " + rebootStr);
            }
        } else {
            Slog.e(TAG, "No value received for reboot");
        }
        if (reasonStr != null) {
            reason = reasonStr;
        } else {
            Slog.e(TAG, "No value received for shutdown reason");
        }
        if (startStr != null) {
            try {
                start = Long.parseLong(startStr);
            }
            catch (NumberFormatException e) {
                Slog.e(TAG, "Cannot parse shutdown start time: " + startStr);
            }
        } else {
            Slog.e(TAG, "No value received for shutdown start time");
        }
        if (durationStr != null) {
            try {
                duration = Long.parseLong(durationStr);
            }
            catch (NumberFormatException e) {
                Slog.e(TAG, "Cannot parse shutdown duration: " + startStr);
            }
        } else {
            Slog.e(TAG, "No value received for shutdown duration");
        }
        StatsLog.write(56, reboot, reason, start, duration);
    }

    private static void logFsShutdownTime() {
        String lines;
        File f = null;
        for (String fileName : LAST_KMSG_FILES) {
            File file = new File(fileName);
            if (!file.exists()) continue;
            f = file;
            break;
        }
        if (f == null) {
            return;
        }
        int maxReadSize = 16384;
        try {
            lines = FileUtils.readTextFile(f, -16384, null);
        }
        catch (IOException e) {
            Slog.w(TAG, "cannot read last msg", e);
            return;
        }
        Pattern pattern = Pattern.compile(LAST_SHUTDOWN_TIME_PATTERN, 8);
        Matcher matcher = pattern.matcher(lines);
        if (matcher.find()) {
            MetricsLogger.histogram(null, "boot_fs_shutdown_duration", Integer.parseInt(matcher.group(1)));
            MetricsLogger.histogram(null, "boot_fs_shutdown_umount_stat", Integer.parseInt(matcher.group(2)));
            Slog.i(TAG, "boot_fs_shutdown," + matcher.group(1) + "," + matcher.group(2));
        } else {
            MetricsLogger.histogram(null, "boot_fs_shutdown_umount_stat", 4);
            Slog.w(TAG, "boot_fs_shutdown, string not found");
        }
    }

    @VisibleForTesting
    public static int fixFsckFsStat(String partition, int statOrg, String[] lines, int startLineNumber, int endLineNumber) {
        int stat = statOrg;
        if ((stat & 0x400) != 0) {
            String line;
            Pattern passPattern = Pattern.compile(FSCK_PASS_PATTERN);
            Pattern treeOptPattern = Pattern.compile(FSCK_TREE_OPTIMIZATION_PATTERN);
            String currentPass = "";
            boolean foundTreeOptimization = false;
            boolean foundQuotaFix = false;
            boolean foundTimestampAdjustment = false;
            boolean foundOtherFix = false;
            String otherFixLine = null;
            for (int i = startLineNumber; i < endLineNumber && !(line = lines[i]).contains(FSCK_FS_MODIFIED); ++i) {
                Matcher matcher;
                if (line.startsWith("Pass ")) {
                    matcher = passPattern.matcher(line);
                    if (!matcher.find()) continue;
                    currentPass = matcher.group(1);
                    continue;
                }
                if (line.startsWith("Inode ")) {
                    matcher = treeOptPattern.matcher(line);
                    if (matcher.find() && currentPass.equals("1")) {
                        foundTreeOptimization = true;
                        Slog.i(TAG, "fs_stat, partition:" + partition + " found tree optimization:" + line);
                        continue;
                    }
                    foundOtherFix = true;
                    otherFixLine = line;
                    break;
                }
                if (line.startsWith("[QUOTA WARNING]") && currentPass.equals("5")) {
                    Slog.i(TAG, "fs_stat, partition:" + partition + " found quota warning:" + line);
                    foundQuotaFix = true;
                    if (foundTreeOptimization) continue;
                    otherFixLine = line;
                    break;
                }
                if (line.startsWith("Update quota info") && currentPass.equals("5")) continue;
                if (line.startsWith("Timestamp(s) on inode") && line.contains("beyond 2310-04-04 are likely pre-1970") && currentPass.equals("1")) {
                    Slog.i(TAG, "fs_stat, partition:" + partition + " found timestamp adjustment:" + line);
                    if (lines[i + 1].contains("Fix? yes")) {
                        ++i;
                    }
                    foundTimestampAdjustment = true;
                    continue;
                }
                if ((line = line.trim()).isEmpty() || currentPass.isEmpty()) continue;
                foundOtherFix = true;
                otherFixLine = line;
                break;
            }
            if (foundOtherFix) {
                if (otherFixLine != null) {
                    Slog.i(TAG, "fs_stat, partition:" + partition + " fix:" + otherFixLine);
                }
            } else if (foundQuotaFix && !foundTreeOptimization) {
                Slog.i(TAG, "fs_stat, got quota fix without tree optimization, partition:" + partition);
            } else if (foundTreeOptimization && foundQuotaFix || foundTimestampAdjustment) {
                Slog.i(TAG, "fs_stat, partition:" + partition + " fix ignored");
                stat &= 0xFFFFFBFF;
            }
        }
        return stat;
    }

    private static void handleFsckFsStat(Matcher match, String[] lines, int startLineNumber, int endLineNumber) {
        int stat;
        String partition = match.group(1);
        try {
            stat = Integer.decode(match.group(2));
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "cannot parse fs_stat: partition:" + partition + " stat:" + match.group(2));
            return;
        }
        stat = BootReceiver.fixFsckFsStat(partition, stat, lines, startLineNumber, endLineNumber);
        MetricsLogger.histogram(null, "boot_fs_stat_" + partition, stat);
        Slog.i(TAG, "fs_stat, partition:" + partition + " stat:0x" + Integer.toHexString(stat));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, Long> readTimestamps() {
        AtomicFile atomicFile = sFile;
        synchronized (atomicFile) {
            HashMap<String, Long> timestamps = new HashMap<String, Long>();
            boolean success = false;
            try (FileInputStream stream = sFile.openRead();){
                int type;
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(stream, StandardCharsets.UTF_8.name());
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    throw new IllegalStateException("no start tag found");
                }
                int outerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                    if (type == 3 || type == 4) continue;
                    String tagName = parser.getName();
                    if (tagName.equals("log")) {
                        String filename = parser.getAttributeValue(null, "filename");
                        long timestamp = Long.valueOf(parser.getAttributeValue(null, "timestamp"));
                        timestamps.put(filename, timestamp);
                        continue;
                    }
                    Slog.w(TAG, "Unknown tag: " + parser.getName());
                    XmlUtils.skipCurrentTag(parser);
                }
                success = true;
            }
            catch (FileNotFoundException e) {
                Slog.i(TAG, "No existing last log timestamp file " + sFile.getBaseFile() + "; starting empty");
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed parsing " + e);
            }
            catch (IllegalStateException e) {
                Slog.w(TAG, "Failed parsing " + e);
            }
            catch (NullPointerException e) {
                Slog.w(TAG, "Failed parsing " + e);
            }
            catch (XmlPullParserException e) {
                Slog.w(TAG, "Failed parsing " + e);
            }
            finally {
                if (!success) {
                    timestamps.clear();
                }
            }
            return timestamps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTimestamps(HashMap<String, Long> timestamps) {
        AtomicFile atomicFile = sFile;
        synchronized (atomicFile) {
            FileOutputStream stream;
            try {
                stream = sFile.startWrite();
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to write timestamp file: " + e);
                return;
            }
            try {
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(stream, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.startTag(null, "log-files");
                for (String filename : timestamps.keySet()) {
                    out.startTag(null, "log");
                    out.attribute(null, "filename", filename);
                    out.attribute(null, "timestamp", timestamps.get(filename).toString());
                    out.endTag(null, "log");
                }
                out.endTag(null, "log-files");
                out.endDocument();
                sFile.finishWrite(stream);
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to write timestamp file, using the backup: " + e);
                sFile.failWrite(stream);
            }
        }
    }
}

